/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.reports;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.commons.TemplateContent;
import org.apache.syncope.client.console.notifications.TemplateModal;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.WizardModalPanel;
import org.apache.syncope.client.console.rest.ReportRestClient;
import org.apache.syncope.client.console.rest.TemplateRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.XMLEditorPanel;
import org.apache.syncope.client.console.wizards.AbstractModalPanelBuilder;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ReportTemplateTO;
import org.apache.syncope.common.lib.types.ReportTemplateFormat;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;

public class ReportTemplateDirectoryPanel
extends DirectoryPanel<ReportTemplateTO, ReportTemplateTO, ReportTemplateProvider, ReportRestClient> {
    private static final long serialVersionUID = -3789392431954221446L;
    protected final BaseModal<String> utilityModal = new BaseModal("outer");

    public ReportTemplateDirectoryPanel(String id, final PageReference pageReference) {
        super(id, pageReference, true);
        this.disableCheckBoxes();
        this.modal.size(Modal.Size.Small);
        this.modal.addSubmitButton();
        this.setFooterVisibility(true);
        this.modal.setWindowClosedCallback(new ModalWindow.WindowClosedCallback(){
            private static final long serialVersionUID = 8804221891699487139L;

            public void onClose(AjaxRequestTarget target) {
                ReportTemplateDirectoryPanel.this.updateResultTable(target);
                ReportTemplateDirectoryPanel.this.modal.show(false);
            }
        });
        this.addOuterObject(new Component[]{this.utilityModal});
        this.setWindowClosedReloadCallback(this.utilityModal);
        this.utilityModal.size(Modal.Size.Large);
        this.utilityModal.addSubmitButton();
        this.restClient = new ReportRestClient();
        this.addNewItemPanelBuilder(new AbstractModalPanelBuilder<ReportTemplateTO>(new ReportTemplateTO(), this.pageRef){
            private static final long serialVersionUID = 1995192603527154740L;

            @Override
            public WizardModalPanel<ReportTemplateTO> build(String id, int index, AjaxWizard.Mode mode) {
                return new TemplateModal(ReportTemplateDirectoryPanel.this.modal, (TemplateRestClient)ReportTemplateDirectoryPanel.this.restClient, new ReportTemplateTO(), pageReference);
            }
        }, true);
        this.initResultTable();
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"MAIL_TEMPLATE_CREATE");
    }

    @Override
    protected List<IColumn<ReportTemplateTO, String>> getColumns() {
        ArrayList<IColumn<ReportTemplateTO, String>> columns = new ArrayList<IColumn<ReportTemplateTO, String>>();
        columns.add((IColumn<ReportTemplateTO, String>)new PropertyColumn((IModel)new StringResourceModel("key", (Component)this), (Object)"key", "key"));
        return columns;
    }

    @Override
    public ActionsPanel<ReportTemplateTO> getActions(final IModel<ReportTemplateTO> model) {
        ActionsPanel<ReportTemplateTO> panel = super.getActions(model);
        panel.add(new ActionLink<ReportTemplateTO>(){
            private static final long serialVersionUID = -7978723352517770645L;

            @Override
            public void onClick(AjaxRequestTarget target, ReportTemplateTO ignore) {
                TemplateContent<ReportTemplateFormat> content = new TemplateContent<ReportTemplateFormat>(((ReportTemplateTO)model.getObject()).getKey(), ReportTemplateFormat.FO);
                content.setContent(((ReportRestClient)ReportTemplateDirectoryPanel.this.restClient).readTemplateFormat(((ReportTemplateTO)model.getObject()).getKey(), ReportTemplateFormat.FO));
                ReportTemplateDirectoryPanel.this.utilityModal.header((IModel)new ResourceModel("report.template.fo", "XSLT for XSL-FO"));
                ReportTemplateDirectoryPanel.this.utilityModal.setContent(new TemplateContentEditorPanel(content, ReportTemplateDirectoryPanel.this.pageRef));
                ReportTemplateDirectoryPanel.this.utilityModal.show(true);
                target.add(new Component[]{ReportTemplateDirectoryPanel.this.utilityModal});
            }
        }, ActionLink.ActionType.FO_EDIT, "MAIL_TEMPLATE_UPDATE");
        panel.add(new ActionLink<ReportTemplateTO>(){
            private static final long serialVersionUID = -7978723352517770645L;

            @Override
            public void onClick(AjaxRequestTarget target, ReportTemplateTO ignore) {
                TemplateContent<ReportTemplateFormat> content = new TemplateContent<ReportTemplateFormat>(((ReportTemplateTO)model.getObject()).getKey(), ReportTemplateFormat.HTML);
                content.setContent(((ReportRestClient)ReportTemplateDirectoryPanel.this.restClient).readTemplateFormat(((ReportTemplateTO)model.getObject()).getKey(), ReportTemplateFormat.HTML));
                ReportTemplateDirectoryPanel.this.utilityModal.header((IModel)new ResourceModel("report.template.html", "XSLT for HTML"));
                ReportTemplateDirectoryPanel.this.utilityModal.setContent(new TemplateContentEditorPanel(content, ReportTemplateDirectoryPanel.this.pageRef));
                ReportTemplateDirectoryPanel.this.utilityModal.show(true);
                target.add(new Component[]{ReportTemplateDirectoryPanel.this.utilityModal});
            }
        }, ActionLink.ActionType.HTML, "MAIL_TEMPLATE_UPDATE");
        panel.add(new ActionLink<ReportTemplateTO>(){
            private static final long serialVersionUID = -7978723352517770645L;

            @Override
            public void onClick(AjaxRequestTarget target, ReportTemplateTO ignore) {
                TemplateContent<ReportTemplateFormat> content = new TemplateContent<ReportTemplateFormat>(((ReportTemplateTO)model.getObject()).getKey(), ReportTemplateFormat.CSV);
                content.setContent(((ReportRestClient)ReportTemplateDirectoryPanel.this.restClient).readTemplateFormat(((ReportTemplateTO)model.getObject()).getKey(), ReportTemplateFormat.CSV));
                ReportTemplateDirectoryPanel.this.utilityModal.header((IModel)new ResourceModel("report.template.csv", "XSLT for CSV"));
                ReportTemplateDirectoryPanel.this.utilityModal.setContent(new TemplateContentEditorPanel(content, ReportTemplateDirectoryPanel.this.pageRef));
                ReportTemplateDirectoryPanel.this.utilityModal.show(true);
                target.add(new Component[]{ReportTemplateDirectoryPanel.this.utilityModal});
            }
        }, ActionLink.ActionType.TEXT, "MAIL_TEMPLATE_UPDATE");
        panel.add(new ActionLink<ReportTemplateTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, ReportTemplateTO ignore) {
                try {
                    ((ReportRestClient)ReportTemplateDirectoryPanel.this.restClient).deleteTemplate(((ReportTemplateTO)model.getObject()).getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)ReportTemplateDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{ReportTemplateDirectoryPanel.this.container});
                }
                catch (SyncopeClientException e) {
                    LOG.error("While deleting object {}", (Object)((ReportTemplateTO)model.getObject()).getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)ReportTemplateDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "MAIL_TEMPLATE_DELETE", true);
        return panel;
    }

    @Override
    protected ReportTemplateProvider dataProvider() {
        return new ReportTemplateProvider(this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "mail.template.paginator.rows";
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        return Collections.emptyList();
    }

    private class TemplateContentEditorPanel
    extends XMLEditorPanel {
        private static final long serialVersionUID = -3528875878627216097L;
        private final TemplateContent<ReportTemplateFormat> content;

        TemplateContentEditorPanel(TemplateContent<ReportTemplateFormat> content, PageReference pageRef) {
            super(ReportTemplateDirectoryPanel.this.utilityModal, (IModel<String>)new PropertyModel(content, "content"), false, pageRef);
            this.content = content;
        }

        @Override
        public void onSubmit(AjaxRequestTarget target) {
            if (StringUtils.isBlank((CharSequence)this.content.getContent())) {
                SyncopeConsoleSession.get().error((Serializable)((Object)"No content to save"));
            } else {
                try {
                    ((ReportRestClient)ReportTemplateDirectoryPanel.this.restClient).updateTemplateFormat(this.content.getKey(), this.content.getContent(), this.content.getFormat());
                    SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                    this.modal.show(false);
                    this.modal.close((IPartialPageRequestHandler)target);
                }
                catch (Exception e) {
                    LOG.error("While updating template for {}", (Object)this.content.getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException(e);
                }
            }
            ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
        }
    }

    protected final class ReportTemplateProvider
    extends DirectoryDataProvider<ReportTemplateTO> {
        private static final long serialVersionUID = -276043813563988590L;
        private final SortableDataProviderComparator<ReportTemplateTO> comparator;

        public ReportTemplateProvider(int paginatorRows) {
            super(paginatorRows);
            this.setSort("key", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator<ReportTemplateTO>(this);
        }

        public Iterator<ReportTemplateTO> iterator(long first, long count) {
            List<ReportTemplateTO> list = ((ReportRestClient)ReportTemplateDirectoryPanel.this.restClient).listTemplates();
            Collections.sort(list, this.comparator);
            return list.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return ((ReportRestClient)ReportTemplateDirectoryPanel.this.restClient).listTemplates().size();
        }

        public IModel<ReportTemplateTO> model(final ReportTemplateTO reportTemplateTO) {
            return new IModel<ReportTemplateTO>(){
                private static final long serialVersionUID = 774694801558497248L;

                public ReportTemplateTO getObject() {
                    return reportTemplateTO;
                }
            };
        }
    }
}

