/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.reports;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.reports.ReportStartAtTogglePanel;
import org.apache.syncope.client.console.reports.ReportWizardBuilder;
import org.apache.syncope.client.console.reports.ReportletDirectoryPanel;
import org.apache.syncope.client.console.rest.ReportRestClient;
import org.apache.syncope.client.console.wicket.ajax.IndicatorAjaxTimerBehavior;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.BooleanPropertyColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.DatePropertyColumn;
import org.apache.syncope.client.console.wicket.extensions.markup.html.repeater.data.table.KeyPropertyColumn;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.widgets.JobActionPanel;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.syncope.common.lib.to.ReportTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.util.time.Duration;

public abstract class ReportDirectoryPanel
extends DirectoryPanel<ReportTO, ReportTO, DirectoryDataProvider<ReportTO>, ReportRestClient> {
    private static final long serialVersionUID = 4984337552918213290L;
    private final ReportStartAtTogglePanel startAt;

    protected ReportDirectoryPanel(MultilevelPanel multiLevelPanelRef, PageReference pageRef) {
        super("first", pageRef, true);
        this.restClient = new ReportRestClient();
        this.addNewItemPanelBuilder(new ReportWizardBuilder(new ReportTO(), pageRef), true);
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"REPORT_CREATE");
        this.modal.size(Modal.Size.Large);
        this.initResultTable();
        this.container.add(new Behavior[]{new IndicatorAjaxTimerBehavior(Duration.seconds((int)10)){
            private static final long serialVersionUID = -4661303265651934868L;

            protected void onTimer(AjaxRequestTarget target) {
                ReportDirectoryPanel.this.container.modelChanged();
                target.add(new Component[]{ReportDirectoryPanel.this.container});
            }
        }});
        this.startAt = new ReportStartAtTogglePanel(this.container, pageRef);
        this.addInnerObject(new Component[]{this.startAt});
    }

    @Override
    protected List<IColumn<ReportTO, String>> getColumns() {
        ArrayList<IColumn<ReportTO, String>> columns = new ArrayList<IColumn<ReportTO, String>>();
        columns.add((IColumn<ReportTO, String>)new KeyPropertyColumn((IModel<String>)new StringResourceModel("key", (Component)this), "key"));
        columns.add((IColumn<ReportTO, String>)new PropertyColumn((IModel)new StringResourceModel("name", (Component)this), (Object)"name", "name"));
        columns.add((IColumn<ReportTO, String>)new DatePropertyColumn((IModel<String>)new StringResourceModel("lastExec", (Component)this), null, "lastExec"));
        columns.add((IColumn<ReportTO, String>)new DatePropertyColumn((IModel<String>)new StringResourceModel("nextExec", (Component)this), null, "nextExec"));
        columns.add((IColumn<ReportTO, String>)new DatePropertyColumn((IModel<String>)new StringResourceModel("start", (Component)this), "start", "start"));
        columns.add((IColumn<ReportTO, String>)new DatePropertyColumn((IModel<String>)new StringResourceModel("end", (Component)this), "end", "end"));
        columns.add((IColumn<ReportTO, String>)new PropertyColumn((IModel)new StringResourceModel("latestExecStatus", (Component)this), (Object)"latestExecStatus", "latestExecStatus"));
        columns.add((IColumn<ReportTO, String>)new BooleanPropertyColumn((IModel<String>)new StringResourceModel("active", (Component)this), "active", "active"));
        columns.add((IColumn<ReportTO, String>)new AbstractColumn<ReportTO, String>((IModel)new Model((Serializable)((Object)"")), "running"){
            private static final long serialVersionUID = 4209532514416998046L;

            public void populateItem(Item<ICellPopulator<ReportTO>> cellItem, String componentId, IModel<ReportTO> rowModel) {
                Object panel;
                try {
                    JobTO jobTO = ((ReportRestClient)ReportDirectoryPanel.this.restClient).getJob(((ReportTO)rowModel.getObject()).getKey());
                    panel = new JobActionPanel(componentId, jobTO, false, (Component)ReportDirectoryPanel.this, ReportDirectoryPanel.this.pageRef);
                    MetaDataRoleAuthorizationStrategy.authorize((Component)panel, (Action)WebPage.ENABLE, (String)String.format("%s,%s", "REPORT_EXECUTE", "REPORT_UPDATE"));
                }
                catch (Exception e) {
                    LOG.error("Could not get job for report {}", (Object)((ReportTO)rowModel.getObject()).getKey(), (Object)e);
                    panel = new Label(componentId, (IModel)Model.of());
                }
                cellItem.add(new Component[]{panel});
            }

            public String getCssClass() {
                return "col-xs-1";
            }
        });
        return columns;
    }

    @Override
    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof JobActionPanel.JobActionPayload) {
            this.container.modelChanged();
            ((JobActionPanel.JobActionPayload)JobActionPanel.JobActionPayload.class.cast(event.getPayload())).getTarget().add(new Component[]{this.container});
        } else {
            super.onEvent(event);
        }
    }

    @Override
    public ActionsPanel<ReportTO> getActions(final IModel<ReportTO> model) {
        ActionsPanel<ReportTO> panel = super.getActions(model);
        panel.add(new ActionLink<ReportTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, ReportTO ignore) {
                ReportDirectoryPanel.this.send((IEventSink)ReportDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent<ReportTO>(((ReportRestClient)ReportDirectoryPanel.this.restClient).read(((ReportTO)model.getObject()).getKey()), target));
            }
        }, ActionLink.ActionType.EDIT, "REPORT_UPDATE");
        panel.add(new ActionLink<ReportTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, ReportTO ignore) {
                ReportTO clone = (ReportTO)SerializationUtils.clone((Serializable)((Serializable)model.getObject()));
                clone.setKey(null);
                ReportDirectoryPanel.this.send((IEventSink)ReportDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent<ReportTO>(clone, target));
            }
        }, ActionLink.ActionType.CLONE, "REPORT_CREATE");
        panel.add(new ActionLink<ReportTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, ReportTO ignore) {
                target.add(new Component[]{ReportDirectoryPanel.this.modal.setContent(new ReportletDirectoryPanel(ReportDirectoryPanel.this.modal, ((ReportTO)model.getObject()).getKey(), ReportDirectoryPanel.this.pageRef))});
                ReportDirectoryPanel.this.modal.header((IModel)new StringResourceModel("reportlet.conf", (Component)ReportDirectoryPanel.this, (IModel)Model.of((Serializable)((Serializable)model.getObject()))));
                MetaDataRoleAuthorizationStrategy.authorize(ReportDirectoryPanel.this.modal.getForm(), (Action)Component.ENABLE, (String)"RESOURCE_UPDATE");
                ReportDirectoryPanel.this.modal.show(true);
            }
        }, ActionLink.ActionType.COMPOSE, "REPORT_UPDATE");
        panel.add(new ActionLink<ReportTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, ReportTO ignore) {
                ReportDirectoryPanel.this.viewReport((ReportTO)model.getObject(), target);
            }
        }, ActionLink.ActionType.VIEW, "REPORT_READ");
        panel.add(new ActionLink<ReportTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, ReportTO ignore) {
                ReportDirectoryPanel.this.startAt.setExecutionDetail(((ReportTO)model.getObject()).getKey(), ((ReportTO)model.getObject()).getName(), target);
                ReportDirectoryPanel.this.startAt.toggle(target, true);
            }
        }, ActionLink.ActionType.EXECUTE, "REPORT_EXECUTE");
        panel.add(new ActionLink<ReportTO>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, ReportTO ignore) {
                ReportTO reportTO = (ReportTO)model.getObject();
                try {
                    ((ReportRestClient)ReportDirectoryPanel.this.restClient).delete(reportTO.getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)ReportDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{ReportDirectoryPanel.this.container});
                }
                catch (SyncopeClientException e) {
                    LOG.error("While deleting {}", (Object)reportTO.getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)ReportDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "REPORT_DELETE", true);
        return panel;
    }

    @Override
    protected Collection<ActionLink.ActionType> getBatches() {
        ArrayList<ActionLink.ActionType> batches = new ArrayList<ActionLink.ActionType>();
        batches.add(ActionLink.ActionType.EXECUTE);
        batches.add(ActionLink.ActionType.DELETE);
        return batches;
    }

    @Override
    protected ReportDataProvider dataProvider() {
        return new ReportDataProvider(this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "report.paginator.rows";
    }

    protected abstract void viewReport(ReportTO var1, AjaxRequestTarget var2);

    protected class ReportDataProvider
    extends DirectoryDataProvider<ReportTO> {
        private static final long serialVersionUID = 4725679400450513556L;
        private final SortableDataProviderComparator<ReportTO> comparator;

        public ReportDataProvider(int paginatorRows) {
            super(paginatorRows);
            this.setSort("name", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator<ReportTO>(this);
        }

        public Iterator<ReportTO> iterator(long first, long count) {
            List<ReportTO> list = ((ReportRestClient)ReportDirectoryPanel.this.restClient).list();
            Collections.sort(list, this.comparator);
            return list.subList((int)first, (int)first + (int)count).iterator();
        }

        public long size() {
            return ((ReportRestClient)ReportDirectoryPanel.this.restClient).list().size();
        }

        public IModel<ReportTO> model(ReportTO object) {
            return new CompoundPropertyModel((Object)object);
        }
    }
}

