/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels.search;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.panels.search.AbstractSearchPanel;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.rest.ConnectorRestClient;
import org.apache.syncope.common.lib.to.ConnIdObjectClassTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class ConnObjectSearchPanel
extends AbstractSearchPanel {
    private static final long serialVersionUID = 21020550706646L;
    protected final ConnectorRestClient connectorRestClient = new ConnectorRestClient();
    protected final ResourceTO resource;

    protected ConnObjectSearchPanel(String id, AnyTypeKind kind, Builder builder) {
        super(id, kind, builder);
        this.resource = builder.resource;
    }

    protected ConnObjectSearchPanel(String id, AnyTypeKind kind, String type, Builder builder) {
        super(id, kind, type, builder);
        this.resource = builder.resource;
    }

    @Override
    protected void populate() {
        this.types = new LoadableDetachableModel<List<SearchClause.Type>>(){
            private static final long serialVersionUID = 22668815812716L;

            protected List<SearchClause.Type> load() {
                return Collections.singletonList(SearchClause.Type.ATTRIBUTE);
            }
        };
        this.dnames = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 2989042618372L;

            protected List<String> load() {
                return Collections.emptyList();
            }
        };
        this.anames = new LoadableDetachableModel<Map<String, PlainSchemaTO>>(){
            private static final long serialVersionUID = 3002350300761L;

            protected Map<String, PlainSchemaTO> load() {
                return ConnObjectSearchPanel.this.connectorRestClient.buildObjectClassInfo(ConnObjectSearchPanel.this.connectorRestClient.read(ConnObjectSearchPanel.this.resource.getConnector()), false).stream().map(ConnIdObjectClassTO::getAttributes).flatMap(Collection::stream).collect(Collectors.toMap(SchemaTO::getKey, Function.identity(), (schema1, schema2) -> schema1));
            }
        };
    }

    public static class Builder
    extends AbstractSearchPanel.Builder<ConnObjectSearchPanel> {
        private static final long serialVersionUID = 6308997285778809578L;
        private final ResourceTO resource;
        private final AnyTypeKind anyType;
        private final String typeName;

        public Builder(ResourceTO resource, AnyTypeKind anyType, String type, IModel<List<SearchClause>> model) {
            super(model);
            this.resource = resource;
            this.anyType = anyType;
            this.typeName = type;
        }

        @Override
        public ConnObjectSearchPanel build(String id) {
            return new ConnObjectSearchPanel(id, this.anyType, this.typeName, this);
        }
    }
}

