/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.layout.AnyLayout;
import org.apache.syncope.client.console.layout.AnyLayoutUtils;
import org.apache.syncope.client.console.layout.LinkedAccountForm;
import org.apache.syncope.client.console.layout.LinkedAccountFormLayoutInfo;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.ListViewPanel;
import org.apache.syncope.client.console.panels.ModalPanel;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.rest.UserRestClient;
import org.apache.syncope.client.console.status.LinkedAccountStatusPanel;
import org.apache.syncope.client.console.status.ReconTaskPanel;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLinksTogglePanel;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.client.console.wizards.any.LinkedAccountWizardBuilder;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.patch.LinkedAccountPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.LinkedAccountTO;
import org.apache.syncope.common.lib.to.ProvisioningTaskTO;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.to.PushTaskTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkedAccountModalPanel
extends Panel
implements ModalPanel {
    private static final long serialVersionUID = -4603032036433309900L;
    private static final Logger LOG = LoggerFactory.getLogger(LinkedAccountModalPanel.class);
    private LinkedAccountForm wizard;
    private final WizardMgtPanel<LinkedAccountTO> list;
    private final AjaxLink<LinkedAccountTO> addAjaxLink;
    private ActionLinksTogglePanel<LinkedAccountTO> actionTogglePanel;
    private UserRestClient userRestClient = new UserRestClient();
    private AnyTypeRestClient anyTypeRestClient = new AnyTypeRestClient();
    private final List<LinkedAccountTO> linkedAccountTOs;

    public LinkedAccountModalPanel(BaseModal<?> baseModal, final IModel<UserTO> model, final PageReference pageRef, boolean recounciliationOnly) {
        super(BaseModal.getContentId(), model);
        final MultilevelPanel mlp = new MultilevelPanel("mlpContainer");
        mlp.setOutputMarkupId(true);
        this.setOutputMarkupId(true);
        this.actionTogglePanel = new ActionLinksTogglePanel("toggle", pageRef);
        this.add(new Component[]{this.actionTogglePanel});
        AnyLayout anyLayout = AnyLayoutUtils.fetch(this.anyTypeRestClient.listAnyTypes().stream().map(EntityTO::getKey).collect(Collectors.toList()));
        LinkedAccountFormLayoutInfo linkedAccountFormLayoutInfo = anyLayout.getUser().getLinkedAccountFormLayoutInfo();
        try {
            this.wizard = linkedAccountFormLayoutInfo.getFormClass().getConstructor(model.getClass(), LinkedAccountFormLayoutInfo.class, PageReference.class).newInstance(model, linkedAccountFormLayoutInfo, pageRef);
        }
        catch (Exception e) {
            LOG.error("Error instantiating form layout", (Throwable)e);
            this.wizard = new LinkedAccountWizardBuilder(model, linkedAccountFormLayoutInfo, pageRef);
        }
        ListViewPanel.Builder<LinkedAccountTO> builder = new ListViewPanel.Builder<LinkedAccountTO>(LinkedAccountTO.class, pageRef){
            private static final long serialVersionUID = -5322423525438435153L;

            @Override
            protected LinkedAccountTO getActualItem(LinkedAccountTO item, List<LinkedAccountTO> list) {
                return item == null ? null : (LinkedAccountTO)list.stream().filter(in -> item.getKey() == null && in.getKey() == null || in.getKey() != null && in.getKey().equals(item.getKey())).findAny().orElse(null);
            }

            @Override
            protected void customActionCallback(AjaxRequestTarget target) {
                LinkedAccountModalPanel.this.send((IEventSink)LinkedAccountModalPanel.this, Broadcast.BUBBLE, new BaseModal.ChangeFooterVisibilityEvent(target));
            }

            @Override
            protected void customActionOnCancelCallback(AjaxRequestTarget target) {
                LinkedAccountModalPanel.this.send((IEventSink)LinkedAccountModalPanel.this, Broadcast.BUBBLE, new BaseModal.ChangeFooterVisibilityEvent(target));
            }

            @Override
            protected void customActionOnFinishCallback(AjaxRequestTarget target) {
                LinkedAccountModalPanel.this.checkAddButton();
                LinkedAccountModalPanel.this.linkedAccountTOs.clear();
                LinkedAccountModalPanel.this.linkedAccountTOs.addAll(((UserTO)model.getObject()).getLinkedAccounts());
                LinkedAccountModalPanel.this.sortLinkedAccounts();
                ((ListViewPanel)((Object)ListViewPanel.class.cast((Object)LinkedAccountModalPanel.this.list))).refreshList(LinkedAccountModalPanel.this.linkedAccountTOs);
                LinkedAccountModalPanel.this.send((IEventSink)LinkedAccountModalPanel.this, Broadcast.BUBBLE, new BaseModal.ChangeFooterVisibilityEvent(target));
            }

            @Override
            protected Component getValueComponent(String key, LinkedAccountTO bean) {
                if ("suspended".equalsIgnoreCase(key)) {
                    Label label = new Label("field", (Serializable)((Object)""));
                    if (bean.isSuspended()) {
                        label.add(new Behavior[]{new AttributeModifier("class", (Serializable)((Object)"glyphicon glyphicon-ok"))});
                        label.add(new Behavior[]{new AttributeModifier("style", (Serializable)((Object)"display: table-cell; text-align: center;"))});
                    }
                    return label;
                }
                return super.getValueComponent(key, bean);
            }

            @Override
            protected ActionLinksTogglePanel<LinkedAccountTO> getTogglePanel() {
                return LinkedAccountModalPanel.this.actionTogglePanel;
            }
        };
        this.linkedAccountTOs = new ArrayList<LinkedAccountTO>(((UserTO)model.getObject()).getLinkedAccounts());
        this.sortLinkedAccounts();
        builder.setItems(this.linkedAccountTOs);
        builder.includes("connObjectKeyValue", "resource", "suspended");
        builder.setReuseItem(false);
        builder.withChecks(ListViewPanel.CheckAvailability.NONE);
        builder.addAction(new ActionLink<LinkedAccountTO>(){
            private static final long serialVersionUID = 2555747430358755813L;

            @Override
            public void onClick(AjaxRequestTarget target, LinkedAccountTO linkedAccountTO) {
                mlp.next(linkedAccountTO.getResource(), new LinkedAccountStatusPanel(linkedAccountTO.getResource(), ((UserTO)model.getObject()).getType(), linkedAccountTO.getConnObjectKeyValue()), target);
                target.add(new Component[]{mlp});
                ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                LinkedAccountModalPanel.this.send((IEventSink)LinkedAccountModalPanel.this, Broadcast.BREADTH, new ActionLinksTogglePanel.ActionLinkToggleCloseEventPayload(target));
            }
        }, ActionLink.ActionType.VIEW, "USER_READ");
        if (!recounciliationOnly) {
            builder.addAction(new ActionLink<LinkedAccountTO>(){
                private static final long serialVersionUID = 2555747430358755813L;

                @Override
                public void onClick(AjaxRequestTarget target, LinkedAccountTO linkedAccountTO) {
                    try {
                        LinkedAccountModalPanel.this.send((IEventSink)LinkedAccountModalPanel.this, Broadcast.DEPTH, new AjaxWizard.NewItemActionEvent<LinkedAccountTO>(linkedAccountTO, 1, target).setResourceModel((IModel<String>)new StringResourceModel("inner.edit.linkedAccount", (Component)LinkedAccountModalPanel.this, (IModel)Model.of((Serializable)linkedAccountTO))));
                    }
                    catch (SyncopeClientException e) {
                        LOG.error("While attempting to create new linked account", (Throwable)e);
                        SyncopeConsoleSession.get().onException((Exception)((Object)e));
                        ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    }
                    LinkedAccountModalPanel.this.send((IEventSink)LinkedAccountModalPanel.this, Broadcast.BREADTH, new ActionLinksTogglePanel.ActionLinkToggleCloseEventPayload(target));
                }
            }, ActionLink.ActionType.EDIT, "USER_UPDATE");
            builder.addAction(new ActionLink<LinkedAccountTO>(){
                private static final long serialVersionUID = 2555747430358755813L;

                @Override
                public void onClick(AjaxRequestTarget target, LinkedAccountTO linkedAccountTO) {
                    try {
                        linkedAccountTO.setSuspended(!linkedAccountTO.isSuspended());
                        LinkedAccountPatch linkedAccountPatch = (LinkedAccountPatch)((LinkedAccountPatch.Builder)new LinkedAccountPatch.Builder().operation(PatchOperation.ADD_REPLACE)).linkedAccountTO(linkedAccountTO).build();
                        UserPatch patch = new UserPatch();
                        patch.setKey(((UserTO)model.getObject()).getKey());
                        patch.getLinkedAccounts().add(linkedAccountPatch);
                        model.setObject((Object)LinkedAccountModalPanel.this.userRestClient.update(((UserTO)model.getObject()).getETagValue(), patch).getEntity());
                        SyncopeConsoleSession.get().success((Serializable)((Object)LinkedAccountModalPanel.this.getString("operation_succeeded")));
                    }
                    catch (SyncopeClientException e) {
                        LOG.error("While toggling status of linked account", (Throwable)e);
                        SyncopeConsoleSession.get().onException((Exception)((Object)e));
                        ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    }
                    LinkedAccountModalPanel.this.checkAddButton();
                    ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    LinkedAccountModalPanel.this.send((IEventSink)LinkedAccountModalPanel.this, Broadcast.DEPTH, new ListViewPanel.ListViewReload(target));
                }
            }, ActionLink.ActionType.ENABLE, "USER_UPDATE");
        }
        builder.addAction(new ActionLink<LinkedAccountTO>(){
            private static final long serialVersionUID = 2555747430358755813L;

            @Override
            public void onClick(AjaxRequestTarget target, LinkedAccountTO linkedAccountTO) {
                mlp.next("PUSH " + linkedAccountTO.getResource(), new ReconTaskPanel(linkedAccountTO.getResource(), (ProvisioningTaskTO)new PushTaskTO(), ((UserTO)model.getObject()).getType(), null, linkedAccountTO.getConnObjectKeyValue(), true, mlp, pageRef), target);
                target.add(new Component[]{mlp});
                ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                LinkedAccountModalPanel.this.send((IEventSink)LinkedAccountModalPanel.this, Broadcast.BREADTH, new ActionLinksTogglePanel.ActionLinkToggleCloseEventPayload(target));
            }
        }, ActionLink.ActionType.RECONCILIATION_PUSH, String.format("%s,%s", "USER_READ", "TASK_EXECUTE"));
        builder.addAction(new ActionLink<LinkedAccountTO>(){
            private static final long serialVersionUID = 2555747430358755813L;

            @Override
            public void onClick(AjaxRequestTarget target, LinkedAccountTO linkedAccountTO) {
                mlp.next("PULL " + linkedAccountTO.getResource(), new ReconTaskPanel(linkedAccountTO.getResource(), (ProvisioningTaskTO)new PullTaskTO(), ((UserTO)model.getObject()).getType(), null, linkedAccountTO.getConnObjectKeyValue(), true, mlp, pageRef), target);
                target.add(new Component[]{mlp});
                ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                LinkedAccountModalPanel.this.send((IEventSink)LinkedAccountModalPanel.this, Broadcast.BREADTH, new ActionLinksTogglePanel.ActionLinkToggleCloseEventPayload(target));
            }
        }, ActionLink.ActionType.RECONCILIATION_PULL, String.format("%s,%s", "USER_UPDATE", "TASK_EXECUTE"));
        if (!recounciliationOnly) {
            builder.addAction(new ActionLink<LinkedAccountTO>(){
                private static final long serialVersionUID = 2555747430358755813L;

                @Override
                public void onClick(AjaxRequestTarget target, LinkedAccountTO linkedAccountTO) {
                    try {
                        LinkedAccountPatch linkedAccountPatch = (LinkedAccountPatch)((LinkedAccountPatch.Builder)new LinkedAccountPatch.Builder().operation(PatchOperation.DELETE)).linkedAccountTO(linkedAccountTO).build();
                        UserPatch patch = new UserPatch();
                        patch.setKey(((UserTO)model.getObject()).getKey());
                        patch.getLinkedAccounts().add(linkedAccountPatch);
                        model.setObject((Object)LinkedAccountModalPanel.this.userRestClient.update(((UserTO)model.getObject()).getETagValue(), patch).getEntity());
                        LinkedAccountModalPanel.this.linkedAccountTOs.remove(linkedAccountTO);
                        SyncopeConsoleSession.get().success((Serializable)((Object)LinkedAccountModalPanel.this.getString("operation_succeeded")));
                    }
                    catch (Exception e) {
                        LOG.error("While removing linked account {}", (Object)linkedAccountTO.getKey(), (Object)e);
                        SyncopeConsoleSession.get().onException(e);
                    }
                    LinkedAccountModalPanel.this.checkAddButton();
                    ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    LinkedAccountModalPanel.this.send((IEventSink)LinkedAccountModalPanel.this, Broadcast.DEPTH, new ListViewPanel.ListViewReload(target));
                }
            }, ActionLink.ActionType.DELETE, "USER_UPDATE", true);
        }
        builder.addNewItemPanelBuilder(this.wizard);
        this.list = builder.build("first");
        this.list.setOutputMarkupId(true);
        this.list.setReadOnly(!SyncopeConsoleSession.get().owns("USER_UPDATE", new String[0]));
        this.addAjaxLink = new AjaxLink<LinkedAccountTO>("add"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                this.send((IEventSink)LinkedAccountModalPanel.this, Broadcast.BREADTH, new ActionLinksTogglePanel.ActionLinkToggleCloseEventPayload(target));
                this.send((IEventSink)LinkedAccountModalPanel.this.list, Broadcast.DEPTH, new AjaxWizard.NewItemActionEvent<LinkedAccountTO>(new LinkedAccountTO(), target).setResourceModel((IModel<String>)new StringResourceModel("inner.create.linkedAccount", (Component)LinkedAccountModalPanel.this)));
            }
        };
        this.list.addOrReplaceInnerObject(this.addAjaxLink.setEnabled(!recounciliationOnly).setVisible(!recounciliationOnly));
        this.add(new Component[]{mlp.setFirstLevel(this.list)});
    }

    private void sortLinkedAccounts() {
        this.linkedAccountTOs.sort(Comparator.comparing(LinkedAccountTO::getConnObjectKeyValue));
    }

    private void checkAddButton() {
        this.addAjaxLink.setVisible(SyncopeConsoleSession.get().owns("USER_UPDATE", new String[0]));
    }
}

