/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.audit.AuditHistoryModal;
import org.apache.syncope.client.console.layout.AbstractAnyFormLayout;
import org.apache.syncope.client.console.layout.AnyLayout;
import org.apache.syncope.client.console.layout.AnyLayoutUtils;
import org.apache.syncope.client.console.notifications.NotificationTasks;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.AnyDirectoryPanel;
import org.apache.syncope.client.console.panels.AnyObjectDirectoryPanel;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.GroupDisplayAttributesModalPanel;
import org.apache.syncope.client.console.panels.MembersTogglePanel;
import org.apache.syncope.client.console.panels.ModalPanel;
import org.apache.syncope.client.console.panels.TypeExtensionDirectoryPanel;
import org.apache.syncope.client.console.panels.UserDirectoryPanel;
import org.apache.syncope.client.console.rest.AnyTypeClassRestClient;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.rest.GroupRestClient;
import org.apache.syncope.client.console.status.AnyStatusModal;
import org.apache.syncope.client.console.tasks.AnyPropagationTasks;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.client.console.wizards.any.AnyWrapper;
import org.apache.syncope.client.console.wizards.any.GroupWrapper;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.patch.GroupPatch;
import org.apache.syncope.common.lib.search.AnyObjectCompleteCondition;
import org.apache.syncope.common.lib.search.AnyObjectProperty;
import org.apache.syncope.common.lib.search.UserCompleteCondition;
import org.apache.syncope.common.lib.search.UserProperty;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AnyTypeClassTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyEntitlement;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.ProvisionAction;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;

public class GroupDirectoryPanel
extends AnyDirectoryPanel<GroupTO, GroupRestClient> {
    private static final long serialVersionUID = -1100228004207271270L;
    private final BaseModal<Serializable> typeExtensionsModal = new BaseModal("outer");
    protected final BaseModal<Serializable> membersModal = new BaseModal("outer");
    protected final MembersTogglePanel templates;

    protected GroupDirectoryPanel(String id, Builder builder, boolean wizardInModal) {
        super(id, builder, wizardInModal);
        this.typeExtensionsModal.size(Modal.Size.Large);
        this.addOuterObject(new Component[]{this.typeExtensionsModal});
        this.setWindowClosedReloadCallback(this.typeExtensionsModal);
        this.typeExtensionsModal.addSubmitButton();
        this.addOuterObject(new Component[]{this.membersModal});
        this.membersModal.size(Modal.Size.Large);
        this.templates = new MembersTogglePanel(this.page.getPageReference()){
            private static final long serialVersionUID = -8765794727538618705L;

            @Override
            protected Serializable onApplyInternal(GroupTO groupTO, String type, AjaxRequestTarget target) {
                AnyTypeRestClient anyTypeRestClient = new AnyTypeRestClient();
                AnyTypeClassRestClient classRestClient = new AnyTypeClassRestClient();
                AnyLayout layout = AnyLayoutUtils.fetch(anyTypeRestClient.list());
                Object anyPanel = AnyLayoutUtils.newAnyPanel(layout.getAnyPanelClass(), "content", anyTypeRestClient.read(type), null, layout, false, (id, anyTypeTO, realmTO, anyLayout, pageRef) -> {
                    WizardMgtPanel panel;
                    if (AnyTypeKind.USER.name().equals(type)) {
                        String fiql = ((UserCompleteCondition)((UserProperty)SyncopeClient.getUserSearchConditionBuilder().inGroups(groupTO.getKey(), new String[0]).and("key")).notNullValue()).query();
                        panel = new UserDirectoryPanel.Builder(classRestClient.list(anyTypeTO.getClasses()), anyTypeTO.getKey(), pageRef).setRealm("/").setFiltered(true).setFiql(fiql).disableCheckBoxes().addNewItemPanelBuilder(AnyLayoutUtils.newLayoutInfo(new UserTO(), anyTypeTO.getClasses(), anyLayout.getUser(), pageRef), false).setWizardInModal(false).build(id);
                        MetaDataRoleAuthorizationStrategy.authorize(panel, (Action)WebPage.RENDER, (String)"USER_SEARCH");
                    } else {
                        String fiql = ((AnyObjectCompleteCondition)((AnyObjectProperty)SyncopeClient.getAnyObjectSearchConditionBuilder((String)type).inGroups(groupTO.getKey(), new String[0]).and("key")).notNullValue()).query();
                        panel = new AnyObjectDirectoryPanel.Builder(classRestClient.list(anyTypeTO.getClasses()), anyTypeTO.getKey(), pageRef).setRealm("/").setFiltered(true).setFiql(fiql).disableCheckBoxes().addNewItemPanelBuilder(AnyLayoutUtils.newLayoutInfo(new AnyObjectTO(), anyTypeTO.getClasses(), (AbstractAnyFormLayout)layout.getAnyObjects().get(type), pageRef), false).setWizardInModal(false).build(id);
                        MetaDataRoleAuthorizationStrategy.authorize(panel, (Action)WebPage.RENDER, (String)AnyEntitlement.SEARCH.getFor(anyTypeTO.getKey()));
                    }
                    return panel;
                }, this.pageRef);
                GroupDirectoryPanel.this.membersModal.header((IModel)new StringResourceModel("group.members", (Component)GroupDirectoryPanel.this, (IModel)Model.of((Serializable)Pair.of((Object)groupTO, (Object)type))));
                GroupDirectoryPanel.this.membersModal.setContent((ModalPanel)anyPanel);
                GroupDirectoryPanel.this.membersModal.show(true);
                target.add(new Component[]{GroupDirectoryPanel.this.membersModal});
                return null;
            }
        };
        this.addOuterObject(new Component[]{this.templates});
    }

    @Override
    protected String paginatorRowsKey() {
        return "group.paginator.rows";
    }

    @Override
    protected String[] getDefaultAttributeSelection() {
        return GroupDisplayAttributesModalPanel.DEFAULT_SELECTION;
    }

    @Override
    public ActionsPanel<Serializable> getHeader(String componentId) {
        ActionsPanel<Serializable> panel = super.getHeader(componentId);
        panel.add(new ActionLink<Serializable>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                target.add(new Component[]{GroupDirectoryPanel.this.displayAttributeModal.setContent(new GroupDisplayAttributesModalPanel(GroupDirectoryPanel.this.displayAttributeModal, GroupDirectoryPanel.this.page.getPageReference(), GroupDirectoryPanel.this.pSchemaNames, GroupDirectoryPanel.this.dSchemaNames))});
                GroupDirectoryPanel.this.displayAttributeModal.header((IModel)new ResourceModel("any.attr.display"));
                GroupDirectoryPanel.this.displayAttributeModal.show(true);
            }
        }, ActionLink.ActionType.CHANGE_VIEW, "GROUP_READ").hideLabel();
        return panel;
    }

    @Override
    public ActionsPanel<GroupTO> getActions(final IModel<GroupTO> model) {
        ActionsPanel<GroupTO> panel = super.getActions(model);
        panel.add(new ActionLink<GroupTO>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, GroupTO ignore) {
                GroupDirectoryPanel.this.send((IEventSink)GroupDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent<GroupWrapper>(new GroupWrapper((GroupTO)((GroupRestClient)GroupDirectoryPanel.this.restClient).read(((GroupTO)model.getObject()).getKey())), target));
            }
        }, ActionLink.ActionType.EDIT, String.format("%s,%s", "GROUP_READ", "GROUP_UPDATE")).setRealms(this.realm, ((GroupTO)model.getObject()).getDynRealms());
        panel.add(new ActionLink<GroupTO>(){
            private static final long serialVersionUID = 6242834621660352855L;

            @Override
            public void onClick(AjaxRequestTarget target, GroupTO ignore) {
                target.add(new Component[]{GroupDirectoryPanel.this.typeExtensionsModal.setContent(new TypeExtensionDirectoryPanel(GroupDirectoryPanel.this.typeExtensionsModal, (GroupTO)model.getObject(), GroupDirectoryPanel.this.pageRef))});
                GroupDirectoryPanel.this.typeExtensionsModal.header((IModel)new StringResourceModel("typeExtensions", model));
                GroupDirectoryPanel.this.typeExtensionsModal.show(true);
            }
        }, ActionLink.ActionType.TYPE_EXTENSIONS, "GROUP_UPDATE").setRealms(this.realm, ((GroupTO)model.getObject()).getDynRealms());
        panel.add(new ActionLink<GroupTO>(){
            private static final long serialVersionUID = -7978723352517770645L;

            @Override
            public void onClick(AjaxRequestTarget target, GroupTO ignore) {
                GroupDirectoryPanel.this.templates.setTargetObject((GroupTO)model.getObject());
                GroupDirectoryPanel.this.templates.toggle(target, true);
            }

            @Override
            public boolean isIndicatorEnabled() {
                return false;
            }
        }, ActionLink.ActionType.MEMBERS, String.format("%s,%s", "GROUP_READ", "GROUP_UPDATE")).setRealms(this.realm, ((GroupTO)model.getObject()).getDynRealms());
        panel.add(new ActionLink<GroupTO>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, GroupTO ignore) {
                try {
                    ((GroupRestClient)GroupDirectoryPanel.this.restClient).provisionMembers(((GroupTO)model.getObject()).getKey(), ProvisionAction.PROVISION);
                    SyncopeConsoleSession.get().success((Serializable)((Object)GroupDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{GroupDirectoryPanel.this.container});
                }
                catch (SyncopeClientException e) {
                    DirectoryPanel.LOG.error("While provisioning members of group {}", (Object)((GroupTO)model.getObject()).getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)GroupDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.PROVISION_MEMBERS, String.format("%s,%s", "TASK_CREATE", "TASK_EXECUTE")).setRealm(this.realm);
        panel.add(new ActionLink<GroupTO>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, GroupTO ignore) {
                try {
                    ((GroupRestClient)GroupDirectoryPanel.this.restClient).provisionMembers(((GroupTO)model.getObject()).getKey(), ProvisionAction.DEPROVISION);
                    SyncopeConsoleSession.get().success((Serializable)((Object)GroupDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{GroupDirectoryPanel.this.container});
                }
                catch (SyncopeClientException e) {
                    DirectoryPanel.LOG.error("While provisioning members of group {}", (Object)((GroupTO)model.getObject()).getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)GroupDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DEPROVISION_MEMBERS, String.format("%s,%s", "TASK_CREATE", "TASK_EXECUTE")).setRealm(this.realm);
        panel.add(new ActionLink<GroupTO>(){
            private static final long serialVersionUID = -7978723352517770645L;

            @Override
            public void onClick(AjaxRequestTarget target, GroupTO ignore) {
                CompoundPropertyModel formModel = new CompoundPropertyModel(new AnyWrapper<AnyTO>((AnyTO)model.getObject()));
                GroupDirectoryPanel.this.altDefaultModal.setFormModel(formModel);
                target.add(new Component[]{GroupDirectoryPanel.this.altDefaultModal.setContent(new AnyStatusModal(GroupDirectoryPanel.this.altDefaultModal, GroupDirectoryPanel.this.pageRef, ((AnyWrapper)formModel.getObject()).getInnerObject(), "resource", false))});
                GroupDirectoryPanel.this.altDefaultModal.header((IModel)new Model((Serializable)((Object)GroupDirectoryPanel.this.getString("any.edit", (IModel)new Model(new AnyWrapper<AnyTO>((AnyTO)model.getObject()))))));
                GroupDirectoryPanel.this.altDefaultModal.show(true);
            }
        }, ActionLink.ActionType.MANAGE_RESOURCES, String.format("%s,%s", "GROUP_READ", "GROUP_UPDATE")).setRealms(this.realm, ((GroupTO)model.getObject()).getDynRealms());
        panel.add(new ActionLink<GroupTO>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, GroupTO ignore) {
                target.add(new Component[]{GroupDirectoryPanel.this.utilityModal.setContent(new AnyPropagationTasks(GroupDirectoryPanel.this.utilityModal, AnyTypeKind.GROUP, ((GroupTO)model.getObject()).getKey(), GroupDirectoryPanel.this.pageRef))});
                GroupDirectoryPanel.this.utilityModal.header((IModel)new StringResourceModel("any.propagation.tasks", model));
                GroupDirectoryPanel.this.utilityModal.show(true);
            }
        }, ActionLink.ActionType.PROPAGATION_TASKS, "TASK_LIST");
        panel.add(new ActionLink<GroupTO>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, GroupTO ignore) {
                target.add(new Component[]{GroupDirectoryPanel.this.utilityModal.setContent(new NotificationTasks(AnyTypeKind.GROUP, ((GroupTO)model.getObject()).getKey(), GroupDirectoryPanel.this.pageRef))});
                GroupDirectoryPanel.this.utilityModal.header((IModel)new StringResourceModel("any.notification.tasks", model));
                GroupDirectoryPanel.this.utilityModal.show(true);
            }
        }, ActionLink.ActionType.NOTIFICATION_TASKS, "TASK_LIST");
        panel.add(new ActionLink<GroupTO>(){
            private static final long serialVersionUID = -2878723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, GroupTO ignore) {
                model.setObject(((GroupRestClient)GroupDirectoryPanel.this.restClient).read(((GroupTO)model.getObject()).getKey()));
                target.add(new Component[]{GroupDirectoryPanel.this.altDefaultModal.setContent(new AuditHistoryModal<GroupTO>(GroupDirectoryPanel.this.altDefaultModal, AuditElements.EventCategoryType.LOGIC, "GroupLogic", (GroupTO)model.getObject(), "GROUP_UPDATE", GroupDirectoryPanel.this.pageRef){
                    private static final long serialVersionUID = -5819724478921691835L;

                    @Override
                    protected void restore(String json, AjaxRequestTarget target) {
                        GroupTO original = (GroupTO)model.getObject();
                        try {
                            GroupTO updated = (GroupTO)DirectoryPanel.MAPPER.readValue(json, GroupTO.class);
                            GroupPatch groupPatch = AnyOperations.diff((GroupTO)updated, (GroupTO)original, (boolean)false);
                            ProvisioningResult<GroupTO> result = ((GroupRestClient)GroupDirectoryPanel.this.restClient).update(original.getETagValue(), groupPatch);
                            ((GroupTO)model.getObject()).setLastChangeDate(((GroupTO)result.getEntity()).getLastChangeDate());
                            SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                            target.add(new Component[]{GroupDirectoryPanel.this.container});
                        }
                        catch (Exception e) {
                            DirectoryPanel.LOG.error("While restoring group {}", (Object)((GroupTO)model.getObject()).getKey(), (Object)e);
                            SyncopeConsoleSession.get().onException(e);
                        }
                        ((BasePage)GroupDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    }
                })});
                GroupDirectoryPanel.this.altDefaultModal.header((IModel)new Model((Serializable)((Object)GroupDirectoryPanel.this.getString("auditHistory.title", (IModel)new Model(new AnyWrapper<AnyTO>((AnyTO)model.getObject()))))));
                GroupDirectoryPanel.this.altDefaultModal.show(true);
            }
        }, ActionLink.ActionType.VIEW_AUDIT_HISTORY, String.format("%s,%s", "GROUP_READ", "AUDIT_LIST")).setRealms(this.realm, ((GroupTO)model.getObject()).getDynRealms());
        panel.add(new ActionLink<GroupTO>(){
            private static final long serialVersionUID = 6242834621660352855L;

            @Override
            public void onClick(AjaxRequestTarget target, GroupTO ignore) {
                GroupTO clone = (GroupTO)SerializationUtils.clone((Serializable)((Serializable)model.getObject()));
                clone.setKey(null);
                GroupDirectoryPanel.this.send((IEventSink)GroupDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.NewItemActionEvent<GroupWrapper>(new GroupWrapper(clone), target));
            }

            @Override
            protected boolean statusCondition(GroupTO modelObject) {
                return GroupDirectoryPanel.this.realm.startsWith("/");
            }
        }, ActionLink.ActionType.CLONE, "GROUP_CREATE").setRealm(this.realm);
        panel.add(new ActionLink<GroupTO>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, GroupTO ignore) {
                try {
                    ((GroupRestClient)GroupDirectoryPanel.this.restClient).delete(((GroupTO)model.getObject()).getETagValue(), ((GroupTO)model.getObject()).getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)GroupDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{GroupDirectoryPanel.this.container});
                }
                catch (SyncopeClientException e) {
                    DirectoryPanel.LOG.error("While deleting group {}", (Object)((GroupTO)model.getObject()).getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)GroupDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }

            @Override
            protected boolean statusCondition(GroupTO modelObject) {
                return GroupDirectoryPanel.this.realm.startsWith("/");
            }
        }, ActionLink.ActionType.DELETE, "GROUP_DELETE", true).setRealm(this.realm);
        return panel;
    }

    public static class Builder
    extends AnyDirectoryPanel.Builder<GroupTO, GroupRestClient> {
        private static final long serialVersionUID = 3844281520756293159L;

        public Builder(List<AnyTypeClassTO> anyTypeClassTOs, String type, PageReference pageRef) {
            super(anyTypeClassTOs, new GroupRestClient(), type, pageRef);
            this.setShowResultPage(true);
        }

        @Override
        protected WizardMgtPanel<AnyWrapper<GroupTO>> newInstance(String id, boolean wizardInModal) {
            return new GroupDirectoryPanel(id, this, wizardInModal);
        }
    }
}

