/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.init;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.client.console.annotations.BinaryPreview;
import org.apache.syncope.client.console.annotations.ExtPage;
import org.apache.syncope.client.console.annotations.ExtWidget;
import org.apache.syncope.client.console.annotations.Resource;
import org.apache.syncope.client.console.pages.BaseExtPage;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.SSOLoginFormPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.preview.AbstractBinaryPreviewer;
import org.apache.syncope.client.console.widgets.BaseExtWidget;
import org.apache.syncope.client.console.widgets.ExtAlertWidget;
import org.apache.syncope.common.lib.policy.AccountRuleConf;
import org.apache.syncope.common.lib.policy.PasswordRuleConf;
import org.apache.syncope.common.lib.policy.PullCorrelationRuleConf;
import org.apache.syncope.common.lib.policy.PushCorrelationRuleConf;
import org.apache.syncope.common.lib.report.ReportletConf;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.wicket.request.resource.AbstractResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

public class ClassPathScanImplementationLookup {
    private static final Logger LOG = LoggerFactory.getLogger(ClassPathScanImplementationLookup.class);
    private static final String DEFAULT_BASE_PACKAGE = "org.apache.syncope";
    public static final Set<String> USER_FIELD_NAMES = new HashSet<String>();
    public static final Set<String> GROUP_FIELD_NAMES = new HashSet<String>();
    public static final Set<String> ANY_OBJECT_FIELD_NAMES = new HashSet<String>();
    private List<Class<? extends BasePage>> pages;
    private List<Class<? extends AbstractBinaryPreviewer>> previewers;
    private List<Class<? extends BaseExtPage>> extPages;
    private List<Class<? extends BaseExtWidget>> extWidgets;
    private List<Class<? extends ExtAlertWidget<?>>> extAlertWidgets;
    private List<Class<? extends SSOLoginFormPanel>> ssoLoginFormPanels;
    private Map<String, Class<? extends ReportletConf>> reportletConfs;
    private Map<String, Class<? extends AccountRuleConf>> accountRuleConfs;
    private Map<String, Class<? extends PasswordRuleConf>> passwordRuleConfs;
    private Map<String, Class<? extends PullCorrelationRuleConf>> pullCorrelationRuleConfs;
    private Map<String, Class<? extends PushCorrelationRuleConf>> pushCorrelationRuleConfs;
    private List<Class<? extends AbstractResource>> resources;

    private static void initFieldNames(Class<?> entityClass, Set<String> keys) {
        List classes = org.apache.commons.lang3.ClassUtils.getAllSuperclasses(entityClass);
        classes.add(entityClass);
        for (Class clazz : classes) {
            for (Field field : clazz.getDeclaredFields()) {
                if (field.isSynthetic() || Modifier.isStatic(field.getModifiers()) || Collection.class.isAssignableFrom(field.getType()) || Map.class.isAssignableFrom(field.getType())) continue;
                keys.add(field.getName());
            }
        }
    }

    protected String getBasePackage() {
        return DEFAULT_BASE_PACKAGE;
    }

    public void load() {
        this.pages = new ArrayList<Class<? extends BasePage>>();
        this.previewers = new ArrayList<Class<? extends AbstractBinaryPreviewer>>();
        this.extPages = new ArrayList<Class<? extends BaseExtPage>>();
        this.extWidgets = new ArrayList<Class<? extends BaseExtWidget>>();
        this.extAlertWidgets = new ArrayList();
        this.ssoLoginFormPanels = new ArrayList<Class<? extends SSOLoginFormPanel>>();
        this.reportletConfs = new HashMap<String, Class<? extends ReportletConf>>();
        this.accountRuleConfs = new HashMap<String, Class<? extends AccountRuleConf>>();
        this.passwordRuleConfs = new HashMap<String, Class<? extends PasswordRuleConf>>();
        this.pullCorrelationRuleConfs = new HashMap<String, Class<? extends PullCorrelationRuleConf>>();
        this.pushCorrelationRuleConfs = new HashMap<String, Class<? extends PushCorrelationRuleConf>>();
        this.resources = new ArrayList<Class<? extends AbstractResource>>();
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(BasePage.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(AbstractBinaryPreviewer.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(BaseExtPage.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(BaseExtWidget.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(ExtAlertWidget.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(SSOLoginFormPanel.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(ReportletConf.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(AccountRuleConf.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(PasswordRuleConf.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(PullCorrelationRuleConf.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(PushCorrelationRuleConf.class));
        scanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(AbstractResource.class));
        scanner.findCandidateComponents(this.getBasePackage()).forEach(bd -> {
            try {
                Class clazz = ClassUtils.resolveClassName((String)bd.getBeanClassName(), (ClassLoader)ClassUtils.getDefaultClassLoader());
                boolean isAbsractClazz = Modifier.isAbstract(clazz.getModifiers());
                if (!isAbsractClazz) {
                    if (BaseExtPage.class.isAssignableFrom(clazz)) {
                        if (clazz.isAnnotationPresent(ExtPage.class)) {
                            this.extPages.add(clazz);
                        } else {
                            LOG.error("Could not find annotation {} in {}, ignoring", (Object)ExtPage.class.getName(), (Object)clazz.getName());
                        }
                    } else if (BaseExtWidget.class.isAssignableFrom(clazz)) {
                        if (clazz.isAnnotationPresent(ExtWidget.class)) {
                            this.extWidgets.add(clazz);
                        } else {
                            LOG.error("Could not find annotation {} in {}, ignoring", (Object)ExtWidget.class.getName(), (Object)clazz.getName());
                        }
                    } else if (ExtAlertWidget.class.isAssignableFrom(clazz)) {
                        if (clazz.isAnnotationPresent(ExtWidget.class)) {
                            this.extAlertWidgets.add(clazz);
                        } else {
                            LOG.error("Could not find annotation {} in {}, ignoring", (Object)ExtWidget.class.getName(), (Object)clazz.getName());
                        }
                    } else if (BasePage.class.isAssignableFrom(clazz)) {
                        this.pages.add(clazz);
                    } else if (AbstractBinaryPreviewer.class.isAssignableFrom(clazz)) {
                        this.previewers.add(clazz);
                    } else if (SSOLoginFormPanel.class.isAssignableFrom(clazz)) {
                        this.ssoLoginFormPanels.add(clazz);
                    } else if (ReportletConf.class.isAssignableFrom(clazz)) {
                        this.reportletConfs.put(clazz.getName(), clazz);
                    } else if (AccountRuleConf.class.isAssignableFrom(clazz)) {
                        this.accountRuleConfs.put(clazz.getName(), clazz);
                    } else if (PasswordRuleConf.class.isAssignableFrom(clazz)) {
                        this.passwordRuleConfs.put(clazz.getName(), clazz);
                    } else if (PullCorrelationRuleConf.class.isAssignableFrom(clazz)) {
                        this.pullCorrelationRuleConfs.put(clazz.getName(), clazz);
                    } else if (PushCorrelationRuleConf.class.isAssignableFrom(clazz)) {
                        this.pushCorrelationRuleConfs.put(clazz.getName(), clazz);
                    } else if (AbstractResource.class.isAssignableFrom(clazz)) {
                        if (clazz.isAnnotationPresent(Resource.class)) {
                            this.resources.add(clazz);
                        } else {
                            LOG.error("Could not find annotation {} in {}, ignoring", (Object)Resource.class.getName(), (Object)clazz.getName());
                        }
                    }
                }
            }
            catch (Throwable t) {
                LOG.warn("Could not inspect class {}", (Object)bd.getBeanClassName(), (Object)t);
            }
        });
        this.pages = Collections.unmodifiableList(this.pages);
        this.previewers = Collections.unmodifiableList(this.previewers);
        this.extPages.sort(Comparator.comparing(o -> o.getAnnotation(ExtPage.class).priority()));
        this.extPages = Collections.unmodifiableList(this.extPages);
        this.extWidgets.sort(Comparator.comparing(o -> o.getAnnotation(ExtWidget.class).priority()));
        this.extWidgets = Collections.unmodifiableList(this.extWidgets);
        this.extAlertWidgets.sort(Comparator.comparing(o -> o.getAnnotation(ExtWidget.class).priority()));
        this.extAlertWidgets = Collections.unmodifiableList(this.extAlertWidgets);
        this.ssoLoginFormPanels = Collections.unmodifiableList(this.ssoLoginFormPanels);
        this.reportletConfs = Collections.unmodifiableMap(this.reportletConfs);
        this.accountRuleConfs = Collections.unmodifiableMap(this.accountRuleConfs);
        this.passwordRuleConfs = Collections.unmodifiableMap(this.passwordRuleConfs);
        this.pullCorrelationRuleConfs = Collections.unmodifiableMap(this.pullCorrelationRuleConfs);
        this.pushCorrelationRuleConfs = Collections.unmodifiableMap(this.pushCorrelationRuleConfs);
        this.resources = Collections.unmodifiableList(this.resources);
        LOG.debug("Binary previewers found: {}", this.previewers);
        LOG.debug("Extension pages found: {}", this.extPages);
        LOG.debug("Extension widgets found: {}", this.extWidgets);
        LOG.debug("Extension alert widgets found: {}", this.extAlertWidgets);
        LOG.debug("SSO Login pages found: {}", this.ssoLoginFormPanels);
        LOG.debug("Reportlet configurations found: {}", this.reportletConfs);
        LOG.debug("Account Rule configurations found: {}", this.accountRuleConfs);
        LOG.debug("Password Rule configurations found: {}", this.passwordRuleConfs);
        LOG.debug("Pull Correlation Rule configurations found: {}", this.pullCorrelationRuleConfs);
        LOG.debug("Push Correlation Rule configurations found: {}", this.pushCorrelationRuleConfs);
        LOG.debug("Resources found: {}", this.resources);
    }

    public Class<? extends AbstractBinaryPreviewer> getPreviewerClass(String mimeType) {
        LOG.debug("Searching for previewer class for MIME type: {}", (Object)mimeType);
        Class<? extends AbstractBinaryPreviewer> previewer = null;
        for (Class<? extends AbstractBinaryPreviewer> candidate : this.previewers) {
            LOG.debug("Evaluating previewer class {} for MIME type {}", (Object)candidate.getName(), (Object)mimeType);
            if (!candidate.isAnnotationPresent(BinaryPreview.class) || !ArrayUtils.contains((Object[])candidate.getAnnotation(BinaryPreview.class).mimeTypes(), (Object)mimeType)) continue;
            LOG.debug("Found existing previewer for MIME type {}: {}", (Object)mimeType, (Object)candidate.getName());
            previewer = candidate;
        }
        return previewer;
    }

    public List<Class<? extends BasePage>> getPageClasses() {
        return this.pages;
    }

    public List<Class<? extends BaseExtPage>> getExtPageClasses() {
        return this.extPages;
    }

    public List<Class<? extends BaseExtWidget>> getExtWidgetClasses() {
        return this.extWidgets;
    }

    public List<Class<? extends ExtAlertWidget<?>>> getExtAlertWidgetClasses() {
        return this.extAlertWidgets;
    }

    public List<Class<? extends SSOLoginFormPanel>> getSSOLoginFormPanels() {
        return this.ssoLoginFormPanels;
    }

    public Map<String, Class<? extends ReportletConf>> getReportletConfs() {
        return this.reportletConfs;
    }

    public Map<String, Class<? extends AccountRuleConf>> getAccountRuleConfs() {
        return this.accountRuleConfs;
    }

    public Map<String, Class<? extends PasswordRuleConf>> getPasswordRuleConfs() {
        return this.passwordRuleConfs;
    }

    public Map<String, Class<? extends PullCorrelationRuleConf>> getPullCorrelationRuleConfs() {
        return this.pullCorrelationRuleConfs;
    }

    public Map<String, Class<? extends PushCorrelationRuleConf>> getPushCorrelationRuleConfs() {
        return this.pushCorrelationRuleConfs;
    }

    public List<Class<? extends AbstractResource>> getResources() {
        return this.resources;
    }

    static {
        ClassPathScanImplementationLookup.initFieldNames(UserTO.class, USER_FIELD_NAMES);
        ClassPathScanImplementationLookup.initFieldNames(GroupTO.class, GROUP_FIELD_NAMES);
        ClassPathScanImplementationLookup.initFieldNames(AnyObjectTO.class, ANY_OBJECT_FIELD_NAMES);
    }
}

