/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.commons.status;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.commons.status.Status;
import org.apache.syncope.client.console.commons.status.StatusBean;
import org.apache.syncope.client.console.panels.LabelPanel;
import org.apache.syncope.client.console.rest.ReconciliationRestClient;
import org.apache.syncope.common.lib.patch.StatusPatch;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.ConnObjectTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.to.ReconStatus;
import org.apache.syncope.common.lib.types.ExecStatus;
import org.apache.syncope.common.rest.api.beans.ReconQuery;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StatusUtils
implements Serializable {
    private static final long serialVersionUID = 7238009174387184309L;
    private static final Logger LOG = LoggerFactory.getLogger(StatusUtils.class);
    private static final ReconciliationRestClient RECONCILIATION_REST_CLIENT = new ReconciliationRestClient();

    public static Optional<ReconStatus> getReconStatus(String anyTypeKey, String connObjectKeyValue, String resource) {
        ReconStatus result = null;
        try {
            result = RECONCILIATION_REST_CLIENT.status(new ReconQuery.Builder(anyTypeKey, resource).connObjectKeyValue(connObjectKeyValue).build());
        }
        catch (Exception e) {
            LOG.warn("Unexpected error for {} {} on {}", new Object[]{anyTypeKey, connObjectKeyValue, resource, e});
        }
        return Optional.ofNullable(result);
    }

    public static List<Pair<String, ReconStatus>> getReconStatuses(String anyTypeKey, String anyKey, Collection<String> resources) {
        return resources.stream().map(resource -> {
            try {
                return Pair.of((Object)resource, (Object)RECONCILIATION_REST_CLIENT.status(new ReconQuery.Builder(anyTypeKey, resource).anyKey(anyKey).build()));
            }
            catch (Exception e) {
                LOG.warn("Unexpected error for {} {} on {}", new Object[]{anyTypeKey, anyKey, resource, e});
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static StatusBean getStatusBean(AnyTO anyTO, String resource, ConnObjectTO connObjectTO, boolean notUser) {
        StatusBean statusBean = new StatusBean(anyTO, resource);
        if (connObjectTO != null) {
            Boolean enabled = StatusUtils.isEnabled(connObjectTO);
            statusBean.setStatus(enabled == null ? (notUser ? Status.ACTIVE : Status.UNDEFINED) : (enabled != false ? Status.ACTIVE : Status.SUSPENDED));
            statusBean.setConnObjectLink(StatusUtils.getConnObjectLink(connObjectTO));
        }
        return statusBean;
    }

    public static StatusBean getStatusBean(RealmTO realmTO, String resource, ConnObjectTO connObjectTO) {
        StatusBean statusBean = new StatusBean(realmTO, resource);
        if (connObjectTO != null) {
            Boolean enabled = StatusUtils.isEnabled(connObjectTO);
            statusBean.setStatus(enabled == null ? Status.ACTIVE : (enabled != false ? Status.ACTIVE : Status.SUSPENDED));
            statusBean.setConnObjectLink(StatusUtils.getConnObjectLink(connObjectTO));
        }
        return statusBean;
    }

    public static Boolean isEnabled(ConnObjectTO objectTO) {
        Optional status = objectTO.getAttr("__ENABLE__");
        return status.isPresent() && ((AttrTO)status.get()).getValues() != null && !((AttrTO)status.get()).getValues().isEmpty() ? Boolean.valueOf((String)((AttrTO)status.get()).getValues().get(0)) : Boolean.FALSE;
    }

    private static String getConnObjectLink(ConnObjectTO objectTO) {
        Optional name = objectTO == null ? null : objectTO.getAttr("__NAME__");
        return name != null && name.isPresent() && ((AttrTO)name.get()).getValues() != null && !((AttrTO)name.get()).getValues().isEmpty() ? (String)((AttrTO)name.get()).getValues().get(0) : null;
    }

    public static StatusPatch.Builder statusPatch(Collection<StatusBean> statuses) {
        StatusPatch.Builder builder = new StatusPatch.Builder();
        builder.onSyncope(false);
        statuses.forEach(status -> {
            if ("syncope".equalsIgnoreCase(status.getResource())) {
                builder.onSyncope(true);
            } else {
                builder.resource(status.getResource());
            }
        });
        return builder;
    }

    public static Panel getStatusImagePanel(String componentId, Status status) {
        return new LabelPanel(componentId, StatusUtils.getStatusImage("label", status));
    }

    public static Label getStatusImage(String componentId, Status status) {
        String clazz;
        String title;
        String alt;
        switch (status) {
            case NOT_YET_SUBMITTED: {
                alt = "undefined icon";
                title = "Not yet submitted";
                clazz = "glyphicon glyphicon-question-sign";
                break;
            }
            case ACTIVE: {
                alt = "active icon";
                title = "Enabled";
                clazz = "glyphicon glyphicon-ok-circle";
                break;
            }
            case UNDEFINED: {
                alt = "undefined icon";
                title = "Undefined status";
                clazz = "glyphicon glyphicon-question-sign";
                break;
            }
            case OBJECT_NOT_FOUND: {
                alt = "notfound icon";
                title = "Not found";
                clazz = "glyphicon glyphicon-remove-circle";
                break;
            }
            case CREATED: {
                alt = "created icon";
                title = "Created";
                clazz = "glyphicon glyphicon-ok-circle";
                break;
            }
            case SUSPENDED: {
                alt = "inactive icon";
                title = "Disabled";
                clazz = "glyphicon glyphicon-ban-circle";
                break;
            }
            default: {
                alt = "";
                title = "";
                clazz = "";
            }
        }
        return StatusUtils.getLabel(componentId, alt, title, clazz);
    }

    public static Panel getStatusImagePanel(String componentId, ExecStatus status) {
        return new LabelPanel(componentId, StatusUtils.getStatusImage("label", status));
    }

    public static Label getStatusImage(String componentId, ExecStatus status) {
        String clazz;
        String title;
        String alt;
        switch (status) {
            case NOT_ATTEMPTED: {
                alt = "not attempted";
                title = "Not attempted";
                clazz = "glyphicon glyphicon-question-sign";
                break;
            }
            case CREATED: {
                alt = "created icon";
                title = "Created";
                clazz = "glyphicon glyphicon-ok-circle";
                break;
            }
            case SUCCESS: {
                alt = "success icon";
                title = "Propagation succeded";
                clazz = "glyphicon glyphicon-ok-circle";
                break;
            }
            case FAILURE: {
                alt = "failure icon";
                title = "Propagation failed";
                clazz = "glyphicon glyphicon-remove-circle";
                break;
            }
            default: {
                alt = "";
                title = "";
                clazz = "";
            }
        }
        return StatusUtils.getLabel(componentId, alt, title, clazz);
    }

    public static Label getLabel(String componentId, final String alt, final String title, final String clazz) {
        return new Label(componentId, (Serializable)((Object)"")){
            private static final long serialVersionUID = 4755868673082976208L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("alt", (CharSequence)alt);
                tag.put("title", (CharSequence)title);
                tag.put("class", (CharSequence)clazz);
            }
        };
    }

    private StatusUtils() {
    }
}

