/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ConnObjectTO;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ConnInstanceDAO;
import org.apache.syncope.core.persistence.api.dao.DuplicateException;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.ConnInstance;
import org.apache.syncope.core.persistence.api.entity.LinkingMappingItem;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.resource.MappingItem;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.ConnectorFactory;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.VirAttrHandler;
import org.apache.syncope.core.provisioning.api.data.ConnInstanceDataBinder;
import org.apache.syncope.core.provisioning.api.data.ResourceDataBinder;
import org.apache.syncope.core.provisioning.api.utils.RealmUtils;
import org.apache.syncope.core.provisioning.java.pushpull.OutboundMatcher;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.DelegatedAdministrationException;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.spi.SearchResultsHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class ResourceLogic
extends AbstractTransactionalLogic<ResourceTO> {
    @Autowired
    private ExternalResourceDAO resourceDAO;
    @Autowired
    private AnyTypeDAO anyTypeDAO;
    @Autowired
    private ConnInstanceDAO connInstanceDAO;
    @Autowired
    private VirSchemaDAO virSchemaDAO;
    @Autowired
    private VirAttrHandler virAttrHandler;
    @Autowired
    private ResourceDataBinder binder;
    @Autowired
    private ConnInstanceDataBinder connInstanceDataBinder;
    @Autowired
    private OutboundMatcher outboundMatcher;
    @Autowired
    private MappingManager mappingManager;
    @Autowired
    private ConnectorFactory connFactory;
    @Autowired
    private AnyUtilsFactory anyUtilsFactory;

    protected void securityChecks(Set<String> effectiveRealms, String realm, String key) {
        boolean authorized = effectiveRealms.stream().anyMatch(ownedRealm -> realm.startsWith((String)ownedRealm));
        if (!authorized) {
            throw new DelegatedAdministrationException(realm, ExternalResource.class.getSimpleName(), key);
        }
    }

    @PreAuthorize(value="hasRole('RESOURCE_CREATE')")
    public ResourceTO create(ResourceTO resourceTO) {
        if (StringUtils.isBlank((CharSequence)resourceTO.getKey())) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
            sce.getElements().add("Resource key");
            throw sce;
        }
        ConnInstance connInstance = this.connInstanceDAO.authFind(resourceTO.getConnector());
        if (connInstance == null) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidExternalResource);
            sce.getElements().add("Connector " + resourceTO.getConnector());
            throw sce;
        }
        Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("RESOURCE_CREATE")), (String)connInstance.getAdminRealm().getFullPath());
        this.securityChecks(effectiveRealms, connInstance.getAdminRealm().getFullPath(), null);
        if (this.resourceDAO.authFind(resourceTO.getKey()) != null) {
            throw new DuplicateException(resourceTO.getKey());
        }
        return this.binder.getResourceTO(this.resourceDAO.save(this.binder.create(resourceTO)));
    }

    @PreAuthorize(value="hasRole('RESOURCE_UPDATE')")
    public ResourceTO update(ResourceTO resourceTO) {
        ExternalResource resource = this.resourceDAO.authFind(resourceTO.getKey());
        if (resource == null) {
            throw new NotFoundException("Resource '" + resourceTO.getKey() + "'");
        }
        Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("RESOURCE_UPDATE")), (String)resource.getConnector().getAdminRealm().getFullPath());
        this.securityChecks(effectiveRealms, resource.getConnector().getAdminRealm().getFullPath(), resource.getKey());
        return this.binder.getResourceTO(this.resourceDAO.save(this.binder.update(resource, resourceTO)));
    }

    @PreAuthorize(value="hasRole('RESOURCE_UPDATE')")
    public void setLatestSyncToken(String key, String anyTypeKey) {
        Connector connector;
        ExternalResource resource = this.resourceDAO.authFind(key);
        if (resource == null) {
            throw new NotFoundException("Resource '" + key + "'");
        }
        try {
            connector = this.connFactory.getConnector(resource);
        }
        catch (Exception e) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidConnInstance);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
        if ("REALM".equals(anyTypeKey)) {
            if (resource.getOrgUnit() == null) {
                throw new NotFoundException("Realm provision not enabled for Resource '" + key + "'");
            }
            resource.getOrgUnit().setSyncToken(connector.getLatestSyncToken(resource.getOrgUnit().getObjectClass()));
        } else {
            AnyType anyType = this.anyTypeDAO.find(anyTypeKey);
            if (anyType == null) {
                throw new NotFoundException("AnyType '" + anyTypeKey + "'");
            }
            Optional provision = resource.getProvision(anyType);
            if (!provision.isPresent()) {
                throw new NotFoundException("Provision for AnyType '" + anyTypeKey + "' in Resource '" + key + "'");
            }
            ((Provision)provision.get()).setSyncToken(connector.getLatestSyncToken(((Provision)provision.get()).getObjectClass()));
        }
        Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("RESOURCE_UPDATE")), (String)resource.getConnector().getAdminRealm().getFullPath());
        this.securityChecks(effectiveRealms, resource.getConnector().getAdminRealm().getFullPath(), resource.getKey());
        this.resourceDAO.save(resource);
    }

    @PreAuthorize(value="hasRole('RESOURCE_UPDATE')")
    public void removeSyncToken(String key, String anyTypeKey) {
        ExternalResource resource = this.resourceDAO.authFind(key);
        if (resource == null) {
            throw new NotFoundException("Resource '" + key + "'");
        }
        if ("REALM".equals(anyTypeKey)) {
            if (resource.getOrgUnit() == null) {
                throw new NotFoundException("Realm provision not enabled for Resource '" + key + "'");
            }
            resource.getOrgUnit().setSyncToken(null);
        } else {
            AnyType anyType = this.anyTypeDAO.find(anyTypeKey);
            if (anyType == null) {
                throw new NotFoundException("AnyType '" + anyTypeKey + "'");
            }
            Optional provision = resource.getProvision(anyType);
            if (!provision.isPresent()) {
                throw new NotFoundException("Provision for AnyType '" + anyTypeKey + "' in Resource '" + key + "'");
            }
            ((Provision)provision.get()).setSyncToken(null);
        }
        Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("RESOURCE_UPDATE")), (String)resource.getConnector().getAdminRealm().getFullPath());
        this.securityChecks(effectiveRealms, resource.getConnector().getAdminRealm().getFullPath(), resource.getKey());
        this.resourceDAO.save(resource);
    }

    @PreAuthorize(value="hasRole('RESOURCE_DELETE')")
    public ResourceTO delete(String key) {
        ExternalResource resource = this.resourceDAO.authFind(key);
        if (resource == null) {
            throw new NotFoundException("Resource '" + key + "'");
        }
        Set effectiveRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("RESOURCE_DELETE")), (String)resource.getConnector().getAdminRealm().getFullPath());
        this.securityChecks(effectiveRealms, resource.getConnector().getAdminRealm().getFullPath(), resource.getKey());
        ResourceTO resourceToDelete = this.binder.getResourceTO(resource);
        this.resourceDAO.delete(key);
        return resourceToDelete;
    }

    @PreAuthorize(value="hasRole('RESOURCE_READ')")
    @Transactional(readOnly=true)
    public ResourceTO read(String key) {
        ExternalResource resource = this.resourceDAO.authFind(key);
        if (resource == null) {
            throw new NotFoundException("Resource '" + key + "'");
        }
        return this.binder.getResourceTO(resource);
    }

    @PreAuthorize(value="hasRole('RESOURCE_LIST')")
    @Transactional(readOnly=true)
    public List<ResourceTO> list() {
        return this.resourceDAO.findAll().stream().map(arg_0 -> ((ResourceDataBinder)this.binder).getResourceTO(arg_0)).collect(Collectors.toList());
    }

    private Provision getProvision(String resourceKey, String anyTypeKey) {
        ExternalResource resource = this.resourceDAO.find(resourceKey);
        if (resource == null) {
            throw new NotFoundException("Resource '" + resourceKey + "'");
        }
        AnyType anyType = this.anyTypeDAO.find(anyTypeKey);
        if (anyType == null) {
            throw new NotFoundException("AnyType '" + anyTypeKey + "'");
        }
        return (Provision)resource.getProvision(anyType).orElseThrow(() -> new NotFoundException("Provision on resource '" + resourceKey + "' for type '" + anyTypeKey + "'"));
    }

    @Transactional(readOnly=true)
    public String getConnObjectKeyValue(String key, String anyTypeKey, String anyKey) {
        Provision provision = this.getProvision(key, anyTypeKey);
        Any any = this.anyUtilsFactory.getInstance(provision.getAnyType().getKind()).dao().authFind(anyKey);
        if (any == null) {
            throw new NotFoundException(provision.getAnyType() + " " + anyKey);
        }
        return (String)this.mappingManager.getConnObjectKeyValue(any, provision).orElseThrow(() -> new NotFoundException("No ConnObjectKey value found for " + anyTypeKey + " " + anyKey + " on resource '" + key + "'"));
    }

    @PreAuthorize(value="hasRole('RESOURCE_GET_CONNOBJECT')")
    @Transactional(readOnly=true)
    public ConnObjectTO readConnObjectByAnyKey(String key, String anyTypeKey, String anyKey) {
        Provision provision = this.getProvision(key, anyTypeKey);
        Any any = this.anyUtilsFactory.getInstance(provision.getAnyType().getKind()).dao().authFind(anyKey);
        if (any == null) {
            throw new NotFoundException(provision.getAnyType() + " " + anyKey);
        }
        List connObjs = this.outboundMatcher.match(this.connFactory.getConnector(provision.getResource()), any, provision, Optional.empty(), new LinkingMappingItem[0]);
        if (connObjs.isEmpty()) {
            throw new NotFoundException("Object " + any + " with class " + provision.getObjectClass() + " not found on resource " + provision.getResource().getKey());
        }
        if (connObjs.size() > 1) {
            LOG.warn("Expected single match, found {}", (Object)connObjs);
        } else {
            this.virAttrHandler.setValues(any, (ConnectorObject)connObjs.get(0));
        }
        return ConnObjectUtils.getConnObjectTO((Set)((ConnectorObject)connObjs.get(0)).getAttributes());
    }

    @PreAuthorize(value="hasRole('RESOURCE_GET_CONNOBJECT')")
    @Transactional(readOnly=true)
    public ConnObjectTO readConnObjectByConnObjectKeyValue(String key, String anyTypeKey, String connObjectKeyValue) {
        Provision provision = this.getProvision(key, anyTypeKey);
        MappingItem connObjectKeyItem = (MappingItem)MappingUtils.getConnObjectKeyItem((Provision)provision).orElseThrow(() -> new NotFoundException("ConnObjectKey mapping for " + provision.getAnyType().getKey() + " on resource '" + provision.getResource().getKey() + "'"));
        Optional connObj = this.outboundMatcher.matchByConnObjectKeyValue(this.connFactory.getConnector(provision.getResource()), connObjectKeyItem, connObjectKeyValue, provision, Optional.empty(), Optional.empty());
        if (connObj.isPresent()) {
            return ConnObjectUtils.getConnObjectTO((Set)((ConnectorObject)connObj.get()).getAttributes());
        }
        throw new NotFoundException("Object " + connObjectKeyValue + " with class " + provision.getObjectClass() + " not found on resource " + provision.getResource().getKey());
    }

    @PreAuthorize(value="hasRole('RESOURCE_LIST_CONNOBJECT')")
    @Transactional(readOnly=true)
    public Pair<SearchResult, List<ConnObjectTO>> searchConnObjects(Filter filter, Set<String> moreAttrsToGet, String key, String anyTypeKey, final int size, String pagedResultsCookie, List<OrderByClause> orderBy) {
        OperationOptions options;
        ObjectClass objectClass;
        ExternalResource resource;
        if ("REALM".equals(anyTypeKey)) {
            resource = this.resourceDAO.find(key);
            if (resource == null) {
                throw new NotFoundException("Resource '" + key + "'");
            }
            if (resource.getOrgUnit() == null) {
                throw new NotFoundException("Realm provisioning for resource '" + key + "'");
            }
            objectClass = resource.getOrgUnit().getObjectClass();
            options = MappingUtils.buildOperationOptions(resource.getOrgUnit().getItems().stream(), (String[])moreAttrsToGet.toArray(new String[0]));
        } else {
            Provision provision = this.getProvision(key, anyTypeKey);
            resource = provision.getResource();
            objectClass = provision.getObjectClass();
            Stream<MappingItem> mapItems = Stream.concat(provision.getMapping().getItems().stream(), this.virSchemaDAO.findByProvision(provision).stream().map(VirSchema::asLinkingMappingItem));
            options = MappingUtils.buildOperationOptions(mapItems, (String[])moreAttrsToGet.toArray(new String[0]));
        }
        final ArrayList connObjects = new ArrayList();
        SearchResult searchResult = this.connFactory.getConnector(resource).search(objectClass, filter, new SearchResultsHandler(){
            private int count;

            public boolean handle(ConnectorObject connectorObject) {
                connObjects.add(ConnObjectUtils.getConnObjectTO((Set)connectorObject.getAttributes()));
                ++this.count;
                return this.count < size;
            }

            public void handleResult(SearchResult sr) {
            }
        }, size, pagedResultsCookie, orderBy, options);
        return Pair.of((Object)searchResult, connObjects);
    }

    @PreAuthorize(value="hasRole('CONNECTOR_READ')")
    @Transactional(readOnly=true)
    public void check(ResourceTO resourceTO) {
        ConnInstance connInstance = this.connInstanceDAO.find(resourceTO.getConnector());
        if (connInstance == null) {
            throw new NotFoundException("Connector '" + resourceTO.getConnector() + "'");
        }
        this.connFactory.createConnector(this.connFactory.buildConnInstanceOverride(this.connInstanceDataBinder.getConnInstanceTO(connInstance), (Collection)resourceTO.getConfOverride(), (Collection)(resourceTO.isOverrideCapabilities() ? resourceTO.getCapabilitiesOverride() : null))).test();
    }

    @Override
    protected ResourceTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof ResourceTO)) continue;
                key = ((ResourceTO)args[i]).getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getResourceTO(this.resourceDAO.find(key));
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

