/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.SyncopeConstants;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.ConnObjectTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.to.PushTaskTO;
import org.apache.syncope.common.lib.to.ReconStatus;
import org.apache.syncope.common.lib.types.AnyEntitlement;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.MatchType;
import org.apache.syncope.common.rest.api.beans.AbstractCSVSpec;
import org.apache.syncope.common.rest.api.beans.CSVPullSpec;
import org.apache.syncope.common.rest.api.beans.CSVPushSpec;
import org.apache.syncope.common.rest.api.beans.ReconQuery;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.AnyDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.DerSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.LinkingMappingItem;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.resource.Item;
import org.apache.syncope.core.persistence.api.entity.resource.MappingItem;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.user.LinkedAccount;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.ConnectorFactory;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.VirAttrHandler;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopeSinglePullExecutor;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopeSinglePushExecutor;
import org.apache.syncope.core.provisioning.api.pushpull.stream.SyncopeStreamPullExecutor;
import org.apache.syncope.core.provisioning.api.pushpull.stream.SyncopeStreamPushExecutor;
import org.apache.syncope.core.provisioning.api.utils.RealmUtils;
import org.apache.syncope.core.provisioning.java.pushpull.InboundMatcher;
import org.apache.syncope.core.provisioning.java.pushpull.OutboundMatcher;
import org.apache.syncope.core.provisioning.java.pushpull.stream.CSVStreamConnector;
import org.apache.syncope.core.provisioning.java.utils.ConnObjectUtils;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.Uid;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Component;

@Component
public class ReconciliationLogic
extends AbstractTransactionalLogic<EntityTO> {
    @Autowired
    private AnyUtilsFactory anyUtilsFactory;
    @Autowired
    private AnyTypeDAO anyTypeDAO;
    @Autowired
    private ExternalResourceDAO resourceDAO;
    @Autowired
    private RealmDAO realmDAO;
    @Autowired
    private PlainSchemaDAO plainSchemaDAO;
    @Autowired
    private DerSchemaDAO derSchemaDAO;
    @Autowired
    private VirSchemaDAO virSchemaDAO;
    @Autowired
    private AnySearchDAO searchDAO;
    @Autowired
    private VirAttrHandler virAttrHandler;
    @Autowired
    private MappingManager mappingManager;
    @Autowired
    private InboundMatcher inboundMatcher;
    @Autowired
    private OutboundMatcher outboundMatcher;
    @Autowired
    private ConnectorFactory connFactory;
    @Autowired
    private SyncopeSinglePullExecutor singlePullExecutor;
    @Autowired
    private SyncopeSinglePushExecutor singlePushExecutor;
    @Autowired
    private SyncopeStreamPushExecutor streamPushExecutor;
    @Autowired
    private SyncopeStreamPullExecutor streamPullExecutor;

    private Provision getProvision(String anyTypeKey, String resourceKey) {
        AnyType anyType = this.anyTypeDAO.find(anyTypeKey);
        if (anyType == null) {
            throw new NotFoundException("AnyType '" + anyTypeKey + "'");
        }
        ExternalResource resource = this.resourceDAO.find(resourceKey);
        if (resource == null) {
            throw new NotFoundException("Resource '" + resourceKey + "'");
        }
        Provision provision = (Provision)resource.getProvision(anyType).orElseThrow(() -> new NotFoundException("Provision for " + anyType + " on Resource '" + resourceKey + "'"));
        if (provision.getMapping() == null) {
            throw new NotFoundException("Mapping for " + anyType + " on Resource '" + resourceKey + "'");
        }
        return provision;
    }

    private ConnObjectTO getOnSyncope(MappingItem connObjectKeyItem, String connObjectKeyValue, Set<Attribute> attrs) {
        ConnObjectTO connObjectTO = ConnObjectUtils.getConnObjectTO(attrs);
        connObjectTO.getAttrs().add(new AttrTO.Builder().schema(connObjectKeyItem.getExtAttrName()).value(connObjectKeyValue).build());
        connObjectTO.getAttrs().add(new AttrTO.Builder().schema(Uid.NAME).value(connObjectKeyValue).build());
        return connObjectTO;
    }

    private ConnObjectTO getOnSyncope(Any<?> any, MappingItem connObjectKeyItem, Provision provision) {
        Pair prepared = this.mappingManager.prepareAttrsFromAny(any, null, false, Boolean.valueOf(true), provision);
        return this.getOnSyncope(connObjectKeyItem, (String)prepared.getLeft(), (Set)prepared.getRight());
    }

    private ConnObjectTO getOnSyncope(LinkedAccount account, MappingItem connObjectKeyItem, Provision provision) {
        Set attrs = this.mappingManager.prepareAttrsFromLinkedAccount(account.getOwner(), account, null, false, provision);
        return this.getOnSyncope(connObjectKeyItem, account.getConnObjectKeyValue(), attrs);
    }

    private Any<?> getAny(Provision provision, String anyKey) {
        Any any;
        AnyDAO dao = this.anyUtilsFactory.getInstance(provision.getAnyType().getKind()).dao();
        Any any2 = any = SyncopeConstants.UUID_PATTERN.matcher(anyKey).matches() ? dao.authFind(anyKey) : dao.authFind(dao.findKey(anyKey));
        if (any == null) {
            throw new NotFoundException(provision.getAnyType().getKey() + " '" + anyKey + "'");
        }
        return any;
    }

    @PreAuthorize(value="hasRole('RESOURCE_GET_CONNOBJECT')")
    public ReconStatus status(ReconQuery query) {
        Provision provision = this.getProvision(query.getAnyTypeKey(), query.getResourceKey());
        MappingItem connObjectKeyItem = (MappingItem)MappingUtils.getConnObjectKeyItem((Provision)provision).orElseThrow(() -> new NotFoundException("ConnObjectKey for " + provision.getAnyType().getKey() + " on resource '" + provision.getResource().getKey() + "'"));
        ReconStatus status = new ReconStatus();
        if (query.getConnObjectKeyValue() != null) {
            this.inboundMatcher.matchByConnObjectKeyValue((Item)connObjectKeyItem, query.getConnObjectKeyValue(), provision).stream().findFirst().ifPresent(match -> {
                if (match.getAny() != null) {
                    status.setMatchType(MatchType.ANY);
                    status.setAnyTypeKind(match.getAny().getType().getKind());
                    status.setAnyKey(match.getAny().getKey());
                    status.setRealm(match.getAny().getRealm().getFullPath());
                    status.setOnSyncope(this.getOnSyncope(match.getAny(), connObjectKeyItem, provision));
                } else if (match.getLinkedAccount() != null) {
                    status.setMatchType(MatchType.LINKED_ACCOUNT);
                    status.setAnyTypeKind(AnyTypeKind.USER);
                    status.setAnyKey(match.getLinkedAccount().getOwner().getKey());
                    status.setRealm(match.getLinkedAccount().getOwner().getRealm().getFullPath());
                    status.setOnSyncope(this.getOnSyncope(match.getLinkedAccount(), connObjectKeyItem, provision));
                }
            });
            this.outboundMatcher.matchByConnObjectKeyValue(this.connFactory.getConnector(provision.getResource()), connObjectKeyItem, query.getConnObjectKeyValue(), provision, Optional.empty(), Optional.empty()).ifPresent(connObj -> {
                status.setOnResource(ConnObjectUtils.getConnObjectTO((Set)connObj.getAttributes()));
                if (status.getMatchType() == MatchType.ANY && StringUtils.isNotBlank((CharSequence)status.getAnyKey())) {
                    this.virAttrHandler.setValues(this.getAny(provision, status.getAnyKey()), connObj);
                }
            });
        }
        if (query.getAnyKey() != null) {
            Any<?> any = this.getAny(provision, query.getAnyKey());
            status.setMatchType(MatchType.ANY);
            status.setAnyTypeKind(any.getType().getKind());
            status.setAnyKey(any.getKey());
            status.setRealm(any.getRealm().getFullPath());
            status.setOnSyncope(this.getOnSyncope(any, connObjectKeyItem, provision));
            List connObjs = this.outboundMatcher.match(this.connFactory.getConnector(provision.getResource()), any, provision, Optional.empty(), new LinkingMappingItem[0]);
            if (!connObjs.isEmpty()) {
                status.setOnResource(ConnObjectUtils.getConnObjectTO((Set)((ConnectorObject)connObjs.get(0)).getAttributes()));
                if (connObjs.size() > 1) {
                    LOG.warn("Expected single match, found {}", (Object)connObjs);
                } else {
                    this.virAttrHandler.setValues(any, (ConnectorObject)connObjs.get(0));
                }
            }
        }
        return status;
    }

    @PreAuthorize(value="hasRole('TASK_EXECUTE')")
    public void push(ReconQuery query, PushTaskTO pushTask) {
        Provision provision = this.getProvision(query.getAnyTypeKey(), query.getResourceKey());
        MappingItem connObjectKeyItem = (MappingItem)MappingUtils.getConnObjectKeyItem((Provision)provision).orElseThrow(() -> new NotFoundException("ConnObjectKey for " + provision.getAnyType().getKey() + " on resource '" + provision.getResource().getKey() + "'"));
        SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Reconciliation);
        ArrayList results = new ArrayList();
        if (query.getConnObjectKeyValue() != null) {
            this.inboundMatcher.matchByConnObjectKeyValue((Item)connObjectKeyItem, query.getConnObjectKeyValue(), provision).stream().findFirst().ifPresent(match -> {
                try {
                    if (match.getMatchTarget() == MatchType.ANY) {
                        results.addAll(this.singlePushExecutor.push(provision, this.connFactory.getConnector(provision.getResource()), match.getAny(), pushTask));
                        if (!results.isEmpty() && ((ProvisioningReport)results.get(0)).getStatus() == ProvisioningReport.Status.FAILURE) {
                            sce.getElements().add(((ProvisioningReport)results.get(0)).getMessage());
                        }
                    } else {
                        ProvisioningReport result = this.singlePushExecutor.push(provision, this.connFactory.getConnector(provision.getResource()), match.getLinkedAccount(), pushTask);
                        if (result.getStatus() == ProvisioningReport.Status.FAILURE) {
                            sce.getElements().add(result.getMessage());
                        } else {
                            results.add(result);
                        }
                    }
                }
                catch (JobExecutionException e) {
                    sce.getElements().add(e.getMessage());
                }
            });
        }
        if (sce.isEmpty() && results.isEmpty() && query.getAnyKey() != null) {
            try {
                results.addAll(this.singlePushExecutor.push(provision, this.connFactory.getConnector(provision.getResource()), this.getAny(provision, query.getAnyKey()), pushTask));
                if (!results.isEmpty() && ((ProvisioningReport)results.get(0)).getStatus() == ProvisioningReport.Status.FAILURE) {
                    sce.getElements().add(((ProvisioningReport)results.get(0)).getMessage());
                }
            }
            catch (JobExecutionException e) {
                sce.getElements().add(e.getMessage());
            }
        }
        if (!sce.isEmpty()) {
            throw sce;
        }
    }

    @PreAuthorize(value="hasRole('TASK_EXECUTE')")
    public void pull(ReconQuery query, PullTaskTO pullTask) {
        Provision provision = this.getProvision(query.getAnyTypeKey(), query.getResourceKey());
        Optional connObjectKeyValue = Optional.ofNullable(query.getConnObjectKeyValue());
        if (query.getAnyKey() != null) {
            Any<?> any = this.getAny(provision, query.getAnyKey());
            connObjectKeyValue = this.mappingManager.getConnObjectKeyValue(any, provision);
        }
        if (!connObjectKeyValue.isPresent()) {
            throw new NotFoundException("ConnObjectKey for " + provision.getAnyType().getKey() + " on resource '" + provision.getResource().getKey() + "'");
        }
        if (pullTask.getDestinationRealm() == null || this.realmDAO.findByFullPath(pullTask.getDestinationRealm()) == null) {
            throw new NotFoundException("Realm " + pullTask.getDestinationRealm());
        }
        if (!provision.getMapping().getConnObjectKeyItem().isPresent()) {
            throw new NotFoundException("ConnObjectKey cannot be determines for mapping " + provision.getMapping().getKey());
        }
        SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Reconciliation);
        try {
            List results = this.singlePullExecutor.pull(provision, this.connFactory.getConnector(provision.getResource()), ((MappingItem)provision.getMapping().getConnObjectKeyItem().get()).getExtAttrName(), (String)connObjectKeyValue.get(), pullTask);
            if (!results.isEmpty() && ((ProvisioningReport)results.get(0)).getStatus() == ProvisioningReport.Status.FAILURE) {
                sce.getElements().add(((ProvisioningReport)results.get(0)).getMessage());
            }
        }
        catch (JobExecutionException e) {
            sce.getElements().add(e.getMessage());
        }
        if (!sce.isEmpty()) {
            throw sce;
        }
    }

    private CsvSchema.Builder csvSchema(AbstractCSVSpec spec) {
        CsvSchema.Builder schemaBuilder = new CsvSchema.Builder().setUseHeader(true).setColumnSeparator(spec.getColumnSeparator()).setArrayElementSeparator(spec.getArrayElementSeparator()).setQuoteChar(spec.getQuoteChar()).setLineSeparator(spec.getLineSeparator()).setNullValue(spec.getNullValue()).setAllowComments(spec.isAllowComments());
        if (spec.getEscapeChar() != null) {
            schemaBuilder.setEscapeChar(spec.getEscapeChar().charValue());
        }
        return schemaBuilder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PreAuthorize(value="hasRole('TASK_EXECUTE')")
    public List<ProvisioningReport> push(SearchCond searchCond, int page, int size, List<OrderByClause> orderBy, String realm, CSVPushSpec spec, OutputStream os) {
        List matching;
        SearchCond effectiveCond;
        String entitlement;
        AnyType anyType = this.anyTypeDAO.find(spec.getAnyTypeKey());
        if (anyType == null) {
            throw new NotFoundException("AnyType '" + spec.getAnyTypeKey() + "'");
        }
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(anyType.getKind());
        switch (anyType.getKind()) {
            case GROUP: {
                entitlement = "GROUP_SEARCH";
                break;
            }
            case ANY_OBJECT: {
                entitlement = AnyEntitlement.SEARCH.getFor(anyType.getKey());
                break;
            }
            default: {
                entitlement = "USER_SEARCH";
            }
        }
        Set adminRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get(entitlement)), (String)realm);
        SearchCond searchCond2 = effectiveCond = searchCond == null ? anyUtils.dao().getAllMatchingCond() : searchCond;
        if (spec.getIgnorePaging().booleanValue()) {
            matching = new ArrayList();
            int count = this.searchDAO.count(adminRealms, effectiveCond, anyType.getKind());
            int pages = count / 500 + 1;
            for (int p = 1; p <= pages; ++p) {
                matching.addAll(this.searchDAO.search(adminRealms, effectiveCond, p, 500, orderBy, anyType.getKind()));
            }
        } else {
            matching = this.searchDAO.search(adminRealms, effectiveCond, page, size, orderBy, anyType.getKind());
        }
        ArrayList columns = new ArrayList();
        spec.getFields().forEach(item -> {
            if (anyUtils.getField(item) == null) {
                LOG.warn("Ignoring invalid field {}", item);
            } else {
                columns.add(item);
            }
        });
        spec.getPlainAttrs().forEach(item -> {
            if (this.plainSchemaDAO.find(item) == null) {
                LOG.warn("Ignoring invalid plain schema {}", item);
            } else {
                columns.add(item);
            }
        });
        spec.getDerAttrs().forEach(item -> {
            if (this.derSchemaDAO.find(item) == null) {
                LOG.warn("Ignoring invalid derived schema {}", item);
            } else {
                columns.add(item);
            }
        });
        spec.getVirAttrs().forEach(item -> {
            if (this.virSchemaDAO.find(item) == null) {
                LOG.warn("Ignoring invalid virtual schema {}", item);
            } else {
                columns.add(item);
            }
        });
        PushTaskTO pushTask = new PushTaskTO();
        pushTask.setMatchingRule(spec.getMatchingRule());
        pushTask.setUnmatchingRule(spec.getUnmatchingRule());
        pushTask.getActions().addAll(spec.getProvisioningActions());
        try (CSVStreamConnector connector = new CSVStreamConnector(null, spec.getArrayElementSeparator(), this.csvSchema((AbstractCSVSpec)spec), null, os, columns.toArray(new String[columns.size()]));){
            List list = this.streamPushExecutor.push(anyType, matching, columns, (Connector)connector, spec.getPropagationActions(), pushTask);
            return list;
        }
        catch (Exception e) {
            LOG.error("Could not push to stream", (Throwable)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Reconciliation);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PreAuthorize(value="hasRole('TASK_EXECUTE')")
    public List<ProvisioningReport> pull(CSVPullSpec spec, InputStream csv) {
        AnyType anyType = this.anyTypeDAO.find(spec.getAnyTypeKey());
        if (anyType == null) {
            throw new NotFoundException("AnyType '" + spec.getAnyTypeKey() + "'");
        }
        if (this.realmDAO.findByFullPath(spec.getDestinationRealm()) == null) {
            throw new NotFoundException("Realm " + spec.getDestinationRealm());
        }
        PullTaskTO pullTask = new PullTaskTO();
        pullTask.setDestinationRealm(spec.getDestinationRealm());
        pullTask.setRemediation(spec.isRemediation());
        pullTask.setMatchingRule(spec.getMatchingRule());
        pullTask.setUnmatchingRule(spec.getUnmatchingRule());
        pullTask.getActions().addAll(spec.getProvisioningActions());
        try (CSVStreamConnector connector = new CSVStreamConnector(spec.getKeyColumn(), spec.getArrayElementSeparator(), this.csvSchema((AbstractCSVSpec)spec), csv, null, new String[0]);){
            List columns = connector.getColumns(spec);
            if (!columns.contains(spec.getKeyColumn())) {
                throw new NotFoundException("Key column '" + spec.getKeyColumn() + "'");
            }
            List list = this.streamPullExecutor.pull(anyType, spec.getKeyColumn(), columns, spec.getConflictResolutionAction(), spec.getPullCorrelationRule(), (Connector)connector, pullTask);
            return list;
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error("Could not pull from stream", (Throwable)e);
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.Reconciliation);
            sce.getElements().add(e.getMessage());
            throw sce;
        }
    }

    @Override
    protected EntityTO resolveReference(Method method, Object ... os) throws UnresolvedReferenceException {
        throw new UnresolvedReferenceException();
    }
}

