/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull.stream;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.types.ConflictResolutionAction;
import org.apache.syncope.common.lib.types.ImplementationType;
import org.apache.syncope.common.lib.types.MappingPurpose;
import org.apache.syncope.common.lib.types.PullMode;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.policy.PullCorrelationRuleEntity;
import org.apache.syncope.core.persistence.api.entity.policy.PullPolicy;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.resource.Mapping;
import org.apache.syncope.core.persistence.api.entity.resource.MappingItem;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.pushpull.GroupPullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.PullActions;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePullExecutor;
import org.apache.syncope.core.provisioning.api.pushpull.stream.SyncopeStreamPullExecutor;
import org.apache.syncope.core.provisioning.java.pushpull.PullJobDelegate;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.spring.ImplementationManager;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StreamPullJobDelegate
extends PullJobDelegate
implements SyncopeStreamPullExecutor {
    @Autowired
    private ImplementationDAO implementationDAO;
    @Autowired
    private RealmDAO realmDAO;
    @Autowired
    private PlainSchemaDAO plainSchemaDAO;

    private PullPolicy pullPolicy(AnyType anyType, ConflictResolutionAction conflictResolutionAction, String pullCorrelationRule) {
        PullCorrelationRuleEntity pullCorrelationRuleEntity = null;
        if (pullCorrelationRule != null) {
            Implementation implementation = this.implementationDAO.find(pullCorrelationRule);
            if (implementation == null || implementation.getType() != ImplementationType.PULL_ACTIONS) {
                LOG.debug("Invalid " + Implementation.class.getSimpleName() + " {}, ignoring...", (Object)pullCorrelationRule);
            } else {
                pullCorrelationRuleEntity = (PullCorrelationRuleEntity)this.entityFactory.newEntity(PullCorrelationRuleEntity.class);
                pullCorrelationRuleEntity.setAnyType(anyType);
                pullCorrelationRuleEntity.setImplementation(implementation);
            }
        }
        PullPolicy pullPolicy = (PullPolicy)this.entityFactory.newEntity(PullPolicy.class);
        pullPolicy.setConflictResolutionAction(conflictResolutionAction);
        if (pullCorrelationRuleEntity != null) {
            pullPolicy.add(pullCorrelationRuleEntity);
            pullCorrelationRuleEntity.setPullPolicy(pullPolicy);
        }
        return pullPolicy;
    }

    private Provision provision(AnyType anyType, String keyColumn, List<String> columns) throws JobExecutionException {
        PlainSchema keyColumnSchema;
        Provision provision = (Provision)this.entityFactory.newEntity(Provision.class);
        provision.setAnyType(anyType);
        provision.setObjectClass(new ObjectClass(anyType.getKey()));
        Mapping mapping = (Mapping)this.entityFactory.newEntity(Mapping.class);
        provision.setMapping(mapping);
        mapping.setProvision(provision);
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(anyType.getKind());
        if (anyUtils.getField(keyColumn) == null && (keyColumnSchema = (PlainSchema)this.plainSchemaDAO.find(keyColumn)) == null) {
            throw new JobExecutionException("Plain Schema for key column not found: " + keyColumn);
        }
        MappingItem connObjectKeyItem = (MappingItem)this.entityFactory.newEntity(MappingItem.class);
        connObjectKeyItem.setExtAttrName(keyColumn);
        connObjectKeyItem.setIntAttrName(keyColumn);
        connObjectKeyItem.setPurpose(MappingPurpose.PULL);
        mapping.setConnObjectKeyItem(connObjectKeyItem);
        columns.stream().filter(column -> anyUtils.getField(column) != null || this.plainSchemaDAO.find(column) != null || this.virSchemaDAO.find(column) != null).map(column -> {
            MappingItem item = (MappingItem)this.entityFactory.newEntity(MappingItem.class);
            item.setExtAttrName(column);
            item.setIntAttrName(column);
            item.setPurpose(MappingPurpose.PULL);
            mapping.add(item);
            return item;
        }).forEach(arg_0 -> ((Mapping)mapping).add(arg_0));
        return provision;
    }

    private ExternalResource externalResource(AnyType anyType, String keyColumn, List<String> columns, ConflictResolutionAction conflictResolutionAction, String pullCorrelationRule) throws JobExecutionException {
        Provision provision = this.provision(anyType, keyColumn, columns);
        ExternalResource resource = (ExternalResource)this.entityFactory.newEntity(ExternalResource.class);
        resource.add(provision);
        provision.setResource(resource);
        resource.setPullPolicy(this.pullPolicy(anyType, conflictResolutionAction, pullCorrelationRule));
        return resource;
    }

    public List<ProvisioningReport> pull(AnyType anyType, String keyColumn, List<String> columns, ConflictResolutionAction conflictResolutionAction, String pullCorrelationRule, Connector connector, PullTaskTO pullTaskTO) throws JobExecutionException {
        LOG.debug("Executing stream pull");
        ArrayList actions = new ArrayList();
        pullTaskTO.getActions().forEach(key -> {
            Implementation impl = this.implementationDAO.find(key);
            if (impl == null || impl.getType() != ImplementationType.PULL_ACTIONS) {
                LOG.debug("Invalid " + Implementation.class.getSimpleName() + " {}, ignoring...", key);
            } else {
                try {
                    actions.add(ImplementationManager.build((Implementation)impl));
                }
                catch (Exception e) {
                    LOG.warn("While building {}", (Object)impl, (Object)e);
                }
            }
        });
        try {
            GroupPullResultHandler handler;
            ExternalResource resource = this.externalResource(anyType, keyColumn, columns, conflictResolutionAction, pullCorrelationRule);
            Provision provision = (Provision)resource.getProvisions().get(0);
            PullTask pullTask = (PullTask)this.entityFactory.newEntity(PullTask.class);
            pullTask.setResource(resource);
            pullTask.setMatchingRule(pullTaskTO.getMatchingRule());
            pullTask.setUnmatchingRule(pullTaskTO.getUnmatchingRule());
            pullTask.setPullMode(PullMode.FULL_RECONCILIATION);
            pullTask.setPerformCreate(true);
            pullTask.setPerformUpdate(true);
            pullTask.setPerformDelete(false);
            pullTask.setSyncStatus(false);
            pullTask.setDestinationRealm(this.realmDAO.findByFullPath(pullTaskTO.getDestinationRealm()));
            pullTask.setRemediation(pullTaskTO.isRemediation());
            this.profile = new ProvisioningProfile(connector, (ProvisioningTask)pullTask);
            this.profile.setDryRun(false);
            this.profile.setConflictResolutionAction(ConflictResolutionAction.FIRSTMATCH);
            this.profile.getActions().addAll(actions);
            for (PullActions action2 : actions) {
                action2.beforeAll(this.profile);
            }
            GroupPullResultHandler ghandler = this.buildGroupHandler();
            switch (anyType.getKind()) {
                case USER: {
                    handler = this.buildUserHandler();
                    break;
                }
                case GROUP: {
                    handler = ghandler;
                    break;
                }
                default: {
                    handler = this.buildAnyObjectHandler();
                }
            }
            handler.setProfile(this.profile);
            handler.setPullExecutor((SyncopePullExecutor)this);
            HashSet moreAttrsToGet = new HashSet();
            actions.forEach(action -> moreAttrsToGet.addAll(action.moreAttrsToGet(this.profile, provision)));
            Stream<MappingItem> mapItems = Stream.concat(MappingUtils.getPullItems(provision.getMapping().getItems().stream()), this.virSchemaDAO.findByProvision(provision).stream().map(VirSchema::asLinkingMappingItem));
            connector.fullReconciliation(provision.getObjectClass(), (SyncResultsHandler)handler, MappingUtils.buildOperationOptions(mapItems, moreAttrsToGet.toArray(new String[0])));
            try {
                this.setGroupOwners(ghandler);
            }
            catch (Exception e) {
                LOG.error("While setting group owners", (Throwable)e);
            }
            for (PullActions action3 : actions) {
                action3.afterAll(this.profile);
            }
            return this.profile.getResults();
        }
        catch (Exception e) {
            throw e instanceof JobExecutionException ? (JobExecutionException)((Object)e) : new JobExecutionException("While stream pulling", (Throwable)e);
        }
    }
}

