/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.ConflictResolutionAction;
import org.apache.syncope.common.lib.types.ImplementationType;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.PullMode;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.resource.MappingItem;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.task.AnyTemplatePullTask;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.PullTask;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.pushpull.GroupPullResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.PullActions;
import org.apache.syncope.core.provisioning.api.pushpull.ReconFilterBuilder;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePullExecutor;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopeSinglePullExecutor;
import org.apache.syncope.core.provisioning.java.pushpull.PullJobDelegate;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.provisioning.java.utils.TemplateUtils;
import org.apache.syncope.core.spring.ImplementationManager;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.common.objects.filter.FilterBuilder;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SinglePullJobDelegate
extends PullJobDelegate
implements SyncopeSinglePullExecutor {
    @Autowired
    private ImplementationDAO implementationDAO;
    @Autowired
    private RealmDAO realmDAO;
    @Autowired
    private TemplateUtils templateUtils;

    public List<ProvisioningReport> pull(Provision provision, Connector connector, String connObjectKey, String connObjectValue, PullTaskTO pullTaskTO) throws JobExecutionException {
        LOG.debug("Executing pull on {}", (Object)provision.getResource());
        ArrayList actions = new ArrayList();
        pullTaskTO.getActions().forEach(key -> {
            Implementation impl = this.implementationDAO.find(key);
            if (impl == null || impl.getType() != ImplementationType.PULL_ACTIONS) {
                LOG.debug("Invalid " + Implementation.class.getSimpleName() + " {}, ignoring...", key);
            } else {
                try {
                    actions.add(ImplementationManager.build((Implementation)impl));
                }
                catch (Exception e) {
                    LOG.warn("While building {}", (Object)impl, (Object)e);
                }
            }
        });
        try {
            GroupPullResultHandler handler;
            PullTask pullTask = (PullTask)this.entityFactory.newEntity(PullTask.class);
            pullTask.setResource(provision.getResource());
            pullTask.setMatchingRule(pullTaskTO.getMatchingRule() == null ? MatchingRule.UPDATE : pullTaskTO.getMatchingRule());
            pullTask.setUnmatchingRule(pullTaskTO.getUnmatchingRule() == null ? UnmatchingRule.PROVISION : pullTaskTO.getUnmatchingRule());
            pullTask.setPullMode(PullMode.FILTERED_RECONCILIATION);
            pullTask.setPerformCreate(pullTaskTO.isPerformCreate());
            pullTask.setPerformUpdate(pullTaskTO.isPerformUpdate());
            pullTask.setPerformDelete(pullTaskTO.isPerformDelete());
            pullTask.setSyncStatus(pullTaskTO.isSyncStatus());
            pullTask.setDestinationRealm(this.realmDAO.findByFullPath(pullTaskTO.getDestinationRealm()));
            pullTask.setRemediation(pullTaskTO.isRemediation());
            this.templateUtils.check(pullTaskTO.getTemplates(), ClientExceptionType.InvalidPullTask);
            pullTaskTO.getTemplates().forEach((type, template) -> {
                AnyType anyType = this.anyTypeDAO.find(type);
                if (anyType == null) {
                    LOG.debug("Invalid AnyType {} specified, ignoring...", type);
                } else {
                    AnyTemplatePullTask anyTemplate = pullTask.getTemplate(anyType).orElse(null);
                    if (anyTemplate == null) {
                        anyTemplate = (AnyTemplatePullTask)this.entityFactory.newEntity(AnyTemplatePullTask.class);
                        anyTemplate.setAnyType(anyType);
                        anyTemplate.setPullTask(pullTask);
                        pullTask.add(anyTemplate);
                    }
                    anyTemplate.set(template);
                }
            });
            this.profile = new ProvisioningProfile(connector, (ProvisioningTask)pullTask);
            this.profile.setDryRun(false);
            this.profile.setConflictResolutionAction(ConflictResolutionAction.FIRSTMATCH);
            this.profile.getActions().addAll(actions);
            for (PullActions action2 : actions) {
                action2.beforeAll(this.profile);
            }
            GroupPullResultHandler ghandler = this.buildGroupHandler();
            switch (provision.getAnyType().getKind()) {
                case USER: {
                    handler = this.buildUserHandler();
                    break;
                }
                case GROUP: {
                    handler = ghandler;
                    break;
                }
                default: {
                    handler = this.buildAnyObjectHandler();
                }
            }
            handler.setProfile(this.profile);
            handler.setPullExecutor((SyncopePullExecutor)this);
            HashSet moreAttrsToGet = new HashSet();
            actions.forEach(action -> moreAttrsToGet.addAll(action.moreAttrsToGet(this.profile, provision)));
            Stream<MappingItem> mapItems = Stream.concat(MappingUtils.getPullItems(provision.getMapping().getItems().stream()), this.virSchemaDAO.findByProvision(provision).stream().map(VirSchema::asLinkingMappingItem));
            connector.filteredReconciliation(provision.getObjectClass(), (ReconFilterBuilder)new SingleReconciliationFilterBuilder(connObjectKey, connObjectValue), (SyncResultsHandler)handler, MappingUtils.buildOperationOptions(mapItems, moreAttrsToGet.toArray(new String[0])));
            try {
                this.setGroupOwners(ghandler);
            }
            catch (Exception e) {
                LOG.error("While setting group owners", (Throwable)e);
            }
            for (PullActions action3 : actions) {
                action3.afterAll(this.profile);
            }
            return this.profile.getResults();
        }
        catch (Exception e) {
            throw e instanceof JobExecutionException ? (JobExecutionException)((Object)e) : new JobExecutionException("While pulling from connector", (Throwable)e);
        }
    }

    class SingleReconciliationFilterBuilder
    implements ReconFilterBuilder {
        private final String key;
        private final String value;

        SingleReconciliationFilterBuilder(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public Filter build() {
            return FilterBuilder.equalTo((Attribute)AttributeBuilder.build((String)this.key, (Object[])new Object[]{this.value}));
        }
    }
}

