/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.Map;
import org.apache.syncope.core.provisioning.api.job.JobNamer;
import org.apache.syncope.core.provisioning.api.pushpull.PullActions;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.SecureRandomUtils;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerException;
import org.quartz.TriggerBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

public abstract class SchedulingPullActions
implements PullActions {
    @Autowired
    protected SchedulerFactoryBean scheduler;

    protected <T extends Job> void schedule(Class<T> reference, Map<String, Object> jobMap) throws JobExecutionException {
        Job jobInstance = (Job)ApplicationContextProvider.getBeanFactory().createBean(reference, 2, false);
        String jobName = this.getClass().getName() + SecureRandomUtils.generateRandomUUID();
        jobMap.put("domain", AuthContextUtils.getDomain());
        ApplicationContextProvider.getBeanFactory().registerSingleton(jobName, (Object)jobInstance);
        JobBuilder jobDetailBuilder = JobBuilder.newJob(reference).withIdentity(jobName).usingJobData(new JobDataMap(jobMap));
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger().withIdentity(JobNamer.getTriggerName((String)jobName)).startNow();
        try {
            this.scheduler.getScheduler().scheduleJob(jobDetailBuilder.build(), triggerBuilder.build());
        }
        catch (SchedulerException e) {
            throw new JobExecutionException("Could not schedule, aborting", (Throwable)e);
        }
    }
}

