/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.syncope.common.lib.types.ConflictResolutionAction;
import org.apache.syncope.core.persistence.api.dao.AnyDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.persistence.api.entity.task.PushTaskAnyFilter;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.api.search.SearchCondConverter;
import org.apache.syncope.core.persistence.api.search.SearchCondVisitor;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.ProvisionSorter;
import org.apache.syncope.core.provisioning.api.pushpull.AnyObjectPushResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.GroupPushResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.PushActions;
import org.apache.syncope.core.provisioning.api.pushpull.RealmPushResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePushResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.UserPushResultHandler;
import org.apache.syncope.core.provisioning.java.DefaultProvisionSorter;
import org.apache.syncope.core.provisioning.java.pushpull.AbstractProvisioningJobDelegate;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultAnyObjectPushResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultGroupPushResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultRealmPushResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.DefaultUserPushResultHandler;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.ImplementationManager;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;

public class PushJobDelegate
extends AbstractProvisioningJobDelegate<PushTask> {
    @Autowired
    protected AnySearchDAO searchDAO;
    @Autowired
    protected RealmDAO realmDAO;
    @Autowired
    protected AnyUtilsFactory anyUtilsFactory;
    @Autowired
    protected SearchCondVisitor searchCondVisitor;
    protected ProvisioningProfile<PushTask, PushActions> profile;
    protected final Map<String, MutablePair<Integer, String>> handled = new HashMap<String, MutablePair<Integer, String>>();

    protected void reportHandled(String anyType, String key) {
        MutablePair pair = this.handled.get(anyType);
        if (pair == null) {
            pair = MutablePair.of((Object)0, null);
            this.handled.put(anyType, (MutablePair<Integer, String>)pair);
        }
        pair.setLeft((Object)((Integer)pair.getLeft() + 1));
        pair.setRight((Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String currentStatus() {
        AtomicReference atomicReference = this.status;
        synchronized (atomicReference) {
            if (!this.handled.isEmpty()) {
                StringBuilder builder = new StringBuilder("Processed:\n");
                this.handled.forEach((key, value) -> builder.append(' ').append(value.getLeft()).append('\t').append((String)key).append(" / latest: ").append((String)value.getRight()).append('\n'));
                this.status.set(builder.toString());
            }
        }
        return (String)this.status.get();
    }

    protected void doHandle(List<? extends Any<?>> anys, SyncopePushResultHandler handler, ExternalResource resource) throws JobExecutionException {
        for (int i = 0; i < anys.size() && !this.interrupt; ++i) {
            try {
                handler.handle(anys.get(i).getKey());
                this.reportHandled(anys.get(i).getType().getKey(), anys.get(i) instanceof User ? ((User)anys.get(i)).getUsername() : (anys.get(i) instanceof Group ? ((Group)anys.get(i)).getName() : ((AnyObject)anys.get(i)).getName()));
                continue;
            }
            catch (Exception e) {
                LOG.warn("Failure pushing '{}' on '{}'", new Object[]{anys.get(i), resource, e});
                throw new JobExecutionException("While pushing " + anys.get(i) + " on " + resource, (Throwable)e);
            }
        }
    }

    protected RealmPushResultHandler buildRealmHandler() {
        return (RealmPushResultHandler)ApplicationContextProvider.getBeanFactory().createBean(DefaultRealmPushResultHandler.class, 1, false);
    }

    protected AnyObjectPushResultHandler buildAnyObjectHandler() {
        return (AnyObjectPushResultHandler)ApplicationContextProvider.getBeanFactory().createBean(DefaultAnyObjectPushResultHandler.class, 1, false);
    }

    protected UserPushResultHandler buildUserHandler() {
        return (UserPushResultHandler)ApplicationContextProvider.getBeanFactory().createBean(DefaultUserPushResultHandler.class, 1, false);
    }

    protected GroupPushResultHandler buildGroupHandler() {
        return (GroupPushResultHandler)ApplicationContextProvider.getBeanFactory().createBean(DefaultGroupPushResultHandler.class, 1, false);
    }

    @Override
    protected String doExecuteProvisioning(PushTask pushTask, Connector connector, boolean dryRun) throws JobExecutionException {
        LOG.debug("Executing push on {}", (Object)pushTask.getResource());
        ArrayList actions = new ArrayList();
        pushTask.getActions().forEach(impl -> {
            try {
                actions.add(ImplementationManager.build((Implementation)impl));
            }
            catch (Exception e) {
                LOG.warn("While building {}", impl, (Object)e);
            }
        });
        this.profile = new ProvisioningProfile(connector, (ProvisioningTask)pushTask);
        this.profile.getActions().addAll(actions);
        this.profile.setDryRun(dryRun);
        this.profile.setConflictResolutionAction(pushTask.getResource().getPushPolicy() == null ? ConflictResolutionAction.IGNORE : pushTask.getResource().getPushPolicy().getConflictResolutionAction());
        if (!this.profile.isDryRun()) {
            for (Object action : actions) {
                action.beforeAll(this.profile);
            }
        }
        this.status.set("Initialization completed");
        if (pushTask.getResource().getOrgUnit() != null) {
            this.status.set("Pushing realms");
            RealmPushResultHandler handler = this.buildRealmHandler();
            handler.setProfile(this.profile);
            for (Realm realm : this.realmDAO.findDescendants(((PushTask)this.profile.getTask()).getSourceRealm())) {
                if (realm.getParent() == null) continue;
                try {
                    handler.handle(realm.getKey());
                    this.reportHandled("REALM", realm.getName());
                }
                catch (Exception e) {
                    LOG.warn("Failure pushing '{}' on '{}'", new Object[]{realm, pushTask.getResource(), e});
                    throw new JobExecutionException("While pushing " + realm + " on " + pushTask.getResource(), (Throwable)e);
                }
            }
        }
        DefaultProvisionSorter provisionSorter = new DefaultProvisionSorter();
        if (pushTask.getResource().getProvisionSorter() != null) {
            try {
                provisionSorter = (ProvisionSorter)ImplementationManager.build((Implementation)pushTask.getResource().getProvisionSorter());
            }
            catch (Exception e) {
                LOG.error("While building {}", (Object)pushTask.getResource().getProvisionSorter(), (Object)e);
            }
        }
        for (Provision provision2 : pushTask.getResource().getProvisions().stream().filter(provision -> provision.getMapping() != null).sorted((Comparator<Provision>)((Object)provisionSorter)).collect(Collectors.toList())) {
            UserPushResultHandler handler;
            this.status.set("Pushing " + provision2.getAnyType().getKey());
            AnyDAO anyDAO = this.anyUtilsFactory.getInstance(provision2.getAnyType().getKind()).dao();
            switch (provision2.getAnyType().getKind()) {
                case USER: {
                    handler = this.buildUserHandler();
                    break;
                }
                case GROUP: {
                    handler = this.buildGroupHandler();
                    break;
                }
                default: {
                    handler = this.buildAnyObjectHandler();
                }
            }
            handler.setProfile(this.profile);
            Optional anyFilter = pushTask.getFilter(provision2.getAnyType());
            String filter = anyFilter.isPresent() ? ((PushTaskAnyFilter)anyFilter.get()).getFIQLCond() : null;
            SearchCond cond = StringUtils.isBlank((CharSequence)filter) ? anyDAO.getAllMatchingCond() : SearchCondConverter.convert((SearchCondVisitor)this.searchCondVisitor, (String)filter, (String[])new String[0]);
            int count = this.searchDAO.count(Collections.singleton(((PushTask)this.profile.getTask()).getSourceRealm().getFullPath()), cond, provision2.getAnyType().getKind());
            for (int page = 1; page <= count / 500 + 1 && !this.interrupt; ++page) {
                List anys = this.searchDAO.search(Collections.singleton(((PushTask)this.profile.getTask()).getSourceRealm().getFullPath()), cond, page, 500, Collections.emptyList(), provision2.getAnyType().getKind());
                this.doHandle(anys, (SyncopePushResultHandler)handler, pushTask.getResource());
            }
        }
        if (!this.profile.isDryRun() && !this.interrupt) {
            for (PushActions action : actions) {
                action.afterAll(this.profile);
            }
        }
        if (this.interrupt) {
            this.interrupted = true;
        }
        this.status.set("Push done");
        String result = this.createReport(this.profile.getResults(), pushTask.getResource(), dryRun);
        LOG.debug("Push result: {}", (Object)result);
        return result;
    }
}

