/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.PullMatch;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.java.job.SetUMembershipsJob;
import org.apache.syncope.core.provisioning.java.pushpull.InboundMatcher;
import org.apache.syncope.core.provisioning.java.pushpull.SchedulingPullActions;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class LDAPMembershipPullActions
extends SchedulingPullActions {
    protected static final Logger LOG = LoggerFactory.getLogger(LDAPMembershipPullActions.class);
    @Autowired
    protected AnyTypeDAO anyTypeDAO;
    @Autowired
    protected GroupDAO groupDAO;
    @Autowired
    private InboundMatcher inboundMatcher;
    protected final Map<String, Set<String>> membershipsBefore = new HashMap<String, Set<String>>();
    protected final Map<String, Set<String>> membershipsAfter = new HashMap<String, Set<String>>();

    protected String getGroupMembershipAttrName(Connector connector) {
        return connector.getConnInstance().getConf().stream().filter(property -> "groupMemberAttribute".equals(property.getSchema().getName()) && !property.getValues().isEmpty()).findFirst().map(groupMembership -> (String)groupMembership.getValues().get(0)).orElse("uniquemember");
    }

    protected List<Object> getMembAttrValues(SyncDelta delta, Connector connector) {
        String groupMemberName = this.getGroupMembershipAttrName(connector);
        Attribute membAttr = delta.getObject().getAttributeByName(groupMemberName);
        if (membAttr == null) {
            ConnectorObject remoteObj = connector.getObject(ObjectClass.GROUP, (Attribute)delta.getUid(), false, new OperationOptionsBuilder().setAttributesToGet(new String[]{groupMemberName}).build());
            if (remoteObj == null) {
                LOG.debug("Object for '{}' not found", (Object)delta.getUid().getUidValue());
            } else {
                membAttr = remoteObj.getAttributeByName(groupMemberName);
            }
        }
        return membAttr == null || membAttr.getValue() == null ? Collections.emptyList() : membAttr.getValue();
    }

    @Transactional(readOnly=true)
    public <P extends AnyPatch> void beforeUpdate(ProvisioningProfile<?, ?> profile, SyncDelta delta, EntityTO entity, P anyPatch) throws JobExecutionException {
        if (!(entity instanceof GroupTO)) {
            super.beforeUpdate(profile, delta, entity, anyPatch);
        }
        this.groupDAO.findUMemberships((Group)this.groupDAO.find(entity.getKey())).forEach(uMembership -> {
            Set<String> memb = this.membershipsBefore.get(((User)uMembership.getLeftEnd()).getKey());
            if (memb == null) {
                memb = new HashSet<String>();
                this.membershipsBefore.put(((User)uMembership.getLeftEnd()).getKey(), memb);
            }
            memb.add(entity.getKey());
        });
    }

    public void after(ProvisioningProfile<?, ?> profile, SyncDelta delta, EntityTO entity, ProvisioningReport result) throws JobExecutionException {
        Optional<Provision> provision;
        if (!(entity instanceof GroupTO)) {
            super.after(profile, delta, entity, result);
        }
        if (!(provision = profile.getTask().getResource().getProvision(this.anyTypeDAO.findUser()).filter(p -> p.getMapping() != null)).isPresent()) {
            super.after(profile, delta, entity, result);
        }
        this.getMembAttrValues(delta, profile.getConnector()).forEach(membValue -> {
            Optional<PullMatch> match = this.inboundMatcher.match(this.anyTypeDAO.findUser(), membValue.toString(), profile.getTask().getResource(), profile.getConnector());
            if (match.isPresent()) {
                Set<String> memb = this.membershipsAfter.get(match.get().getAny().getKey());
                if (memb == null) {
                    memb = new HashSet<String>();
                    this.membershipsAfter.put(match.get().getAny().getKey(), memb);
                }
                memb.add(entity.getKey());
            } else {
                LOG.warn("Could not find matching user for {}", membValue);
            }
        });
    }

    public void afterAll(ProvisioningProfile<?, ?> profile) throws JobExecutionException {
        HashMap<String, Object> jobMap = new HashMap<String, Object>();
        jobMap.put("membershipsBefore", this.membershipsBefore);
        jobMap.put("membershipsAfter", this.membershipsAfter);
        this.schedule(SetUMembershipsJob.class, jobMap);
    }
}

