/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.Optional;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.PasswordPatch;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.ProvisioningReport;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.common.lib.types.ConnConfProperty;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.ConnInstance;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.PullActions;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class DBPasswordPullActions
implements PullActions {
    private static final Logger LOG = LoggerFactory.getLogger(DBPasswordPullActions.class);
    private static final String CLEARTEXT = "CLEARTEXT";
    @Autowired
    private UserDAO userDAO;
    private String encodedPassword;
    private CipherAlgorithm cipher;

    @Transactional(readOnly=true)
    public void beforeProvision(ProvisioningProfile<?, ?> profile, SyncDelta delta, EntityTO any) throws JobExecutionException {
        if (any instanceof UserTO) {
            String password = ((UserTO)any).getPassword();
            this.parseEncodedPassword(password, profile.getConnector());
        }
    }

    @Transactional(readOnly=true)
    public <M extends AnyPatch> void beforeUpdate(ProvisioningProfile<?, ?> profile, SyncDelta delta, EntityTO entityTO, M anyPatch) throws JobExecutionException {
        if (anyPatch instanceof UserPatch) {
            PasswordPatch modPassword = ((UserPatch)anyPatch).getPassword();
            this.parseEncodedPassword(modPassword == null ? null : (String)modPassword.getValue(), profile.getConnector());
        }
    }

    private void parseEncodedPassword(String password, Connector connector) {
        ConnInstance connInstance;
        String cipherAlgorithm;
        if (password != null && !CLEARTEXT.equals(cipherAlgorithm = this.getCipherAlgorithm(connInstance = connector.getConnInstance()))) {
            try {
                this.encodedPassword = password;
                this.cipher = CipherAlgorithm.valueOf((String)cipherAlgorithm);
            }
            catch (IllegalArgumentException e) {
                LOG.error("Cipher algorithm not allowed: {}", (Object)cipherAlgorithm, (Object)e);
                this.encodedPassword = null;
            }
        }
    }

    private String getCipherAlgorithm(ConnInstance connInstance) {
        Optional<ConnConfProperty> cipherAlgorithm = connInstance.getConf().stream().filter(property -> "cipherAlgorithm".equals(property.getSchema().getName()) && property.getValues() != null && !property.getValues().isEmpty()).findFirst();
        return cipherAlgorithm.isPresent() ? (String)cipherAlgorithm.get().getValues().get(0) : CLEARTEXT;
    }

    @Transactional
    public void after(ProvisioningProfile<?, ?> profile, SyncDelta delta, EntityTO any, ProvisioningReport result) throws JobExecutionException {
        if (any instanceof UserTO && this.encodedPassword != null && this.cipher != null) {
            User user = (User)this.userDAO.find(any.getKey());
            if (user != null) {
                user.setEncodedPassword(this.encodedPassword.toUpperCase(), this.cipher);
            }
            this.encodedPassword = null;
            this.cipher = null;
        }
    }
}

