/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.propagation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.syncope.common.lib.types.ExecStatus;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.provisioning.api.propagation.PropagationException;
import org.apache.syncope.core.provisioning.api.propagation.PropagationReporter;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskCallable;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskInfo;
import org.apache.syncope.core.provisioning.java.propagation.AbstractPropagationTaskExecutor;
import org.apache.syncope.core.provisioning.java.propagation.DefaultPropagationTaskCallable;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class PriorityPropagationTaskExecutor
extends AbstractPropagationTaskExecutor {
    @Resource(name="propagationTaskExecutorAsyncExecutor")
    protected ThreadPoolTaskExecutor executor;

    protected PropagationTaskCallable newPropagationTaskCallable(PropagationTaskInfo taskInfo, PropagationReporter reporter) {
        PropagationTaskCallable callable = (PropagationTaskCallable)ApplicationContextProvider.getBeanFactory().createBean(DefaultPropagationTaskCallable.class, 2, false);
        callable.setTaskInfo(taskInfo);
        callable.setReporter(reporter);
        return callable;
    }

    @Override
    protected void doExecute(Collection<PropagationTaskInfo> taskInfos, PropagationReporter reporter, boolean nullPriorityAsync) {
        List<PropagationTaskInfo> prioritizedTasks = taskInfos.stream().filter(task -> task.getExternalResource().getPropagationPriority() != null).sorted(Comparator.comparing(task -> task.getExternalResource().getPropagationPriority())).collect(Collectors.toList());
        LOG.debug("Propagation tasks sorted by priority, for serial execution: {}", prioritizedTasks);
        List<PropagationTaskInfo> concurrentTasks = taskInfos.stream().filter(task -> !prioritizedTasks.contains(task)).collect(Collectors.toList());
        LOG.debug("Propagation tasks for concurrent execution: {}", concurrentTasks);
        prioritizedTasks.forEach(task -> {
            ExecStatus execStatus;
            TaskExec execution = null;
            String errorMessage = null;
            try {
                execution = (TaskExec)this.newPropagationTaskCallable((PropagationTaskInfo)task, reporter).call();
                execStatus = ExecStatus.valueOf((String)execution.getStatus());
            }
            catch (Exception e) {
                LOG.error("Unexpected exception", (Throwable)e);
                execStatus = ExecStatus.FAILURE;
                errorMessage = e.getMessage();
            }
            if (execStatus != ExecStatus.SUCCESS) {
                throw new PropagationException(task.getResource(), execution == null ? errorMessage : execution.getMessage());
            }
        });
        if (!concurrentTasks.isEmpty()) {
            ExecutorCompletionService completionService = new ExecutorCompletionService((Executor)this.executor);
            ArrayList futures = new ArrayList();
            concurrentTasks.forEach(taskInfo -> {
                try {
                    futures.add(completionService.submit(this.newPropagationTaskCallable((PropagationTaskInfo)taskInfo, reporter)));
                    if (nullPriorityAsync) {
                        reporter.onSuccessOrNonPriorityResourceFailures(taskInfo, ExecStatus.CREATED, null, null, null);
                    }
                }
                catch (Exception e) {
                    LOG.error("While submitting task for async execution", taskInfo, (Object)e);
                    this.rejected((PropagationTaskInfo)taskInfo, e.getMessage(), reporter);
                }
            });
            if (!nullPriorityAsync) {
                futures.forEach(future -> {
                    try {
                        future.get();
                    }
                    catch (Exception e) {
                        LOG.error("Unexpected exception", (Throwable)e);
                    }
                });
            }
        }
    }
}

