/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.notification;

import java.io.StringWriter;
import java.io.Writer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.AuditLoggerName;
import org.apache.syncope.core.persistence.api.dao.AnyMatchDAO;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.ConfDAO;
import org.apache.syncope.core.persistence.api.dao.DerSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.NotificationDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyAbout;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.DerSchema;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.Notification;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.task.NotificationTask;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.entity.user.UMembership;
import org.apache.syncope.core.persistence.api.entity.user.UPlainAttr;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.api.search.SearchCondConverter;
import org.apache.syncope.core.persistence.api.search.SearchCondVisitor;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.IntAttrName;
import org.apache.syncope.core.provisioning.api.IntAttrNameParser;
import org.apache.syncope.core.provisioning.api.VirAttrHandler;
import org.apache.syncope.core.provisioning.api.data.AnyObjectDataBinder;
import org.apache.syncope.core.provisioning.api.data.GroupDataBinder;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.provisioning.api.event.AfterHandlingEvent;
import org.apache.syncope.core.provisioning.api.jexl.JexlUtils;
import org.apache.syncope.core.provisioning.api.notification.NotificationManager;
import org.apache.syncope.core.provisioning.api.notification.RecipientsProvider;
import org.apache.syncope.core.spring.ImplementationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Throwable.class})
public class DefaultNotificationManager
implements NotificationManager {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationManager.class);
    @Autowired
    private DerSchemaDAO derSchemaDAO;
    @Autowired
    private VirSchemaDAO virSchemaDAO;
    @Autowired
    private NotificationDAO notificationDAO;
    @Autowired
    private ConfDAO confDAO;
    @Autowired
    private AnyObjectDAO anyObjectDAO;
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private GroupDAO groupDAO;
    @Autowired
    private AnySearchDAO searchDAO;
    @Autowired
    private AnyMatchDAO anyMatchDAO;
    @Autowired
    private TaskDAO taskDAO;
    @Autowired
    private DerAttrHandler derAttrHander;
    @Autowired
    private VirAttrHandler virAttrHander;
    @Autowired
    private UserDataBinder userDataBinder;
    @Autowired
    private GroupDataBinder groupDataBinder;
    @Autowired
    private AnyObjectDataBinder anyObjectDataBinder;
    @Autowired
    private EntityFactory entityFactory;
    @Autowired
    private IntAttrNameParser intAttrNameParser;
    @Autowired
    private SearchCondVisitor searchCondVisitor;

    @Transactional(readOnly=true)
    public long getMaxRetries() {
        return (Long)this.confDAO.find("notification.maxRetries", (Object)0L);
    }

    private NotificationTask getNotificationTask(Notification notification, Any<?> any, Map<String, Object> jexlVars) {
        if (any != null) {
            this.virAttrHander.getValues(any);
        }
        ArrayList<User> recipients = new ArrayList<User>();
        if (notification.getRecipientsFIQL() != null) {
            recipients.addAll(this.searchDAO.search(SearchCondConverter.convert((SearchCondVisitor)this.searchCondVisitor, (String)notification.getRecipientsFIQL(), (String[])new String[0]), Collections.emptyList(), AnyTypeKind.USER));
        }
        if (notification.isSelfAsRecipient() && any instanceof User) {
            recipients.add((User)any);
        }
        HashSet recipientEmails = new HashSet();
        ArrayList recipientTOs = new ArrayList(recipients.size());
        recipients.forEach(recipient -> {
            this.virAttrHander.getValues((Any)recipient);
            String email = this.getRecipientEmail(notification.getRecipientAttrName(), (User)recipient);
            if (email == null) {
                LOG.warn("{} cannot be notified: {} not found", recipient, (Object)notification.getRecipientAttrName());
            } else {
                recipientEmails.add(email);
                recipientTOs.add(this.userDataBinder.getUserTO(recipient, true));
            }
        });
        if (notification.getStaticRecipients() != null) {
            recipientEmails.addAll(notification.getStaticRecipients());
        }
        if (notification.getRecipientsProvider() != null) {
            try {
                RecipientsProvider recipientsProvider = (RecipientsProvider)ImplementationManager.build((Implementation)notification.getRecipientsProvider());
                recipientEmails.addAll(recipientsProvider.provideRecipients(notification));
            }
            catch (Exception e) {
                LOG.error("While building {}", (Object)notification.getRecipientsProvider(), (Object)e);
            }
        }
        jexlVars.put("recipients", recipientTOs);
        jexlVars.put("syncopeConf", this.findAllSyncopeConfs());
        jexlVars.put("events", notification.getEvents());
        NotificationTask task = (NotificationTask)this.entityFactory.newEntity(NotificationTask.class);
        task.setNotification(notification);
        if (any != null) {
            task.setEntityKey(any.getKey());
            task.setAnyTypeKind(any.getType().getKind());
        }
        task.setTraceLevel(notification.getTraceLevel());
        task.getRecipients().addAll(recipientEmails);
        task.setSender(notification.getSender());
        task.setSubject(notification.getSubject());
        if (StringUtils.isNotBlank((CharSequence)notification.getTemplate().getTextTemplate())) {
            task.setTextBody(this.evaluate(notification.getTemplate().getTextTemplate(), jexlVars));
        }
        if (StringUtils.isNotBlank((CharSequence)notification.getTemplate().getHTMLTemplate())) {
            task.setHtmlBody(this.evaluate(notification.getTemplate().getHTMLTemplate(), jexlVars));
        }
        return task;
    }

    private String evaluate(String template, Map<String, Object> jexlVars) {
        StringWriter writer = new StringWriter();
        JexlUtils.newJxltEngine().createTemplate(template).evaluate((JexlContext)new MapContext(jexlVars), (Writer)writer);
        return writer.toString();
    }

    public boolean notificationsAvailable(AuditElements.EventCategoryType type, String category, String subcategory, String event) {
        String successEvent = AuditLoggerName.buildEvent((AuditElements.EventCategoryType)type, (String)category, (String)subcategory, (String)event, (AuditElements.Result)AuditElements.Result.SUCCESS);
        String failureEvent = AuditLoggerName.buildEvent((AuditElements.EventCategoryType)type, (String)category, (String)subcategory, (String)event, (AuditElements.Result)AuditElements.Result.FAILURE);
        return this.notificationDAO.findAll().stream().anyMatch(notification -> notification.isActive() && (notification.getEvents().contains(successEvent) || notification.getEvents().contains(failureEvent)));
    }

    public void createTasks(AfterHandlingEvent event) {
        this.createTasks(event.getWho(), event.getType(), event.getCategory(), event.getSubcategory(), event.getEvent(), event.getCondition(), event.getBefore(), event.getOutput(), event.getInput());
    }

    public List<NotificationTask> createTasks(String who, AuditElements.EventCategoryType type, String category, String subcategory, String event, AuditElements.Result condition, Object before, Object output, Object ... input) {
        Any any = null;
        if (before instanceof UserTO) {
            any = this.userDAO.find(((UserTO)before).getKey());
        } else if (output instanceof UserTO) {
            any = this.userDAO.find(((UserTO)output).getKey());
        } else if (output instanceof Pair && ((Pair)output).getRight() instanceof UserTO) {
            any = this.userDAO.find(((UserTO)((Pair)output).getRight()).getKey());
        } else if (output instanceof ProvisioningResult && ((ProvisioningResult)output).getEntity() instanceof UserTO) {
            any = this.userDAO.find(((ProvisioningResult)output).getEntity().getKey());
        } else if (before instanceof AnyObjectTO) {
            any = this.anyObjectDAO.find(((AnyObjectTO)before).getKey());
        } else if (output instanceof AnyObjectTO) {
            any = this.anyObjectDAO.find(((AnyObjectTO)output).getKey());
        } else if (output instanceof ProvisioningResult && ((ProvisioningResult)output).getEntity() instanceof AnyObjectTO) {
            any = this.anyObjectDAO.find(((ProvisioningResult)output).getEntity().getKey());
        } else if (before instanceof GroupTO) {
            any = this.groupDAO.find(((GroupTO)before).getKey());
        } else if (output instanceof GroupTO) {
            any = this.groupDAO.find(((GroupTO)output).getKey());
        } else if (output instanceof ProvisioningResult && ((ProvisioningResult)output).getEntity() instanceof GroupTO) {
            any = this.groupDAO.find(((ProvisioningResult)output).getEntity().getKey());
        }
        AnyType anyType = any == null ? null : any.getType();
        LOG.debug("Search notification for [{}]{}", (Object)anyType, (Object)any);
        ArrayList<NotificationTask> notifications = new ArrayList<NotificationTask>();
        for (Notification notification : this.notificationDAO.findAll()) {
            if (LOG.isDebugEnabled()) {
                notification.getAbouts().forEach(about -> LOG.debug("Notification about {} defined: {}", (Object)about.getAnyType(), (Object)about.get()));
            }
            if (notification.isActive()) {
                String currentEvent = AuditLoggerName.buildEvent((AuditElements.EventCategoryType)type, (String)category, (String)subcategory, (String)event, (AuditElements.Result)condition);
                if (!notification.getEvents().contains(currentEvent)) {
                    LOG.debug("No events found about {}", (Object)any);
                    continue;
                }
                if (anyType != null && any != null && notification.getAbout(anyType).isPresent() && !this.anyMatchDAO.matches(any, SearchCondConverter.convert((SearchCondVisitor)this.searchCondVisitor, (String)((AnyAbout)notification.getAbout(anyType).get()).get(), (String[])new String[0]))) continue;
                LOG.debug("Creating notification task for event {} about {}", (Object)currentEvent, (Object)any);
                HashMap<String, Object> model = new HashMap<String, Object>();
                model.put("who", who);
                model.put("type", type);
                model.put("category", category);
                model.put("subcategory", subcategory);
                model.put("event", event);
                model.put("condition", condition);
                model.put("before", before);
                model.put("output", output);
                model.put("input", input);
                if (any instanceof User) {
                    model.put("user", this.userDataBinder.getUserTO((User)any, true));
                } else if (any instanceof Group) {
                    model.put("group", this.groupDataBinder.getGroupTO((Group)any, true));
                } else if (any instanceof AnyObject) {
                    model.put("anyObject", this.anyObjectDataBinder.getAnyObjectTO((AnyObject)any, true));
                }
                NotificationTask notificationTask = this.getNotificationTask(notification, any, model);
                notificationTask = (NotificationTask)this.taskDAO.save((Task)notificationTask);
                notifications.add(notificationTask);
                continue;
            }
            LOG.debug("Notification {} is not active, task will not be created", (Object)notification.getKey());
        }
        return notifications;
    }

    private String getRecipientEmail(String recipientAttrName, User user) {
        IntAttrName intAttrName;
        String email = null;
        try {
            intAttrName = this.intAttrNameParser.parse(recipientAttrName, AnyTypeKind.USER);
        }
        catch (ParseException e) {
            LOG.error("Invalid intAttrName '{}' specified as recipient, ignoring", (Object)recipientAttrName, (Object)e);
            return email;
        }
        if ("username".equals(intAttrName.getField())) {
            email = user.getUsername();
        } else if (intAttrName.getSchemaType() != null) {
            Group group;
            UMembership membership = null;
            if (intAttrName.getMembershipOfGroup() != null && (group = this.groupDAO.findByName(intAttrName.getMembershipOfGroup())) != null) {
                membership = user.getMembership(group.getKey()).orElse(null);
            }
            switch (intAttrName.getSchemaType()) {
                case PLAIN: {
                    Optional attr;
                    Optional optional = attr = membership == null ? user.getPlainAttr(recipientAttrName) : user.getPlainAttr(recipientAttrName, membership);
                    if (!attr.isPresent()) break;
                    email = ((UPlainAttr)attr.get()).getValuesAsStrings().isEmpty() ? null : (String)((UPlainAttr)attr.get()).getValuesAsStrings().get(0);
                    break;
                }
                case DERIVED: {
                    DerSchema schema = (DerSchema)this.derSchemaDAO.find(recipientAttrName);
                    if (schema == null) {
                        LOG.warn("Ignoring non existing {} {}", (Object)DerSchema.class.getSimpleName(), (Object)recipientAttrName);
                        break;
                    }
                    email = membership == null ? this.derAttrHander.getValue((Any)user, schema) : this.derAttrHander.getValue((Any)user, (Membership)membership, schema);
                    break;
                }
                case VIRTUAL: {
                    VirSchema virSchema = (VirSchema)this.virSchemaDAO.find(recipientAttrName);
                    if (virSchema == null) {
                        LOG.warn("Ignoring non existing {} {}", (Object)VirSchema.class.getSimpleName(), (Object)recipientAttrName);
                        break;
                    }
                    List virAttrValues = membership == null ? this.virAttrHander.getValues((Any)user, virSchema) : this.virAttrHander.getValues((Any)user, (Membership)membership, virSchema);
                    email = virAttrValues.isEmpty() ? null : (String)virAttrValues.get(0);
                    break;
                }
            }
        }
        return email;
    }

    public TaskExec storeExec(TaskExec execution) {
        NotificationTask task = (NotificationTask)this.taskDAO.find(execution.getTask().getKey());
        task.add(execution);
        task.setExecuted(true);
        this.taskDAO.save((Task)task);
        return execution;
    }

    public void setTaskExecuted(String taskKey, boolean executed) {
        NotificationTask task = (NotificationTask)this.taskDAO.find(taskKey);
        task.setExecuted(executed);
        this.taskDAO.save((Task)task);
    }

    public long countExecutionsWithStatus(String taskKey, String status) {
        NotificationTask task = (NotificationTask)this.taskDAO.find(taskKey);
        long count = 0L;
        for (TaskExec taskExec : task.getExecs()) {
            if (status == null) {
                if (taskExec.getStatus() != null) continue;
                ++count;
                continue;
            }
            if (!status.equals(taskExec.getStatus())) continue;
            ++count;
        }
        return count;
    }

    protected Map<String, String> findAllSyncopeConfs() {
        return this.confDAO.get().getPlainAttrs().stream().collect(Collectors.toMap(attr -> attr.getSchema().getKey(), attr -> (String)attr.getValuesAsStrings().get(0)));
    }
}

