/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job.report;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.syncope.common.lib.report.ReportletConf;
import org.apache.syncope.core.persistence.api.dao.Reportlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractReportlet
implements Reportlet {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractReportlet.class);
    protected ReportletConf conf;

    public void setConf(ReportletConf conf) {
        this.conf = conf;
    }

    protected abstract void doExtract(ReportletConf var1, ContentHandler var2, AtomicReference<String> var3) throws SAXException;

    @Transactional(readOnly=true)
    public void extract(ContentHandler handler, AtomicReference<String> status) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "name", "xsd:string", this.conf.getName());
        atts.addAttribute("", "", "class", "xsd:string", this.getClass().getName());
        handler.startElement("", "", "reportlet", atts);
        this.doExtract(this.conf, handler, status);
        handler.endElement("", "", "reportlet");
    }
}

