/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job;

import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.to.PropagationStatus;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ProvisionAction;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.search.AbstractSearchCond;
import org.apache.syncope.core.persistence.api.dao.search.MembershipCond;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.AnyObjectProvisioningManager;
import org.apache.syncope.core.provisioning.api.UserProvisioningManager;
import org.apache.syncope.core.provisioning.java.job.AbstractSchedTaskJobDelegate;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public class GroupMemberProvisionTaskJobDelegate
extends AbstractSchedTaskJobDelegate {
    public static final String ACTION_JOBDETAIL_KEY = "action";
    public static final String GROUP_KEY_JOBDETAIL_KEY = "groupKey";
    @Autowired
    private GroupDAO groupDAO;
    @Autowired
    private AnySearchDAO searchDAO;
    @Autowired
    private UserProvisioningManager userProvisioningManager;
    @Autowired
    private AnyObjectProvisioningManager anyObjectProvisioningManager;
    private String groupKey;
    private ProvisionAction action;

    @Override
    @Transactional
    public void execute(String taskKey, boolean dryRun, JobExecutionContext context) throws JobExecutionException {
        this.groupKey = context.getMergedJobDataMap().getString(GROUP_KEY_JOBDETAIL_KEY);
        this.action = (ProvisionAction)context.getMergedJobDataMap().get((Object)ACTION_JOBDETAIL_KEY);
        super.execute(taskKey, dryRun, context);
    }

    @Override
    protected String doExecute(boolean dryRun) throws JobExecutionException {
        Group group = (Group)this.groupDAO.authFind(this.groupKey);
        StringBuilder result = new StringBuilder("Group ").append(group.getName()).append(" members ");
        if (this.action == ProvisionAction.DEPROVISION) {
            result.append("de");
        }
        result.append("provision\n\n");
        this.status.set(result.toString());
        MembershipCond membershipCond = new MembershipCond();
        membershipCond.setGroup(this.groupKey);
        List users = this.searchDAO.search(SearchCond.getLeaf((AbstractSearchCond)membershipCond), AnyTypeKind.USER);
        Collection groupResourceKeys = this.groupDAO.findAllResourceKeys(this.groupKey);
        this.status.set("About to " + (this.action == ProvisionAction.DEPROVISION ? "de" : "") + "provision " + users.size() + " users from " + groupResourceKeys);
        for (int i = 0; i < users.size() && !this.interrupt; ++i) {
            List statuses = this.action == ProvisionAction.DEPROVISION ? this.userProvisioningManager.deprovision(((User)users.get(i)).getKey(), groupResourceKeys, false) : this.userProvisioningManager.provision(((User)users.get(i)).getKey(), true, null, groupResourceKeys, false);
            for (PropagationStatus propagationStatus : statuses) {
                result.append("User ").append(((User)users.get(i)).getKey()).append('\t').append("Resource ").append(propagationStatus.getResource()).append('\t').append(propagationStatus.getStatus());
                if (StringUtils.isNotBlank((CharSequence)propagationStatus.getFailureReason())) {
                    result.append('\n').append(propagationStatus.getFailureReason()).append('\n');
                }
                result.append("\n");
            }
            result.append("\n");
        }
        if (this.interrupt) {
            LOG.debug("Group assignment interrupted");
            this.interrupted = true;
            return result.append("\n*** Group assignment interrupted ***\n").toString();
        }
        membershipCond = new MembershipCond();
        membershipCond.setGroup(this.groupKey);
        List anyObjects = this.searchDAO.search(SearchCond.getLeaf((AbstractSearchCond)membershipCond), AnyTypeKind.ANY_OBJECT);
        this.status.set("About to " + (this.action == ProvisionAction.DEPROVISION ? "de" : "") + "provision " + anyObjects.size() + " any objects from " + groupResourceKeys);
        for (int i = 0; i < anyObjects.size() && !this.interrupt; ++i) {
            List statuses = this.action == ProvisionAction.DEPROVISION ? this.anyObjectProvisioningManager.deprovision(((AnyObject)anyObjects.get(i)).getKey(), groupResourceKeys, false) : this.anyObjectProvisioningManager.provision(((AnyObject)anyObjects.get(i)).getKey(), groupResourceKeys, false);
            for (PropagationStatus propagationStatus : statuses) {
                result.append(((AnyObject)anyObjects.get(i)).getType().getKey()).append(' ').append(((AnyObject)anyObjects.get(i)).getKey()).append('\t').append("Resource ").append(propagationStatus.getResource()).append('\t').append(propagationStatus.getStatus());
                if (StringUtils.isNotBlank((CharSequence)propagationStatus.getFailureReason())) {
                    result.append('\n').append(propagationStatus.getFailureReason()).append('\n');
                }
                result.append("\n");
            }
            result.append("\n");
        }
        if (this.interrupt) {
            LOG.debug("Group assignment interrupted");
            this.interrupted = true;
            result.append("\n*** Group assignment interrupted ***\n");
        }
        return result.toString();
    }

    @Override
    protected boolean hasToBeRegistered(TaskExec execution) {
        return true;
    }
}

