/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.AttrPatch;
import org.apache.syncope.common.lib.patch.PasswordPatch;
import org.apache.syncope.common.lib.patch.StringPatchItem;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.LinkedAccountTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.dao.AccessTokenDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ApplicationDAO;
import org.apache.syncope.core.persistence.api.dao.ConfDAO;
import org.apache.syncope.core.persistence.api.dao.RoleDAO;
import org.apache.syncope.core.persistence.api.dao.SecurityQuestionDAO;
import org.apache.syncope.core.persistence.api.entity.AccessToken;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.GroupableRelatable;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Privilege;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.Relationship;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.persistence.api.entity.Role;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.user.LAPlainAttr;
import org.apache.syncope.core.persistence.api.entity.user.LinkedAccount;
import org.apache.syncope.core.persistence.api.entity.user.SecurityQuestion;
import org.apache.syncope.core.persistence.api.entity.user.UMembership;
import org.apache.syncope.core.persistence.api.entity.user.UPlainAttr;
import org.apache.syncope.core.persistence.api.entity.user.URelationship;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.provisioning.java.data.AbstractAnyDataBinder;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(rollbackFor={Throwable.class})
public class UserDataBinderImpl
extends AbstractAnyDataBinder
implements UserDataBinder {
    @Autowired
    private RoleDAO roleDAO;
    @Autowired
    private ConfDAO confDAO;
    @Autowired
    private SecurityQuestionDAO securityQuestionDAO;
    @Autowired
    private AnyTypeDAO anyTypeDAO;
    @Autowired
    private ApplicationDAO applicationDAO;
    @Autowired
    private AccessTokenDAO accessTokenDAO;
    @Resource(name="adminUser")
    private String adminUser;
    @Resource(name="anonymousUser")
    private String anonymousUser;

    @Transactional(readOnly=true)
    public UserTO returnUserTO(UserTO userTO) {
        if (!((Boolean)this.confDAO.find("return.password.value", (Object)false)).booleanValue()) {
            userTO.setPassword(null);
            userTO.getLinkedAccounts().forEach(account -> account.setPassword(null));
        }
        return userTO;
    }

    @Transactional(readOnly=true)
    public UserTO getAuthenticatedUserTO() {
        UserTO authUserTO;
        String authUsername = AuthContextUtils.getUsername();
        if (this.anonymousUser.equals(authUsername)) {
            authUserTO = new UserTO();
            authUserTO.setKey(null);
            authUserTO.setUsername(this.anonymousUser);
        } else if (this.adminUser.equals(authUsername)) {
            authUserTO = new UserTO();
            authUserTO.setKey(null);
            authUserTO.setUsername(this.adminUser);
        } else {
            User authUser = this.userDAO.findByUsername(authUsername);
            authUserTO = this.getUserTO(authUser, true);
        }
        return authUserTO;
    }

    private void setPassword(User user, String password, SyncopeClientCompositeException scce) {
        try {
            String algorithm = (String)this.confDAO.find("password.cipher.algorithm", (Object)CipherAlgorithm.AES.name());
            user.setPassword(password, CipherAlgorithm.valueOf((String)algorithm));
        }
        catch (IllegalArgumentException e) {
            SyncopeClientException invalidCiperAlgorithm = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.NotFound);
            invalidCiperAlgorithm.getElements().add(e.getMessage());
            scce.addException(invalidCiperAlgorithm);
            throw scce;
        }
    }

    private void linkedAccount(final User user, final LinkedAccountTO accountTO, AnyUtils anyUtils, SyncopeClientException invalidValues) {
        final ExternalResource resource = this.resourceDAO.find(accountTO.getResource());
        if (resource == null) {
            LOG.debug("Ignoring invalid resource {}", (Object)accountTO.getResource());
        } else {
            Optional found = user.getLinkedAccount(resource.getKey(), accountTO.getConnObjectKeyValue());
            LinkedAccount account = found.isPresent() ? (LinkedAccount)found.get() : new Supplier<LinkedAccount>(){

                @Override
                public LinkedAccount get() {
                    LinkedAccount acct = (LinkedAccount)UserDataBinderImpl.this.entityFactory.newEntity(LinkedAccount.class);
                    acct.setOwner(user);
                    user.add(acct);
                    acct.setConnObjectKeyValue(accountTO.getConnObjectKeyValue());
                    acct.setResource(resource);
                    return acct;
                }
            }.get();
            account.setUsername(accountTO.getUsername());
            if (StringUtils.isBlank((CharSequence)accountTO.getPassword())) {
                account.setEncodedPassword(null, null);
            } else if (!accountTO.getPassword().equals(account.getPassword())) {
                account.setPassword(accountTO.getPassword(), CipherAlgorithm.AES);
            }
            account.setSuspended(Boolean.valueOf(accountTO.isSuspended()));
            accountTO.getPlainAttrs().stream().filter(attrTO -> !attrTO.getValues().isEmpty()).forEach(attrTO -> {
                PlainSchema schema = this.getPlainSchema(attrTO.getSchema());
                if (schema != null) {
                    LAPlainAttr attr = account.getPlainAttr(schema.getKey()).orElse(null);
                    if (attr == null) {
                        attr = (LAPlainAttr)this.entityFactory.newEntity(LAPlainAttr.class);
                        attr.setSchema(schema);
                        attr.setOwner((Any)user);
                        attr.setAccount(account);
                    }
                    this.fillAttr(attrTO.getValues(), anyUtils, schema, (PlainAttr<?>)attr, invalidValues);
                    if (attr.getValuesAsStrings().isEmpty()) {
                        attr.setOwner(null);
                    } else {
                        account.add((PlainAttr)attr);
                    }
                }
            });
            accountTO.getPrivileges().forEach(key -> {
                Privilege privilege = this.applicationDAO.findPrivilege(key);
                if (privilege == null) {
                    LOG.debug("Invalid privilege {}, ignoring", key);
                } else {
                    account.add(privilege);
                }
            });
        }
    }

    public void create(User user, UserTO userTO, boolean storePassword) {
        SecurityQuestion securityQuestion;
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        user.setUsername(userTO.getUsername());
        if (StringUtils.isBlank((CharSequence)userTO.getPassword()) || !storePassword) {
            LOG.debug("Password was not provided or not required to be stored");
        } else {
            this.setPassword(user, userTO.getPassword(), scce);
            user.setChangePwdDate(new Date());
        }
        user.setMustChangePassword(userTO.isMustChangePassword());
        if (userTO.getSecurityQuestion() != null && (securityQuestion = this.securityQuestionDAO.find(userTO.getSecurityQuestion())) != null) {
            user.setSecurityQuestion(securityQuestion);
        }
        user.setSecurityAnswer(userTO.getSecurityAnswer());
        userTO.getRoles().forEach(roleKey -> {
            Role role = this.roleDAO.find(roleKey);
            if (role == null) {
                LOG.warn("Ignoring unknown role with id {}", roleKey);
            } else {
                user.add(role);
            }
        });
        Realm realm = this.realmDAO.findByFullPath(userTO.getRealm());
        if (realm == null) {
            SyncopeClientException noRealm = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
            noRealm.getElements().add("Invalid or null realm specified: " + userTO.getRealm());
            scce.addException(noRealm);
        }
        user.setRealm(realm);
        userTO.getRelationships().forEach(relationshipTO -> {
            AnyObject otherEnd = (AnyObject)this.anyObjectDAO.find(relationshipTO.getOtherEndKey());
            if (otherEnd == null) {
                LOG.debug("Ignoring invalid anyObject " + relationshipTO.getOtherEndKey());
            } else if (user.getRealm().getFullPath().startsWith(otherEnd.getRealm().getFullPath())) {
                RelationshipType relationshipType = this.relationshipTypeDAO.find(relationshipTO.getType());
                if (relationshipType == null) {
                    LOG.debug("Ignoring invalid relationship type {}", (Object)relationshipTO.getType());
                } else {
                    URelationship relationship = (URelationship)this.entityFactory.newEntity(URelationship.class);
                    relationship.setType(relationshipType);
                    relationship.setRightEnd((Any)otherEnd);
                    relationship.setLeftEnd((Any)user);
                    user.add((Relationship)relationship);
                }
            } else {
                LOG.error("{} cannot be related to {}", (Object)otherEnd, (Object)user);
                SyncopeClientException unrelatable = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                unrelatable.getElements().add(otherEnd.getType().getKey() + " " + otherEnd.getName() + " cannot be related");
                scce.addException(unrelatable);
            }
        });
        userTO.getMemberships().forEach(membershipTO -> {
            Group group;
            Group group2 = group = membershipTO.getGroupKey() == null ? this.groupDAO.findByName(membershipTO.getGroupName()) : (Group)this.groupDAO.find(membershipTO.getGroupKey());
            if (group == null) {
                LOG.debug("Ignoring invalid group {}", (Object)(membershipTO.getGroupKey() + " / " + membershipTO.getGroupName()));
            } else if (user.getRealm().getFullPath().startsWith(group.getRealm().getFullPath())) {
                UMembership membership = (UMembership)this.entityFactory.newEntity(UMembership.class);
                membership.setRightEnd((Any)group);
                membership.setLeftEnd((Any)user);
                user.add((Membership)membership);
                this.fill((Any)user, (Membership)membership, (MembershipTO)membershipTO, this.anyUtilsFactory.getInstance(AnyTypeKind.USER), scce);
            } else {
                LOG.error("{} cannot be assigned to {}", (Object)group, (Object)user);
                SyncopeClientException unassignable = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidMembership);
                unassignable.getElements().add("Group " + group.getName() + " cannot be assigned");
                scce.addException(unassignable);
            }
        });
        SyncopeClientException invalidValues = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
        userTO.getLinkedAccounts().forEach(accountTO -> this.linkedAccount(user, (LinkedAccountTO)accountTO, this.anyUtilsFactory.getLinkedAccountInstance(), invalidValues));
        if (!invalidValues.isEmpty()) {
            scce.addException(invalidValues);
        }
        this.fill((Any)user, (AnyTO)userTO, this.anyUtilsFactory.getInstance(AnyTypeKind.USER), scce);
        if (scce.hasExceptions()) {
            throw scce;
        }
    }

    private boolean isPasswordMapped(ExternalResource resource) {
        return resource.getProvision(this.anyTypeDAO.findUser()).filter(provision -> provision.getMapping() != null).map(provision -> provision.getMapping().getItems().stream().anyMatch(item -> item.isPassword())).orElse(false);
    }

    public Pair<PropagationByResource<String>, PropagationByResource<Pair<String, String>>> update(User toBeUpdated, UserPatch userPatch) {
        User user = (User)this.userDAO.save((Any)toBeUpdated);
        PropagationByResource propByRes = new PropagationByResource();
        PropagationByResource propByLinkedAccount = new PropagationByResource();
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        AnyUtils anyUtils = this.anyUtilsFactory.getInstance(AnyTypeKind.USER);
        Collection currentResources = this.userDAO.findAllResourceKeys(user.getKey());
        Map<String, String> oldConnObjectKeys = this.getConnObjectKeys((Any<?>)user, anyUtils);
        this.setRealm((Any<?>)user, (AnyPatch)userPatch);
        if (userPatch.getPassword() != null) {
            if (userPatch.getPassword().getOperation() == PatchOperation.DELETE) {
                user.setEncodedPassword(null, null);
                propByRes.addAll(ResourceOperation.UPDATE, (Collection)userPatch.getPassword().getResources());
            } else if (StringUtils.isNotBlank((CharSequence)((CharSequence)userPatch.getPassword().getValue()))) {
                if (userPatch.getPassword().isOnSyncope()) {
                    this.setPassword(user, (String)userPatch.getPassword().getValue(), scce);
                    user.setChangePwdDate(new Date());
                }
                propByRes.addAll(ResourceOperation.UPDATE, (Collection)userPatch.getPassword().getResources());
            }
        }
        if (userPatch.getUsername() != null && StringUtils.isNotBlank((CharSequence)((CharSequence)userPatch.getUsername().getValue()))) {
            AccessToken accessToken;
            String oldUsername = user.getUsername();
            user.setUsername((String)userPatch.getUsername().getValue());
            if (oldUsername.equals(AuthContextUtils.getUsername())) {
                AuthContextUtils.updateUsername((String)((String)userPatch.getUsername().getValue()));
            }
            if ((accessToken = this.accessTokenDAO.findByOwner(oldUsername)) != null) {
                accessToken.setOwner((String)userPatch.getUsername().getValue());
                this.accessTokenDAO.save(accessToken);
            }
            propByRes.addAll(ResourceOperation.UPDATE, currentResources);
        }
        if (userPatch.getSecurityQuestion() != null) {
            if (userPatch.getSecurityQuestion().getValue() == null) {
                user.setSecurityQuestion(null);
                user.setSecurityAnswer(null);
            } else {
                SecurityQuestion securityQuestion = this.securityQuestionDAO.find((String)userPatch.getSecurityQuestion().getValue());
                if (securityQuestion != null) {
                    user.setSecurityQuestion(securityQuestion);
                    user.setSecurityAnswer((String)userPatch.getSecurityAnswer().getValue());
                }
            }
        }
        if (userPatch.getMustChangePassword() != null) {
            user.setMustChangePassword(((Boolean)userPatch.getMustChangePassword().getValue()).booleanValue());
            propByRes.addAll(ResourceOperation.UPDATE, (Collection)anyUtils.getAllResources((Any)toBeUpdated).stream().filter(resource -> resource.getProvision(toBeUpdated.getType()).isPresent()).filter(resource -> this.mappingManager.hasMustChangePassword((Provision)resource.getProvision(toBeUpdated.getType()).get())).map(Entity::getKey).collect(Collectors.toSet()));
        }
        block3: for (StringPatchItem patch2 : userPatch.getRoles()) {
            Role role = this.roleDAO.find((String)patch2.getValue());
            if (role == null) {
                LOG.warn("Ignoring unknown role with key {}", patch2.getValue());
                continue;
            }
            switch (patch2.getOperation()) {
                case ADD_REPLACE: {
                    user.add(role);
                    continue block3;
                }
            }
            user.getRoles().remove(role);
        }
        propByRes.merge(this.fill((Any)user, (AnyPatch)userPatch, anyUtils, scce));
        userPatch.getRelationships().stream().filter(patch -> patch.getRelationshipTO() != null).forEach(patch -> {
            RelationshipType relationshipType = this.relationshipTypeDAO.find(patch.getRelationshipTO().getType());
            if (relationshipType == null) {
                LOG.debug("Ignoring invalid relationship type {}", (Object)patch.getRelationshipTO().getType());
            } else {
                user.getRelationship(relationshipType, patch.getRelationshipTO().getOtherEndKey()).ifPresent(relationship -> {
                    user.getRelationships().remove(relationship);
                    relationship.setLeftEnd(null);
                });
                if (patch.getOperation() == PatchOperation.ADD_REPLACE) {
                    AnyObject otherEnd = (AnyObject)this.anyObjectDAO.find(patch.getRelationshipTO().getOtherEndKey());
                    if (otherEnd == null) {
                        LOG.debug("Ignoring invalid any object {}", (Object)patch.getRelationshipTO().getOtherEndKey());
                    } else if (user.getRealm().getFullPath().startsWith(otherEnd.getRealm().getFullPath())) {
                        URelationship newRelationship = (URelationship)this.entityFactory.newEntity(URelationship.class);
                        newRelationship.setType(relationshipType);
                        newRelationship.setRightEnd((Any)otherEnd);
                        newRelationship.setLeftEnd((Any)user);
                        user.add((Relationship)newRelationship);
                    } else {
                        LOG.error("{} cannot be related to {}", (Object)otherEnd, (Object)user);
                        SyncopeClientException unrelatable = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRelationship);
                        unrelatable.getElements().add(otherEnd.getType().getKey() + " " + otherEnd.getName() + " cannot be related");
                        scce.addException(unrelatable);
                    }
                }
            }
        });
        Collection resources = this.userDAO.findAllResources(user);
        HashMap reasons = new HashMap();
        user.getResources().forEach(resource -> reasons.put(resource.getKey(), new HashSet<String>(Collections.singleton(user.getKey()))));
        this.userDAO.findAllGroupKeys(user).forEach(group -> this.groupDAO.findAllResourceKeys(group).forEach(resource -> {
            if (!reasons.containsKey(resource)) {
                reasons.put(resource, new HashSet());
            }
            ((Set)reasons.get(resource)).add(group);
        }));
        HashSet toBeDeprovisioned = new HashSet();
        HashSet toBeProvisioned = new HashSet();
        SyncopeClientException invalidValues = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
        userPatch.getMemberships().stream().filter(patch -> patch.getGroup() != null).forEach(patch -> {
            user.getMembership(patch.getGroup()).ifPresent(membership -> {
                user.remove((Membership)membership);
                membership.setLeftEnd(null);
                user.getPlainAttrs((Membership)membership).forEach(attr -> {
                    user.remove((PlainAttr)attr);
                    attr.setOwner(null);
                    attr.setMembership(null);
                    this.plainAttrValueDAO.deleteAll((PlainAttr)attr, anyUtils);
                    this.plainAttrDAO.delete((PlainAttr)attr);
                });
                if (patch.getOperation() == PatchOperation.DELETE) {
                    this.groupDAO.findAllResourceKeys(((Group)membership.getRightEnd()).getKey()).stream().filter(resource -> reasons.containsKey(resource)).forEach(resource -> {
                        ((Set)reasons.get(resource)).remove(((Group)membership.getRightEnd()).getKey());
                        toBeProvisioned.add(resource);
                    });
                }
            });
            if (patch.getOperation() == PatchOperation.ADD_REPLACE) {
                Group group = (Group)this.groupDAO.find(patch.getGroup());
                if (group == null) {
                    LOG.debug("Ignoring invalid group {}", (Object)patch.getGroup());
                } else if (user.getRealm().getFullPath().startsWith(group.getRealm().getFullPath())) {
                    UMembership newMembership = (UMembership)this.entityFactory.newEntity(UMembership.class);
                    newMembership.setRightEnd((Any)group);
                    newMembership.setLeftEnd((Any)user);
                    user.add((Membership)newMembership);
                    patch.getPlainAttrs().forEach(attrTO -> {
                        PlainSchema schema = this.getPlainSchema(attrTO.getSchema());
                        if (schema == null) {
                            LOG.debug("Invalid " + PlainSchema.class.getSimpleName() + "{}, ignoring...", (Object)attrTO.getSchema());
                        } else {
                            UPlainAttr attr = user.getPlainAttr(schema.getKey(), (Membership)newMembership).orElse(null);
                            if (attr == null) {
                                LOG.debug("No plain attribute found for {} and membership of {}", (Object)schema, (Object)newMembership.getRightEnd());
                                attr = (UPlainAttr)anyUtils.newPlainAttr();
                                attr.setOwner((Any)user);
                                attr.setMembership((Membership)newMembership);
                                attr.setSchema(schema);
                                user.add((PlainAttr)attr);
                                this.processAttrPatch((Any)user, (AttrPatch)new AttrPatch.Builder().attrTO(attrTO).build(), schema, (PlainAttr<?>)attr, anyUtils, resources, (PropagationByResource<String>)propByRes, invalidValues);
                            }
                        }
                    });
                    if (!invalidValues.isEmpty()) {
                        scce.addException(invalidValues);
                    }
                    toBeProvisioned.addAll(this.groupDAO.findAllResourceKeys(group.getKey()));
                    if (toBeUpdated.canDecodePassword()) {
                        if (userPatch.getPassword() == null) {
                            userPatch.setPassword(new PasswordPatch());
                        }
                        group.getResources().stream().filter(resource -> this.isPasswordMapped((ExternalResource)resource)).forEach(resource -> userPatch.getPassword().getResources().add(resource.getKey()));
                    }
                } else {
                    LOG.error("{} cannot be assigned to {}", (Object)group, (Object)user);
                    SyncopeClientException unassignable = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidMembership);
                    unassignable.getElements().add("Group " + group.getName() + " cannot be assigned");
                    scce.addException(unassignable);
                }
            }
        });
        userPatch.getLinkedAccounts().stream().filter(patch -> patch.getLinkedAccountTO() != null).forEach(patch -> {
            user.getLinkedAccount(patch.getLinkedAccountTO().getResource(), patch.getLinkedAccountTO().getConnObjectKeyValue()).ifPresent(account -> {
                if (patch.getOperation() == PatchOperation.DELETE) {
                    user.getLinkedAccounts().remove(account);
                    account.setOwner(null);
                    propByLinkedAccount.add(ResourceOperation.DELETE, (Serializable)Pair.of((Object)account.getResource().getKey(), (Object)account.getConnObjectKeyValue()));
                }
                account.getPlainAttrs().stream().collect(Collectors.toSet()).forEach(attr -> {
                    account.remove((PlainAttr)attr);
                    attr.setOwner(null);
                    attr.setAccount(null);
                    this.plainAttrValueDAO.deleteAll((PlainAttr)attr, this.anyUtilsFactory.getLinkedAccountInstance());
                    this.plainAttrDAO.delete((PlainAttr)attr);
                });
            });
            if (patch.getOperation() == PatchOperation.ADD_REPLACE) {
                this.linkedAccount(user, patch.getLinkedAccountTO(), this.anyUtilsFactory.getLinkedAccountInstance(), invalidValues);
            }
        });
        user.getLinkedAccounts().forEach(account -> propByLinkedAccount.add(ResourceOperation.CREATE, (Serializable)Pair.of((Object)account.getResource().getKey(), (Object)account.getConnObjectKeyValue())));
        reasons.entrySet().stream().filter(entry -> ((Set)entry.getValue()).isEmpty()).forEach(entry -> toBeDeprovisioned.add(entry.getKey()));
        propByRes.addAll(ResourceOperation.DELETE, toBeDeprovisioned);
        propByRes.addAll(ResourceOperation.UPDATE, toBeProvisioned);
        if (!toBeDeprovisioned.isEmpty() || !toBeProvisioned.isEmpty()) {
            currentResources.removeAll(toBeDeprovisioned);
            propByRes.addAll(ResourceOperation.UPDATE, currentResources);
        }
        Map<String, String> newConnObjectKeys = this.getConnObjectKeys((Any<?>)user, anyUtils);
        oldConnObjectKeys.entrySet().stream().filter(entry -> newConnObjectKeys.containsKey(entry.getKey()) && !((String)entry.getValue()).equals(newConnObjectKeys.get(entry.getKey()))).forEach(entry -> {
            propByRes.addOldConnObjectKey((String)entry.getKey(), (String)entry.getValue());
            propByRes.add(ResourceOperation.UPDATE, (Serializable)entry.getKey());
        });
        Pair dynGroupMembs = this.userDAO.saveAndGetDynGroupMembs(user);
        ((Set)dynGroupMembs.getLeft()).stream().filter(group -> !((Set)dynGroupMembs.getRight()).contains(group)).forEach(delete -> ((Group)this.groupDAO.find(delete)).getResources().stream().filter(resource -> !propByRes.contains((Serializable)((Object)resource.getKey()))).forEach(resource -> propByRes.add(ResourceOperation.DELETE, (Serializable)((Object)resource.getKey()))));
        ((Set)dynGroupMembs.getLeft()).stream().filter(group -> ((Set)dynGroupMembs.getRight()).contains(group)).forEach(update -> ((Group)this.groupDAO.find(update)).getResources().stream().filter(resource -> !propByRes.contains((Serializable)((Object)resource.getKey()))).forEach(resource -> propByRes.add(ResourceOperation.UPDATE, (Serializable)((Object)resource.getKey()))));
        ((Set)dynGroupMembs.getRight()).stream().filter(group -> !((Set)dynGroupMembs.getLeft()).contains(group)).forEach(create -> ((Group)this.groupDAO.find(create)).getResources().stream().filter(resource -> !propByRes.contains((Serializable)((Object)resource.getKey()))).forEach(resource -> propByRes.add(ResourceOperation.CREATE, (Serializable)((Object)resource.getKey()))));
        if (scce.hasExceptions()) {
            throw scce;
        }
        this.userDAO.save((Any)user);
        return Pair.of((Object)propByRes, (Object)propByLinkedAccount);
    }

    @Transactional(readOnly=true)
    public LinkedAccountTO getLinkedAccountTO(LinkedAccount account) {
        LinkedAccountTO accountTO = new LinkedAccountTO.Builder(account.getKey(), account.getResource().getKey(), account.getConnObjectKeyValue()).username(account.getUsername()).password(account.getPassword()).suspended(BooleanUtils.isTrue((Boolean)account.isSuspended())).build();
        account.getPlainAttrs().forEach(plainAttr -> accountTO.getPlainAttrs().add(new AttrTO.Builder().schema(plainAttr.getSchema().getKey()).values((Collection)plainAttr.getValuesAsStrings()).build()));
        accountTO.getPrivileges().addAll(account.getPrivileges().stream().map(Entity::getKey).collect(Collectors.toList()));
        return accountTO;
    }

    @Transactional(readOnly=true)
    public UserTO getUserTO(User user, boolean details) {
        UserTO userTO = new UserTO();
        userTO.setKey(user.getKey());
        userTO.setUsername(user.getUsername());
        userTO.setPassword(user.getPassword());
        userTO.setType(user.getType().getKey());
        userTO.setCreationDate(user.getCreationDate());
        userTO.setCreator(user.getCreator());
        userTO.setLastChangeDate(user.getLastChangeDate());
        userTO.setLastModifier(user.getLastModifier());
        userTO.setStatus(user.getStatus());
        userTO.setSuspended(BooleanUtils.isTrue((Boolean)user.isSuspended()));
        userTO.setChangePwdDate(user.getChangePwdDate());
        userTO.setFailedLogins(user.getFailedLogins());
        userTO.setLastLoginDate(user.getLastLoginDate());
        userTO.setMustChangePassword(user.isMustChangePassword());
        userTO.setToken(user.getToken());
        userTO.setTokenExpireTime(user.getTokenExpireTime());
        if (user.getSecurityQuestion() != null) {
            userTO.setSecurityQuestion(user.getSecurityQuestion().getKey());
        }
        this.fillTO((AnyTO)userTO, user.getRealm().getFullPath(), user.getAuxClasses(), user.getPlainAttrs(), this.derAttrHandler.getValues((Any)user), details ? this.virAttrHandler.getValues((Any)user) : Collections.emptyMap(), this.userDAO.findAllResources(user), details);
        userTO.getDynRealms().addAll(this.userDAO.findDynRealms(user.getKey()));
        if (details) {
            userTO.getRoles().addAll(user.getRoles().stream().map(Entity::getKey).collect(Collectors.toList()));
            userTO.getDynRoles().addAll(this.userDAO.findDynRoles(user.getKey()).stream().map(Entity::getKey).collect(Collectors.toList()));
            userTO.getPrivileges().addAll(this.userDAO.findAllRoles(user).stream().flatMap(role -> role.getPrivileges().stream()).map(Entity::getKey).collect(Collectors.toSet()));
            userTO.getRelationships().addAll(user.getRelationships().stream().map(relationship -> this.getRelationshipTO(relationship.getType().getKey(), (AnyObject)relationship.getRightEnd())).collect(Collectors.toList()));
            userTO.getMemberships().addAll(user.getMemberships().stream().map(membership -> this.getMembershipTO(user.getPlainAttrs((Membership)membership), this.derAttrHandler.getValues((GroupableRelatable)user, (Membership)membership), this.virAttrHandler.getValues((Any)user, (Membership)membership), (Membership<? extends Any<?>>)membership)).collect(Collectors.toList()));
            userTO.getDynMemberships().addAll(this.userDAO.findDynGroups(user.getKey()).stream().map(group -> new MembershipTO.Builder().group(group.getKey(), group.getName()).build()).collect(Collectors.toList()));
            userTO.getLinkedAccounts().addAll(user.getLinkedAccounts().stream().map(this::getLinkedAccountTO).collect(Collectors.toList()));
        }
        return userTO;
    }

    @Transactional(readOnly=true)
    public UserTO getUserTO(String key) {
        return this.getUserTO((User)this.userDAO.authFind(key), true);
    }
}

