/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.resource.Item;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.data.JEXLItemTransformer;
import org.apache.syncope.core.provisioning.api.jexl.JexlUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class JEXLItemTransformerImpl
implements JEXLItemTransformer {
    @Autowired
    private DerAttrHandler derAttrHandler;
    private String propagationJEXL;
    private String pullJEXL;

    public void setPropagationJEXL(String propagationJEXL) {
        this.propagationJEXL = propagationJEXL;
    }

    public void setPullJEXL(String pullJEXL) {
        this.pullJEXL = pullJEXL;
    }

    public Pair<AttrSchemaType, List<PlainAttrValue>> beforePropagation(Item item, Entity entity, AttrSchemaType schemaType, List<PlainAttrValue> values) {
        if (StringUtils.isNotBlank((CharSequence)this.propagationJEXL) && values != null) {
            values.forEach(value -> {
                Object originalValue = value.getValue();
                if (originalValue != null) {
                    MapContext jexlContext = new MapContext();
                    if (entity != null) {
                        JexlUtils.addFieldsToContext((Object)entity, (JexlContext)jexlContext);
                        if (entity instanceof Any) {
                            JexlUtils.addPlainAttrsToContext((Collection)((Any)entity).getPlainAttrs(), (JexlContext)jexlContext);
                            JexlUtils.addDerAttrsToContext((Any)((Any)entity), (DerAttrHandler)this.derAttrHandler, (JexlContext)jexlContext);
                        }
                    }
                    jexlContext.set("value", originalValue);
                    value.setBinaryValue(null);
                    value.setBooleanValue(null);
                    value.setDateValue(null);
                    value.setDoubleValue(null);
                    value.setLongValue(null);
                    value.setStringValue(JexlUtils.evaluate((String)this.propagationJEXL, (JexlContext)jexlContext));
                }
            });
            return Pair.of((Object)AttrSchemaType.String, values);
        }
        return super.beforePropagation(item, entity, schemaType, values);
    }

    public List<Object> beforePull(Item item, EntityTO entityTO, List<Object> values) {
        if (StringUtils.isNotBlank((CharSequence)this.pullJEXL) && values != null) {
            ArrayList<Object> newValues = new ArrayList<Object>(values.size());
            values.forEach(value -> {
                MapContext jexlContext = new MapContext();
                jexlContext.set("value", value);
                if (entityTO instanceof AnyTO) {
                    JexlUtils.addFieldsToContext((Object)((AnyTO)entityTO), (JexlContext)jexlContext);
                    JexlUtils.addAttrTOsToContext((Collection)((AnyTO)entityTO).getPlainAttrs(), (JexlContext)jexlContext);
                    JexlUtils.addAttrTOsToContext((Collection)((AnyTO)entityTO).getDerAttrs(), (JexlContext)jexlContext);
                    JexlUtils.addAttrTOsToContext((Collection)((AnyTO)entityTO).getVirAttrs(), (JexlContext)jexlContext);
                } else if (entityTO instanceof RealmTO) {
                    JexlUtils.addFieldsToContext((Object)((RealmTO)entityTO), (JexlContext)jexlContext);
                }
                newValues.add(JexlUtils.evaluate((String)this.pullJEXL, (JexlContext)jexlContext));
            });
            return newValues;
        }
        return super.beforePull(item, entityTO, values);
    }
}

