/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.CipherAlgorithm;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.dao.AccessTokenDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.entity.AccessToken;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.provisioning.api.EntitlementsHolder;
import org.apache.syncope.core.provisioning.api.data.AnyTypeDataBinder;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.Encryptor;
import org.apache.syncope.core.spring.security.SyncopeGrantedAuthority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnyTypeDataBinderImpl
implements AnyTypeDataBinder {
    private static final Logger LOG = LoggerFactory.getLogger(AnyTypeDataBinder.class);
    private static final Encryptor ENCRYPTOR = Encryptor.getInstance();
    @Resource(name="adminUser")
    private String adminUser;
    @Autowired
    private AnyTypeDAO anyTypeDAO;
    @Autowired
    private AnyTypeClassDAO anyTypeClassDAO;
    @Autowired
    private AccessTokenDAO accessTokenDAO;
    @Autowired
    private EntityFactory entityFactory;

    public AnyType create(AnyTypeTO anyTypeTO) {
        AnyType anyType = (AnyType)this.entityFactory.newEntity(AnyType.class);
        this.update(anyType, anyTypeTO);
        Set added = EntitlementsHolder.getInstance().addFor(anyType.getKey());
        if (!this.adminUser.equals(AuthContextUtils.getUsername())) {
            AccessToken accessToken = this.accessTokenDAO.findByOwner(AuthContextUtils.getUsername());
            try {
                HashSet authorities = new HashSet((Collection)POJOHelper.deserialize((String)ENCRYPTOR.decode(new String(accessToken.getAuthorities()), CipherAlgorithm.AES), (TypeReference)new TypeReference<Set<SyncopeGrantedAuthority>>(){}));
                added.forEach(entitlement -> authorities.add(new SyncopeGrantedAuthority(entitlement, "/")));
                accessToken.setAuthorities(ENCRYPTOR.encode(POJOHelper.serialize(authorities), CipherAlgorithm.AES).getBytes());
                this.accessTokenDAO.save(accessToken);
            }
            catch (Exception e) {
                LOG.error("Could not fetch or store authorities", (Throwable)e);
            }
        }
        return anyType;
    }

    public void update(AnyType anyType, AnyTypeTO anyTypeTO) {
        if (anyType.getKey() == null) {
            anyType.setKey(anyTypeTO.getKey());
        }
        if (anyType.getKind() == null) {
            anyType.setKind(anyTypeTO.getKind());
        }
        if (anyType.getKind() != anyTypeTO.getKind()) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidAnyType);
            sce.getElements().add(AnyTypeKind.class.getSimpleName() + " cannot be changed");
            throw sce;
        }
        anyType.getClasses().clear();
        anyTypeTO.getClasses().forEach(anyTypeClassName -> {
            AnyTypeClass anyTypeClass = this.anyTypeClassDAO.find(anyTypeClassName);
            if (anyTypeClass == null) {
                LOG.debug("Invalid " + AnyTypeClass.class.getSimpleName() + " {}, ignoring...", anyTypeClassName);
            } else {
                anyType.add(anyTypeClass);
            }
        });
    }

    public AnyTypeTO delete(AnyType anyType) {
        AnyTypeTO deleted = this.getAnyTypeTO(anyType);
        this.anyTypeDAO.delete(anyType.getKey());
        Set removed = EntitlementsHolder.getInstance().removeFor(deleted.getKey());
        if (!this.adminUser.equals(AuthContextUtils.getUsername())) {
            AccessToken accessToken = this.accessTokenDAO.findByOwner(AuthContextUtils.getUsername());
            try {
                HashSet authorities = new HashSet((Collection)POJOHelper.deserialize((String)ENCRYPTOR.decode(new String(accessToken.getAuthorities()), CipherAlgorithm.AES), (TypeReference)new TypeReference<Set<SyncopeGrantedAuthority>>(){}));
                authorities.removeAll(authorities.stream().filter(authority -> removed.contains(authority.getAuthority())).collect(Collectors.toList()));
                accessToken.setAuthorities(ENCRYPTOR.encode(POJOHelper.serialize(authorities), CipherAlgorithm.AES).getBytes());
                this.accessTokenDAO.save(accessToken);
            }
            catch (Exception e) {
                LOG.error("Could not fetch or store authorities", (Throwable)e);
            }
        }
        return deleted;
    }

    public AnyTypeTO getAnyTypeTO(AnyType anyType) {
        AnyTypeTO anyTypeTO = new AnyTypeTO();
        anyTypeTO.setKey(anyType.getKey());
        anyTypeTO.setKind(anyType.getKind());
        anyTypeTO.getClasses().addAll(anyType.getClasses().stream().map(Entity::getKey).collect(Collectors.toList()));
        return anyTypeTO;
    }
}

