/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.AttrPatch;
import org.apache.syncope.common.lib.patch.StringPatchItem;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.RelationshipTO;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.persistence.api.attrvalue.validation.InvalidPlainAttrValueException;
import org.apache.syncope.core.persistence.api.dao.AllowedSchemas;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.PlainAttrDAO;
import org.apache.syncope.core.persistence.api.dao.PlainAttrValueDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.RelationshipTypeDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.AnyTypeClass;
import org.apache.syncope.core.persistence.api.entity.AnyUtils;
import org.apache.syncope.core.persistence.api.entity.AnyUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.DerSchema;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.GroupablePlainAttr;
import org.apache.syncope.core.persistence.api.entity.GroupableRelatable;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.VirSchema;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.resource.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.resource.MappingItem;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.provisioning.api.AccountGetter;
import org.apache.syncope.core.provisioning.api.DerAttrHandler;
import org.apache.syncope.core.provisioning.api.IntAttrName;
import org.apache.syncope.core.provisioning.api.IntAttrNameParser;
import org.apache.syncope.core.provisioning.api.MappingManager;
import org.apache.syncope.core.provisioning.api.PlainAttrGetter;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.VirAttrHandler;
import org.apache.syncope.core.provisioning.api.jexl.JexlUtils;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

abstract class AbstractAnyDataBinder {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractAnyDataBinder.class);
    @Autowired
    protected RealmDAO realmDAO;
    @Autowired
    protected AnyTypeClassDAO anyTypeClassDAO;
    @Autowired
    protected AnyObjectDAO anyObjectDAO;
    @Autowired
    protected UserDAO userDAO;
    @Autowired
    protected GroupDAO groupDAO;
    @Autowired
    protected PlainSchemaDAO plainSchemaDAO;
    @Autowired
    protected PlainAttrDAO plainAttrDAO;
    @Autowired
    protected PlainAttrValueDAO plainAttrValueDAO;
    @Autowired
    protected ExternalResourceDAO resourceDAO;
    @Autowired
    protected RelationshipTypeDAO relationshipTypeDAO;
    @Autowired
    protected EntityFactory entityFactory;
    @Autowired
    protected AnyUtilsFactory anyUtilsFactory;
    @Autowired
    protected DerAttrHandler derAttrHandler;
    @Autowired
    protected VirAttrHandler virAttrHandler;
    @Autowired
    protected MappingManager mappingManager;
    @Autowired
    protected IntAttrNameParser intAttrNameParser;

    AbstractAnyDataBinder() {
    }

    protected void setRealm(Any<?> any, AnyPatch anyPatch) {
        if (anyPatch.getRealm() != null && StringUtils.isNotBlank((CharSequence)((CharSequence)anyPatch.getRealm().getValue()))) {
            Realm newRealm = this.realmDAO.findByFullPath((String)anyPatch.getRealm().getValue());
            if (newRealm == null) {
                LOG.debug("Invalid realm specified: {}, ignoring", anyPatch.getRealm().getValue());
            } else {
                any.setRealm(newRealm);
            }
        }
    }

    protected PlainSchema getPlainSchema(String schemaName) {
        PlainSchema schema = null;
        if (StringUtils.isNotBlank((CharSequence)schemaName)) {
            schema = (PlainSchema)this.plainSchemaDAO.find(schemaName);
            if (schema == null) {
                LOG.debug("Ignoring invalid schema {}", (Object)schemaName);
            } else if (schema.isReadonly()) {
                schema = null;
                LOG.debug("Ignoring readonly schema {}", (Object)schemaName);
            }
        }
        return schema;
    }

    protected void fillAttr(List<String> values, AnyUtils anyUtils, PlainSchema schema, PlainAttr<?> attr, SyncopeClientException invalidValues) {
        List<String> valuesProvided = schema.isMultivalue() ? values : (values.isEmpty() ? Collections.emptyList() : Collections.singletonList(values.get(0)));
        valuesProvided.forEach(value -> {
            if (StringUtils.isBlank((CharSequence)value)) {
                LOG.debug("Null value for {}, ignoring", (Object)schema.getKey());
            } else {
                try {
                    attr.add(value, anyUtils);
                }
                catch (InvalidPlainAttrValueException e) {
                    String valueToPrint = value.length() > 40 ? value.substring(0, 20) + "..." : value;
                    LOG.warn("Invalid value for attribute " + schema.getKey() + ": " + valueToPrint, (Throwable)e);
                    invalidValues.getElements().add(schema.getKey() + ": " + valueToPrint + " - " + e.getMessage());
                }
            }
        });
    }

    private List<String> evaluateMandatoryCondition(Provision provision, Any<?> any) {
        ArrayList<String> missingAttrNames = new ArrayList<String>();
        MappingUtils.getPropagationItems(provision.getMapping().getItems().stream()).forEach(mapItem -> {
            AttrSchemaType schemaType;
            Pair intValues;
            IntAttrName intAttrName = null;
            try {
                intAttrName = this.intAttrNameParser.parse(mapItem.getIntAttrName(), provision.getAnyType().getKind());
            }
            catch (ParseException e) {
                LOG.error("Invalid intAttrName '{}', ignoring", (Object)mapItem.getIntAttrName(), (Object)e);
            }
            if (intAttrName != null && intAttrName.getSchema() != null && ((List)(intValues = this.mappingManager.getIntValues(provision, mapItem, intAttrName, schemaType = intAttrName.getSchema() instanceof PlainSchema ? ((PlainSchema)intAttrName.getSchema()).getType() : AttrSchemaType.String, any, AccountGetter.DEFAULT, PlainAttrGetter.DEFAULT)).getRight()).isEmpty() && JexlUtils.evaluateMandatoryCondition((String)mapItem.getMandatoryCondition(), (Any)any, (DerAttrHandler)this.derAttrHandler)) {
                missingAttrNames.add(mapItem.getIntAttrName());
            }
        });
        return missingAttrNames;
    }

    private SyncopeClientException checkMandatoryOnResources(Any<?> any, Collection<? extends ExternalResource> resources) {
        SyncopeClientException reqValMissing = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
        resources.forEach(resource -> {
            List<String> missingAttrNames;
            Optional provision = resource.getProvision(any.getType());
            if (resource.isEnforceMandatoryCondition() && provision.isPresent() && !(missingAttrNames = this.evaluateMandatoryCondition((Provision)provision.get(), any)).isEmpty()) {
                LOG.error("Mandatory schemas {} not provided with values", missingAttrNames);
                reqValMissing.getElements().addAll(missingAttrNames);
            }
        });
        return reqValMissing;
    }

    private void checkMandatory(PlainSchema schema, PlainAttr<?> attr, Any<?> any, SyncopeClientException reqValMissing) {
        if (attr == null && !schema.isReadonly() && JexlUtils.evaluateMandatoryCondition((String)schema.getMandatoryCondition(), any, (DerAttrHandler)this.derAttrHandler)) {
            LOG.error("Mandatory schema " + schema.getKey() + " not provided with values");
            reqValMissing.getElements().add(schema.getKey());
        }
    }

    private SyncopeClientException checkMandatory(Any<?> any, AnyUtils anyUtils) {
        SyncopeClientException reqValMissing = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
        AllowedSchemas allowedPlainSchemas = anyUtils.dao().findAllowedSchemas(any, PlainSchema.class);
        allowedPlainSchemas.getForSelf().forEach(schema -> this.checkMandatory((PlainSchema)schema, any.getPlainAttr(schema.getKey()).orElse(null), any, reqValMissing));
        if (any instanceof GroupableRelatable) {
            allowedPlainSchemas.getForMemberships().forEach((group, schemas) -> {
                GroupableRelatable groupable = (GroupableRelatable)GroupableRelatable.class.cast(any);
                Membership membership = groupable.getMembership(group.getKey()).orElse(null);
                schemas.forEach(schema -> this.checkMandatory((PlainSchema)schema, groupable.getPlainAttr(schema.getKey(), membership).orElse(null), any, reqValMissing));
            });
        }
        return reqValMissing;
    }

    protected void processAttrPatch(Any any, AttrPatch patch, PlainSchema schema, PlainAttr<?> attr, AnyUtils anyUtils, Collection<ExternalResource> resources, PropagationByResource<String> propByRes, SyncopeClientException invalidValues) {
        switch (patch.getOperation()) {
            case ADD_REPLACE: {
                List valuesToBeAdded;
                if (attr.getSchema().isUniqueConstraint()) {
                    if (attr.getUniqueValue() != null && !patch.getAttrTO().getValues().isEmpty() && !((String)patch.getAttrTO().getValues().get(0)).equals(attr.getUniqueValue().getValueAsString())) {
                        this.plainAttrValueDAO.deleteAll(attr, anyUtils);
                    }
                } else {
                    this.plainAttrValueDAO.deleteAll(attr, anyUtils);
                }
                if (!((valuesToBeAdded = patch.getAttrTO().getValues()).isEmpty() || schema.isUniqueConstraint() && attr.getUniqueValue() != null && ((String)valuesToBeAdded.get(0)).equals(attr.getUniqueValue().getValueAsString()))) {
                    this.fillAttr(valuesToBeAdded, anyUtils, schema, attr, invalidValues);
                }
                if (!attr.getValuesAsStrings().isEmpty()) break;
                this.plainAttrDAO.delete(attr);
                break;
            }
            default: {
                any.remove(attr);
                this.plainAttrDAO.delete(attr);
            }
        }
        resources.stream().filter(resource -> resource.getProvision(any.getType()).isPresent() && ((Provision)resource.getProvision(any.getType()).get()).getMapping() != null).forEach(resource -> MappingUtils.getPropagationItems(((Provision)resource.getProvision(any.getType()).get()).getMapping().getItems().stream()).filter(item -> schema.getKey().equals(item.getIntAttrName())).forEach(item -> {
            propByRes.add(ResourceOperation.UPDATE, (Serializable)((Object)resource.getKey()));
            if (item.isConnObjectKey() && !attr.getValuesAsStrings().isEmpty()) {
                propByRes.addOldConnObjectKey(resource.getKey(), (String)attr.getValuesAsStrings().get(0));
            }
        }));
    }

    protected PropagationByResource<String> fill(Any any, AnyPatch anyPatch, AnyUtils anyUtils, SyncopeClientCompositeException scce) {
        SyncopeClientException requiredValuesMissing;
        PropagationByResource propByRes = new PropagationByResource();
        block6: for (StringPatchItem patch2 : anyPatch.getAuxClasses()) {
            AnyTypeClass auxClass = this.anyTypeClassDAO.find((String)patch2.getValue());
            if (auxClass == null) {
                LOG.debug("Invalid " + AnyTypeClass.class.getSimpleName() + " {}, ignoring...", patch2.getValue());
                continue;
            }
            switch (patch2.getOperation()) {
                case ADD_REPLACE: {
                    any.add(auxClass);
                    continue block6;
                }
            }
            any.getAuxClasses().remove(auxClass);
        }
        block7: for (StringPatchItem patch2 : anyPatch.getResources()) {
            ExternalResource resource = this.resourceDAO.find((String)patch2.getValue());
            if (resource == null) {
                LOG.debug("Invalid " + ExternalResource.class.getSimpleName() + " {}, ignoring...", patch2.getValue());
                continue;
            }
            switch (patch2.getOperation()) {
                case ADD_REPLACE: {
                    propByRes.add(ResourceOperation.CREATE, (Serializable)((Object)resource.getKey()));
                    any.add(resource);
                    continue block7;
                }
            }
            propByRes.add(ResourceOperation.DELETE, (Serializable)((Object)resource.getKey()));
            any.getResources().remove(resource);
        }
        Set resources = anyUtils.getAllResources(any);
        SyncopeClientException invalidValues = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
        anyPatch.getPlainAttrs().stream().filter(patch -> patch.getAttrTO() != null).forEach(patch -> {
            PlainSchema schema = this.getPlainSchema(patch.getAttrTO().getSchema());
            if (schema == null) {
                LOG.debug("Invalid " + PlainSchema.class.getSimpleName() + " {}, ignoring...", (Object)patch.getAttrTO().getSchema());
            } else {
                PlainAttr attr = any.getPlainAttr(schema.getKey()).orElse(null);
                if (attr == null) {
                    LOG.debug("No plain attribute found for schema {}", (Object)schema);
                    if (patch.getOperation() == PatchOperation.ADD_REPLACE) {
                        attr = anyUtils.newPlainAttr();
                        attr.setOwner(any);
                        attr.setSchema(schema);
                        any.add(attr);
                    }
                }
                if (attr != null) {
                    this.processAttrPatch(any, (AttrPatch)patch, schema, (PlainAttr<?>)attr, anyUtils, resources, (PropagationByResource<String>)propByRes, invalidValues);
                }
            }
        });
        if (!invalidValues.isEmpty()) {
            scce.addException(invalidValues);
        }
        if (!(requiredValuesMissing = this.checkMandatory(any, anyUtils)).isEmpty()) {
            scce.addException(requiredValuesMissing);
        }
        if (!(requiredValuesMissing = this.checkMandatoryOnResources(any, resources)).isEmpty()) {
            scce.addException(requiredValuesMissing);
        }
        return propByRes;
    }

    protected void fill(Any any, AnyTO anyTO, AnyUtils anyUtils, SyncopeClientCompositeException scce) {
        SyncopeClientException requiredValuesMissing;
        any.getAuxClasses().clear();
        anyTO.getAuxClasses().stream().map(className -> this.anyTypeClassDAO.find(className)).forEachOrdered(auxClass -> {
            if (auxClass == null) {
                LOG.debug("Invalid " + AnyTypeClass.class.getSimpleName() + " {}, ignoring...", auxClass);
            } else {
                any.add(auxClass);
            }
        });
        SyncopeClientException invalidValues = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
        anyTO.getPlainAttrs().stream().filter(attrTO -> !attrTO.getValues().isEmpty()).forEach(attrTO -> {
            PlainSchema schema = this.getPlainSchema(attrTO.getSchema());
            if (schema != null) {
                PlainAttr attr = any.getPlainAttr(schema.getKey()).orElse(null);
                if (attr == null) {
                    attr = anyUtils.newPlainAttr();
                    attr.setOwner(any);
                    attr.setSchema(schema);
                }
                this.fillAttr(attrTO.getValues(), anyUtils, schema, attr, invalidValues);
                if (attr.getValuesAsStrings().isEmpty()) {
                    attr.setOwner(null);
                } else {
                    any.add(attr);
                }
            }
        });
        if (!invalidValues.isEmpty()) {
            scce.addException(invalidValues);
        }
        if (!(requiredValuesMissing = this.checkMandatory(any, anyUtils)).isEmpty()) {
            scce.addException(requiredValuesMissing);
        }
        anyTO.getResources().forEach(resourceKey -> {
            ExternalResource resource = this.resourceDAO.find(resourceKey);
            if (resource == null) {
                LOG.debug("Invalid " + ExternalResource.class.getSimpleName() + " {}, ignoring...", resourceKey);
            } else {
                any.add(resource);
            }
        });
        requiredValuesMissing = this.checkMandatoryOnResources(any, anyUtils.getAllResources(any));
        if (!requiredValuesMissing.isEmpty()) {
            scce.addException(requiredValuesMissing);
        }
    }

    protected void fill(Any any, Membership membership, MembershipTO membershipTO, AnyUtils anyUtils, SyncopeClientCompositeException scce) {
        SyncopeClientException invalidValues = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
        membershipTO.getPlainAttrs().stream().filter(attrTO -> !attrTO.getValues().isEmpty()).forEach(attrTO -> {
            PlainSchema schema = this.getPlainSchema(attrTO.getSchema());
            if (schema != null) {
                GroupablePlainAttr attr = ((GroupableRelatable)GroupableRelatable.class.cast(any)).getPlainAttr(schema.getKey(), membership).orElse(null);
                if (attr == null) {
                    attr = (GroupablePlainAttr)anyUtils.newPlainAttr();
                    attr.setOwner(any);
                    attr.setMembership(membership);
                    attr.setSchema(schema);
                }
                this.fillAttr(attrTO.getValues(), anyUtils, schema, (PlainAttr<?>)attr, invalidValues);
                if (attr.getValuesAsStrings().isEmpty()) {
                    attr.setOwner(null);
                } else {
                    any.add((PlainAttr)attr);
                }
            }
        });
        if (!invalidValues.isEmpty()) {
            scce.addException(invalidValues);
        }
    }

    protected void fillTO(AnyTO anyTO, String realmFullPath, Collection<? extends AnyTypeClass> auxClasses, Collection<? extends PlainAttr<?>> plainAttrs, Map<DerSchema, String> derAttrs, Map<VirSchema, List<String>> virAttrs, Collection<? extends ExternalResource> resources, boolean details) {
        anyTO.setRealm(realmFullPath);
        anyTO.getAuxClasses().addAll(auxClasses.stream().map(Entity::getKey).collect(Collectors.toList()));
        plainAttrs.forEach(plainAttr -> anyTO.getPlainAttrs().add(new AttrTO.Builder().schema(plainAttr.getSchema().getKey()).values((Collection)plainAttr.getValuesAsStrings()).build()));
        derAttrs.forEach((schema, value) -> anyTO.getDerAttrs().add(new AttrTO.Builder().schema(schema.getKey()).value(value).build()));
        virAttrs.forEach((schema, values) -> anyTO.getVirAttrs().add(new AttrTO.Builder().schema(schema.getKey()).values((Collection)values).build()));
        anyTO.getResources().addAll(resources.stream().map(Entity::getKey).collect(Collectors.toSet()));
    }

    protected RelationshipTO getRelationshipTO(String relationshipType, AnyObject otherEnd) {
        return new RelationshipTO.Builder().type(relationshipType).otherEnd(otherEnd.getType().getKey(), otherEnd.getKey(), otherEnd.getName()).build();
    }

    protected MembershipTO getMembershipTO(Collection<? extends PlainAttr<?>> plainAttrs, Map<DerSchema, String> derAttrs, Map<VirSchema, List<String>> virAttrs, Membership<? extends Any<?>> membership) {
        MembershipTO membershipTO = new MembershipTO.Builder().group(((Group)membership.getRightEnd()).getKey(), ((Group)membership.getRightEnd()).getName()).build();
        plainAttrs.forEach(plainAttr -> membershipTO.getPlainAttrs().add(new AttrTO.Builder().schema(plainAttr.getSchema().getKey()).values((Collection)plainAttr.getValuesAsStrings()).build()));
        derAttrs.forEach((schema, value) -> membershipTO.getDerAttrs().add(new AttrTO.Builder().schema(schema.getKey()).value(value).build()));
        virAttrs.forEach((schema, values) -> membershipTO.getVirAttrs().add(new AttrTO.Builder().schema(schema.getKey()).values((Collection)values).build()));
        return membershipTO;
    }

    protected Map<String, String> getConnObjectKeys(Any<?> any, AnyUtils anyUtils) {
        HashMap<String, String> connObjectKeys = new HashMap<String, String>();
        anyUtils.getAllResources(any).forEach(resource -> resource.getProvision(any.getType()).filter(provision -> provision.getMapping() != null).ifPresent(provision -> {
            MappingItem connObjectKeyItem = MappingUtils.getConnObjectKeyItem(provision).orElseThrow(() -> new NotFoundException("ConnObjectKey mapping for " + any.getType().getKey() + " " + any.getKey() + " on resource '" + resource.getKey() + "'"));
            this.mappingManager.getConnObjectKeyValue(any, provision).ifPresent(value -> connObjectKeys.put(resource.getKey(), (String)value));
        }));
        return connObjectKeys;
    }
}

