/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.data;

import java.text.ParseException;
import org.apache.syncope.common.lib.SyncopeClientCompositeException;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.ItemTO;
import org.apache.syncope.common.lib.to.OIDCProviderTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.MappingPurpose;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.OIDCProviderDAO;
import org.apache.syncope.core.persistence.api.entity.OIDCEntityFactory;
import org.apache.syncope.core.persistence.api.entity.OIDCProvider;
import org.apache.syncope.core.persistence.api.entity.OIDCProviderItem;
import org.apache.syncope.core.persistence.api.entity.OIDCUserTemplate;
import org.apache.syncope.core.provisioning.api.IntAttrName;
import org.apache.syncope.core.provisioning.api.IntAttrNameParser;
import org.apache.syncope.core.provisioning.api.data.OIDCProviderDataBinder;
import org.apache.syncope.core.provisioning.api.jexl.JexlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OIDCProviderDataBinderImpl
implements OIDCProviderDataBinder {
    private static final Logger LOG = LoggerFactory.getLogger(OIDCProviderDataBinder.class);
    @Autowired
    private AnyTypeDAO anyTypeDAO;
    @Autowired
    private OIDCProviderDAO oidcOPDAO;
    @Autowired
    private OIDCEntityFactory entityFactory;
    @Autowired
    private IntAttrNameParser intAttrNameParser;

    public OIDCProvider create(OIDCProviderTO opTO) {
        return this.update((OIDCProvider)this.entityFactory.newEntity(OIDCProvider.class), opTO);
    }

    private void populateItems(OIDCProviderTO opTO, OIDCProvider op) {
        SyncopeClientCompositeException scce = SyncopeClientException.buildComposite();
        SyncopeClientException invalidMapping = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidMapping);
        SyncopeClientException requiredValuesMissing = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.RequiredValuesMissing);
        opTO.getItems().forEach(itemTO -> {
            if (itemTO == null) {
                LOG.error("Null {}", (Object)ItemTO.class.getSimpleName());
                invalidMapping.getElements().add("Null " + ItemTO.class.getSimpleName());
            } else if (itemTO.getIntAttrName() == null) {
                requiredValuesMissing.getElements().add("intAttrName");
                scce.addException(requiredValuesMissing);
            } else {
                IntAttrName intAttrName = null;
                try {
                    intAttrName = this.intAttrNameParser.parse(itemTO.getIntAttrName(), AnyTypeKind.USER);
                }
                catch (ParseException e) {
                    LOG.error("Invalid intAttrName '{}' specified, ignoring", (Object)itemTO.getIntAttrName(), (Object)e);
                }
                if (intAttrName == null || intAttrName.getSchemaType() == null && intAttrName.getField() == null) {
                    LOG.error("'{}' not existing", (Object)itemTO.getIntAttrName());
                    invalidMapping.getElements().add('\'' + itemTO.getIntAttrName() + "' not existing");
                } else {
                    if (!JexlUtils.isExpressionValid((String)(itemTO.getMandatoryCondition() == null ? "false" : itemTO.getMandatoryCondition()))) {
                        SyncopeClientException invalidMandatoryCondition = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidValues);
                        invalidMandatoryCondition.getElements().add(itemTO.getMandatoryCondition());
                        scce.addException(invalidMandatoryCondition);
                    }
                    OIDCProviderItem item = (OIDCProviderItem)this.entityFactory.newEntity(OIDCProviderItem.class);
                    item.setIntAttrName(itemTO.getIntAttrName());
                    item.setExtAttrName(itemTO.getExtAttrName());
                    item.setMandatoryCondition(itemTO.getMandatoryCondition());
                    item.setConnObjectKey(itemTO.isConnObjectKey());
                    item.setPassword(itemTO.isPassword());
                    item.setPropagationJEXLTransformer(itemTO.getPropagationJEXLTransformer());
                    item.setPullJEXLTransformer(itemTO.getPullJEXLTransformer());
                    item.setOP(op);
                    item.setPurpose(MappingPurpose.NONE);
                    if (item.isConnObjectKey()) {
                        if (intAttrName.getSchemaType() == SchemaType.VIRTUAL) {
                            invalidMapping.getElements().add("Virtual attributes cannot be set as ConnObjectKey");
                        }
                        if ("password".equals(intAttrName.getField())) {
                            invalidMapping.getElements().add("Password attributes cannot be set as ConnObjectKey");
                        }
                        op.setConnObjectKeyItem(item);
                    } else {
                        op.add(item);
                    }
                }
            }
        });
        if (!invalidMapping.getElements().isEmpty()) {
            scce.addException(invalidMapping);
        }
        if (scce.hasExceptions()) {
            throw scce;
        }
    }

    public OIDCProvider update(OIDCProvider op, OIDCProviderTO opTO) {
        op.setAuthorizationEndpoint(opTO.getAuthorizationEndpoint());
        op.setClientID(opTO.getClientID());
        op.setClientSecret(opTO.getClientSecret());
        op.setName(opTO.getName());
        op.setIssuer(opTO.getIssuer());
        op.setJwksUri(opTO.getJwksUri());
        op.setTokenEndpoint(opTO.getTokenEndpoint());
        op.setUserinfoEndpoint(opTO.getUserinfoEndpoint());
        op.setEndSessionEndpoint(opTO.getEndSessionEndpoint());
        op.setHasDiscovery(opTO.getHasDiscovery());
        op.setCreateUnmatching(opTO.isCreateUnmatching());
        op.setSelfRegUnmatching(opTO.isSelfRegUnmatching());
        op.setUpdateMatching(opTO.isUpdateMatching());
        if (opTO.getUserTemplate() == null) {
            op.setUserTemplate(null);
        } else {
            OIDCUserTemplate userTemplate = op.getUserTemplate();
            if (userTemplate == null) {
                userTemplate = (OIDCUserTemplate)this.entityFactory.newEntity(OIDCUserTemplate.class);
                userTemplate.setAnyType(this.anyTypeDAO.findUser());
                userTemplate.setOP(op);
                op.setUserTemplate(userTemplate);
            }
            userTemplate.set((AnyTO)opTO.getUserTemplate());
        }
        op.getItems().clear();
        this.populateItems(opTO, op);
        op.getActionsClassNames().clear();
        op.getActionsClassNames().addAll(opTO.getActionsClassNames());
        return this.oidcOPDAO.save(op);
    }

    private static void populateItems(OIDCProvider op, OIDCProviderTO opTO) {
        op.getItems().forEach(item -> {
            ItemTO itemTO = new ItemTO();
            itemTO.setKey(item.getKey());
            itemTO.setIntAttrName(item.getIntAttrName());
            itemTO.setExtAttrName(item.getExtAttrName());
            itemTO.setMandatoryCondition(item.getMandatoryCondition());
            itemTO.setConnObjectKey(item.isConnObjectKey());
            itemTO.setPassword(item.isPassword());
            itemTO.setPropagationJEXLTransformer(item.getPropagationJEXLTransformer());
            itemTO.setPullJEXLTransformer(item.getPullJEXLTransformer());
            itemTO.setPurpose(MappingPurpose.NONE);
            if (itemTO.isConnObjectKey()) {
                opTO.setConnObjectKeyItem(itemTO);
            } else {
                opTO.add(itemTO);
            }
        });
    }

    public OIDCProviderTO getOIDCProviderTO(OIDCProvider op) {
        OIDCProviderTO opTO = new OIDCProviderTO();
        opTO.setKey(op.getKey());
        opTO.setAuthorizationEndpoint(op.getAuthorizationEndpoint());
        opTO.setClientID(op.getClientID());
        opTO.setClientSecret(op.getClientSecret());
        opTO.setName(op.getName());
        opTO.setIssuer(op.getIssuer());
        opTO.setJwksUri(op.getJwksUri());
        opTO.setTokenEndpoint(op.getTokenEndpoint());
        opTO.setUserinfoEndpoint(op.getUserinfoEndpoint());
        opTO.setEndSessionEndpoint(op.getEndSessionEndpoint());
        opTO.setHasDiscovery(op.getHasDiscovery());
        opTO.setCreateUnmatching(op.isCreateUnmatching());
        opTO.setSelfRegUnmatching(op.isSelfRegUnmatching());
        opTO.setUpdateMatching(op.isUpdateMatching());
        if (op.getUserTemplate() != null) {
            opTO.setUserTemplate((UserTO)op.getUserTemplate().get());
        }
        OIDCProviderDataBinderImpl.populateItems(op, opTO);
        opTO.getActionsClassNames().addAll(op.getActionsClassNames());
        return opTO;
    }
}

