/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.data.table;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.OrderByBorder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IStyledColumn;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.RefreshingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class HeadersToolbar<S>
extends AbstractToolbar {
    private static final long serialVersionUID = 1L;

    public <T> HeadersToolbar(final DataTable<T, S> table, final ISortStateLocator<S> stateLocator) {
        super(table);
        RefreshingView headers = new RefreshingView<IColumn<T, S>>("headers"){
            private static final long serialVersionUID = 1L;

            protected Iterator<IModel<IColumn<T, S>>> getItemModels() {
                LinkedList<Model> columnsModels = new LinkedList<Model>();
                for (IColumn column : table.getColumns()) {
                    columnsModels.add(Model.of(column));
                }
                return columnsModels.iterator();
            }

            protected void populateItem(Item<IColumn<T, S>> item) {
                final IColumn column = (IColumn)item.getModelObject();
                WebMarkupContainer header = column.isSortable() ? HeadersToolbar.this.newSortableHeader("header", column.getSortProperty(), stateLocator) : new WebMarkupContainer("header");
                if (column instanceof IStyledColumn) {
                    DataTable.CssAttributeBehavior cssAttributeBehavior = new DataTable.CssAttributeBehavior(){
                        private static final long serialVersionUID = 1L;

                        @Override
                        protected String getCssClass() {
                            return ((IStyledColumn)column).getCssClass();
                        }
                    };
                    header.add(new Behavior[]{cssAttributeBehavior});
                }
                if (column.getHeaderColspan() > 1) {
                    header.add(new Behavior[]{AttributeModifier.replace((String)"colspan", (Serializable)Integer.valueOf(column.getHeaderColspan()))});
                }
                if (column.getHeaderRowspan() > 1) {
                    header.add(new Behavior[]{AttributeModifier.replace((String)"rowspan", (Serializable)Integer.valueOf(column.getHeaderRowspan()))});
                }
                item.add(new Component[]{header});
                item.setRenderBodyOnly(true);
                header.add(new Component[]{column.getHeader("label")});
            }
        };
        this.add(new Component[]{headers});
    }

    protected WebMarkupContainer newSortableHeader(String headerId, S property, ISortStateLocator<S> locator) {
        return new OrderByBorder<S>(headerId, property, locator){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onSortChanged() {
                HeadersToolbar.this.getTable().setCurrentPage(0L);
            }
        };
    }
}

