/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.scimv11.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.tirasa.connid.bundles.scimv11.SCIMv11ConnectorConfiguration;
import net.tirasa.connid.bundles.scimv11.dto.PagedResults;
import net.tirasa.connid.bundles.scimv11.dto.User;
import net.tirasa.connid.bundles.scimv11.service.SCIMv11Service;
import net.tirasa.connid.bundles.scimv11.utils.SCIMv11Utils;
import org.apache.cxf.jaxrs.client.WebClient;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;

public class SCIMv11Client
extends SCIMv11Service {
    private static final Log LOG = Log.getLog(SCIMv11Client.class);

    public SCIMv11Client(SCIMv11ConnectorConfiguration config) {
        super(config);
    }

    public List<User> getAllUsers(Set<String> attributesToGet) {
        WebClient webClient = this.getWebclient("Users", null);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("attributes", SCIMv11Utils.cleanAttributesToGet(attributesToGet, this.config.getCustomAttributesJSON()));
        return this.doGetAllUsers(webClient).getResources();
    }

    public List<User> getAllUsers(String filterQuery, Set<String> attributesToGet) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("filter", filterQuery);
        params.put("attributes", SCIMv11Utils.cleanAttributesToGet(attributesToGet, this.config.getCustomAttributesJSON()));
        WebClient webClient = this.getWebclient("Users", params);
        return this.doGetAllUsers(webClient).getResources();
    }

    public PagedResults<User> getAllUsers(Integer startIndex, Integer count, Set<String> attributesToGet) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("startIndex", String.valueOf(startIndex));
        if (count != null) {
            params.put("count", String.valueOf(count));
        }
        params.put("attributes", SCIMv11Utils.cleanAttributesToGet(attributesToGet, this.config.getCustomAttributesJSON()));
        WebClient webClient = this.getWebclient("Users", params);
        return this.doGetAllUsers(webClient);
    }

    public PagedResults<User> getAllUsers(String filterQuery, Integer startIndex, Integer count, Set<String> attributesToGet) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("startIndex", String.valueOf(startIndex));
        if (count != null) {
            params.put("count", String.valueOf(count));
        }
        params.put("filter", filterQuery);
        params.put("attributes", SCIMv11Utils.cleanAttributesToGet(attributesToGet, this.config.getCustomAttributesJSON()));
        WebClient webClient = this.getWebclient("Users", params);
        return this.doGetAllUsers(webClient);
    }

    public User getUser(String userId) {
        WebClient webClient = this.getWebclient("Users", null).path((Object)userId);
        return this.doGetUser(webClient);
    }

    public User createUser(User user) {
        return (User)User.class.cast(this.doCreateUser(user));
    }

    public User updateUser(User user) {
        return (User)User.class.cast(this.doUpdateUser(user));
    }

    public void deleteUser(String userId) {
        WebClient webClient = this.getWebclient("Users", null).path((Object)userId);
        this.doDeleteUser(userId, webClient);
    }

    public void activateUser(String userId) {
        this.doActivateUser(userId);
    }

    public boolean testService() {
        HashSet<String> attributesToGet = new HashSet<String>();
        attributesToGet.add("userName");
        return this.getAllUsers(1, 1, attributesToGet) != null;
    }

    private PagedResults<User> doGetAllUsers(WebClient webClient) {
        PagedResults resources = null;
        JsonNode node = null;
        try {
            node = this.doGet(webClient);
            resources = (PagedResults)SCIMv11Utils.MAPPER.readValue(node.toString(), (TypeReference)new TypeReference<PagedResults<User>>(){});
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex, "While converting from JSON to Users", new Object[0]);
        }
        if (resources == null || node == null) {
            SCIMv11Utils.handleGeneralError("While retrieving users from service");
        } else if (!resources.getResources().isEmpty()) {
            this.readCustomAttributes(resources, node.get("Resources"));
        }
        return resources;
    }

    private User doGetUser(WebClient webClient) {
        User user = null;
        JsonNode node = null;
        try {
            node = this.doGet(webClient);
            user = (User)SCIMv11Utils.MAPPER.readValue(node.toString(), User.class);
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex, "While converting from JSON to User", new Object[0]);
        }
        if (user == null || node == null) {
            SCIMv11Utils.handleGeneralError("While retrieving user from service after create");
        } else {
            this.readCustomAttributes(user, node);
        }
        return user;
    }

    private User doCreateUser(User user) {
        this.doCreate(user, this.getWebclient("Users", null));
        return user;
    }

    private User doUpdateUser(User user) {
        if (StringUtil.isBlank((String)user.getId())) {
            SCIMv11Utils.handleGeneralError("Missing required user id attribute for update");
        }
        User updated = null;
        try {
            updated = (User)SCIMv11Utils.MAPPER.readValue(this.doUpdate(user, this.getWebclient("Users", null).path((Object)user.getId())).toString(), User.class);
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex, "While converting from JSON to User", new Object[0]);
        }
        if (updated == null) {
            SCIMv11Utils.handleGeneralError("While retrieving user from service after update");
        }
        return updated;
    }

    private void doDeleteUser(String userId, WebClient webClient) {
        this.doDelete(userId, webClient);
    }

    private void doActivateUser(String userId) {
        this.doActivate(userId, this.getWebclient("activation", null).path((Object)"tokens"));
    }
}

