/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.installer.validators;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.installer.validators.AbstractValidator;

public class ArchetypeValidator
extends AbstractValidator {
    private StringBuilder error;

    @Override
    public DataValidator.Status validateData(InstallData installData) {
        String mavenDir = StringUtils.trim(installData.getVariable("mvn.directory"));
        String mavenGroupId = StringUtils.trim(installData.getVariable("mvn.groupid"));
        String mavenArtifactId = StringUtils.trim(installData.getVariable("mvn.artifactid"));
        String mavenSecretKey = StringUtils.trim(installData.getVariable("mvn.secretkey"));
        String mavenAnonymousKey = StringUtils.trim(installData.getVariable("mvn.anonymous.key"));
        String mavenJwsKey = StringUtils.trim(installData.getVariable("mvn.jws.key"));
        String mavenAdminPassword = StringUtils.trim(installData.getVariable("mvn.syncope.admin.password"));
        String mavenLogDirectory = StringUtils.trim(installData.getVariable("mvn.log.directory"));
        String mavenBundleDirectory = StringUtils.trim(installData.getVariable("mvn.bundle.directory"));
        boolean verified = true;
        this.error = new StringBuilder("Required fields:\n");
        if (StringUtils.isBlank(mavenDir)) {
            this.error.append("Maven home directory\n");
            verified = false;
        } else if (!new File(mavenDir + "/bin/mvn").exists()) {
            this.error.append("Maven home directory not valid, check it please...\n");
            verified = false;
        }
        if (StringUtils.isBlank(mavenGroupId)) {
            this.error.append("GroupID\n");
            verified = false;
        }
        if (StringUtils.isBlank(mavenArtifactId)) {
            this.error.append("ArtifactID\n");
            verified = false;
        }
        if (StringUtils.isBlank(mavenSecretKey)) {
            this.error.append("SecretKey\n");
            verified = false;
        }
        if (StringUtils.isBlank(mavenAnonymousKey)) {
            this.error.append("AnonymousKey\n");
            verified = false;
        }
        if (StringUtils.isBlank(mavenJwsKey)) {
            this.error.append("JwsKey\n");
            verified = false;
        }
        if (StringUtils.isBlank(mavenAdminPassword)) {
            this.error.append("AdminPassword\n");
            verified = false;
        }
        if (StringUtils.isBlank(mavenLogDirectory)) {
            this.error.append("Logs directory\n");
            verified = false;
        }
        if (StringUtils.isBlank(mavenBundleDirectory)) {
            this.error.append("Bundles directory\n");
            verified = false;
        }
        return verified ? DataValidator.Status.OK : DataValidator.Status.ERROR;
    }

    @Override
    public String getErrorMessageId() {
        return this.error.toString();
    }

    @Override
    public String getWarningMessageId() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean getDefaultAnswer() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

