/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.installer.utilities;

import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.syncope.installer.utilities.InstallLog;
import org.w3c.dom.Document;

public class FileSystemUtils {
    private final AbstractUIProcessHandler handler;

    public FileSystemUtils(AbstractUIProcessHandler handler) {
        this.handler = handler;
    }

    public void createDirectory(String directoryPath) {
        File directory = new File(directoryPath);
        if (!directory.exists()) {
            directory.mkdirs();
        }
    }

    public void copyFile(String sourceFilePath, String targetFilePath) {
        try {
            FileUtils.copyFile(new File(sourceFilePath), new File(targetFilePath));
        }
        catch (IOException ex) {
            String errorMessage = "Error copying file " + sourceFilePath + " to " + targetFilePath + ": " + ex.getMessage();
            this.handler.emitError(errorMessage, errorMessage);
            InstallLog.getInstance().error(errorMessage);
        }
    }

    public void exec(String cmd, String path) {
        try {
            this.handler.logOutput("Executing " + cmd, true);
            ProcessBuilder builder = new ProcessBuilder(cmd.split(" "));
            if (path != null && !path.isEmpty()) {
                builder.directory(new File(path));
            }
            Process process = builder.start();
            this.readResponse(process.getInputStream());
        }
        catch (IOException ex) {
            String errorMessage = "Error executing " + cmd + ": " + ex.getMessage();
            this.handler.emitError(errorMessage, errorMessage);
            InstallLog.getInstance().error(errorMessage);
        }
    }

    private void readResponse(InputStream inputStream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        String line = reader.readLine();
        while (line != null) {
            line = reader.readLine();
            String content = line == null ? "" : line;
            this.handler.logOutput(content, false);
            InstallLog.getInstance().info(content);
        }
        inputStream.close();
    }

    public void writeToFile(File file, String content) {
        try {
            FileWriter fw = new FileWriter(file.getAbsoluteFile());
            try (BufferedWriter bw = new BufferedWriter(fw);){
                bw.write(content);
            }
        }
        catch (IOException ex) {
            String errorMessage = "Error writing file " + file.getAbsolutePath() + ": " + ex.getMessage();
            this.handler.emitError(errorMessage, errorMessage);
            InstallLog.getInstance().error(errorMessage);
        }
    }

    public String readFile(File file) {
        String content = "";
        try {
            content = FileUtils.readFileToString(file, Charset.forName("UTF-8"));
        }
        catch (IOException ex) {
            String errorMessage = "Error reading file " + file.getAbsolutePath() + ": " + ex.getMessage();
            this.handler.emitError(errorMessage, errorMessage);
            InstallLog.getInstance().error(errorMessage);
        }
        return content;
    }

    public void appendToFile(File file, String content) {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(file, true)));){
                out.println(content);
            }
        }
        catch (IOException ex) {
            String errorMessage = "Error writing file " + file.getAbsolutePath() + ": " + ex.getMessage();
            this.handler.emitError(errorMessage, errorMessage);
            InstallLog.getInstance().error(errorMessage);
        }
    }

    public static void writeXML(Document doc, OutputStream out) throws IOException, TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.transform(new DOMSource(doc), new StreamResult(new OutputStreamWriter(out, Charset.forName("UTF-8"))));
        out.close();
    }

    public static void delete(File file) {
        FileUtils.deleteQuietly(file);
    }

    public void copyFileFromResources(String filePath, String destination, AbstractUIProcessHandler handler) {
        try {
            FileUtils.copyURLToFile(this.getClass().getResource(filePath), new File(destination));
        }
        catch (IOException ex) {
            String errorMessage = "Error copying file " + filePath + " to + " + destination + ": " + ex.getMessage();
            handler.emitError(errorMessage, errorMessage);
            InstallLog.getInstance().error(errorMessage);
        }
    }
}

