/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.installer.processes;

import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import java.io.File;
import java.util.Properties;
import org.apache.syncope.installer.processes.BaseProcess;
import org.apache.syncope.installer.utilities.FileSystemUtils;
import org.apache.syncope.installer.utilities.InstallLog;
import org.apache.syncope.installer.utilities.MavenUtils;

public class ArchetypeProcess
extends BaseProcess {
    @Override
    public void run(AbstractUIProcessHandler handler, String[] args) {
        String contentPomFile;
        File pomFile;
        String installPath = args[0];
        String mavenDir = args[1];
        String groupId = args[2];
        String artifactId = args[3];
        String secretKey = args[4];
        String anonymousKey = args[5];
        String confDirectory = args[6];
        String logsDirectory = args[7];
        String bundlesDirectory = args[8];
        String syncopeVersion = args[9];
        String syncopeAdminPassword = args[10];
        boolean isProxyEnabled = Boolean.valueOf(args[11]);
        String proxyHost = args[12];
        String proxyPort = args[13];
        String proxyUser = args[14];
        String proxyPwd = args[15];
        boolean mavenProxyAutoconf = Boolean.valueOf(args[16]);
        boolean swagger = Boolean.valueOf(args[17]);
        boolean flowable = Boolean.valueOf(args[18]);
        String jwsKey = args[19];
        this.setSyncopeInstallDir(installPath, artifactId);
        FileSystemUtils fileSystemUtils = new FileSystemUtils(handler);
        fileSystemUtils.createDirectory(installPath);
        InstallLog.initialize(installPath, handler);
        MavenUtils mavenUtils = new MavenUtils(mavenDir, handler);
        File customMavenProxySettings = null;
        if (isProxyEnabled && mavenProxyAutoconf) {
            try {
                customMavenProxySettings = MavenUtils.createSettingsWithProxy(installPath, proxyHost, proxyPort, proxyUser, proxyPwd);
            }
            catch (Exception e) {
                StringBuilder message = new StringBuilder("Error during creation of custom Maven settings.xml");
                handler.emitError(message.toString(), e.getMessage());
                InstallLog.getInstance().error(message.append('\n').append(e.getMessage()).toString());
            }
        }
        handler.logOutput("########################## IMPORTANT ##########################", true);
        handler.logOutput("See " + InstallLog.getInstance().getFileAbsolutePath() + " for the maven logs", true);
        handler.logOutput("########################## IMPORTANT ##########################", true);
        mavenUtils.archetypeGenerate(syncopeVersion, groupId, artifactId, secretKey, anonymousKey, jwsKey, syncopeAdminPassword, installPath, customMavenProxySettings);
        if (syncopeVersion.contains("SNAPSHOT")) {
            pomFile = new File(this.syncopeInstallDir + PROPERTIES.getProperty("pomFile"));
            contentPomFile = fileSystemUtils.readFile(pomFile);
            fileSystemUtils.writeToFile(pomFile, contentPomFile.replace("</project>", "  <repositories>\n    <repository>\n      <id>ASF</id>\n      <url>https://repository.apache.org/content/repositories/snapshots/</url>\n      <snapshots>\n        <enabled>true</enabled>\n      </snapshots>\n    </repository>\n  </repositories>\n</project>\n"));
        }
        if (swagger) {
            pomFile = new File(this.syncopeInstallDir + File.separator + "core" + File.separator + PROPERTIES.getProperty("pomFile"));
            contentPomFile = fileSystemUtils.readFile(pomFile);
            fileSystemUtils.writeToFile(pomFile, contentPomFile.replace("</dependencies>", "  <dependency>\n      <groupId>org.apache.syncope.ext</groupId>\n      <artifactId>syncope-ext-swagger-ui</artifactId>\n      <version>${syncope.version}</version>\n    </dependency>\n  </dependencies>\n"));
        }
        fileSystemUtils.createDirectory(confDirectory);
        fileSystemUtils.createDirectory(logsDirectory);
        fileSystemUtils.createDirectory(bundlesDirectory);
        if (flowable) {
            pomFile = new File(this.syncopeInstallDir + File.separator + "core" + File.separator + PROPERTIES.getProperty("pomFile"));
            contentPomFile = fileSystemUtils.readFile(pomFile);
            fileSystemUtils.writeToFile(pomFile, contentPomFile.replace("</dependencies>", "    <dependency>\n      <groupId>org.apache.syncope.ext.flowable</groupId>\n      <artifactId>syncope-ext-flowable-rest-cxf</artifactId>\n        </dependency>\n  </dependencies>\n"));
            fileSystemUtils.copyFileFromResources("/workflow.properties", this.syncopeInstallDir + PROPERTIES.getProperty("workflowPropertiesFile"), handler);
            pomFile = new File(this.syncopeInstallDir + File.separator + "console" + File.separator + PROPERTIES.getProperty("pomFile"));
            contentPomFile = fileSystemUtils.readFile(pomFile);
            fileSystemUtils.writeToFile(pomFile, contentPomFile.replace("</dependencies>", "    <dependency>\n      <groupId>org.apache.syncope.ext.flowable</groupId>\n      <artifactId>syncope-ext-flowable-client-console</artifactId>\n      <version>${project.version}</version>\n    </dependency>\n"));
        }
        Properties syncopeProperties = new Properties();
        syncopeProperties.setProperty("conf.directory", confDirectory);
        syncopeProperties.setProperty("log.directory", logsDirectory);
        syncopeProperties.setProperty("bundles.directory", bundlesDirectory);
        mavenUtils.mvnCleanPackageWithProperties(installPath + File.separator + artifactId, syncopeProperties, customMavenProxySettings);
    }
}

