/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer.gui;

import com.izforge.izpack.api.GuiId;
import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.api.installer.ISummarisable;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.core.handler.PromptUIHandler;
import com.izforge.izpack.gui.GUIPrompt;
import com.izforge.izpack.gui.LabelFactory;
import com.izforge.izpack.gui.LayoutConstants;
import com.izforge.izpack.gui.MultiLineLabel;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.HelpWindow;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.LayoutHelper;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;

public abstract class IzPanel
extends JPanel
implements AbstractUIHandler,
LayoutConstants,
ISummarisable {
    private static final long serialVersionUID = 3256442495255786038L;
    protected transient LayoutHelper layoutHelper;
    protected Component initialFocus = null;
    protected final GUIInstallData installData;
    protected final InstallerFrame parent;
    protected JLabel headLineLabel;
    public static final String HEADLINE = "headline";
    public static final String DELIMITER = ".";
    private final transient Resources resources;
    private final Panel metadata;
    private String helpUrl = null;
    private HelpWindow helpWindow = null;

    public IzPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources) {
        this(panel, parent, installData, (LayoutManager2)null, resources);
    }

    public IzPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, LayoutManager2 layoutManager, Resources resources) {
        this.metadata = panel;
        this.parent = parent;
        this.installData = installData;
        this.resources = resources;
        this.initLayoutHelper();
        if (layoutManager != null) {
            this.getLayoutHelper().startLayout(layoutManager);
        }
    }

    @Deprecated
    public IzPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, String iconName, Resources resources) {
        this(panel, parent, installData, resources);
        this.buildHeadline(iconName);
    }

    @Deprecated
    private void buildHeadline(String imageIconName) {
        if (this.parent.isHeading(this)) {
            return;
        }
        String headline = null;
        String searchkey = this.getMetadata().getPanelId() + DELIMITER + HEADLINE;
        if (this.getMetadata().hasPanelId() && this.installData.getMessages().getMessages().containsKey(searchkey)) {
            headline = this.getString(this.getMetadata().getPanelId() + DELIMITER + HEADLINE);
        } else {
            searchkey = this.getClass().getSimpleName() + DELIMITER + HEADLINE;
            if (this.installData.getMessages().getMessages().containsKey(searchkey)) {
                headline = this.getString(searchkey);
            }
        }
        if (headline != null) {
            this.headLineLabel = imageIconName != null && !"".equals(imageIconName) ? new JLabel(headline, this.getImageIcon(imageIconName), 10) : new JLabel(headline);
            Font font = this.headLineLabel.getFont();
            float size = font.getSize();
            font = font.deriveFont(0, size * 1.5f);
            this.headLineLabel.setFont(font);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            gbc.gridheight = 1;
            gbc.fill = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(0, 0, 0, 0);
            this.headLineLabel.setName(HEADLINE);
            ((GridBagLayout)this.getLayout()).addLayoutComponent(this.headLineLabel, gbc);
            this.add(this.headLineLabel);
        }
    }

    public String getString(String key) {
        return this.installData.getMessages().get(key, new Object[0]);
    }

    public ImageIcon getImageIcon(String iconName) {
        return (ImageIcon)this.parent.getIcons().get(iconName);
    }

    protected void initLayoutHelper() {
        this.layoutHelper = new LayoutHelper(this, this.installData);
    }

    protected boolean isValidated() {
        return true;
    }

    protected void saveData() {
    }

    public boolean panelValidated() {
        return this.isValidated();
    }

    public void panelActivate() {
    }

    public void panelDeactivate() {
    }

    public void createInstallationRecord(IXMLElement rootElement) {
    }

    @Override
    public int askQuestion(String title, String question, int choices) {
        return this.askQuestion(title, question, choices, -1);
    }

    @Override
    public int askQuestion(String title, String question, int choices, int defaultChoice) {
        return new PromptUIHandler(new GUIPrompt(this)).askQuestion(title, question, choices, defaultChoice);
    }

    @Override
    public int askWarningQuestion(String title, String question, int choices, int defaultChoice) {
        return new PromptUIHandler(new GUIPrompt(this)).askWarningQuestion(title, question, choices, defaultChoice);
    }

    public boolean emitNotificationFeedback(String message) {
        return this.emitWarning(this.getString("installer.Message"), message);
    }

    @Override
    public void emitNotification(String message) {
        new PromptUIHandler(new GUIPrompt(this)).emitNotification(message);
    }

    @Override
    public boolean emitWarning(String title, String message) {
        return new PromptUIHandler(new GUIPrompt(this)).emitWarning(title, message);
    }

    @Override
    public void emitError(String title, String message) {
        new PromptUIHandler(new GUIPrompt(this)).emitError(title, message);
    }

    public Component getInitialFocus() {
        return this.initialFocus;
    }

    public void setInitialFocus(Component component) {
        this.initialFocus = component;
    }

    public String getI18nStringForClass(String subkey) {
        return this.getI18nStringForClass(subkey, null);
    }

    public String getI18nStringForClass(String subkey, String alternateClass) {
        String retval = null;
        ArrayList<String> prefixes = new ArrayList<String>();
        String panelId = this.getMetadata().getPanelId();
        Class<?> clazz = this.getClass();
        String fullClassname = alternateClass == null ? clazz.getName() : alternateClass;
        String simpleClassname = alternateClass == null ? clazz.getSimpleName() : alternateClass;
        do {
            prefixes.add(fullClassname + DELIMITER + panelId);
            prefixes.add(simpleClassname + DELIMITER + panelId);
            prefixes.add(fullClassname);
            prefixes.add(simpleClassname);
            clazz = clazz.getSuperclass();
            fullClassname = clazz.getName();
            simpleClassname = clazz.getSimpleName();
        } while (alternateClass == null && !clazz.equals(IzPanel.class));
        prefixes.add(2, panelId);
        for (String prefix : prefixes) {
            String searchkey = prefix + DELIMITER + subkey;
            if (this.installData.getMessages().getMessages().containsKey(searchkey)) {
                retval = this.getString(searchkey);
            }
            if (retval == null) continue;
            break;
        }
        if (retval != null && retval.indexOf(36) > -1) {
            retval = this.installData.getVariables().replace(retval);
        }
        return retval;
    }

    public InstallerFrame getInstallerFrame() {
        return this.parent;
    }

    public JLabel createLabel(String subkey, String alternateClass, String iconId, int pos, boolean isFullLine) {
        ImageIcon imageIcon = iconId != null ? (ImageIcon)this.parent.getIcons().get(iconId) : null;
        String msg = this.getI18nStringForClass(subkey, alternateClass);
        JLabel label = LabelFactory.create(msg, imageIcon, pos, isFullLine);
        if (label != null) {
            label.setFont(this.getControlTextFont());
        }
        return label;
    }

    public MultiLineLabel createMultiLineLabelLang(String textId) {
        return this.createMultiLineLabel(this.getString(textId));
    }

    public MultiLineLabel createMultiLineLabel(String text) {
        MultiLineLabel multiLineLabel = new MultiLineLabel(text, 0, 0);
        multiLineLabel.setFont(this.getControlTextFont());
        return multiLineLabel;
    }

    public Font getControlTextFont() {
        Font fontObj = IzPanel.getLAF() != null ? MetalLookAndFeel.getControlTextFont() : this.getFont();
        float val = LabelFactory.getLabelFontSize();
        if (val != 1.0f) {
            fontObj = fontObj.deriveFont(fontObj.getSize2D() * val);
        }
        return fontObj;
    }

    protected static MetalLookAndFeel getLAF() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel instanceof MetalLookAndFeel) {
            return (MetalLookAndFeel)lookAndFeel;
        }
        return null;
    }

    @Override
    public String getSummaryBody() {
        return null;
    }

    @Override
    public String getSummaryCaption() {
        String caption = this.parent.isHeading(this) && this.installData.guiPrefs.modifier.containsKey("useHeadingForSummary") && this.installData.guiPrefs.modifier.get("useHeadingForSummary").equalsIgnoreCase("yes") ? this.getI18nStringForClass(HEADLINE, null) : this.getI18nStringForClass("summaryCaption", null);
        return caption;
    }

    public LayoutHelper getLayoutHelper() {
        return this.layoutHelper;
    }

    public Panel getMetadata() {
        return this.metadata;
    }

    protected String parseText(String string_to_parse) {
        string_to_parse = this.installData.getVariables().replace(string_to_parse);
        return string_to_parse;
    }

    public boolean canShowHelp() {
        return this.helpUrl != null;
    }

    public void showHelp() {
        if (this.helpUrl != null) {
            URL resourceUrl = this.resources.getURL(this.helpUrl);
            this.getHelpWindow().showHelp(this.getString("installer.help"), resourceUrl);
        }
    }

    private HelpWindow getHelpWindow() {
        if (this.helpWindow != null) {
            return this.helpWindow;
        }
        this.helpWindow = new HelpWindow((Frame)this.parent, this.getString("installer.help.close"));
        this.helpWindow.setName(GuiId.HELP_WINDOWS.id);
        return this.helpWindow;
    }

    public void setHelpUrl(String helpUrl) {
        this.helpUrl = helpUrl;
    }

    @Override
    public String toString() {
        return "IzPanel{class=" + this.getClass().getSimpleName() + '}';
    }

    protected Resources getResources() {
        return this.resources;
    }

    public static class Filler
    extends JComponent {
        private static final long serialVersionUID = 3258416144414095153L;
    }
}

