/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.core.container;

import com.izforge.izpack.api.container.Container;
import com.izforge.izpack.api.exception.ContainerException;
import com.izforge.izpack.api.exception.IzPackClassNotFoundException;
import com.izforge.izpack.api.exception.IzPackException;
import org.picocontainer.Characteristics;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoBuilder;
import org.picocontainer.PicoException;

public abstract class AbstractContainer
implements Container {
    private MutablePicoContainer container;

    public AbstractContainer() {
        this(null);
    }

    public AbstractContainer(MutablePicoContainer container) {
        if (container != null) {
            this.initialise(container);
        }
    }

    @Override
    public <T> void addComponent(Class<T> componentType) {
        try {
            this.container.as(Characteristics.USE_NAMES).addComponent(componentType);
        }
        catch (PicoException exception) {
            throw new ContainerException(exception);
        }
    }

    @Override
    public void addComponent(Object componentKey, Object implementation) {
        try {
            this.container.addComponent(componentKey, implementation, new Parameter[0]);
        }
        catch (PicoException exception) {
            throw new ContainerException(exception);
        }
    }

    @Override
    public <T> T getComponent(Class<T> componentType) {
        try {
            return this.container.getComponent(componentType);
        }
        catch (PicoException exception) {
            throw new ContainerException(exception);
        }
    }

    @Override
    public Object getComponent(Object componentKeyOrType) {
        try {
            return this.container.getComponent(componentKeyOrType);
        }
        catch (PicoException exception) {
            throw new ContainerException(exception);
        }
    }

    public void addConfig(String name, Object value) {
        try {
            this.container.addConfig(name, value);
        }
        catch (IzPackException exception) {
            throw new ContainerException(exception);
        }
    }

    @Override
    public Container createChildContainer() {
        try {
            return new ChildContainer(this.container);
        }
        catch (PicoException exception) {
            throw new ContainerException(exception);
        }
    }

    @Override
    public boolean removeChildContainer(Container child) {
        boolean removed = false;
        if (child instanceof AbstractContainer) {
            removed = this.container.removeChildContainer(((AbstractContainer)child).container);
        }
        return removed;
    }

    @Override
    public void dispose() {
        this.container.dispose();
    }

    @Override
    public <T> Class<T> getClass(String className, Class<T> superType) {
        Class<?> type;
        try {
            ClassLoader classLoader = superType.getClassLoader();
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            if (!superType.isAssignableFrom(type = classLoader.loadClass(className))) {
                throw new ClassCastException("Class '" + type.getName() + "' does not implement " + superType.getName());
            }
        }
        catch (ClassNotFoundException exception) {
            throw new IzPackClassNotFoundException(className, exception);
        }
        return type;
    }

    protected void initialise() {
        this.initialise(this.createContainer());
    }

    protected void initialise(MutablePicoContainer container) {
        if (this.container != null) {
            throw new ContainerException("Container already initialised");
        }
        this.container = container;
        try {
            this.fillContainer(container);
        }
        catch (ContainerException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new ContainerException(exception);
        }
    }

    protected void fillContainer(MutablePicoContainer container) {
        this.fillContainer();
    }

    protected void fillContainer() {
    }

    protected MutablePicoContainer getContainer() {
        return this.container;
    }

    protected MutablePicoContainer createContainer() {
        return new PicoBuilder().withConstructorInjection().withCaching().build();
    }

    private static class ChildContainer
    extends AbstractContainer {
        public ChildContainer(MutablePicoContainer parent) {
            super(parent.makeChildContainer());
        }
    }
}

