/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.report;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.cli.Command;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.AbstractCommand;
import org.apache.syncope.client.cli.commands.report.ReportDelete;
import org.apache.syncope.client.cli.commands.report.ReportDeleteExecution;
import org.apache.syncope.client.cli.commands.report.ReportDetails;
import org.apache.syncope.client.cli.commands.report.ReportExecute;
import org.apache.syncope.client.cli.commands.report.ReportExportExecution;
import org.apache.syncope.client.cli.commands.report.ReportList;
import org.apache.syncope.client.cli.commands.report.ReportListJobs;
import org.apache.syncope.client.cli.commands.report.ReportRead;
import org.apache.syncope.client.cli.commands.report.ReportResultManager;

@Command(name="report")
public class ReportCommand
extends AbstractCommand {
    private final ReportResultManager reportResultManager = new ReportResultManager();

    @Override
    public void execute(Input input) {
        if (StringUtils.isBlank((CharSequence)input.getOption())) {
            input.setOption(ReportOptions.HELP.getOptionName());
        }
        switch (ReportOptions.fromName(input.getOption())) {
            case LIST: {
                new ReportList(input).list();
                break;
            }
            case DETAILS: {
                new ReportDetails(input).details();
                break;
            }
            case LIST_JOBS: {
                new ReportListJobs(input).list();
                break;
            }
            case READ: {
                new ReportRead(input).read();
                break;
            }
            case DELETE: {
                new ReportDelete(input).delete();
                break;
            }
            case EXECUTE: {
                new ReportExecute(input).execute();
                break;
            }
            case DELETE_EXECUTION: {
                new ReportDeleteExecution(input).delete();
                break;
            }
            case EXPORT_EXECUTION_RESULT: {
                new ReportExportExecution(input).export();
                break;
            }
            case HELP: {
                System.out.println(this.getHelpMessage());
                break;
            }
            default: {
                this.reportResultManager.defaultOptionMessage(input.getOption(), this.getHelpMessage());
            }
        }
    }

    @Override
    public String getHelpMessage() {
        return this.reportResultManager.commandHelpMessage(this.getClass());
    }

    public static enum ReportOptions {
        HELP("--help"),
        DETAILS("--details"),
        LIST("--list"),
        LIST_JOBS("--list-jobs"),
        READ("--read"),
        DELETE("--delete"),
        EXECUTE("--execute"),
        DELETE_EXECUTION("--delete-execution"),
        EXPORT_EXECUTION_RESULT("--export-execution-result");

        private final String optionName;

        private ReportOptions(String optionName) {
            this.optionName = optionName;
        }

        public String getOptionName() {
            return this.optionName;
        }

        public boolean equalsOptionName(String otherName) {
            return otherName == null ? false : this.optionName.equals(otherName);
        }

        public static ReportOptions fromName(String name) {
            ReportOptions optionToReturn = HELP;
            for (ReportOptions option : ReportOptions.values()) {
                if (!option.equalsOptionName(name)) continue;
                optionToReturn = option;
            }
            return optionToReturn;
        }

        public static List<String> toList() {
            ArrayList<String> options = new ArrayList<String>();
            for (ReportOptions value : ReportOptions.values()) {
                options.add(value.getOptionName());
            }
            return options;
        }
    }
}

