/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.realm;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.cli.Command;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.AbstractCommand;
import org.apache.syncope.client.cli.commands.realm.RealmDetails;
import org.apache.syncope.client.cli.commands.realm.RealmList;
import org.apache.syncope.client.cli.commands.realm.RealmResultManager;

@Command(name="realm")
public class RealmCommand
extends AbstractCommand {
    private final RealmResultManager realmResultManager = new RealmResultManager();

    @Override
    public void execute(Input input) {
        if (StringUtils.isBlank((CharSequence)input.getOption())) {
            input.setOption(RealmOptions.HELP.getOptionName());
        }
        switch (RealmOptions.fromName(input.getOption())) {
            case DETAILS: {
                new RealmDetails(input).details();
                break;
            }
            case LIST: {
                new RealmList(input).list();
                break;
            }
            case HELP: {
                System.out.println(this.getHelpMessage());
                break;
            }
            default: {
                this.realmResultManager.defaultOptionMessage(input.getOption(), this.getHelpMessage());
            }
        }
    }

    @Override
    public String getHelpMessage() {
        return this.realmResultManager.commandHelpMessage(this.getClass());
    }

    private static enum RealmOptions {
        HELP("--help"),
        DETAILS("--details"),
        LIST("--list");

        private final String optionName;

        private RealmOptions(String optionName) {
            this.optionName = optionName;
        }

        public String getOptionName() {
            return this.optionName;
        }

        public boolean equalsOptionName(String otherName) {
            return otherName == null ? false : this.optionName.equals(otherName);
        }

        public static RealmOptions fromName(String name) {
            RealmOptions optionToReturn = HELP;
            for (RealmOptions option : RealmOptions.values()) {
                if (!option.equalsOptionName(name)) continue;
                optionToReturn = option;
            }
            return optionToReturn;
        }

        public static List<String> toList() {
            ArrayList<String> options = new ArrayList<String>();
            for (RealmOptions value : RealmOptions.values()) {
                options.add(value.getOptionName());
            }
            return options;
        }
    }
}

