/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.entitlement;

import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.entitlement.AbstractEntitlementCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitlementReadByUsername
extends AbstractEntitlementCommand {
    private static final Logger LOG = LoggerFactory.getLogger(EntitlementReadByUsername.class);
    private static final String READ_HELP_MESSAGE = "entitlement --read-by-username {USERNAME}";
    private final Input input;

    public EntitlementReadByUsername(Input input) {
        this.input = input;
    }

    public void read() {
        block6: {
            if (this.input.getParameters().length == 1) {
                try {
                    this.entitlementResultManager.toView(this.entitlementSyncopeOperations.usernameEntitlements(this.input.firstParameter()));
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    if (ex.getMessage().startsWith("NotFound")) {
                        LOG.error("Error reading username", ex);
                        this.entitlementResultManager.notFoundError("User", this.input.firstParameter());
                        break block6;
                    }
                    this.entitlementResultManager.genericError(ex.getMessage());
                }
                catch (NumberFormatException ex) {
                    LOG.error("Error reading username", (Throwable)ex);
                    this.entitlementResultManager.numberFormatException("user", this.input.firstParameter());
                }
            } else {
                this.entitlementResultManager.commandOptionError(READ_HELP_MESSAGE);
            }
        }
    }
}

