/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.domain;

import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.domain.AbstractDomainCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainDelete
extends AbstractDomainCommand {
    private static final Logger LOG = LoggerFactory.getLogger(DomainDelete.class);
    private static final String DELETE_HELP_MESSAGE = "domain --delete {DOMAIN-NAME} {DOMAIN-NAME} [...]";
    private final Input input;

    public DomainDelete(Input input) {
        this.input = input;
    }

    public void delete() {
        if (this.input.parameterNumber() >= 1) {
            for (String parameter : this.input.getParameters()) {
                try {
                    this.domainSyncopeOperations.delete(parameter);
                    this.domainResultManager.deletedMessage("Domain", parameter);
                }
                catch (SyncopeClientException ex) {
                    LOG.error("Error deleting domain", (Throwable)ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.domainResultManager.notFoundError("Domain", parameter);
                        continue;
                    }
                    this.domainResultManager.genericError(ex.getMessage());
                }
            }
        } else {
            this.domainResultManager.commandOptionError(DELETE_HELP_MESSAGE);
        }
    }
}

