-- Licensed to the Apache Software Foundation (ASF) under one
-- or more contributor license agreements.  See the NOTICE file
-- distributed with this work for additional information
-- regarding copyright ownership.  The ASF licenses this file
-- to you under the Apache License, Version 2.0 (the
-- "License"); you may not use this file except in compliance
-- with the License.  You may obtain a copy of the License at
--
--   http://www.apache.org/licenses/LICENSE-2.0
--
-- Unless required by applicable law or agreed to in writing,
-- software distributed under the License is distributed on an
-- "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
-- KIND, either express or implied.  See the License for the
-- specific language governing permissions and limitations
-- under the License.

CREATE SEQUENCE PUBLIC.SYSTEM_SEQUENCE_59F7B0CC_7480_4829_9E5B_C3B02CB5126B START WITH 1 BELONGS_TO_TABLE;     
CREATE MEMORY TABLE PUBLIC.QRTZ_CALENDARS(
    SCHED_NAME VARCHAR(120) NOT NULL,
    CALENDAR_NAME VARCHAR(200) NOT NULL,
    CALENDAR IMAGE NOT NULL
);       
ALTER TABLE PUBLIC.QRTZ_CALENDARS ADD CONSTRAINT PUBLIC.PK_QRTZ_CALENDARS PRIMARY KEY(SCHED_NAME, CALENDAR_NAME);              
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_CALENDARS;           
CREATE MEMORY TABLE PUBLIC.QRTZ_CRON_TRIGGERS(
    SCHED_NAME VARCHAR(120) NOT NULL,
    TRIGGER_NAME VARCHAR(200) NOT NULL,
    TRIGGER_GROUP VARCHAR(200) NOT NULL,
    CRON_EXPRESSION VARCHAR(120) NOT NULL,
    TIME_ZONE_ID VARCHAR(80)
);               
ALTER TABLE PUBLIC.QRTZ_CRON_TRIGGERS ADD CONSTRAINT PUBLIC.PK_QRTZ_CRON_TRIGGERS PRIMARY KEY(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP);        
-- 4 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_CRON_TRIGGERS;       
INSERT INTO PUBLIC.QRTZ_CRON_TRIGGERS(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, CRON_EXPRESSION, TIME_ZONE_ID) VALUES
('scheduler', 'Trigger_taskJobe95555d2-1b09-42c8-b25b-f4c4ec597979', 'DEFAULT', '0 0 0 1 * ?', 'Europe/Rome'),
('scheduler', 'Trigger_notificationJob', 'DEFAULT', '0/20 * * * * ?', 'Europe/Rome'),
('scheduler', 'Trigger_systemLoadReporterJob', 'DEFAULT', '0 * * * * ?', 'Europe/Rome'),
('scheduler', 'Trigger_taskJob89de5014-e3f5-4462-84d8-d97575740baf', 'DEFAULT', '0 0/5 * * * ?', 'Europe/Rome');            
CREATE MEMORY TABLE PUBLIC.QRTZ_FIRED_TRIGGERS(
    SCHED_NAME VARCHAR(120) NOT NULL,
    ENTRY_ID VARCHAR(95) NOT NULL,
    TRIGGER_NAME VARCHAR(200) NOT NULL,
    TRIGGER_GROUP VARCHAR(200) NOT NULL,
    INSTANCE_NAME VARCHAR(200) NOT NULL,
    FIRED_TIME BIGINT NOT NULL,
    SCHED_TIME BIGINT NOT NULL,
    PRIORITY INTEGER NOT NULL,
    STATE VARCHAR(16) NOT NULL,
    JOB_NAME VARCHAR(200),
    JOB_GROUP VARCHAR(200),
    IS_NONCONCURRENT BOOLEAN,
    REQUESTS_RECOVERY BOOLEAN
);        
ALTER TABLE PUBLIC.QRTZ_FIRED_TRIGGERS ADD CONSTRAINT PUBLIC.PK_QRTZ_FIRED_TRIGGERS PRIMARY KEY(SCHED_NAME, ENTRY_ID);         
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_FIRED_TRIGGERS;      
INSERT INTO PUBLIC.QRTZ_FIRED_TRIGGERS(SCHED_NAME, ENTRY_ID, TRIGGER_NAME, TRIGGER_GROUP, INSTANCE_NAME, FIRED_TIME, SCHED_TIME, PRIORITY, STATE, JOB_NAME, JOB_GROUP, IS_NONCONCURRENT, REQUESTS_RECOVERY) VALUES
('scheduler', 'bambooo15306986457271530698645716', 'Trigger_notificationJob', 'DEFAULT', 'bambooo1530698645727', 1530698700189, 1530698720000, 5, 'ACQUIRED', NULL, NULL, FALSE, FALSE);    
CREATE MEMORY TABLE PUBLIC.QRTZ_PAUSED_TRIGGER_GRPS(
    SCHED_NAME VARCHAR(120) NOT NULL,
    TRIGGER_GROUP VARCHAR(200) NOT NULL
);          
ALTER TABLE PUBLIC.QRTZ_PAUSED_TRIGGER_GRPS ADD CONSTRAINT PUBLIC.PK_QRTZ_PAUSED_TRIGGER_GRPS PRIMARY KEY(SCHED_NAME, TRIGGER_GROUP);          
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_PAUSED_TRIGGER_GRPS; 
CREATE MEMORY TABLE PUBLIC.QRTZ_SCHEDULER_STATE(
    SCHED_NAME VARCHAR(120) NOT NULL,
    INSTANCE_NAME VARCHAR(200) NOT NULL,
    LAST_CHECKIN_TIME BIGINT NOT NULL,
    CHECKIN_INTERVAL BIGINT NOT NULL
); 
ALTER TABLE PUBLIC.QRTZ_SCHEDULER_STATE ADD CONSTRAINT PUBLIC.PK_QRTZ_SCHEDULER_STATE PRIMARY KEY(SCHED_NAME, INSTANCE_NAME);  
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_SCHEDULER_STATE;     
INSERT INTO PUBLIC.QRTZ_SCHEDULER_STATE(SCHED_NAME, INSTANCE_NAME, LAST_CHECKIN_TIME, CHECKIN_INTERVAL) VALUES
('scheduler', 'bambooo1530698645727', 1530698701866, 20000);    
CREATE MEMORY TABLE PUBLIC.QRTZ_LOCKS(
    SCHED_NAME VARCHAR(120) NOT NULL,
    LOCK_NAME VARCHAR(40) NOT NULL
);             
ALTER TABLE PUBLIC.QRTZ_LOCKS ADD CONSTRAINT PUBLIC.PK_QRTZ_LOCKS PRIMARY KEY(SCHED_NAME, LOCK_NAME);          
-- 2 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_LOCKS;               
INSERT INTO PUBLIC.QRTZ_LOCKS(SCHED_NAME, LOCK_NAME) VALUES
('scheduler', 'TRIGGER_ACCESS'),
('scheduler', 'STATE_ACCESS');    
CREATE MEMORY TABLE PUBLIC.QRTZ_JOB_DETAILS(
    SCHED_NAME VARCHAR(120) NOT NULL,
    JOB_NAME VARCHAR(200) NOT NULL,
    JOB_GROUP VARCHAR(200) NOT NULL,
    DESCRIPTION VARCHAR(250),
    JOB_CLASS_NAME VARCHAR(250) NOT NULL,
    IS_DURABLE BOOLEAN NOT NULL,
    IS_NONCONCURRENT BOOLEAN NOT NULL,
    IS_UPDATE_DATA BOOLEAN NOT NULL,
    REQUESTS_RECOVERY BOOLEAN NOT NULL,
    JOB_DATA IMAGE
); 
ALTER TABLE PUBLIC.QRTZ_JOB_DETAILS ADD CONSTRAINT PUBLIC.PK_QRTZ_JOB_DETAILS PRIMARY KEY(SCHED_NAME, JOB_NAME, JOB_GROUP);    
-- 28 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_JOB_DETAILS;        
INSERT INTO PUBLIC.QRTZ_JOB_DETAILS(SCHED_NAME, JOB_NAME, JOB_GROUP, DESCRIPTION, JOB_CLASS_NAME, IS_DURABLE, IS_NONCONCURRENT, IS_UPDATE_DATA, REQUESTS_RECOVERY, JOB_DATA) VALUES
('scheduler', 'taskJob89de5014-e3f5-4462-84d8-d97575740baf', 'DEFAULT', NULL, 'org.apache.syncope.core.provisioning.java.job.TaskJob', FALSE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000274000d64656c6567617465436c6173737400476f72672e6170616368652e73796e636f70652e636f72652e70726f766973696f6e696e672e6a6176612e6a6f622e45787069726564416363657373546f6b656e436c65616e7570740006646f6d61696e7400064d61737465727800'),
('scheduler', 'taskJob30cfd653-257b-495f-8665-281281dbcb3d', 'DEFAULT', NULL, 'org.apache.syncope.core.provisioning.java.job.TaskJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000274000d64656c6567617465436c6173737400426f72672e6170616368652e73796e636f70652e636f72652e70726f766973696f6e696e672e6a6176612e7075736870756c6c2e50756c6c4a6f6244656c6567617465740006646f6d61696e7400064d61737465727800'),
('scheduler', 'taskJobec674143-480a-4816-98ad-b61fa090821e', 'DEFAULT', NULL, 'org.apache.syncope.core.provisioning.java.job.TaskJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000274000d64656c6567617465436c6173737400426f72672e6170616368652e73796e636f70652e636f72652e70726f766973696f6e696e672e6a6176612e7075736870756c6c2e507573684a6f6244656c6567617465740006646f6d61696e7400064d61737465727800'),
('scheduler', 'taskJob97f327b6-2eff-4d35-85e8-d581baaab855', 'DEFAULT', NULL, 'org.apache.syncope.core.provisioning.java.job.TaskJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000274000d64656c6567617465436c6173737400426f72672e6170616368652e73796e636f70652e636f72652e70726f766973696f6e696e672e6a6176612e7075736870756c6c2e507573684a6f6244656c6567617465740006646f6d61696e7400064d61737465727800'),
('scheduler', 'taskJob81d88f73-d474-4450-9031-605daa4e313f', 'DEFAULT', NULL, 'org.apache.syncope.core.provisioning.java.job.TaskJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000274000d64656c6567617465436c6173737400426f72672e6170616368652e73796e636f70652e636f72652e70726f766973696f6e696e672e6a6176612e7075736870756c6c2e50756c6c4a6f6244656c6567617465740006646f6d61696e7400064d61737465727800');              
INSERT INTO PUBLIC.QRTZ_JOB_DETAILS(SCHED_NAME, JOB_NAME, JOB_GROUP, DESCRIPTION, JOB_CLASS_NAME, IS_DURABLE, IS_NONCONCURRENT, IS_UPDATE_DATA, REQUESTS_RECOVERY, JOB_DATA) VALUES
('scheduler', 'taskJob38abbf9e-a1a3-40a1-a15f-7d0ac02f47f1', 'DEFAULT', NULL, 'org.apache.syncope.core.provisioning.java.job.TaskJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000274000d64656c6567617465436c6173737400426f72672e6170616368652e73796e636f70652e636f72652e70726f766973696f6e696e672e6a6176612e7075736870756c6c2e50756c6c4a6f6244656c6567617465740006646f6d61696e7400064d61737465727800'),
('scheduler', 'taskJobfeae4e57-15ca-40d9-b973-8b9015efca49', 'DEFAULT', NULL, 'org.apache.syncope.core.provisioning.java.job.TaskJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000274000d64656c6567617465436c6173737400426f72672e6170616368652e73796e636f70652e636f72652e70726f766973696f6e696e672e6a6176612e7075736870756c6c2e50756c6c4a6f6244656c6567617465740006646f6d61696e7400064d61737465727800'),
('scheduler', 'taskJob7c2242f4-14af-4ab5-af31-cdae23783655', 'DEFAULT', NULL, 'org.apache.syncope.core.provisioning.java.job.TaskJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000274000d64656c6567617465436c6173737400426f72672e6170616368652e73796e636f70652e636f72652e70726f766973696f6e696e672e6a6176612e7075736870756c6c2e50756c6c4a6f6244656c6567617465740006646f6d61696e7400064d61737465727800'),
('scheduler', 'taskJob83f7e85d-9774-43fe-adba-ccd856312994', 'DEFAULT', NULL, 'org.apache.syncope.core.provisioning.java.job.TaskJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000274000d64656c6567617465436c6173737400426f72672e6170616368652e73796e636f70652e636f72652e70726f766973696f6e696e672e6a6176612e7075736870756c6c2e50756c6c4a6f6244656c6567617465740006646f6d61696e7400064d61737465727800'),
('scheduler', 'taskJobe95555d2-1b09-42c8-b25b-f4c4ec597979', 'DEFAULT', NULL, 'org.apache.syncope.core.provisioning.java.job.TaskJob', FALSE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000274000d64656c6567617465436c61737374003b6f72672e6170616368652e73796e636f70652e6669742e636f72652e7265666572656e63652e5465737453616d706c654a6f6244656c6567617465740006646f6d61696e7400064d61737465727800');      
INSERT INTO PUBLIC.QRTZ_JOB_DETAILS(SCHED_NAME, JOB_NAME, JOB_GROUP, DESCRIPTION, JOB_CLASS_NAME, IS_DURABLE, IS_NONCONCURRENT, IS_UPDATE_DATA, REQUESTS_RECOVERY, JOB_DATA) VALUES
('scheduler', 'taskJob24b1be9c-7e3b-443a-86c9-798ebce5eaf2', 'DEFAULT', NULL, 'org.apache.syncope.core.provisioning.java.job.TaskJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000274000d64656c6567617465436c6173737400426f72672e6170616368652e73796e636f70652e636f72652e70726f766973696f6e696e672e6a6176612e7075736870756c6c2e507573684a6f6244656c6567617465740006646f6d61696e7400064d61737465727800'),
('scheduler', 'taskJob375c7b7f-9e3a-4833-88c9-b7787b0a69f2', 'DEFAULT', NULL, 'org.apache.syncope.core.provisioning.java.job.TaskJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000274000d64656c6567617465436c6173737400426f72672e6170616368652e73796e636f70652e636f72652e70726f766973696f6e696e672e6a6176612e7075736870756c6c2e507573684a6f6244656c6567617465740006646f6d61696e7400064d61737465727800'),
('scheduler', 'taskJobfd905ba5-9d56-4f51-83e2-859096a67b75', 'DEFAULT', NULL, 'org.apache.syncope.core.provisioning.java.job.TaskJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000274000d64656c6567617465436c6173737400426f72672e6170616368652e73796e636f70652e636f72652e70726f766973696f6e696e672e6a6176612e7075736870756c6c2e507573684a6f6244656c6567617465740006646f6d61696e7400064d61737465727800'),
('scheduler', 'taskJobe95555d2-1b09-42c8-b25b-f4c4ec598989', 'DEFAULT', NULL, 'org.apache.syncope.core.provisioning.java.job.TaskJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000274000d64656c6567617465436c6173737400456f72672e6170616368652e73796e636f70652e636f72652e70726f766973696f6e696e672e6a6176612e6a6f622e4964656e74697479526563657274696669636174696f6e740006646f6d61696e7400064d61737465727800'),
('scheduler', 'taskJob986867e2-993b-430e-8feb-aa9abb4c1dcd', 'DEFAULT', NULL, 'org.apache.syncope.core.provisioning.java.job.TaskJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000274000d64656c6567617465436c6173737400426f72672e6170616368652e73796e636f70652e636f72652e70726f766973696f6e696e672e6a6176612e7075736870756c6c2e50756c6c4a6f6244656c6567617465740006646f6d61696e7400064d61737465727800');   
INSERT INTO PUBLIC.QRTZ_JOB_DETAILS(SCHED_NAME, JOB_NAME, JOB_GROUP, DESCRIPTION, JOB_CLASS_NAME, IS_DURABLE, IS_NONCONCURRENT, IS_UPDATE_DATA, REQUESTS_RECOVERY, JOB_DATA) VALUES
('scheduler', 'taskJob1e419ca4-ea81-4493-a14f-28b90113686d', 'DEFAULT', NULL, 'org.apache.syncope.core.provisioning.java.job.TaskJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000274000d64656c6567617465436c6173737400426f72672e6170616368652e73796e636f70652e636f72652e70726f766973696f6e696e672e6a6176612e7075736870756c6c2e50756c6c4a6f6244656c6567617465740006646f6d61696e7400064d61737465727800'),
('scheduler', 'taskJobc41b9b71-9bfa-4f90-89f2-84787def4c5c', 'DEFAULT', NULL, 'org.apache.syncope.core.provisioning.java.job.TaskJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000274000d64656c6567617465436c6173737400426f72672e6170616368652e73796e636f70652e636f72652e70726f766973696f6e696e672e6a6176612e7075736870756c6c2e50756c6c4a6f6244656c6567617465740006646f6d61696e7400064d61737465727800'),
('scheduler', 'taskJobaf558be4-9d2f-4359-bf85-a554e6e90be1', 'DEFAULT', NULL, 'org.apache.syncope.core.provisioning.java.job.TaskJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000274000d64656c6567617465436c6173737400426f72672e6170616368652e73796e636f70652e636f72652e70726f766973696f6e696e672e6a6176612e7075736870756c6c2e507573684a6f6244656c6567617465740006646f6d61696e7400064d61737465727800'),
('scheduler', 'taskJob5e5f7c7e-9de7-4c6a-99f1-4df1af959807', 'DEFAULT', NULL, 'org.apache.syncope.core.provisioning.java.job.TaskJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000274000d64656c6567617465436c6173737400426f72672e6170616368652e73796e636f70652e636f72652e70726f766973696f6e696e672e6a6176612e7075736870756c6c2e507573684a6f6244656c6567617465740006646f6d61696e7400064d61737465727800'),
('scheduler', 'taskJobc46edc3a-a18b-4af2-b707-f4a415507496', 'DEFAULT', NULL, 'org.apache.syncope.core.provisioning.java.job.TaskJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000274000d64656c6567617465436c6173737400426f72672e6170616368652e73796e636f70652e636f72652e70726f766973696f6e696e672e6a6176612e7075736870756c6c2e507573684a6f6244656c6567617465740006646f6d61696e7400064d61737465727800');         
INSERT INTO PUBLIC.QRTZ_JOB_DETAILS(SCHED_NAME, JOB_NAME, JOB_GROUP, DESCRIPTION, JOB_CLASS_NAME, IS_DURABLE, IS_NONCONCURRENT, IS_UPDATE_DATA, REQUESTS_RECOVERY, JOB_DATA) VALUES
('scheduler', 'taskJob0bc11a19-6454-45c2-a4e3-ceef84e5d79b', 'DEFAULT', NULL, 'org.apache.syncope.core.provisioning.java.job.TaskJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000274000d64656c6567617465436c6173737400426f72672e6170616368652e73796e636f70652e636f72652e70726f766973696f6e696e672e6a6176612e7075736870756c6c2e507573684a6f6244656c6567617465740006646f6d61696e7400064d61737465727800'),
('scheduler', 'taskJob51318433-cce4-4f71-8f45-9534b6c9c819', 'DEFAULT', NULL, 'org.apache.syncope.core.provisioning.java.job.TaskJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000274000d64656c6567617465436c6173737400426f72672e6170616368652e73796e636f70652e636f72652e70726f766973696f6e696e672e6a6176612e7075736870756c6c2e507573684a6f6244656c6567617465740006646f6d61696e7400064d61737465727800'),
('scheduler', 'taskJob55d5e74b-497e-4bc0-9156-73abef4b9adc', 'DEFAULT', NULL, 'org.apache.syncope.core.provisioning.java.job.TaskJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000274000d64656c6567617465436c6173737400426f72672e6170616368652e73796e636f70652e636f72652e70726f766973696f6e696e672e6a6176612e7075736870756c6c2e50756c6c4a6f6244656c6567617465740006646f6d61696e7400064d61737465727800'),
('scheduler', 'taskJob03aa2a04-4881-4573-9117-753f81b04865', 'DEFAULT', NULL, 'org.apache.syncope.core.provisioning.java.job.TaskJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c7708000000100000000274000d64656c6567617465436c6173737400426f72672e6170616368652e73796e636f70652e636f72652e70726f766973696f6e696e672e6a6176612e7075736870756c6c2e507573684a6f6244656c6567617465740006646f6d61696e7400064d61737465727800'),
('scheduler', 'reportJob0062ea9c-924d-4ecf-9961-4492a8cc6d1b', 'DEFAULT', NULL, 'org.apache.syncope.core.provisioning.java.job.report.ReportJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c77080000001000000001740006646f6d61696e7400064d61737465727800');        
INSERT INTO PUBLIC.QRTZ_JOB_DETAILS(SCHED_NAME, JOB_NAME, JOB_GROUP, DESCRIPTION, JOB_CLASS_NAME, IS_DURABLE, IS_NONCONCURRENT, IS_UPDATE_DATA, REQUESTS_RECOVERY, JOB_DATA) VALUES
('scheduler', 'reportJobc3520ad9-179f-49e7-b315-d684d216dd97', 'DEFAULT', NULL, 'org.apache.syncope.core.provisioning.java.job.report.ReportJob', TRUE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c77080000001000000001740006646f6d61696e7400064d61737465727800'),
('scheduler', 'notificationJob', 'DEFAULT', NULL, 'org.apache.syncope.core.provisioning.java.job.notification.NotificationJob', FALSE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c77080000001000000001740006646f6d61696e74000354776f7800'),
('scheduler', 'systemLoadReporterJob', 'DEFAULT', NULL, 'org.apache.syncope.core.provisioning.java.job.SystemLoadReporterJob', FALSE, TRUE, FALSE, FALSE, X'aced0005737200156f72672e71756172747a2e4a6f62446174614d61709fb083e8bfa9b0cb020000787200266f72672e71756172747a2e7574696c732e537472696e674b65794469727479466c61674d61708208e8c3fbc55d280200015a0013616c6c6f77735472616e7369656e74446174617872001d6f72672e71756172747a2e7574696c732e4469727479466c61674d617013e62ead28760ace0200025a000564697274794c00036d617074000f4c6a6176612f7574696c2f4d61703b787001737200116a6176612e7574696c2e486173684d61700507dac1c31660d103000246000a6c6f6164466163746f724900097468726573686f6c6478703f4000000000000c77080000001000000001740006646f6d61696e74000354776f7800');   
CREATE MEMORY TABLE PUBLIC.QRTZ_SIMPLE_TRIGGERS(
    SCHED_NAME VARCHAR(120) NOT NULL,
    TRIGGER_NAME VARCHAR(200) NOT NULL,
    TRIGGER_GROUP VARCHAR(200) NOT NULL,
    REPEAT_COUNT BIGINT NOT NULL,
    REPEAT_INTERVAL BIGINT NOT NULL,
    TIMES_TRIGGERED BIGINT NOT NULL
);          
ALTER TABLE PUBLIC.QRTZ_SIMPLE_TRIGGERS ADD CONSTRAINT PUBLIC.PK_QRTZ_SIMPLE_TRIGGERS PRIMARY KEY(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP);    
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_SIMPLE_TRIGGERS;     
CREATE MEMORY TABLE PUBLIC.QRTZ_SIMPROP_TRIGGERS(
    SCHED_NAME VARCHAR(120) NOT NULL,
    TRIGGER_NAME VARCHAR(200) NOT NULL,
    TRIGGER_GROUP VARCHAR(200) NOT NULL,
    STR_PROP_1 VARCHAR(512),
    STR_PROP_2 VARCHAR(512),
    STR_PROP_3 VARCHAR(512),
    INT_PROP_1 INTEGER,
    INT_PROP_2 INTEGER,
    LONG_PROP_1 BIGINT,
    LONG_PROP_2 BIGINT,
    DEC_PROP_1 NUMERIC(13, 4),
    DEC_PROP_2 NUMERIC(13, 4),
    BOOL_PROP_1 BOOLEAN,
    BOOL_PROP_2 BOOLEAN
);              
ALTER TABLE PUBLIC.QRTZ_SIMPROP_TRIGGERS ADD CONSTRAINT PUBLIC.PK_QRTZ_SIMPROP_TRIGGERS PRIMARY KEY(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP);  
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_SIMPROP_TRIGGERS;    
CREATE MEMORY TABLE PUBLIC.QRTZ_BLOB_TRIGGERS(
    SCHED_NAME VARCHAR(120) NOT NULL,
    TRIGGER_NAME VARCHAR(200) NOT NULL,
    TRIGGER_GROUP VARCHAR(200) NOT NULL,
    BLOB_DATA IMAGE
);   
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_BLOB_TRIGGERS;       
CREATE MEMORY TABLE PUBLIC.QRTZ_TRIGGERS(
    SCHED_NAME VARCHAR(120) NOT NULL,
    TRIGGER_NAME VARCHAR(200) NOT NULL,
    TRIGGER_GROUP VARCHAR(200) NOT NULL,
    JOB_NAME VARCHAR(200) NOT NULL,
    JOB_GROUP VARCHAR(200) NOT NULL,
    DESCRIPTION VARCHAR(250),
    NEXT_FIRE_TIME BIGINT,
    PREV_FIRE_TIME BIGINT,
    PRIORITY INTEGER,
    TRIGGER_STATE VARCHAR(16) NOT NULL,
    TRIGGER_TYPE VARCHAR(8) NOT NULL,
    START_TIME BIGINT NOT NULL,
    END_TIME BIGINT,
    CALENDAR_NAME VARCHAR(200),
    MISFIRE_INSTR SMALLINT,
    JOB_DATA IMAGE
);       
ALTER TABLE PUBLIC.QRTZ_TRIGGERS ADD CONSTRAINT PUBLIC.PK_QRTZ_TRIGGERS PRIMARY KEY(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP);  
-- 4 +/- SELECT COUNT(*) FROM PUBLIC.QRTZ_TRIGGERS;            
INSERT INTO PUBLIC.QRTZ_TRIGGERS(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, JOB_NAME, JOB_GROUP, DESCRIPTION, NEXT_FIRE_TIME, PREV_FIRE_TIME, PRIORITY, TRIGGER_STATE, TRIGGER_TYPE, START_TIME, END_TIME, CALENDAR_NAME, MISFIRE_INSTR, JOB_DATA) VALUES
('scheduler', 'Trigger_taskJobe95555d2-1b09-42c8-b25b-f4c4ec597979', 'DEFAULT', 'taskJobe95555d2-1b09-42c8-b25b-f4c4ec597979', 'DEFAULT', NULL, 1533074400000, -1, 5, 'WAITING', 'CRON', 1530698657000, 0, NULL, 0, X''),
('scheduler', 'Trigger_taskJob89de5014-e3f5-4462-84d8-d97575740baf', 'DEFAULT', 'taskJob89de5014-e3f5-4462-84d8-d97575740baf', 'DEFAULT', NULL, 1530699000000, 1530698700000, 5, 'WAITING', 'CRON', 1530698657000, 0, NULL, 0, X''),
('scheduler', 'Trigger_systemLoadReporterJob', 'DEFAULT', 'systemLoadReporterJob', 'DEFAULT', NULL, 1530698760000, 1530698700000, 5, 'WAITING', 'CRON', 1530698657000, 0, NULL, 0, X''),
('scheduler', 'Trigger_notificationJob', 'DEFAULT', 'notificationJob', 'DEFAULT', NULL, 1530698720000, 1530698700000, 5, 'ACQUIRED', 'CRON', 1530698657000, 0, NULL, 0, X'');  
CREATE MEMORY TABLE PUBLIC.ACCESSTOKEN(
    ID VARCHAR(255) NOT NULL,
    AUTHORITIES BLOB,
    BODY CLOB,
    EXPIRYTIME TIMESTAMP,
    OWNER VARCHAR(255)
); 
ALTER TABLE PUBLIC.ACCESSTOKEN ADD CONSTRAINT PUBLIC.CONSTRAINT_4 PRIMARY KEY(ID);             
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACCESSTOKEN;              
CREATE MEMORY TABLE PUBLIC.ACCOUNTPOLICY(
    ID VARCHAR(36) NOT NULL,
    DESCRIPTION VARCHAR(255),
    MAXAUTHENTICATIONATTEMPTS INTEGER,
    PROPAGATESUSPENSION INTEGER
); 
ALTER TABLE PUBLIC.ACCOUNTPOLICY ADD CONSTRAINT PUBLIC.CONSTRAINT_B PRIMARY KEY(ID);           
-- 2 +/- SELECT COUNT(*) FROM PUBLIC.ACCOUNTPOLICY;            
INSERT INTO PUBLIC.ACCOUNTPOLICY(ID, DESCRIPTION, MAXAUTHENTICATIONATTEMPTS, PROPAGATESUSPENSION) VALUES
('20ab5a8c-4b0c-432c-b957-f7fb9784d9f7', 'an account policy', 0, 0),
('06e2ed52-6966-44aa-a177-a0ca7434201f', 'sample account policy', 3, 0);         
CREATE MEMORY TABLE PUBLIC.ACCOUNTPOLICY_EXTERNALRESOURCE(
    ACCOUNTPOLICY_ID VARCHAR(36),
    RESOURCE_ID VARCHAR(255)
);   
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.ACCOUNTPOLICY_EXTERNALRESOURCE;           
INSERT INTO PUBLIC.ACCOUNTPOLICY_EXTERNALRESOURCE(ACCOUNTPOLICY_ID, RESOURCE_ID) VALUES
('20ab5a8c-4b0c-432c-b957-f7fb9784d9f7', 'resource-testdb');           
CREATE MEMORY TABLE PUBLIC.ACCOUNTRULECONFINSTANCE(
    ID VARCHAR(36) NOT NULL,
    SERIALIZEDINSTANCE CLOB,
    ACCOUNTPOLICY_ID VARCHAR(36)
);              
ALTER TABLE PUBLIC.ACCOUNTRULECONFINSTANCE ADD CONSTRAINT PUBLIC.CONSTRAINT_2 PRIMARY KEY(ID); 
-- 2 +/- SELECT COUNT(*) FROM PUBLIC.ACCOUNTRULECONFINSTANCE;  
INSERT INTO PUBLIC.ACCOUNTRULECONFINSTANCE(ID, SERIALIZEDINSTANCE, ACCOUNTPOLICY_ID) VALUES
('5', '{"@class":"org.apache.syncope.common.lib.policy.DefaultAccountRuleConf","maxLength":0,"minLength":0,"pattern":null,"allUpperCase":false,"allLowerCase":false,"wordsNotPermitted":[],"schemasNotPermitted":[],"prefixesNotPermitted":[],"suffixesNotPermitted":[]}', '20ab5a8c-4b0c-432c-b957-f7fb9784d9f7'),
('6', '{"@class":"org.apache.syncope.common.lib.policy.DefaultAccountRuleConf","maxLength":0,"minLength":4,"pattern":null,"allUpperCase":false,"allLowerCase":false,"wordsNotPermitted":[],"schemasNotPermitted":[],"prefixesNotPermitted":["notpermitted1","notpermitted2"],"suffixesNotPermitted":[]}', '06e2ed52-6966-44aa-a177-a0ca7434201f');             
CREATE MEMORY TABLE PUBLIC.ADYNGROUPMEMBERSHIP(
    ID VARCHAR(36) NOT NULL,
    FIQL VARCHAR(255),
    GROUP_ID VARCHAR(36),
    ANYTYPE_ID VARCHAR(255)
);   
ALTER TABLE PUBLIC.ADYNGROUPMEMBERSHIP ADD CONSTRAINT PUBLIC.CONSTRAINT_F PRIMARY KEY(ID);     
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ADYNGROUPMEMBERSHIP;      
CREATE MEMORY TABLE PUBLIC.AMEMBERSHIP(
    ID VARCHAR(36) NOT NULL,
    ANYOBJECT_ID VARCHAR(36),
    GROUP_ID VARCHAR(36)
); 
ALTER TABLE PUBLIC.AMEMBERSHIP ADD CONSTRAINT PUBLIC.CONSTRAINT_9 PRIMARY KEY(ID);             
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.AMEMBERSHIP;              
CREATE INDEX PUBLIC.AMEMBERSHIP_ANYOBJECTINDEX ON PUBLIC.AMEMBERSHIP(ANYOBJECT_ID);            
CREATE INDEX PUBLIC.AMEMBERSHIP_GROUPINDEX ON PUBLIC.AMEMBERSHIP(GROUP_ID);    
CREATE MEMORY TABLE PUBLIC.ANYABOUT(
    ID VARCHAR(36) NOT NULL,
    FILTER CLOB,
    NOTIFICATION_ID VARCHAR(36),
    ANYTYPE_ID VARCHAR(255)
);             
ALTER TABLE PUBLIC.ANYABOUT ADD CONSTRAINT PUBLIC.CONSTRAINT_1 PRIMARY KEY(ID);
-- 2 +/- SELECT COUNT(*) FROM PUBLIC.ANYABOUT; 
INSERT INTO PUBLIC.ANYABOUT(ID, FILTER, NOTIFICATION_ID, ANYTYPE_ID) VALUES
('a328f2e6-25e9-4cc1-badf-7425d7be4b39', 'token!=$null', 'e00945b5-1184-4d43-8e45-4318a8dcdfd4', 'USER'),
('2e2ee845-2abf-43c6-b543-49243a84e2f1', 'fullname==*o*;fullname==*i*', '9e2b911c-25de-4c77-bcea-b86ed9451050', 'USER'); 
CREATE MEMORY TABLE PUBLIC.ANYOBJECT(
    ID VARCHAR(36) NOT NULL,
    CREATIONDATE TIMESTAMP,
    CREATOR VARCHAR(255),
    LASTCHANGEDATE TIMESTAMP,
    LASTMODIFIER VARCHAR(255),
    STATUS VARCHAR(255),
    WORKFLOWID VARCHAR(255),
    NAME VARCHAR(255),
    REALM_ID VARCHAR(36),
    TYPE_ID VARCHAR(255)
);       
ALTER TABLE PUBLIC.ANYOBJECT ADD CONSTRAINT PUBLIC.CONSTRAINT_3 PRIMARY KEY(ID);               
-- 3 +/- SELECT COUNT(*) FROM PUBLIC.ANYOBJECT;
INSERT INTO PUBLIC.ANYOBJECT(ID, CREATIONDATE, CREATOR, LASTCHANGEDATE, LASTMODIFIER, STATUS, NAME, REALM_ID, TYPE_ID) VALUES
('fc6dbc3a-6c07-4965-8781-921e7401a4a5', TIMESTAMP '2010-10-20 11:00:00', 'admin', TIMESTAMP '2010-10-20 11:00:00', 'admin', NULL, 'HP LJ 1300n', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', 'PRINTER'),
('8559d14d-58c2-46eb-a2d4-a7d35161e8f8', TIMESTAMP '2010-10-20 11:00:00', 'admin', TIMESTAMP '2010-10-20 11:00:00', 'admin', NULL, 'Canon MF 8030cn', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', 'PRINTER'),
('9e1d130c-d6a3-48b1-98b3-182477ed0688', TIMESTAMP '2010-10-20 11:00:00', 'admin', TIMESTAMP '2010-10-20 11:00:00', 'admin', NULL, 'Epson Stylus Color', '0679e069-7355-4b20-bd11-a5a0a5453c7c', 'PRINTER');       
CREATE MEMORY TABLE PUBLIC.ANYOBJECT_ANYTYPECLASS(
    ANYOBJECT_ID VARCHAR(36),
    ANYTYPECLASS_ID VARCHAR(255)
);           
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ANYOBJECT_ANYTYPECLASS;   
CREATE MEMORY TABLE PUBLIC.ANYOBJECT_EXTERNALRESOURCE(
    ANYOBJECT_ID VARCHAR(36),
    RESOURCE_ID VARCHAR(255)
);           
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ANYOBJECT_EXTERNALRESOURCE;               
CREATE MEMORY TABLE PUBLIC.ANYTEMPLATEPULLTASK(
    ID VARCHAR(36) NOT NULL,
    TEMPLATE CLOB,
    ANYTYPE_ID VARCHAR(255),
    PULLTASK_ID VARCHAR(36)
);    
ALTER TABLE PUBLIC.ANYTEMPLATEPULLTASK ADD CONSTRAINT PUBLIC.CONSTRAINT_9E PRIMARY KEY(ID);    
-- 8 +/- SELECT COUNT(*) FROM PUBLIC.ANYTEMPLATEPULLTASK;      
INSERT INTO PUBLIC.ANYTEMPLATEPULLTASK(ID, TEMPLATE, ANYTYPE_ID, PULLTASK_ID) VALUES
('3a6173a9-8c34-4e37-b3b1-0c2ea385fac0', '{"@class":"org.apache.syncope.common.lib.to.UserTO","creator":null,"creationDate":null,"lastModifier":null,"lastChangeDate":null,"key":null,"type":"USER","realm":null,"status":null,"password":null,"token":null,"tokenExpireTime":null,"username":null,"lastLoginDate":null,"changePwdDate":null,"failedLogins":null,"securityQuestion":null,"securityAnswer":null,"auxClasses":["csv"],"derAttrs":[{"schema":"cn","values":[""]}],"virAttrs":[],"resources":["resource-testdb"],"relationships":[],"memberships":[{"groupKey":"f779c0d4-633b-4be5-8f57-32eb478a3ca5","groupName":null}],"dynMemberships":[],"roles":[],"dynRoles":[],"plainAttrs":[{"schema":"ctype","values":["email == ''test8@syncope.apache.org''? ''TYPE_8'': ''TYPE_OTHER''"]}]}', 'USER', 'c41b9b71-9bfa-4f90-89f2-84787def4c5c'),
('b3772d66-ec06-4133-bf38-b3273845ac5b', '{"@class":"org.apache.syncope.common.lib.to.GroupTO","creator":null,"creationDate":null,"lastModifier":null,"lastChangeDate":null,"key":null,"type":"GROUP","realm":null,"status":null,"name":null,"userOwner":null,"groupOwner":null,"udynMembershipCond":null,"auxClasses":[],"derAttrs":[],"virAttrs":[],"resources":[],"plainAttrs":[]}', 'GROUP', 'c41b9b71-9bfa-4f90-89f2-84787def4c5c'),
('6c3f578d-327b-4a7c-8037-6f5ba24eb770', '{"@class":"org.apache.syncope.common.lib.to.UserTO","creator":null,"creationDate":null,"lastModifier":null,"lastChangeDate":null,"key":null,"type":"USER","realm":null,"status":null,"password":null,"token":null,"tokenExpireTime":null,"username":null,"lastLoginDate":null,"changePwdDate":null,"failedLogins":null,"securityQuestion":null,"securityAnswer":null,"auxClasses":[],"derAttrs":[],"virAttrs":[],"resources":[],"relationships":[],"memberships":[],"dynMemberships":[],"roles":[],"dynRoles":[],"plainAttrs":[{"schema":"ctype","values":["''type a''"]},{"schema":"userId","values":["''reconciled@syncope.apache.org''"]},{"schema":"fullname","values":["''reconciled fullname''"]},{"schema":"surname","values":["''surname''"]}]}', 'USER', '83f7e85d-9774-43fe-adba-ccd856312994'),
('45b61137-c7c3-49ee-86e0-9efffa75ae68', '{"@class":"org.apache.syncope.common.lib.to.GroupTO","creator":null,"creationDate":null,"lastModifier":null,"lastChangeDate":null,"key":null,"type":"GROUP","realm":null,"status":null,"name":null,"userOwner":null,"groupOwner":null,"udynMembershipCond":null,"auxClasses":[],"derAttrs":[],"virAttrs":[],"resources":[],"plainAttrs":[]}', 'GROUP', '83f7e85d-9774-43fe-adba-ccd856312994'),
('df655a2a-40c0-43b1-a157-3f4988802f58', '{"@class":"org.apache.syncope.common.lib.to.UserTO","creator":null,"creationDate":null,"lastModifier":null,"lastChangeDate":null,"key":null,"type":"USER","realm":"''/'' + title","status":null,"password":null,"token":null,"tokenExpireTime":null,"username":null,"lastLoginDate":null,"changePwdDate":null,"failedLogins":null,"securityQuestion":null,"securityAnswer":null,"auxClasses":["minimal group"],"derAttrs":[],"virAttrs":[{"schema":"virtualReadOnly","values":[""]}],"resources":["resource-ldap"],"roles":[],"dynRoles":[],"relationships":[],"memberships":[],"dynMemberships":[],"plainAttrs":[]}', 'USER', '1e419ca4-ea81-4493-a14f-28b90113686d'),
('fda22ff3-98f3-42e4-a2ae-cd9a28282d57', '{"@class":"org.apache.syncope.common.lib.to.GroupTO","creator":null,"creationDate":null,"lastModifier":null,"lastChangeDate":null,"key":null,"type":"GROUP","realm":null,"status":null,"name":null,"userOwner":null,"groupOwner":null,"udynMembershipCond":null,"auxClasses":[],"derAttrs":[],"virAttrs":[],"resources":[],"plainAttrs":[{"schema":"show","values":["true"]}]}', 'GROUP', '1e419ca4-ea81-4493-a14f-28b90113686d'),
('8bc41ba1-cc1d-4ee0-bb43-61cd148b414f', '{"@class":"org.apache.syncope.common.lib.to.UserTO","creator":null,"creationDate":null,"lastModifier":null,"lastChangeDate":null,"key":null,"type":"USER","realm":null,"status":null,"password":null,"token":null,"tokenExpireTime":null,"username":null,"lastLoginDate":null,"changePwdDate":null,"failedLogins":null,"securityQuestion":null,"securityAnswer":null,"auxClasses":[],"derAttrs":[],"virAttrs":[],"resources":["resource-testdb"],"roles":[],"dynRoles":[],"relationships":[],"memberships":[],"dynMemberships":[],"plainAttrs":[{"schema":"firstname","values":[""]},{"schema":"userId","values":["''test''"]},{"schema":"fullname","values":["''test''"]},{"schema":"surname","values":["''test''"]}]}', 'USER', '986867e2-993b-430e-8feb-aa9abb4c1dcd');       
INSERT INTO PUBLIC.ANYTEMPLATEPULLTASK(ID, TEMPLATE, ANYTYPE_ID, PULLTASK_ID) VALUES
('9af0e343-8a37-42d2-9bc7-6e2e3b103219', '{"@class":"org.apache.syncope.common.lib.to.GroupTO","creator":null,"creationDate":null,"lastModifier":null,"lastChangeDate":null,"key":null,"type":"GROUP","realm":null,"status":null,"name":null,"userOwner":null,"groupOwner":null,"udynMembershipCond":null,"auxClasses":[],"derAttrs":[],"virAttrs":[],"resources":[],"plainAttrs":[]}', 'GROUP', '986867e2-993b-430e-8feb-aa9abb4c1dcd'); 
CREATE MEMORY TABLE PUBLIC.ANYTEMPLATEREALM(
    ID VARCHAR(36) NOT NULL,
    TEMPLATE CLOB,
    REALM_ID VARCHAR(36),
    ANYTYPE_ID VARCHAR(255)
);          
ALTER TABLE PUBLIC.ANYTEMPLATEREALM ADD CONSTRAINT PUBLIC.CONSTRAINT_D PRIMARY KEY(ID);        
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ANYTEMPLATEREALM;         
CREATE MEMORY TABLE PUBLIC.ANYTYPE(
    ID VARCHAR(255) NOT NULL,
    KIND VARCHAR(20)
);      
ALTER TABLE PUBLIC.ANYTYPE ADD CONSTRAINT PUBLIC.CONSTRAINT_F8 PRIMARY KEY(ID);
-- 3 +/- SELECT COUNT(*) FROM PUBLIC.ANYTYPE;  
INSERT INTO PUBLIC.ANYTYPE(ID, KIND) VALUES
('USER', 'USER'),
('GROUP', 'GROUP'),
('PRINTER', 'ANY_OBJECT');   
CREATE MEMORY TABLE PUBLIC.ANYTYPECLASS(
    ID VARCHAR(255) NOT NULL
);       
ALTER TABLE PUBLIC.ANYTYPECLASS ADD CONSTRAINT PUBLIC.CONSTRAINT_49 PRIMARY KEY(ID);           
-- 6 +/- SELECT COUNT(*) FROM PUBLIC.ANYTYPECLASS;             
INSERT INTO PUBLIC.ANYTYPECLASS(ID) VALUES
('generic membership'),
('minimal user'),
('other'),
('minimal group'),
('minimal printer'),
('csv');               
CREATE MEMORY TABLE PUBLIC.ANYTYPE_ANYTYPECLASS(
    ANYTYPE_ID VARCHAR(255),
    ANYTYPECLASS_ID VARCHAR(255)
);              
-- 4 +/- SELECT COUNT(*) FROM PUBLIC.ANYTYPE_ANYTYPECLASS;     
INSERT INTO PUBLIC.ANYTYPE_ANYTYPECLASS(ANYTYPE_ID, ANYTYPECLASS_ID) VALUES
('USER', 'minimal user'),
('USER', 'other'),
('GROUP', 'minimal group'),
('PRINTER', 'minimal printer');           
CREATE MEMORY TABLE PUBLIC.APLAINATTR(
    ID VARCHAR(36) NOT NULL,
    OWNER_ID VARCHAR(36),
    SCHEMA_ID VARCHAR(255),
    MEMBERSHIP_ID VARCHAR(36)
);     
ALTER TABLE PUBLIC.APLAINATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_22 PRIMARY KEY(ID);             
-- 4 +/- SELECT COUNT(*) FROM PUBLIC.APLAINATTR;               
INSERT INTO PUBLIC.APLAINATTR(ID, OWNER_ID, SCHEMA_ID, MEMBERSHIP_ID) VALUES
('956a8440-1df7-4ed6-b156-04173ca47528', 'fc6dbc3a-6c07-4965-8781-921e7401a4a5', 'model', NULL),
('1fa796fd-c7e2-414e-8ad3-ac86b729d62c', 'fc6dbc3a-6c07-4965-8781-921e7401a4a5', 'location', NULL),
('b8342732-81bd-440b-91ac-b8cdad288ed5', '8559d14d-58c2-46eb-a2d4-a7d35161e8f8', 'model', NULL),
('c4cb0684-a033-425c-8b1b-d283597f999b', '8559d14d-58c2-46eb-a2d4-a7d35161e8f8', 'location', NULL);         
CREATE INDEX PUBLIC.APLAINATTR_SCHEMA_INDEX ON PUBLIC.APLAINATTR(SCHEMA_ID);   
CREATE INDEX PUBLIC.APLAINATTR_OWNER_INDEX ON PUBLIC.APLAINATTR(OWNER_ID);     
CREATE INDEX PUBLIC.APLAINATTR_MEMBERSHIP_INDEX ON PUBLIC.APLAINATTR(MEMBERSHIP_ID);           
CREATE MEMORY TABLE PUBLIC.APLAINATTRUNIQUEVALUE(
    ID VARCHAR(36) NOT NULL,
    BINARYVALUE BLOB,
    BOOLEANVALUE INTEGER,
    DATEVALUE TIMESTAMP,
    DOUBLEVALUE DOUBLE,
    LONGVALUE BIGINT,
    STRINGVALUE VARCHAR(255),
    ATTRIBUTE_ID VARCHAR(36),
    SCHEMA_ID VARCHAR(255)
);
ALTER TABLE PUBLIC.APLAINATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_FE PRIMARY KEY(ID);  
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.APLAINATTRUNIQUEVALUE;    
CREATE INDEX PUBLIC.APATTRUNIQUEVALUE_ATTRINDEX ON PUBLIC.APLAINATTRUNIQUEVALUE(ATTRIBUTE_ID); 
CREATE MEMORY TABLE PUBLIC.APLAINATTRVALUE(
    ID VARCHAR(36) NOT NULL,
    BINARYVALUE BLOB,
    BOOLEANVALUE INTEGER,
    DATEVALUE TIMESTAMP,
    DOUBLEVALUE DOUBLE,
    LONGVALUE BIGINT,
    STRINGVALUE VARCHAR(255),
    ATTRIBUTE_ID VARCHAR(36)
);  
ALTER TABLE PUBLIC.APLAINATTRVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_B4 PRIMARY KEY(ID);        
-- 4 +/- SELECT COUNT(*) FROM PUBLIC.APLAINATTRVALUE;          
INSERT INTO PUBLIC.APLAINATTRVALUE(ID, BINARYVALUE, BOOLEANVALUE, DATEVALUE, DOUBLEVALUE, LONGVALUE, STRINGVALUE, ATTRIBUTE_ID) VALUES
('15f64e99-20cc-42ec-a77a-3396dea4248f', NULL, NULL, NULL, NULL, NULL, 'Canon MFC8030', '956a8440-1df7-4ed6-b156-04173ca47528'),
('ad0452c9-93b9-4248-b2ca-48ef8a1cf5b5', NULL, NULL, NULL, NULL, NULL, '1st floor', '1fa796fd-c7e2-414e-8ad3-ac86b729d62c'),
('50e852ac-68ba-4b12-85ca-e366987fd855', NULL, NULL, NULL, NULL, NULL, 'HP Laserjet 1300n', 'b8342732-81bd-440b-91ac-b8cdad288ed5'),
('7b954dee-8a14-4fa1-a433-cff0d1f888f8', NULL, NULL, NULL, NULL, NULL, '2nd floor', 'c4cb0684-a033-425c-8b1b-d283597f999b');         
CREATE INDEX PUBLIC.AATTRVALUE_DATEVALUEINDEX ON PUBLIC.APLAINATTRVALUE(DATEVALUE);            
CREATE INDEX PUBLIC.AATTRVALUE_LONGVALUEINDEX ON PUBLIC.APLAINATTRVALUE(LONGVALUE);            
CREATE INDEX PUBLIC.AATTRVALUE_BOOLEANVALUEINDEX ON PUBLIC.APLAINATTRVALUE(BOOLEANVALUE);      
CREATE INDEX PUBLIC.AATTRVALUE_DOUBLEVALUEINDEX ON PUBLIC.APLAINATTRVALUE(DOUBLEVALUE);        
CREATE INDEX PUBLIC.AATTRVALUE_STRINGVALUEINDEX ON PUBLIC.APLAINATTRVALUE(STRINGVALUE);        
CREATE INDEX PUBLIC.APLAINATTRVALUE_ATTRINDEX ON PUBLIC.APLAINATTRVALUE(ATTRIBUTE_ID);         
CREATE MEMORY TABLE PUBLIC.ARELATIONSHIP(
    ID VARCHAR(36) NOT NULL,
    LEFT_ANYOBJECT_ID VARCHAR(36),
    RIGHT_ANYOBJECT_ID VARCHAR(36),
    TYPE_ID VARCHAR(255)
);      
ALTER TABLE PUBLIC.ARELATIONSHIP ADD CONSTRAINT PUBLIC.CONSTRAINT_9C PRIMARY KEY(ID);          
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.ARELATIONSHIP;            
INSERT INTO PUBLIC.ARELATIONSHIP(ID, LEFT_ANYOBJECT_ID, RIGHT_ANYOBJECT_ID, TYPE_ID) VALUES
('11a0ec66-b59b-428a-af3d-f856950ff1c5', 'fc6dbc3a-6c07-4965-8781-921e7401a4a5', '8559d14d-58c2-46eb-a2d4-a7d35161e8f8', 'neighborhood');          
CREATE INDEX PUBLIC.ARELATIONSHIP_ANYOBJECTINDEX ON PUBLIC.ARELATIONSHIP(LEFT_ANYOBJECT_ID);   
CREATE INDEX PUBLIC.ARELATIONSHIP_RIGHTINDEX ON PUBLIC.ARELATIONSHIP(RIGHT_ANYOBJECT_ID);      
CREATE MEMORY TABLE PUBLIC.CAMELROUTE(
    ID VARCHAR(255) NOT NULL,
    ANYTYPEKIND VARCHAR(20),
    CONTENT CLOB
);          
ALTER TABLE PUBLIC.CAMELROUTE ADD CONSTRAINT PUBLIC.CONSTRAINT_9B PRIMARY KEY(ID);             
-- 31 +/- SELECT COUNT(*) FROM PUBLIC.CAMELROUTE;              
INSERT INTO PUBLIC.CAMELROUTE(ID, ANYTYPEKIND, CONTENT) VALUES
('createUser', 'USER', STRINGDECODE('<route id=\"createUser\">\n    <from uri=\"direct:createUser\"/>\n    <setProperty propertyName=\"actual\">\n      <simple>${body}</simple>\n    </setProperty>\n    <doTry>\n      <bean method=\"create(${body},${property.disablePwdPolicyCheck},${property.enabled},${property.storePassword})\" ref=\"uwfAdapter\"/>\n      <to uri=\"propagate:create?anyTypeKind=USER\"/>\n      <to uri=\"direct:createPort\"/>\n      <doCatch>        \n        <exception>java.lang.RuntimeException</exception>\n        <handled>\n          <constant>false</constant>\n        </handled>\n        <to uri=\"direct:createPort\"/>\n      </doCatch>\n    </doTry>\n  </route>')),
('updateUser', 'USER', STRINGDECODE('<route id=\"updateUser\">\n    <from uri=\"direct:updateUser\"/>\n    <setProperty propertyName=\"actual\">\n      <simple>${body}</simple>\n    </setProperty>\n    <doTry>\n      <bean method=\"update(${body})\" ref=\"uwfAdapter\"/>\n      <to uri=\"propagate:update?anyTypeKind=USER\"/>\n      <to uri=\"direct:updatePort\"/>\n      <doCatch>        \n        <exception>java.lang.RuntimeException</exception>\n        <handled>\n          <constant>false</constant>\n        </handled>\n        <to uri=\"direct:updatePort\"/>\n      </doCatch>\n    </doTry>\n  </route>')),
('updateUserInPull', 'USER', STRINGDECODE('<route id=\"updateUserInPull\">\n    <from uri=\"direct:updateUserInPull\"/>            \n    <doTry>\n      <bean method=\"update(${body})\" ref=\"uwfAdapter\"/>\n      <to uri=\"direct:userInPull\"/>\n      <doCatch>        \n        <exception>java.lang.RuntimeException</exception>\n        <handled>\n          <constant>false</constant>\n        </handled>\n        <to uri=\"direct:updateInPullPort\"/>\n      </doCatch>\n    </doTry>\n  </route>')),
('userInPull', 'USER', STRINGDECODE('<route id=\"userInPull\">\n    <from uri=\"direct:userInPull\"/>\n    <to uri=\"propagate:status?anyTypeKind=USER&amp;pull=true\"/>\n    <to uri=\"propagate:update?anyTypeKind=USER&amp;pull=true\"/>\n    <to uri=\"direct:updateInPullPort\"/>\n  </route>')),
('deleteUser', 'USER', STRINGDECODE('<route id=\"deleteUser\">\n    <from uri=\"direct:deleteUser\"/>\n    <doTry>\n      <to uri=\"propagate:delete?anyTypeKind=USER\"/>\n      <bean method=\"delete(${body})\" ref=\"uwfAdapter\"/>\n      <setBody>\n        <simple>${property.statuses}</simple>\n      </setBody>\n      <to uri=\"direct:deletePort\"/>\n      <doCatch>        \n        <exception>java.lang.RuntimeException</exception>\n        <handled>\n          <constant>false</constant>\n        </handled>\n        <to uri=\"direct:deletePort\"/>\n      </doCatch>\n    </doTry>\n  </route>')),
('unlinkUser', 'USER', STRINGDECODE('<route id=\"unlinkUser\">\n    <from uri=\"direct:unlinkUser\"/>\n    <doTry>\n      <bean method=\"update(${body})\" ref=\"uwfAdapter\"/>\n      <setBody>\n        <simple>${body.getResult.getKey}</simple>\n      </setBody>\n      <to uri=\"direct:unlinkPort\"/>\n      <doCatch>        \n        <exception>java.lang.RuntimeException</exception>\n        <handled>\n          <constant>false</constant>\n        </handled>\n        <to uri=\"direct:unlinkPort\"/>\n      </doCatch>\n    </doTry>            \n  </route>')),
('linkUser', 'USER', STRINGDECODE('<route id=\"linkUser\">\n    <from uri=\"direct:linkUser\"/>\n    <doTry>\n      <bean method=\"update(${body})\" ref=\"uwfAdapter\"/>\n      <setBody>\n        <simple>${body.getResult.getKey}</simple>\n      </setBody>\n      <to uri=\"direct:linkPort\"/>\n      <doCatch>        \n        <exception>java.lang.RuntimeException</exception>\n        <handled>\n          <constant>false</constant>\n        </handled>\n        <to uri=\"direct:linkPort\"/>\n      </doCatch>\n    </doTry>            \n  </route>')),
('activateUser', 'USER', STRINGDECODE('<route id=\"activateUser\">\n    <from uri=\"direct:activateUser\"/>\n    <doTry>\n      <bean method=\"activate(${body}, ${property.token})\" ref=\"uwfAdapter\"/>\n      <to uri=\"direct:userStatusPropagation\"/>\n      <doCatch>        \n        <exception>java.lang.RuntimeException</exception>\n        <handled>\n          <constant>false</constant>\n        </handled>\n        <to uri=\"direct:statusPort\"/>\n      </doCatch>\n    </doTry>    \n  </route>'));      
INSERT INTO PUBLIC.CAMELROUTE(ID, ANYTYPEKIND, CONTENT) VALUES
('reactivateUser', 'USER', STRINGDECODE('<route id=\"reactivateUser\">\n    <from uri=\"direct:reactivateUser\"/>\n    <doTry>\n      <bean method=\"reactivate(${body})\" ref=\"uwfAdapter\"/>\n      <to uri=\"direct:userStatusPropagation\"/>\n      <doCatch>        \n        <exception>java.lang.RuntimeException</exception>\n        <handled>\n          <constant>false</constant>\n        </handled>\n        <to uri=\"direct:statusPort\"/>\n      </doCatch>\n    </doTry>    \n  </route>')),
('suspendUser', 'USER', STRINGDECODE('<route id=\"suspendUser\">\n    <from uri=\"direct:suspendUser\"/>\n    <doTry>\n      <bean method=\"suspend(${body})\" ref=\"uwfAdapter\"/>\n      <to uri=\"direct:userStatusPropagation\"/>\n      <doCatch>        \n        <exception>java.lang.RuntimeException</exception>\n        <handled>\n          <constant>false</constant>\n        </handled>\n        <to uri=\"direct:statusPort\"/>\n      </doCatch>\n    </doTry>  \n  </route>')),
('userStatusPropagation', 'USER', STRINGDECODE('<route id=\"userStatusPropagation\">\n    <from uri=\"direct:userStatusPropagation\"/>            \n    <to uri=\"propagate:status?anyTypeKind=USER\"/>\n    <to uri=\"direct:statusPort\"/> \n  </route>')),
('provisionUser', 'USER', STRINGDECODE('<route id=\"provisionUser\">\n    <from uri=\"direct:provisionUser\"/>            \n    <to uri=\"propagate:provision?anyTypeKind=USER\"/>\n    <to uri=\"direct:provisionPort\"/>              \n  </route>')),
('deprovisionUser', 'USER', STRINGDECODE('<route id=\"deprovisionUser\">\n    <from uri=\"direct:deprovisionUser\"/>            \n    <to uri=\"propagate:deprovision?anyTypeKind=USER\"/>\n    <to uri=\"direct:deprovisionPort\"/>              \n  </route>')),
('internalSuspendUser', 'USER', STRINGDECODE('<route id=\"internalSuspendUser\">\n    <from uri=\"direct:internalSuspendUser\"/>\n    <doTry>\n      <bean method=\"internalSuspend(${body})\" ref=\"uwfAdapter\"/>\n      <to uri=\"propagate:suspend?anyTypeKind=USER\"/>\n      <to uri=\"direct:internalSuspendUserPort\"/>\n      <doCatch>        \n        <exception>java.lang.RuntimeException</exception>\n        <handled>\n          <constant>false</constant>\n        </handled>\n        <to uri=\"direct:internalSuspendUserPort\"/>\n      </doCatch>\n    </doTry>  \n  </route>')),
('requestPwdReset', 'USER', STRINGDECODE('<route id=\"requestPwdReset\">\n    <from uri=\"direct:requestPwdReset\"/>\n    <doTry>\n      <bean method=\"requestPasswordReset(${body})\" ref=\"uwfAdapter\"/>\n      <to uri=\"direct:requestPwdResetPort\"/>\n      <doCatch>        \n        <exception>java.lang.RuntimeException</exception>\n        <handled>\n          <constant>false</constant>\n        </handled>\n        <to uri=\"direct:requestPwdResetPort\"/>\n      </doCatch>\n    </doTry>  \n  </route>')),
('confirmPwdReset', 'USER', STRINGDECODE('<route id=\"confirmPwdReset\">\n    <from uri=\"direct:confirmPwdReset\"/>\n    <doTry>\n      <bean method=\"confirmPasswordReset(${property.key},${property.token},${property.password})\" ref=\"uwfAdapter\"/>\n      <to uri=\"propagate:confirmPasswordReset?anyTypeKind=USER\"/>\n      <to uri=\"direct:confirmPwdResetPort\"/>\n      <doCatch>        \n        <exception>java.lang.RuntimeException</exception>\n        <handled>\n          <constant>false</constant>\n        </handled>\n        <to uri=\"direct:confirmPwdResetPort\"/>\n      </doCatch>\n    </doTry>\n  </route>')),
('createGroup', 'GROUP', STRINGDECODE('<route id=\"createGroup\">\n    <from uri=\"direct:createGroup\"/>\n    <setProperty propertyName=\"actual\">\n      <simple>${body}</simple>\n    </setProperty>\n    <doTry>\n      <bean method=\"create(${body})\" ref=\"gwfAdapter\"/>\n      <to uri=\"propagate:create?anyTypeKind=GROUP\"/>\n      <to uri=\"direct:createGroupPort\"/>\n      <doCatch>        \n        <exception>java.lang.RuntimeException</exception>\n        <handled>\n          <constant>false</constant>\n        </handled>\n        <to uri=\"direct:createGroupPort\"/>\n      </doCatch>\n    </doTry>\n  </route>'));
INSERT INTO PUBLIC.CAMELROUTE(ID, ANYTYPEKIND, CONTENT) VALUES
('createGroupPull', 'GROUP', STRINGDECODE('<route id=\"createGroupPull\">\n    <from uri=\"direct:createGroupInPull\"/>\n    <setProperty propertyName=\"actual\">\n      <simple>${body}</simple>\n    </setProperty>\n    <doTry>\n      <bean method=\"create(${body})\" ref=\"gwfAdapter\"/>\n      <to uri=\"propagate:create?anyTypeKind=GROUP&amp;pull=true\"/>\n      <to uri=\"direct:createGroupInPullPort\"/>\n      <doCatch>        \n        <exception>java.lang.RuntimeException</exception>\n        <handled>\n          <constant>false</constant>\n        </handled>\n        <to uri=\"direct:createGroupInPullPort\"/>\n      </doCatch>\n    </doTry>\n  </route>')),
('updateGroup', 'GROUP', STRINGDECODE('<route id=\"updateGroup\">\n    <from uri=\"direct:updateGroup\"/>\n    <setProperty propertyName=\"actual\">\n      <simple>${body}</simple>\n    </setProperty>\n    <doTry>\n      <bean method=\"update(${body})\" ref=\"gwfAdapter\"/>\n      <to uri=\"propagate:update?anyTypeKind=GROUP\"/>\n      <to uri=\"direct:updateGroupPort\"/>\n      <doCatch>        \n        <exception>java.lang.RuntimeException</exception>\n        <handled>\n          <constant>false</constant>\n        </handled>\n        <to uri=\"direct:updateGroupPort\"/>\n      </doCatch>\n    </doTry>\n  </route>')),
('deleteGroup', 'GROUP', STRINGDECODE('<route id=\"deleteGroup\">\n    <from uri=\"direct:deleteGroup\"/>\n    <doTry>\n      <to uri=\"propagate:delete?anyTypeKind=GROUP\"/>\n      <bean method=\"delete(${body})\" ref=\"gwfAdapter\"/>\n      <setBody>\n        <simple>${property.statuses}</simple>\n      </setBody>\n      <to uri=\"direct:deleteGroupPort\"/>\n      <doCatch>        \n        <exception>java.lang.RuntimeException</exception>\n        <handled>\n          <constant>false</constant>\n        </handled>\n        <to uri=\"direct:deleteGroupPort\"/>\n      </doCatch>\n    </doTry>\n  </route>')),
('unlinkGroup', 'GROUP', STRINGDECODE('<route id=\"unlinkGroup\">\n    <from uri=\"direct:unlinkGroup\"/>\n    <doTry>\n      <bean method=\"update(${body})\" ref=\"gwfAdapter\"/>\n      <setBody>\n        <simple>${body.getResult}</simple>\n      </setBody>\n      <to uri=\"direct:unlinkGroupPort\"/>\n      <doCatch>        \n        <exception>java.lang.RuntimeException</exception>\n        <handled>\n          <constant>false</constant>\n        </handled>\n        <to uri=\"direct:unlinkGroupPort\"/>\n      </doCatch>\n    </doTry>            \n  </route>')),
('linkGroup', 'GROUP', STRINGDECODE('<route id=\"linkGroup\">\n    <from uri=\"direct:linkGroup\"/>\n    <doTry>\n      <bean method=\"update(${body})\" ref=\"gwfAdapter\"/>\n      <setBody>\n        <simple>${body.getResult}</simple>\n      </setBody>\n      <to uri=\"direct:linkGroupPort\"/>\n      <doCatch>        \n        <exception>java.lang.RuntimeException</exception>\n        <handled>\n          <constant>false</constant>\n        </handled>\n        <to uri=\"direct:linkGroupPort\"/>\n      </doCatch>\n    </doTry>            \n  </route>')),
('provisionGroup', 'GROUP', STRINGDECODE('<route id=\"provisionGroup\">\n    <from uri=\"direct:provisionGroup\"/>            \n    <to uri=\"propagate:provision?anyTypeKind=GROUP\"/>\n    <to uri=\"direct:provisionGroupPort\"/>              \n  </route>')),
('deprovisionGroup', 'GROUP', STRINGDECODE('<route id=\"deprovisionGroup\">\n    <from uri=\"direct:deprovisionGroup\"/>            \n    <to uri=\"propagate:deprovision?anyTypeKind=GROUP\"/>\n    <to uri=\"direct:deprovisionGroupPort\"/>              \n  </route>')),
('createAnyObject', 'ANY_OBJECT', STRINGDECODE('<route id=\"createAnyObject\">\n    <from uri=\"direct:createAnyObject\"/>\n    <setProperty propertyName=\"actual\">\n      <simple>${body}</simple>\n    </setProperty>\n    <doTry>\n      <bean method=\"create(${body})\" ref=\"awfAdapter\"/>\n      <to uri=\"propagate:create?anyTypeKind=ANY_OBJECT\"/>\n      <to uri=\"direct:createAnyObjectPort\"/>\n      <doCatch>        \n        <exception>java.lang.RuntimeException</exception>\n        <handled>\n          <constant>false</constant>\n        </handled>\n        <to uri=\"direct:createAnyObjectPort\"/>\n      </doCatch>\n    </doTry>\n  </route>'));      
INSERT INTO PUBLIC.CAMELROUTE(ID, ANYTYPEKIND, CONTENT) VALUES
('updateAnyObject', 'ANY_OBJECT', STRINGDECODE('<route id=\"updateAnyObject\">\n    <from uri=\"direct:updateAnyObject\"/>\n    <setProperty propertyName=\"actual\">\n      <simple>${body}</simple>\n    </setProperty>\n    <doTry>\n      <bean method=\"update(${body})\" ref=\"awfAdapter\"/>\n      <to uri=\"propagate:update?anyTypeKind=ANY_OBJECT\"/>\n      <to uri=\"direct:updateAnyObjectPort\"/>\n      <doCatch>        \n        <exception>java.lang.RuntimeException</exception>\n        <handled>\n          <constant>false</constant>\n        </handled>\n        <to uri=\"direct:updateAnyObjectPort\"/>\n      </doCatch>\n    </doTry>\n  </route>')),
('deleteAnyObject', 'ANY_OBJECT', STRINGDECODE('<route id=\"deleteAnyObject\">\n    <from uri=\"direct:deleteAnyObject\"/>\n    <doTry>\n      <to uri=\"propagate:delete?anyTypeKind=ANY_OBJECT\"/>\n      <bean method=\"delete(${body})\" ref=\"awfAdapter\"/>\n      <setBody>\n        <simple>${property.statuses}</simple>\n      </setBody>\n      <to uri=\"direct:deleteAnyObjectPort\"/>\n      <doCatch>        \n        <exception>java.lang.RuntimeException</exception>\n        <handled>\n          <constant>false</constant>\n        </handled>\n        <to uri=\"direct:deleteAnyObjectPort\"/>\n      </doCatch>\n    </doTry>\n  </route>')),
('unlinkAnyObject', 'ANY_OBJECT', STRINGDECODE('<route id=\"unlinkAnyObject\">\n    <from uri=\"direct:unlinkAnyObject\"/>\n    <doTry>\n      <bean method=\"update(${body})\" ref=\"awfAdapter\"/>\n      <setBody>\n        <simple>${body.getResult}</simple>\n      </setBody>\n      <to uri=\"direct:unlinkAnyObjectPort\"/>\n      <doCatch>        \n        <exception>java.lang.RuntimeException</exception>\n        <handled>\n          <constant>false</constant>\n        </handled>\n        <to uri=\"direct:unlinkAnyObjectPort\"/>\n      </doCatch>\n    </doTry>            \n  </route>')),
('linkAnyObject', 'ANY_OBJECT', STRINGDECODE('<route id=\"linkAnyObject\">\n    <from uri=\"direct:linkAnyObject\"/>\n    <doTry>\n      <bean method=\"update(${body})\" ref=\"awfAdapter\"/>\n      <setBody>\n        <simple>${body.getResult}</simple>\n      </setBody>\n      <to uri=\"direct:linkAnyObjectPort\"/>\n      <doCatch>        \n        <exception>java.lang.RuntimeException</exception>\n        <handled>\n          <constant>false</constant>\n        </handled>\n        <to uri=\"direct:linkAnyObjectPort\"/>\n      </doCatch>\n    </doTry>            \n  </route>')),
('provisionAnyObject', 'ANY_OBJECT', STRINGDECODE('<route id=\"provisionAnyObject\">\n    <from uri=\"direct:provisionAnyObject\"/>            \n    <to uri=\"propagate:provision?anyTypeKind=ANY_OBJECT\"/>\n    <to uri=\"direct:provisionAnyObjectPort\"/>              \n  </route>')),
('deprovisionAnyObject', 'ANY_OBJECT', STRINGDECODE('<route id=\"deprovisionAnyObject\">\n    <from uri=\"direct:deprovisionAnyObject\"/>            \n    <to uri=\"propagate:deprovision?anyTypeKind=ANY_OBJECT\"/>\n    <to uri=\"direct:deprovisionAnyObjectPort\"/>              \n  </route>'));      
CREATE MEMORY TABLE PUBLIC.CONNINSTANCE(
    ID VARCHAR(36) NOT NULL,
    BUNDLENAME VARCHAR(255),
    CONNREQUESTTIMEOUT INTEGER,
    CONNECTORNAME VARCHAR(255),
    DISPLAYNAME VARCHAR(255),
    JSONCONF CLOB,
    LOCATION VARCHAR(255),
    VERSION VARCHAR(255),
    ADMINREALM_ID VARCHAR(36),
    MAXIDLE INTEGER,
    MAXOBJECTS INTEGER,
    MAXWAIT BIGINT,
    MINEVICTABLEIDLETIMEMILLIS BIGINT,
    MINIDLE INTEGER
);         
ALTER TABLE PUBLIC.CONNINSTANCE ADD CONSTRAINT PUBLIC.CONSTRAINT_E PRIMARY KEY(ID);            
-- 10 +/- SELECT COUNT(*) FROM PUBLIC.CONNINSTANCE;            
INSERT INTO PUBLIC.CONNINSTANCE(ID, BUNDLENAME, CONNREQUESTTIMEOUT, CONNECTORNAME, DISPLAYNAME, JSONCONF, LOCATION, VERSION, ADMINREALM_ID, MAXIDLE, MAXOBJECTS, MAXWAIT, MINEVICTABLEIDLETIMEMILLIS, MINIDLE) VALUES
('88a7a819-dab5-46b4-9b90-0b9769eabdb8', 'net.tirasa.connid.bundles.soap', NULL, 'net.tirasa.connid.bundles.soap.WebServiceConnector', 'ConnInstance100', '[{"schema":{"name":"endpoint","displayName":null,"helpMessage":null,"type":"java.lang.String","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["http://localhost:9080/syncope-fit-build-tools/cxf/soap/provisioning"]},{"schema":{"name":"servicename","displayName":null,"helpMessage":null,"type":"java.lang.String","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["net.tirasa.connid.bundles.soap.provisioning.interfaces.Provisioning"]}]', 'file:/home/ilgrosso/work/syncope/syncope2/fit/core-reference/target/bundles/', '1.4.1', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL, NULL, NULL, NULL, NULL),
('5aa5b8be-7521-481a-9651-c557aea078c1', 'net.tirasa.connid.bundles.db.table', NULL, 'net.tirasa.connid.bundles.db.table.DatabaseTableConnector', 'H2', '[{"schema":{"name":"disabledStatusValue","displayName":null,"helpMessage":null,"type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["false"]},{"schema":{"name":"user","displayName":null,"helpMessage":null,"type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["sa"]},{"schema":{"name":"keyColumn","displayName":null,"helpMessage":null,"type":"java.lang.String","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["id"]},{"schema":{"name":"retrievePassword","displayName":null,"helpMessage":null,"type":"boolean","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["true"]},{"schema":{"name":"cipherAlgorithm","displayName":null,"helpMessage":null,"type":"java.lang.String","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["SHA1"]},{"schema":{"name":"enabledStatusValue","displayName":null,"helpMessage":null,"type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["true"]},{"schema":{"name":"passwordColumn","displayName":null,"helpMessage":null,"type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["password"]},{"schema":{"name":"jdbcDriver","displayName":null,"helpMessage":null,"type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["org.h2.Driver"]},{"schema":{"name":"defaultStatusValue","displayName":null,"helpMessage":null,"type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["true"]},{"schema":{"name":"table","displayName":null,"helpMessage":null,"type":"java.lang.String","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["test"]},{"schema":{"name":"password","displayName":null,"helpMessage":null,"type":"org.identityconnectors.common.security.GuardedString","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["sa"]},{"schema":{"name":"statusColumn","displayName":null,"helpMessage":null,"type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["status"]},{"schema":{"name":"jdbcUrlTemplate","displayName":null,"helpMessage":null,"type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["jdbc:h2:tcp://localhost:9092/mem:testdb;DB_CLOSE_DELAY=-1"]}]', 'connid://testconnectorserver@localhost:4554', '2.2.5', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL, NULL, NULL, NULL, NULL);        
INSERT INTO PUBLIC.CONNINSTANCE(ID, BUNDLENAME, CONNREQUESTTIMEOUT, CONNECTORNAME, DISPLAYNAME, JSONCONF, LOCATION, VERSION, ADMINREALM_ID, MAXIDLE, MAXOBJECTS, MAXWAIT, MINEVICTABLEIDLETIMEMILLIS, MINIDLE) VALUES
('5ffbb4ac-a8c3-4b44-b699-11b398a1ba08', 'net.tirasa.connid.bundles.soap', 10, 'net.tirasa.connid.bundles.soap.WebServiceConnector', 'ConnInstance102', '[{"schema":{"name":"servicename","displayName":null,"helpMessage":null,"type":"java.lang.String","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["net.tirasa.connid.bundles.soap.provisioning.interfaces.Provisioning"]},{"schema":{"name":"endpoint","displayName":null,"helpMessage":null,"type":"java.lang.String","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":true,"values":["http://localhost:9080/syncope-fit-build-tools/cxf/soap/provisioning"]}]', 'file:/home/ilgrosso/work/syncope/syncope2/fit/core-reference/target/bundles/', '1.4.1', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL, NULL, NULL, NULL, NULL),
('fcf9f2b0-f7d6-42c9-84a6-61b28255a42b', 'net.tirasa.connid.bundles.soap', NULL, 'net.tirasa.connid.bundles.soap.WebServiceConnector', 'ConnInstance103', '[{"schema":{"name":"endpoint","displayName":null,"helpMessage":null,"type":"java.lang.String","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["http://localhost:9080/syncope-fit-build-tools/cxf/soap/provisioning"]},{"schema":{"name":"servicename","displayName":null,"helpMessage":null,"type":"java.lang.String","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["net.tirasa.connid.bundles.soap.provisioning.interfaces.Provisioning"]}]', 'file:/home/ilgrosso/work/syncope/syncope2/fit/core-reference/target/bundles/', '1.4.1', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL, NULL, NULL, NULL, NULL),
('6c2acf1b-b052-46f0-8c56-7a8ad6905edf', 'net.tirasa.connid.bundles.csvdir', NULL, 'net.tirasa.connid.bundles.csvdir.CSVDirConnector', 'CSVDir', '[{"schema":{"name":"fields","displayName":"fields","helpMessage":"Column names separated by comma","type":"[Ljava.lang.String;","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["id","name","surname","email","password","theirgroup","membership","status","deleted"]},{"schema":{"name":"keyColumnNames","displayName":"Key column name","helpMessage":"Name of the column used to identify user uniquely","type":"[Ljava.lang.String;","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["name","surname"]},{"schema":{"name":"deleteColumnName","displayName":"Delete column name","helpMessage":"Name of the column used to specify users to be deleted","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["deleted"]},{"schema":{"name":"passwordColumnName","displayName":"Password column name","helpMessage":"Name of the column used to specify user password","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["password"]},{"schema":{"name":"keyseparator","displayName":"Key separator","helpMessage":"Character used to separate keys in a multi-key scenario","type":"java.lang.String","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":[","]},{"schema":{"name":"ignoreHeader","displayName":"Ignore header","helpMessage":"Specify it first line file must be ignored","type":"java.lang.Boolean","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":[false]},{"schema":{"name":"fieldDelimiter","displayName":"fieldDelimiter","helpMessage":"fieldDelimiter","type":"char","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":[","]},{"schema":{"name":"quotationRequired","displayName":"Value quotation required","helpMessage":"Specify if value quotation is required","type":"java.lang.Boolean","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":[false]},{"schema":{"name":"statusColumn","displayName":"statusColumn","helpMessage":"Status column","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["status"]},{"schema":{"name":"sourcePath","displayName":"Source path","helpMessage":"Absolute path of a directory where are located CSV files to be processed","type":"java.lang.String","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["/home/ilgrosso/work/syncope/syncope2/fit/core-reference/target/test-csvdir"]},{"schema":{"name":"fileMask","displayName":"File mask","helpMessage":"Regular expression describing files to be processed","type":"java.lang.String","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["test.csv"]}]', 'file:/home/ilgrosso/work/syncope/syncope2/fit/core-reference/target/bundles/', '0.8.7', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL, NULL, NULL, NULL, NULL);        
CREATE TABLE IF NOT EXISTS SYSTEM_LOB_STREAM(ID INT NOT NULL, PART INT NOT NULL, CDATA VARCHAR, BDATA BINARY); 
CREATE PRIMARY KEY SYSTEM_LOB_STREAM_PRIMARY_KEY ON SYSTEM_LOB_STREAM(ID, PART);               
CREATE ALIAS IF NOT EXISTS SYSTEM_COMBINE_CLOB FOR "org.h2.command.dml.ScriptCommand.combineClob";             
CREATE ALIAS IF NOT EXISTS SYSTEM_COMBINE_BLOB FOR "org.h2.command.dml.ScriptCommand.combineBlob";             
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 0, '[{"schema":{"name":"synchronizePasswords","displayName":"Enable Password Synchronization","helpMessage":"If true, the connector will synchronize passwords. The Password Capture Plugin needs to be installed for password synchronization to work.","type":"boolean","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["false"]},{"schema":{"name":"maintainLdapGroupMembership","displayName":"Maintain LDAP Group Membership","helpMessage":"When enabled and a user is renamed or deleted, update any LDAP groups to which the user belongs to reflect the new name. Otherwise, the LDAP resource must maintain referential integrity with respect to group membership.","type":"boolean","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["true"]},{"schema":{"name":"host","displayName":"Host","helpMessage":"The name or IP address of the host where the LDAP server is running.","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["localhost"]},{"schema":{"name":"passwordHashAlgorithm","displayName":"Password Hash Algorithm","helpMessage":"Indicates the algorithm that the Identity system should use to hash the password. Currently supported values are SSHA, SHA, SSHA1, and SHA1. A blank value indicates that the system will not hash passwords. This will cause cleartext passwords to be stored in LDAP unless the LDAP server performs the hash (Netscape Directory Server and iPlanet Directory Server do).","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["SHA"]},{"schema":{"name":"port","displayName":"TCP Port","helpMessage":"TCP/IP port number used to communicate with the LDAP server.","type":"int","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":[1389]},{"schema":{"name":"vlvSortAttribute","displayName":"VLV Sort Attribute","helpMessage":"Specify the sort attribute to use for VLV indexes on the resource.","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"statusManagementClass","displayName":"Status management class ","helpMessage":"Class to be used to manage enabled/disabled status. If no class is specified then identity status management wont be possible.","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["net.tirasa.connid.bundles.ldap.commons.AttributeStatusManagement"]},{"schema":{"name":"accountObjectClasses","displayName":"Account Object Classes","helpMessage":"The object class or classes that will be used when creating new user objects in the LDAP tree. When entering more than one object class, each entry should be on its own line; do not use commas or semi-colons to separate multiple object classes. Some object classes may require that you specify all object classes in the class hierarchy.","type":"[Ljava.lang.String;","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["inetOrgPerson"]},{"schema":{"name":"accountUserNameAttributes","displayName":"Account User Name Attributes","helpMessage":"Attribute or attributes which holds the account user name. They will be used when authenticating to find the LDAP entry for the user name to authenticate.","type":"[Ljava.lang.String;","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["uid"]},{"schema":{"name":"baseContextsToSynchronize","displayName":"Base Contexts to Synchronize","helpMessage":"One or more starting points in the LDAP tree that will be used to determine if a change should be synchronized. The base contexts attribute will be used to synchronize a change if this property is not set.","type":"[Ljava.lang.String;","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["ou=people,o=isp","ou=grou', NULL);          
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 1, 'ps,o=isp"]},{"schema":{"name":"accountSynchronizationFilter","displayName":"LDAP Filter for Accounts to Synchronize","helpMessage":"An optional LDAP filter for the objects to synchronize. Because the change log is for all objects, this filter updates only objects that match the specified filter. If you specify a filter, an object will be synchronized only if it matches the filter and includes a synchronized object class.","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"removeLogEntryObjectClassFromFilter","displayName":"Remove Log Entry Object Class from Filter","helpMessage":"If this property is set (the default), the filter used to fetch change log entries does not contain the \"changeLogEntry\" object class, expecting that there are no entries of other object types in the change log.","type":"boolean","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["false"]},{"schema":{"name":"passwordDecryptionKey","displayName":"Password Decryption Key","helpMessage":"The key to decrypt passwords with when performing password synchronization.","type":"org.identityconnectors.common.security.GuardedByteArray","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"readSchema","displayName":"Read Schema","helpMessage":"If true, the connector will read the schema from the server. If false, the connector will provide a default schema based on the object classes in the configuration. This property must be true in order to use extended object classes.","type":"boolean","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["true"]},{"schema":{"name":"ssl","displayName":"SSL","helpMessage":"Select the check box to connect to the LDAP server using SSL.","type":"boolean","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["false"]},{"schema":{"name":"passwordAttributeToSynchronize","displayName":"Password Attribute to Synchronize","helpMessage":"The name of the password attribute to synchronize when performing password synchronization.","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"accountSearchFilter","displayName":"LDAP Filter for Retrieving Accounts","helpMessage":"An optional LDAP filter to control which accounts are returned from the LDAP resource. If no filter is specified, only accounts that include all specified object classes are returned.","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["uid=*"]},{"schema":{"name":"passwordDecryptionInitializationVector","displayName":"Password Decryption Initialization Vector","helpMessage":"The initialization vector to decrypt passwords with when performing password synchronization.","type":"org.identityconnectors.common.security.GuardedByteArray","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"groupMemberAttribute","displayName":"Group Member Attribute","helpMessage":"The name of the group attribute that will be updated with the distinguished name of the user when the user is added to the group.","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"failover","displayName":"Failover Servers","helpMessage":"List all servers that should be used for failover in case the preferred server fails. If the preferred server fails, JNDI will connect to the next available server in the list. List all servers in the form of \"ldap://ldap.example.com:389/\", which follows the standard LDAP v3 URLs described in RFC 2255. Only the host and port parts of the URL are relevant in this setting.","type":"[Ljava.lang.String;","required":false,"order":0,"confidential":fals', NULL);          
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 2, 'e,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"modifiersNamesToFilterOut","displayName":"Filter Out Changes By","helpMessage":"The names (DNs) of directory administrators to filter from the changes. Changes with the attribute \"modifiersName\" that match entries in this list will be filtered out. The standard value is the administrator name used by this adapter, to prevent loops. Entries should be of the format \"cn=Directory Manager\".","type":"[Ljava.lang.String;","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"groupNameAttributes","displayName":"Group Name Attributes","helpMessage":"Attribute or attributes which holds the group name.","type":"[Ljava.lang.String;","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["cn"]},{"schema":{"name":"uidAttribute","displayName":"Uid Attribute","helpMessage":"The name of the LDAP attribute which is mapped to the Uid attribute.","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":true,"values":["cn"]},{"schema":{"name":"gidAttribute","displayName":"Uid Attribute for groups","helpMessage":"The name of the LDAP attribute which is mapped to the Uid attribute for groups.","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":true,"values":["cn"]},{"schema":{"name":"respectResourcePasswordPolicyChangeAfterReset","displayName":"Respect Resource Password Policy Change-After-Reset","helpMessage":"When this resource is specified in a Login Module (i.e., this resource is a pass-through authentication target) and the resource password policy is configured for change-after-reset, a user whose resource account password has been administratively reset will be required to change that password after successfully authenticating.","type":"boolean","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["false"]},{"schema":{"name":"filterWithOrInsteadOfAnd","displayName":"Filter with Or Instead of And","helpMessage":"Normally the the filter used to fetch change log entries is an and-based filter retrieving an interval of change entries. If this property is set, the filter will or together the required change numbers instead.","type":"boolean","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["false"]},{"schema":{"name":"principal","displayName":"Principal","helpMessage":"The distinguished name with which to authenticate to the LDAP server.","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["uid=admin,ou=system"]},{"schema":{"name":"changeLogBlockSize","displayName":"Change Log Block Size","helpMessage":"The number of change log entries to fetch per query.","type":"int","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":[100]},{"schema":{"name":"baseContexts","displayName":"Base Contexts","helpMessage":"One or more starting points in the LDAP tree that will be used when searching the tree. Searches are performed when discovering users from the LDAP server or when looking for the groups of which a user is a member.","type":"[Ljava.lang.String;","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":true,"values":["ou=people,o=isp","ou=groups,o=isp"]},{"schema":{"name":"passwordAttribute","displayName":"Password Attribute","helpMessage":"The name of the LDAP attribute which holds the password. When changing an user password, the new password is set to this attribute.","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["userpassword"]},{"schema":{"name":"changeNumberAttribute","displayName":"Change Number Attribute","helpMessage":"The name of the change number attribute in the change log entry.","type":"java.lang.String","requir', NULL);          
INSERT INTO SYSTEM_LOB_STREAM VALUES(0, 3, 'ed":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["changeNumber"]},{"schema":{"name":"objectClassesToSynchronize","displayName":"Object Classes to Synchronize","helpMessage":"The object classes to synchronize. The change log is for all objects; this filters updates to just the listed object classes. You should not list the superclasses of an object class unless you intend to synchronize objects with any of the superclass values. For example, if only \"inetOrgPerson\" objects should be synchronized, but the superclasses of \"inetOrgPerson\" (\"person\", \"organizationalperson\" and \"top\") should be filtered out, then list only \"inetOrgPerson\" here. All objects in LDAP are subclassed from \"top\". For this reason, you should never list \"top\", otherwise no object would be filtered.","type":"[Ljava.lang.String;","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["inetOrgPerson","groupOfUniqueNames"]},{"schema":{"name":"credentials","displayName":"Password","helpMessage":"Password for the principal.","type":"org.identityconnectors.common.security.GuardedString","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["secret"]},{"schema":{"name":"attributesToSynchronize","displayName":"Attributes to Synchronize","helpMessage":"The names of the attributes to synchronize. This ignores updates from the change log if they do not update any of the named attributes. For example, if only \"department\" is listed, then only changes that affect \"department\" will be processed. All other updates are ignored. If blank (the default), then all changes are processed.","type":"[Ljava.lang.String;","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"maintainPosixGroupMembership","displayName":"Maintain POSIX Group Membership","helpMessage":"When enabled and a user is renamed or deleted, update any POSIX groups to which the user belongs to reflect the new name. Otherwise, the LDAP resource must maintain referential integrity with respect to group membership.","type":"boolean","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["false"]}]', NULL);     
INSERT INTO SYSTEM_LOB_STREAM VALUES(1, 0, '[{"schema":{"name":"changeLogColumn","displayName":"Change Log Column (Sync)","helpMessage":"=<b>Change Log Column</b><br>The change log column store the latest change time. Providing this value the Pull capabilities are activated.","type":"java.lang.String","required":false,"order":21,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"nativeTimestamps","displayName":"Native Timestamps ","helpMessage":"<b>Native Timestamps</b><br>Select to retrieve Timestamp data type of the columns in java.sql.Timestamp format from the database table.","type":"boolean","required":false,"order":18,"confidential":false,"defaultValues":null},"overridable":false,"values":["false"]},{"schema":{"name":"cipherAlgorithm","displayName":"Password cipher algorithm (defaults to CLEARTEXT)","helpMessage":"Cipher algorithm used to encode password before to store it onto the database table.\nSpecify one of the values among CLEARTEXT,AES, MD5, SHA1, SHA256 or a custom implementation identified by its class name.","type":"java.lang.String","required":false,"order":24,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"enabledStatusValue","displayName":"Enabled Status Value","helpMessage":"<b>Enabled Status Value</b><br>Enter the value for enabled status.","type":"java.lang.String","required":false,"order":12,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"retrievePassword","displayName":"Retrieve password","helpMessage":"Specify if password must be retrieved by default.","type":"boolean","required":true,"order":27,"confidential":false,"defaultValues":null},"overridable":false,"values":["false"]},{"schema":{"name":"datasource","displayName":"Datasource Path","helpMessage":"<b>JDBC Data Source Name/Path</b><br>Enter the JDBC Data Source Name/Path to connect to the Oracle server. If specified, connector will only try to connect using Datasource and ignore other resource parameters specified.<br>the example value is: <CODE>jdbc/SampleDataSourceName</CODE>","type":"java.lang.String","required":false,"order":22,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"allNative","displayName":"All native","helpMessage":"<b>All native</b><br>Select to retrieve all data type of the columns in a native format from the database table.","type":"boolean","required":false,"order":19,"confidential":false,"defaultValues":null},"overridable":false,"values":["false"]},{"schema":{"name":"user","displayName":"User","helpMessage":"<b>User</b><br>Enter the name of the mandatory Database user with permission to account table.","type":"java.lang.String","required":false,"order":4,"confidential":false,"defaultValues":null},"overridable":false,"values":["sa"]},{"schema":{"name":"pwdEncodeToLowerCase","displayName":"Force password encoding to lower case","helpMessage":"Force password encoding to lower case.","type":"boolean","required":false,"order":26,"confidential":false,"defaultValues":null},"overridable":false,"values":["false"]},{"schema":{"name":"jdbcUrlTemplate","displayName":"JDBC Connection URL","helpMessage":"<b>JDBC Connection URL</b><br>Specify the JDBC Driver Connection URL.<br> Oracle template is jdbc:oracle:thin:@[host]:[port(1521)]:[DB].<br>  MySQL template is jdbc:mysql://[host]:[port(3306)]/[db], for more info, read the JDBC driver documentation.<br>Could be empty if datasource is provided.","type":"java.lang.String","required":false,"order":15,"confidential":false,"defaultValues":null},"overridable":false,"values":["jdbc:h2:tcp://localhost:9092/mem:testdb;DB_CLOSE_DELAY=-1"]},{"schema":{"name":"keyColumn","displayName":"Key Column","helpMessage":"<b>Key Column</b><br>This mandatory column value will be used as the unique identifier for rows in the table.<br>","type":"java.lang.String","required":true,"order":8,"confidential":false,"defaultValues":null},"overridable":false,"values":["id"]},{"schema":{"name":"validConnectionQuery","displayName":"Validate Connection Query","helpMessage":"<b>Vali', NULL);          
INSERT INTO SYSTEM_LOB_STREAM VALUES(1, 1, 'date Connection Query</b><br>There can be specified the check connection alive query. If empty, default implementation will test it using the switch on/off the autocommit. Some select 1 from dummy table could be more efficient.","type":"java.lang.String","required":false,"order":20,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"rethrowAllSQLExceptions","displayName":"Rethrow all SQLExceptions","helpMessage":"If this is not checked, SQL statements which throw SQLExceptions with a 0 ErrorCode will be have the exception caught and suppressed. Check it to have exceptions with 0 ErrorCodes rethrown.","type":"boolean","required":false,"order":17,"confidential":false,"defaultValues":null},"overridable":false,"values":["false"]},{"schema":{"name":"passwordColumn","displayName":"Password Column","helpMessage":"<b>Password Column</b><br>Enter the name of the column in the table that will hold the password values. If empty, no validation on resource and passwords are activated.","type":"java.lang.String","required":false,"order":9,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"jndiProperties","displayName":"Initial JNDI Properties","helpMessage":"<b>Initial JNDI Properties</b><br>Could be empty or enter the JDBC JNDI Initial context factory, context provider in a format: key = value.","type":"[Ljava.lang.String;","required":false,"order":23,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"password","displayName":"User Password","helpMessage":"<b>User Password</b><br>Enter a user account that has permission to access accounts table.","type":"org.identityconnectors.common.security.GuardedString","required":false,"order":5,"confidential":true,"defaultValues":null},"overridable":false,"values":["sa"]},{"schema":{"name":"host","displayName":"Host","helpMessage":"<b>Host</b><br>Enter the name of the host where the database is running.","type":"java.lang.String","required":false,"order":2,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"port","displayName":"Port","helpMessage":"<b>TCP Port</b><br>Enter the port number the database server is listening on.","type":"java.lang.String","required":false,"order":3,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"statusColumn","displayName":"Status Column","helpMessage":"<b>Status Column</b><br>Enter the name of the column in the table that will hold the status values. If empty enabled and disabled operation wont be performed.","type":"java.lang.String","required":false,"order":10,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"pwdEncodeToUpperCase","displayName":"Force password encoding to upper case","helpMessage":"Force password encoding to upper case.","type":"boolean","required":false,"order":25,"confidential":false,"defaultValues":null},"overridable":false,"values":["false"]},{"schema":{"name":"enableEmptyString","displayName":"Enable writing empty string","helpMessage":"<b>Enable writing empty string</b><br>Select to enable support for writing an empty strings, instead of a NULL value, in character based columns defined as not-null in the table schema. This option does not influence the way strings are written for Oracle based tables. By default empty strings are written as a NULL value.","type":"boolean","required":false,"order":16,"confidential":false,"defaultValues":null},"overridable":false,"values":["false"]},{"schema":{"name":"database","displayName":"Database","helpMessage":"<b>Database</b><br>Enter the name of the database on the database server that contains the table.","type":"java.lang.String","required":false,"order":6,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"defaultStatusValue","displayName":"Default Status Value","helpMessage":"<b>Default Status Value</b><br>Enter the value for status in case of status not specified.","type":"java.lang.String","re', NULL);          
INSERT INTO SYSTEM_LOB_STREAM VALUES(1, 2, 'quired":false,"order":13,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"table","displayName":"Table","helpMessage":"<b>Table</b><br>Enter the name of the table in the database that contains the accounts.","type":"java.lang.String","required":true,"order":7,"confidential":false,"defaultValues":null},"overridable":false,"values":["testpull"]},{"schema":{"name":"disabledStatusValue","displayName":"Disabled Status Value","helpMessage":"<b>Disabled Status Value</b><br>Enter the value for disabled status.","type":"java.lang.String","required":false,"order":11,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"jdbcDriver","displayName":"JDBC Driver","helpMessage":"<b>JDBC Driver</b><br>Specify the JDBC Driver class name. Oracle is oracle.jdbc.driver.OracleDriver. MySQL is org.gjt.mm.mysql.Driver.<br>Could be empty if datasource is provided.","type":"java.lang.String","required":false,"order":14,"confidential":false,"defaultValues":null},"overridable":false,"values":["org.h2.Driver"]},{"schema":{"name":"quoting","displayName":"Name Quoting","helpMessage":"<b>Name Quoting</b><br>Select whether database column names for this resource should be quoted, and the quoting characters. By default, database column names are not quoted (None). For other selections (Single, Double, Back, or Brackets), column names will appear between single quotes, double quotes, back quotes, or brackets in the SQL generated to access the database.","type":"java.lang.String","required":false,"order":1,"confidential":false,"defaultValues":null},"overridable":false,"values":[]},{"schema":{"name":"cipherKey","displayName":"Password cipher key","helpMessage":"Specify key in case of reversible algorithm.","type":"java.lang.String","required":false,"order":25,"confidential":false,"defaultValues":null},"overridable":false,"values":[]}]', NULL);               
INSERT INTO SYSTEM_LOB_STREAM VALUES(2, 0, '[{"schema":{"name":"updateScriptFileName","displayName":"updateScriptFileName","helpMessage":"updateScriptFileName","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":[]},"overridable":false,"values":["/home/ilgrosso/work/syncope/syncope2/fit/core-reference/target/test-classes/scriptedsql/UpdateScript.groovy"]},{"schema":{"name":"testScript","displayName":"testScript","helpMessage":"testScript","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":[""]},"overridable":false,"values":[]},{"schema":{"name":"host","displayName":"Host","helpMessage":"<b>Host</b><br/>Enter the name of the host where the database is running.","type":"java.lang.String","required":false,"order":2,"confidential":false,"defaultValues":["localhost"]},"overridable":false},{"schema":{"name":"port","displayName":"Port","helpMessage":"<b>TCP Port</b><br/>Enter the port number the database server is listening on.","type":"java.lang.String","required":false,"order":3,"confidential":false,"defaultValues":["3306"]},"overridable":false},{"schema":{"name":"database","displayName":"Database","helpMessage":"<b>Database</b><br/>Enter the name of the database on the database server that contains the table.","type":"java.lang.String","required":false,"order":6,"confidential":false,"defaultValues":[""]},"overridable":false},{"schema":{"name":"createScript","displayName":"createScript","helpMessage":"createScript","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":[""]},"overridable":false,"values":[]},{"schema":{"name":"jdbcUrlTemplate","displayName":"JDBC Connection URL","helpMessage":"<b>JDBC Connection URL</b><br/>Specify the JDBC Driver Connection URL.<br/> Oracle template is jdbc:oracle:thin:@[host]:[port(1521)]:[DB].<br/>  MySQL template is jdbc:mysql://[host]:[port(3306)]/[db], for more info, read the JDBC driver documentation.<br/>Could be empty if datasource is provided.","type":"java.lang.String","required":false,"order":11,"confidential":false,"defaultValues":["jdbc:mysql://%h:%p/%d"]},"overridable":false,"values":["jdbc:h2:tcp://localhost:9092/mem:testdb;DB_CLOSE_DELAY=-1"]},{"schema":{"name":"jndiProperties","displayName":"Initial JNDI Properties","helpMessage":"<b>Initial JNDI Properties</b><br/>Could be empty or enter the JDBC JNDI Initial context factory, context provider in a format: key = value.","type":"[Ljava.lang.String;","required":false,"order":21,"confidential":false,"defaultValues":[]},"overridable":false,"values":[]},{"schema":{"name":"enableEmptyString","displayName":"Enable writing empty string","helpMessage":"<b>Enable writing empty string</b><br/>Select to enable support for writing an empty strings, instead of a NULL value, in character based columns defined as not-null in the table schema. This option does not influence the way strings are written for Oracle based tables. By default empty strings are written as a NULL value.","type":"boolean","required":false,"order":12,"confidential":false,"defaultValues":[false]},"overridable":false,"values":["false"]},{"schema":{"name":"allNative","displayName":"All native","helpMessage":"<b>All native</b><br/>Select to retrieve all data type of the columns in a native format from the database table.","type":"boolean","required":false,"order":16,"confidential":false,"defaultValues":[false]},"overridable":false,"values":[false]},{"schema":{"name":"password","displayName":"User Password","helpMessage":"<b>User Password</b><br/>Enter a user account that has permission to access accounts table.","type":"org.identityconnectors.common.security.GuardedString","required":false,"order":5,"confidential":true,"defaultValues":[]},"overridable":false,"values":["sa"]},{"schema":{"name":"validConnectionQuery","displayName":"Validate Connection Query","helpMessage":"<b>Validate Connection Query</b><br/>There can be specified the check connection alive query. If empty, default implementation will test it using the switch on/off the autocommit. Some select 1 from dummy table could be more efficient.","t', NULL);          
INSERT INTO SYSTEM_LOB_STREAM VALUES(2, 1, 'ype":"java.lang.String","required":false,"order":17,"confidential":false,"defaultValues":[]},"overridable":false,"values":[]},{"schema":{"name":"reloadScriptOnExecution","displayName":"reloadScriptOnExecution","helpMessage":"reloadScriptOnExecution","type":"boolean","required":false,"order":0,"confidential":false,"defaultValues":[false]},"overridable":false,"values":["true"]},{"schema":{"name":"schemaScriptFileName","displayName":"schemaScriptFileName","helpMessage":"schemaScriptFileName","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":[]},"overridable":true,"values":["/home/ilgrosso/work/syncope/syncope2/fit/core-reference/target/test-classes/scriptedsql/SchemaScript.groovy"]},{"schema":{"name":"jdbcDriver","displayName":"JDBC Driver","helpMessage":"<b>JDBC Driver</b><br/>Specify the JDBC Driver class name. Oracle is oracle.jdbc.driver.OracleDriver. MySQL is org.gjt.mm.mysql.Driver.<br/>Could be empty if datasource is provided.","type":"java.lang.String","required":false,"order":10,"confidential":false,"defaultValues":["com.mysql.jdbc.Driver"]},"overridable":false,"values":["org.h2.Driver"]},{"schema":{"name":"testScriptFileName","displayName":"testScriptFileName","helpMessage":"testScriptFileName","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":[]},"overridable":true,"values":["/home/ilgrosso/work/syncope/syncope2/fit/core-reference/target/test-classes/scriptedsql/TestScript.groovy"]},{"schema":{"name":"quoting","displayName":"Name Quoting","helpMessage":"<b>Name Quoting</b><br/>Select whether database column names for this resource should be quoted, and the quoting characters. By default, database column names are not quoted (None). For other selections (Single, Double, Back, or Brackets), column names will appear between single quotes, double quotes, back quotes, or brackets in the SQL generated to access the database.","type":"java.lang.String","required":false,"order":-1,"confidential":false,"defaultValues":[""]},"overridable":false,"values":[]},{"schema":{"name":"createScriptFileName","displayName":"createScriptFileName","helpMessage":"createScriptFileName","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":[]},"overridable":false,"values":["/home/ilgrosso/work/syncope/syncope2/fit/core-reference/target/test-classes/scriptedsql/CreateScript.groovy"]},{"schema":{"name":"clearTextPasswordToScript","displayName":"clearTextPasswordToScript","helpMessage":"clearTextPasswordToScript","type":"boolean","required":false,"order":0,"confidential":false,"defaultValues":[true]},"overridable":false,"values":["false"]},{"schema":{"name":"nativeTimestamps","displayName":"Native Timestamps","helpMessage":"<b>Native Timestamps</b><br/>Select to retrieve Timestamp data type of the columns in java.sql.Timestamp format from the database table.","type":"boolean","required":false,"order":15,"confidential":false,"defaultValues":[false]},"overridable":false,"values":[false]},{"schema":{"name":"syncScript","displayName":"syncScript","helpMessage":"syncScript","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":[""]},"overridable":false,"values":[]},{"schema":{"name":"autoCommit","displayName":"autoCommit","helpMessage":"autoCommit","type":"boolean","required":false,"order":0,"confidential":false,"defaultValues":[true]},"overridable":false,"values":[true]},{"schema":{"name":"scriptingLanguage","displayName":"scriptingLanguage","helpMessage":"scriptingLanguage","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":["GROOVY"]},"overridable":false,"values":["GROOVY"]},{"schema":{"name":"datasource","displayName":"Datasource Path","helpMessage":"<b>JDBC Data Source Name/Path</b><br/>Enter the JDBC Data Source Name/Path to connect to the Oracle server. If specified, connector will only try to connect using Datasource and ignore other resource parameters specified.<br/>the example value is: <CODE>jdbc/SampleDataSourceName</CODE>","type":"java.lang.Strin', NULL);          
INSERT INTO SYSTEM_LOB_STREAM VALUES(2, 2, 'g","required":false,"order":20,"confidential":false,"defaultValues":[""]},"overridable":false,"values":[]},{"schema":{"name":"deleteScript","displayName":"deleteScript","helpMessage":"deleteScript","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":[""]},"overridable":false,"values":[]},{"schema":{"name":"rethrowAllSQLExceptions","displayName":"Rethrow all SQLExceptions","helpMessage":"If this is not checked, SQL statements which throw SQLExceptions with a 0 ErrorCode will be have the exception caught and suppressed. Check it to have exceptions with 0 ErrorCodes rethrown.","type":"boolean","required":false,"order":14,"confidential":false,"defaultValues":[true]},"overridable":false,"values":[true]},{"schema":{"name":"syncScriptFileName","displayName":"syncScriptFileName","helpMessage":"syncScriptFileName","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":[]},"overridable":true,"values":["/home/ilgrosso/work/syncope/syncope2/fit/core-reference/target/test-classes/scriptedsql/SyncScript.groovy"]},{"schema":{"name":"updateScript","displayName":"updateScript","helpMessage":"updateScript","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":[""]},"overridable":false,"values":[]},{"schema":{"name":"user","displayName":"User","helpMessage":"<b>User</b><br/>Enter the name of the mandatory Database user with permission to account table.","type":"java.lang.String","required":false,"order":4,"confidential":false,"defaultValues":[""]},"overridable":false,"values":["sa"]},{"schema":{"name":"deleteScriptFileName","displayName":"deleteScriptFileName","helpMessage":"deleteScriptFileName","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":[]},"overridable":false,"values":["/home/ilgrosso/work/syncope/syncope2/fit/core-reference/target/test-classes/scriptedsql/DeleteScript.groovy"]},{"schema":{"name":"searchScriptFileName","displayName":"searchScriptFileName","helpMessage":"searchScriptFileName","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":[]},"overridable":true,"values":["/home/ilgrosso/work/syncope/syncope2/fit/core-reference/target/test-classes/scriptedsql/SearchScript.groovy"]},{"schema":{"name":"searchScript","displayName":"searchScript","helpMessage":"searchScript","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":[""]},"overridable":false,"values":[]}]', NULL);  
INSERT INTO PUBLIC.CONNINSTANCE(ID, BUNDLENAME, CONNREQUESTTIMEOUT, CONNECTORNAME, DISPLAYNAME, JSONCONF, LOCATION, VERSION, ADMINREALM_ID, MAXIDLE, MAXOBJECTS, MAXWAIT, MINEVICTABLEIDLETIMEMILLIS, MINIDLE) VALUES
('74141a3b-0762-4720-a4aa-fc3e374ef3ef', 'net.tirasa.connid.bundles.ldap', NULL, 'net.tirasa.connid.bundles.ldap.LdapConnector', 'ApacheDS', SYSTEM_COMBINE_CLOB(0), 'file:/home/ilgrosso/work/syncope/syncope2/fit/core-reference/target/bundles/', '1.5.2', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL, NULL, NULL, NULL, NULL),
('a28abd9b-9f4a-4ef6-a7a8-d19ad2a8f29d', 'net.tirasa.connid.bundles.db.table', NULL, 'net.tirasa.connid.bundles.db.table.DatabaseTableConnector', 'H2-test2', '[{"schema":{"name":"disabledStatusValue","displayName":null,"helpMessage":null,"type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["false"]},{"schema":{"name":"user","displayName":null,"helpMessage":null,"type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["sa"]},{"schema":{"name":"keyColumn","displayName":null,"helpMessage":null,"type":"java.lang.String","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["id"]},{"schema":{"name":"cipherAlgorithm","displayName":null,"helpMessage":null,"type":"java.lang.String","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["SHA1"]},{"schema":{"name":"enabledStatusValue","displayName":null,"helpMessage":null,"type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["true"]},{"schema":{"name":"passwordColumn","displayName":null,"helpMessage":null,"type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["password"]},{"schema":{"name":"jdbcDriver","displayName":null,"helpMessage":null,"type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["org.h2.Driver"]},{"schema":{"name":"retrievePassword","displayName":null,"helpMessage":null,"type":"java.lang.Boolean","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["true"]},{"schema":{"name":"defaultStatusValue","displayName":null,"helpMessage":null,"type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["true"]},{"schema":{"name":"password","displayName":null,"helpMessage":null,"type":"org.identityconnectors.common.security.GuardedString","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["sa"]},{"schema":{"name":"statusColumn","displayName":null,"helpMessage":null,"type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["status"]},{"schema":{"name":"jdbcUrlTemplate","displayName":null,"helpMessage":null,"type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["jdbc:h2:tcp://localhost:9092/mem:testdb;DB_CLOSE_DELAY=-1"]},{"schema":{"name":"table","displayName":null,"helpMessage":null,"type":"java.lang.String","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":false,"values":["test2"]}]', 'connid://testconnectorserver@localhost:4554', '2.2.5', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL, NULL, NULL, NULL, NULL),
('be24b061-019d-4e3e-baf0-0a6d0a45cb9c', 'net.tirasa.connid.bundles.db.table', NULL, 'net.tirasa.connid.bundles.db.table.DatabaseTableConnector', 'H2-testpull', SYSTEM_COMBINE_CLOB(1), 'connid://testconnectorserver@localhost:4554', '2.2.5', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL, NULL, NULL, NULL, NULL),
('a6d017fd-a705-4507-bb7c-6ab6a6745997', 'net.tirasa.connid.bundles.db.scriptedsql', NULL, 'net.tirasa.connid.bundles.db.scriptedsql.ScriptedSQLConnector', 'Scripted SQL', SYSTEM_COMBINE_CLOB(2), 'connid://testconnectorserver@localhost:4554', '2.2.5', '0679e069-7355-4b20-bd11-a5a0a5453c7c', NULL, NULL, NULL, NULL, NULL);         
INSERT INTO SYSTEM_LOB_STREAM VALUES(3, 0, '[{"schema":{"name":"authenticateScript","displayName":"authenticateScript","helpMessage":"authenticateScript","type":"java.lang.String","required":false,"order":6,"confidential":false,"defaultValues":[""]},"overridable":false,"values":[]},{"schema":{"name":"contentType","displayName":"contentType","helpMessage":"contentType","type":"java.lang.String","required":true,"order":-1,"confidential":false,"defaultValues":["application/json"]},"overridable":false,"values":["application/json"]},{"schema":{"name":"resolveUsernameScriptFileName","displayName":"resolveUsernameScriptFileName","helpMessage":"resolveUsernameScriptFileName","type":"java.lang.String","required":false,"order":15,"confidential":false,"defaultValues":[]},"overridable":false,"values":[]},{"schema":{"name":"createScriptFileName","displayName":"createScriptFileName","helpMessage":"createScriptFileName","type":"java.lang.String","required":false,"order":10,"confidential":false,"defaultValues":[]},"overridable":false,"values":["/home/ilgrosso/work/syncope/syncope2/fit/core-reference/target/test-classes/rest/CreateScript.groovy"]},{"schema":{"name":"username","displayName":"username","helpMessage":"username","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":[]},"overridable":false,"values":[]},{"schema":{"name":"updateScript","displayName":"updateScript","helpMessage":"updateScript","type":"java.lang.String","required":false,"order":4,"confidential":false,"defaultValues":[""]},"overridable":false,"values":[]},{"schema":{"name":"searchScript","displayName":"searchScript","helpMessage":"searchScript","type":"java.lang.String","required":false,"order":6,"confidential":false,"defaultValues":[""]},"overridable":false,"values":[]},{"schema":{"name":"clearTextPasswordToScript","displayName":"clearTextPasswordToScript","helpMessage":"clearTextPasswordToScript","type":"boolean","required":false,"order":1,"confidential":false,"defaultValues":[true]},"overridable":false,"values":[true]},{"schema":{"name":"syncScript","displayName":"syncScript","helpMessage":"syncScript","type":"java.lang.String","required":false,"order":7,"confidential":false,"defaultValues":[""]},"overridable":false,"values":[]},{"schema":{"name":"deleteScriptFileName","displayName":"deleteScriptFileName","helpMessage":"deleteScriptFileName","type":"java.lang.String","required":false,"order":12,"confidential":false,"defaultValues":[]},"overridable":false,"values":["/home/ilgrosso/work/syncope/syncope2/fit/core-reference/target/test-classes/rest/DeleteScript.groovy"]},{"schema":{"name":"resolveUsernameScript","displayName":"resolveUsernameScript","helpMessage":"resolveUsernameScript","type":"java.lang.String","required":false,"order":6,"confidential":false,"defaultValues":[""]},"overridable":false,"values":[]},{"schema":{"name":"searchScriptFileName","displayName":"searchScriptFileName","helpMessage":"searchScriptFileName","type":"java.lang.String","required":false,"order":13,"confidential":false,"defaultValues":[]},"overridable":false,"values":["/home/ilgrosso/work/syncope/syncope2/fit/core-reference/target/test-classes/rest/SearchScript.groovy"]},{"schema":{"name":"syncScriptFileName","displayName":"syncScriptFileName","helpMessage":"syncScriptFileName","type":"java.lang.String","required":false,"order":16,"confidential":false,"defaultValues":[]},"overridable":false,"values":["/home/ilgrosso/work/syncope/syncope2/fit/core-reference/target/test-classes/rest/SyncScript.groovy"]},{"schema":{"name":"schemaScriptFileName","displayName":"schemaScriptFileName","helpMessage":"schemaScriptFileName","type":"java.lang.String","required":false,"order":17,"confidential":false,"defaultValues":[]},"overridable":false,"values":["/home/ilgrosso/work/syncope/syncope2/fit/core-reference/target/test-classes/rest/SchemaScript.groovy"]},{"schema":{"name":"password","displayName":"password","helpMessage":"password","type":"org.identityconnectors.common.security.GuardedString","required":false,"order":1,"confidential":true,"defaultValues":[]},"overridable":false,"values":[]},{"schema":{"nam', NULL);          
INSERT INTO SYSTEM_LOB_STREAM VALUES(3, 1, 'e":"updateScriptFileName","displayName":"updateScriptFileName","helpMessage":"updateScriptFileName","type":"java.lang.String","required":false,"order":11,"confidential":false,"defaultValues":[]},"overridable":false,"values":["/home/ilgrosso/work/syncope/syncope2/fit/core-reference/target/test-classes/rest/UpdateScript.groovy"]},{"schema":{"name":"testScriptFileName","displayName":"testScriptFileName","helpMessage":"testScriptFileName","type":"java.lang.String","required":false,"order":18,"confidential":false,"defaultValues":[]},"overridable":false,"values":["/home/ilgrosso/work/syncope/syncope2/fit/core-reference/target/test-classes/rest/TestScript.groovy"]},{"schema":{"name":"accept","displayName":"accept","helpMessage":"accept","type":"java.lang.String","required":true,"order":-2,"confidential":false,"defaultValues":["application/json"]},"overridable":false,"values":["application/json"]},{"schema":{"name":"baseAddress","displayName":"baseAddress","helpMessage":"baseAddress","type":"java.lang.String","required":true,"order":-3,"confidential":false,"defaultValues":[]},"overridable":false,"values":["http://localhost:9080/syncope-fit-build-tools/cxf/rest"]},{"schema":{"name":"authenticateScriptFileName","displayName":"authenticateScriptFileName","helpMessage":"authenticateScriptFileName","type":"java.lang.String","required":false,"order":14,"confidential":false,"defaultValues":[]},"overridable":false,"values":["/home/ilgrosso/work/syncope/syncope2/fit/core-reference/target/test-classes/rest/AuthenticateScript.groovy"]},{"schema":{"name":"deleteScript","displayName":"deleteScript","helpMessage":"deleteScript","type":"java.lang.String","required":false,"order":5,"confidential":false,"defaultValues":[""]},"overridable":false,"values":[]},{"schema":{"name":"schemaScript","displayName":"schemaScript","helpMessage":"schemaScript","type":"java.lang.String","required":false,"order":8,"confidential":false,"defaultValues":[""]},"overridable":false,"values":[]},{"schema":{"name":"createScript","displayName":"createScript","helpMessage":"createScript","type":"java.lang.String","required":false,"order":3,"confidential":false,"defaultValues":[""]},"overridable":false,"values":[]},{"schema":{"name":"scriptingLanguage","displayName":"scriptingLanguage","helpMessage":"scriptingLanguage","type":"java.lang.String","required":false,"order":0,"confidential":false,"defaultValues":["GROOVY"]},"overridable":false,"values":["GROOVY"]},{"schema":{"name":"testScript","displayName":"testScript","helpMessage":"testScript","type":"java.lang.String","required":false,"order":9,"confidential":false,"defaultValues":[""]},"overridable":false,"values":[]},{"schema":{"name":"reloadScriptOnExecution","displayName":"reloadScriptOnExecution","helpMessage":"reloadScriptOnExecution","type":"boolean","required":false,"order":2,"confidential":false,"defaultValues":[false]},"overridable":false,"values":[false]}]', NULL);    
INSERT INTO PUBLIC.CONNINSTANCE(ID, BUNDLENAME, CONNREQUESTTIMEOUT, CONNECTORNAME, DISPLAYNAME, JSONCONF, LOCATION, VERSION, ADMINREALM_ID, MAXIDLE, MAXOBJECTS, MAXWAIT, MINEVICTABLEIDLETIMEMILLIS, MINIDLE) VALUES
('44c02549-19c3-483c-8025-4919c3283c37', 'net.tirasa.connid.bundles.rest', NULL, 'net.tirasa.connid.bundles.rest.RESTConnector', 'REST', SYSTEM_COMBINE_CLOB(3), 'connid://testconnectorserver@localhost:4554', '1.0.3', '0679e069-7355-4b20-bd11-a5a0a5453c7c', NULL, NULL, NULL, NULL, NULL);          
CREATE MEMORY TABLE PUBLIC.CONNINSTANCEHISTORYCONF(
    ID VARCHAR(36) NOT NULL,
    CONF CLOB,
    CREATION TIMESTAMP,
    CREATOR VARCHAR(255) NOT NULL,
    ENTITY_ID VARCHAR(36)
);        
ALTER TABLE PUBLIC.CONNINSTANCEHISTORYCONF ADD CONSTRAINT PUBLIC.CONSTRAINT_C PRIMARY KEY(ID); 
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.CONNINSTANCEHISTORYCONF;  
CREATE MEMORY TABLE PUBLIC.CONNINSTANCE_CAPABILITIES(
    CONNINSTANCE_ID VARCHAR(36),
    CAPABILITY VARCHAR(20)
);           
-- 42 +/- SELECT COUNT(*) FROM PUBLIC.CONNINSTANCE_CAPABILITIES;               
INSERT INTO PUBLIC.CONNINSTANCE_CAPABILITIES(CONNINSTANCE_ID, CAPABILITY) VALUES
('88a7a819-dab5-46b4-9b90-0b9769eabdb8', 'CREATE'),
('88a7a819-dab5-46b4-9b90-0b9769eabdb8', 'UPDATE'),
('88a7a819-dab5-46b4-9b90-0b9769eabdb8', 'DELETE'),
('88a7a819-dab5-46b4-9b90-0b9769eabdb8', 'SEARCH'),
('5aa5b8be-7521-481a-9651-c557aea078c1', 'AUTHENTICATE'),
('5aa5b8be-7521-481a-9651-c557aea078c1', 'CREATE'),
('5aa5b8be-7521-481a-9651-c557aea078c1', 'UPDATE'),
('5aa5b8be-7521-481a-9651-c557aea078c1', 'DELETE'),
('5aa5b8be-7521-481a-9651-c557aea078c1', 'SEARCH'),
('5aa5b8be-7521-481a-9651-c557aea078c1', 'SYNC'),
('5ffbb4ac-a8c3-4b44-b699-11b398a1ba08', 'CREATE'),
('5ffbb4ac-a8c3-4b44-b699-11b398a1ba08', 'UPDATE'),
('5ffbb4ac-a8c3-4b44-b699-11b398a1ba08', 'DELETE'),
('5ffbb4ac-a8c3-4b44-b699-11b398a1ba08', 'SEARCH'),
('6c2acf1b-b052-46f0-8c56-7a8ad6905edf', 'CREATE'),
('6c2acf1b-b052-46f0-8c56-7a8ad6905edf', 'UPDATE'),
('6c2acf1b-b052-46f0-8c56-7a8ad6905edf', 'DELETE'),
('6c2acf1b-b052-46f0-8c56-7a8ad6905edf', 'SEARCH'),
('6c2acf1b-b052-46f0-8c56-7a8ad6905edf', 'SYNC'),
('74141a3b-0762-4720-a4aa-fc3e374ef3ef', 'CREATE'),
('74141a3b-0762-4720-a4aa-fc3e374ef3ef', 'UPDATE'),
('74141a3b-0762-4720-a4aa-fc3e374ef3ef', 'DELETE'),
('74141a3b-0762-4720-a4aa-fc3e374ef3ef', 'SEARCH'),
('a28abd9b-9f4a-4ef6-a7a8-d19ad2a8f29d', 'CREATE'),
('a28abd9b-9f4a-4ef6-a7a8-d19ad2a8f29d', 'UPDATE'),
('a28abd9b-9f4a-4ef6-a7a8-d19ad2a8f29d', 'SEARCH'),
('a28abd9b-9f4a-4ef6-a7a8-d19ad2a8f29d', 'SYNC'),
('be24b061-019d-4e3e-baf0-0a6d0a45cb9c', 'CREATE'),
('be24b061-019d-4e3e-baf0-0a6d0a45cb9c', 'UPDATE'),
('be24b061-019d-4e3e-baf0-0a6d0a45cb9c', 'DELETE'),
('be24b061-019d-4e3e-baf0-0a6d0a45cb9c', 'SEARCH'),
('a6d017fd-a705-4507-bb7c-6ab6a6745997', 'CREATE'),
('a6d017fd-a705-4507-bb7c-6ab6a6745997', 'UPDATE'),
('a6d017fd-a705-4507-bb7c-6ab6a6745997', 'DELETE'),
('a6d017fd-a705-4507-bb7c-6ab6a6745997', 'SEARCH'),
('a6d017fd-a705-4507-bb7c-6ab6a6745997', 'SYNC'),
('44c02549-19c3-483c-8025-4919c3283c37', 'AUTHENTICATE'),
('44c02549-19c3-483c-8025-4919c3283c37', 'SYNC'),
('44c02549-19c3-483c-8025-4919c3283c37', 'CREATE'),
('44c02549-19c3-483c-8025-4919c3283c37', 'DELETE'),
('44c02549-19c3-483c-8025-4919c3283c37', 'SEARCH'),
('44c02549-19c3-483c-8025-4919c3283c37', 'UPDATE');     
CREATE MEMORY TABLE PUBLIC.CPLAINATTR(
    ID VARCHAR(36) NOT NULL,
    OWNER_ID VARCHAR(255),
    SCHEMA_ID VARCHAR(255)
);   
ALTER TABLE PUBLIC.CPLAINATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_A PRIMARY KEY(ID);              
-- 16 +/- SELECT COUNT(*) FROM PUBLIC.CPLAINATTR;              
INSERT INTO PUBLIC.CPLAINATTR(ID, OWNER_ID, SCHEMA_ID) VALUES
('56db89b9-119e-4923-a16e-f42823b90c66', 'cd64d66f-6fff-4008-b966-a06b1cc1436d', 'password.cipher.algorithm'),
('abd5a2d2-25ee-48b7-b5ca-76813b54a6f2', 'cd64d66f-6fff-4008-b966-a06b1cc1436d', 'notificationjob.cronExpression'),
('0523d7e6-af13-4e1e-9edb-e35971aacee7', 'cd64d66f-6fff-4008-b966-a06b1cc1436d', 'notification.maxRetries'),
('58977caa-dcf7-4ae3-8591-7e3d0a395200', 'cd64d66f-6fff-4008-b966-a06b1cc1436d', 'token.length'),
('01f69abd-df85-4e1b-bb88-ad570594e045', 'cd64d66f-6fff-4008-b966-a06b1cc1436d', 'token.expireTime'),
('7b19cefa-d606-477c-8431-c9464f53fe8b', 'cd64d66f-6fff-4008-b966-a06b1cc1436d', 'selfRegistration.allowed'),
('dc35cc97-6ed9-4bb2-bb3b-509f4cd8f3d3', 'cd64d66f-6fff-4008-b966-a06b1cc1436d', 'passwordReset.allowed'),
('e5a712ad-53fd-4102-ba55-fb45caed5f7b', 'cd64d66f-6fff-4008-b966-a06b1cc1436d', 'passwordReset.securityQuestion'),
('577c6c4d-7149-43c2-9821-9ab4510effbd', 'cd64d66f-6fff-4008-b966-a06b1cc1436d', 'authentication.attributes'),
('888ae8e1-a295-4ee2-a15e-31dbf6dfc3f9', 'cd64d66f-6fff-4008-b966-a06b1cc1436d', 'authentication.statuses'),
('9891c0a7-27ee-4215-9eea-ca32e580b4e4', 'cd64d66f-6fff-4008-b966-a06b1cc1436d', 'log.lastlogindate'),
('bcfd7efc-0605-4b5e-b4bb-85c1d5f6493a', 'cd64d66f-6fff-4008-b966-a06b1cc1436d', 'return.password.value'),
('cfec3140-562d-459c-ac6a-e3e10758661d', 'cd64d66f-6fff-4008-b966-a06b1cc1436d', 'jwt.lifetime.minutes'),
('ae36c6ab-0f39-40d7-b6e6-3b8394547c9c', 'cd64d66f-6fff-4008-b966-a06b1cc1436d', 'connector.conf.history.size'),
('ae7ae53a-74cf-48b0-9a57-6d2c94928e60', 'cd64d66f-6fff-4008-b966-a06b1cc1436d', 'resource.conf.history.size');         
CREATE INDEX PUBLIC.CPLAINATTR_SCHEMA_INDEX ON PUBLIC.CPLAINATTR(SCHEMA_ID);   
CREATE INDEX PUBLIC.CPLAINATTR_OWNER_INDEX ON PUBLIC.CPLAINATTR(OWNER_ID);     
CREATE MEMORY TABLE PUBLIC.CPLAINATTRUNIQUEVALUE(
    ID VARCHAR(36) NOT NULL,
    BINARYVALUE BLOB,
    BOOLEANVALUE INTEGER,
    DATEVALUE TIMESTAMP,
    DOUBLEVALUE DOUBLE,
    LONGVALUE BIGINT,
    STRINGVALUE VARCHAR(255),
    ATTRIBUTE_ID VARCHAR(36),
    SCHEMA_ID VARCHAR(255)
);
ALTER TABLE PUBLIC.CPLAINATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_17 PRIMARY KEY(ID);  
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.CPLAINATTRUNIQUEVALUE;    
CREATE INDEX PUBLIC.CPATTRUNIQUEVALUE_ATTRINDEX ON PUBLIC.CPLAINATTRUNIQUEVALUE(ATTRIBUTE_ID); 
CREATE MEMORY TABLE PUBLIC.CPLAINATTRVALUE(
    ID VARCHAR(36) NOT NULL,
    BINARYVALUE BLOB,
    BOOLEANVALUE INTEGER,
    DATEVALUE TIMESTAMP,
    DOUBLEVALUE DOUBLE,
    LONGVALUE BIGINT,
    STRINGVALUE VARCHAR(255),
    ATTRIBUTE_ID VARCHAR(36)
);  
ALTER TABLE PUBLIC.CPLAINATTRVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_6 PRIMARY KEY(ID);         
-- 18 +/- SELECT COUNT(*) FROM PUBLIC.CPLAINATTRVALUE;         
INSERT INTO PUBLIC.CPLAINATTRVALUE(ID, BINARYVALUE, BOOLEANVALUE, DATEVALUE, DOUBLEVALUE, LONGVALUE, STRINGVALUE, ATTRIBUTE_ID) VALUES
('870323e8-8db6-4a64-b512-15f9fa094905', NULL, NULL, NULL, NULL, NULL, 'SHA1', '56db89b9-119e-4923-a16e-f42823b90c66'),
('4828ea70-d151-4c16-b344-2d07b1956bee', NULL, NULL, NULL, NULL, NULL, '0/20 * * * * ?', 'abd5a2d2-25ee-48b7-b5ca-76813b54a6f2'),
('010e2bdc-0094-4918-bac3-d0d5ea17b54a', NULL, NULL, NULL, NULL, 3, NULL, '0523d7e6-af13-4e1e-9edb-e35971aacee7'),
('372e28e0-3af1-4774-b668-81aa84903b75', NULL, NULL, NULL, NULL, 256, NULL, '58977caa-dcf7-4ae3-8591-7e3d0a395200'),
('963970cf-4af6-46bb-875b-a1b758ac8d05', NULL, NULL, NULL, NULL, 60, NULL, '01f69abd-df85-4e1b-bb88-ad570594e045'),
('c8b9a0f1-0168-4e2a-95b8-4819fc70e620', NULL, 1, NULL, NULL, NULL, NULL, '7b19cefa-d606-477c-8431-c9464f53fe8b'),
('b1ecea41-ab7c-4dd3-9e3e-b6baf0f98046', NULL, 1, NULL, NULL, NULL, NULL, 'dc35cc97-6ed9-4bb2-bb3b-509f4cd8f3d3'),
('b5e8e79d-8039-4318-9698-fe5e181ebe98', NULL, 1, NULL, NULL, NULL, NULL, 'e5a712ad-53fd-4102-ba55-fb45caed5f7b'),
('c13660b5-926c-47ea-946d-52db32dd492b', NULL, NULL, NULL, NULL, NULL, 'username', '577c6c4d-7149-43c2-9821-9ab4510effbd'),
('0f112dbd-00d4-441c-b732-331e7f348f8a', NULL, NULL, NULL, NULL, NULL, 'userId', '577c6c4d-7149-43c2-9821-9ab4510effbd'),
('4b8e7d2b-f527-43a3-a2e2-5530dcab2f52', NULL, NULL, NULL, NULL, NULL, 'created', '888ae8e1-a295-4ee2-a15e-31dbf6dfc3f9'),
('f0c89f2c-ea87-4c95-a1cf-142bf6e6f523', NULL, NULL, NULL, NULL, NULL, 'active', '888ae8e1-a295-4ee2-a15e-31dbf6dfc3f9'),
('162dd874-0417-4bb9-9724-db1ff2952dd1', NULL, 1, NULL, NULL, NULL, NULL, '9891c0a7-27ee-4215-9eea-ca32e580b4e4'),
('e5fa94db-b524-4309-908d-8198d0b3f779', NULL, 0, NULL, NULL, NULL, NULL, 'bcfd7efc-0605-4b5e-b4bb-85c1d5f6493a'),
('e5fa94db-b524-4309-908d-8198d0b3f77b', NULL, NULL, NULL, NULL, 365, NULL, 'bcfd7efc-0605-4b5e-b4bb-85c1d5f64bbb'),
('447e2456-3ff5-41bc-8ff1-cbb0567546cb', NULL, NULL, NULL, NULL, 120, NULL, 'cfec3140-562d-459c-ac6a-e3e10758661d'),
('4989ce5d-7b42-4a5c-b725-54286888df10', NULL, NULL, NULL, NULL, 10, NULL, 'ae36c6ab-0f39-40d7-b6e6-3b8394547c9c'),
('059ac3e1-687f-4dd9-a28b-a23f8b436f31', NULL, NULL, NULL, NULL, 10, NULL, 'ae7ae53a-74cf-48b0-9a57-6d2c94928e60');       
CREATE INDEX PUBLIC.CATTRVALUE_DOUBLEVALUEINDEX ON PUBLIC.CPLAINATTRVALUE(DOUBLEVALUE);        
CREATE INDEX PUBLIC.CATTRVALUE_LONGVALUEINDEX ON PUBLIC.CPLAINATTRVALUE(LONGVALUE);            
CREATE INDEX PUBLIC.CATTRVALUE_BOOLEANVALUEINDEX ON PUBLIC.CPLAINATTRVALUE(BOOLEANVALUE);      
CREATE INDEX PUBLIC.CATTRVALUE_STRINGVALUEINDEX ON PUBLIC.CPLAINATTRVALUE(STRINGVALUE);        
CREATE INDEX PUBLIC.CATTRVALUE_DATEVALUEINDEX ON PUBLIC.CPLAINATTRVALUE(DATEVALUE);            
CREATE INDEX PUBLIC.CPLAINATTRVALUE_ATTRINDEX ON PUBLIC.CPLAINATTRVALUE(ATTRIBUTE_ID);         
CREATE MEMORY TABLE PUBLIC.DERSCHEMA(
    ID VARCHAR(255) NOT NULL,
    EXPRESSION VARCHAR(255),
    ANYTYPECLASS_ID VARCHAR(255)
);           
ALTER TABLE PUBLIC.DERSCHEMA ADD CONSTRAINT PUBLIC.CONSTRAINT_E5 PRIMARY KEY(ID);              
-- 10 +/- SELECT COUNT(*) FROM PUBLIC.DERSCHEMA;               
INSERT INTO PUBLIC.DERSCHEMA(ID, EXPRESSION, ANYTYPECLASS_ID) VALUES
('csvuserid', 'firstname + '','' + surname', 'csv'),
('cn', 'surname + '', '' + firstname', 'minimal user'),
('noschema', 'surname + '', '' + notfound', 'other'),
('info', 'username + '' - '' + creationDate + ''['' + failedLogins + '']''', 'minimal user'),
('rderiveddata', 'rderived_sx + ''-'' + rderived_dx', 'minimal group'),
('displayProperty', 'icon + '': '' + show', 'minimal group'),
('rderToBePropagated', 'rderived_sx + ''-'' + rderived_dx', 'minimal group'),
('rderivedschema', 'rderived_sx + ''-'' + rderived_dx', 'minimal group'),
('mderiveddata', 'mderived_sx + ''-'' + mderived_dx', NULL),
('mderToBePropagated', 'mderived_sx + ''-'' + mderived_dx', 'generic membership');            
CREATE MEMORY TABLE PUBLIC.DYNREALM(
    ID VARCHAR(255) NOT NULL
);           
ALTER TABLE PUBLIC.DYNREALM ADD CONSTRAINT PUBLIC.CONSTRAINT_8 PRIMARY KEY(ID);
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.DYNREALM; 
CREATE MEMORY TABLE PUBLIC.DYNREALMMEMBERSHIP(
    ID VARCHAR(36) NOT NULL,
    FIQL VARCHAR(255),
    DYNREALM_ID VARCHAR(255),
    ANYTYPE_ID VARCHAR(255)
);
ALTER TABLE PUBLIC.DYNREALMMEMBERSHIP ADD CONSTRAINT PUBLIC.CONSTRAINT_13 PRIMARY KEY(ID);     
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.DYNREALMMEMBERSHIP;       
CREATE MEMORY TABLE PUBLIC.DYNROLEMEMBERSHIP(
    ID VARCHAR(36) NOT NULL,
    FIQL VARCHAR(255),
    ROLE_ID VARCHAR(255)
);  
ALTER TABLE PUBLIC.DYNROLEMEMBERSHIP ADD CONSTRAINT PUBLIC.CONSTRAINT_64 PRIMARY KEY(ID);      
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.DYNROLEMEMBERSHIP;        
CREATE MEMORY TABLE PUBLIC.EXTERNALRESOURCE(
    ID VARCHAR(255) NOT NULL,
    CREATETRACELEVEL VARCHAR(20),
    DELETETRACELEVEL VARCHAR(20),
    ENFORCEMANDATORYCONDITION INTEGER,
    JSONCONF CLOB,
    OVERRIDECAPABILITIES INTEGER,
    PROPAGATIONPRIORITY INTEGER,
    PROVISIONINGTRACELEVEL VARCHAR(20),
    RANDOMPWDIFNOTPROVIDED INTEGER,
    UPDATETRACELEVEL VARCHAR(20),
    ACCOUNTPOLICY_ID VARCHAR(36),
    CONNECTOR_ID VARCHAR(36),
    PASSWORDPOLICY_ID VARCHAR(36),
    PULLPOLICY_ID VARCHAR(36)
);  
ALTER TABLE PUBLIC.EXTERNALRESOURCE ADD CONSTRAINT PUBLIC.CONSTRAINT_FB PRIMARY KEY(ID);       
-- 21 +/- SELECT COUNT(*) FROM PUBLIC.EXTERNALRESOURCE;        
INSERT INTO PUBLIC.EXTERNALRESOURCE(ID, CREATETRACELEVEL, DELETETRACELEVEL, ENFORCEMANDATORYCONDITION, JSONCONF, OVERRIDECAPABILITIES, PROPAGATIONPRIORITY, PROVISIONINGTRACELEVEL, RANDOMPWDIFNOTPROVIDED, UPDATETRACELEVEL, ACCOUNTPOLICY_ID, CONNECTOR_ID, PASSWORDPOLICY_ID, PULLPOLICY_ID) VALUES
('ws-target-resource-1', 'ALL', 'ALL', 0, NULL, 0, 1, 'ALL', 0, 'ALL', NULL, '88a7a819-dab5-46b4-9b90-0b9769eabdb8', NULL, NULL),
('ws-target-resource-2', 'FAILURES', 'NONE', 1, NULL, 0, NULL, 'ALL', 0, 'ALL', NULL, '88a7a819-dab5-46b4-9b90-0b9769eabdb8', NULL, '9454b0d7-2610-400a-be82-fc23cf553dd6'),
('ws-target-resource-timeout', 'FAILURES', 'NONE', 1, '[{"schema":{"name":"endpoint","displayName":null,"helpMessage":null,"type":"java.lang.String","required":true,"order":0,"confidential":false,"defaultValues":null},"overridable":true,"values":["http://localhost:9080/syncope-fit-build-tools/services/provisioning"]}]', 0, 1, 'ALL', 0, 'ALL', NULL, '5ffbb4ac-a8c3-4b44-b699-11b398a1ba08', NULL, NULL),
('ws-target-resource-list-mappings-1', 'ALL', 'ALL', 0, NULL, 0, NULL, 'ALL', 0, 'ALL', NULL, '88a7a819-dab5-46b4-9b90-0b9769eabdb8', NULL, NULL),
('ws-target-resource-list-mappings-2', 'ALL', 'ALL', 1, NULL, 0, NULL, 'ALL', 0, 'ALL', NULL, '88a7a819-dab5-46b4-9b90-0b9769eabdb8', NULL, NULL),
('ws-target-resource-delete', 'ALL', 'ALL', 0, NULL, 0, 2, 'ALL', 0, 'ALL', NULL, '5ffbb4ac-a8c3-4b44-b699-11b398a1ba08', NULL, NULL),
('ws-target-resource-update', 'ALL', 'ALL', 1, NULL, 0, NULL, 'ALL', 0, 'ALL', NULL, '88a7a819-dab5-46b4-9b90-0b9769eabdb8', NULL, NULL),
('resource-testdb', 'ALL', 'ALL', 1, NULL, 0, NULL, 'ALL', 0, 'ALL', NULL, '5aa5b8be-7521-481a-9651-c557aea078c1', NULL, NULL),
('resource-testdb2', 'ALL', 'ALL', 1, NULL, 0, NULL, 'ALL', 1, 'ALL', NULL, 'a28abd9b-9f4a-4ef6-a7a8-d19ad2a8f29d', NULL, NULL),
('resource-csv', 'ALL', 'ALL', 0, NULL, 0, NULL, 'ALL', 0, 'ALL', NULL, '6c2acf1b-b052-46f0-8c56-7a8ad6905edf', NULL, '880f8553-069b-4aed-9930-2cd53873f544'),
('ws-target-resource-update-resetsynctoken', 'ALL', 'ALL', 1, NULL, NULL, NULL, 'ALL', 0, 'ALL', NULL, '88a7a819-dab5-46b4-9b90-0b9769eabdb8', NULL, NULL),
('resource-ldap', 'ALL', 'ALL', 1, NULL, 0, 1, 'ALL', 1, 'ALL', NULL, '74141a3b-0762-4720-a4aa-fc3e374ef3ef', NULL, NULL),
('resource-ldap-orgunit', 'ALL', 'ALL', 1, '[{"schema":{"name":"uidAttribute","displayName":"Uid Attribute","helpMessage":"The name of the LDAP attribute which is mapped to the Uid attribute. Default is \"entryUUID\".","type":"java.lang.String","required":false,"order":21,"confidential":false,"defaultValues":["entryUUID"]},"overridable":true,"values":["l"]},{"schema":{"name":"baseContexts","displayName":"Base Contexts","helpMessage":"One or more starting points in the LDAP tree that will be used when searching the tree. Searches are performed when discovering users from the LDAP server or when looking for the groups of which a user is a member.","type":"[Ljava.lang.String;","required":true,"order":7,"confidential":false,"defaultValues":[]},"overridable":true,"values":["o=isp"]}]', 0, 1, 'ALL', 1, 'ALL', NULL, '74141a3b-0762-4720-a4aa-fc3e374ef3ef', NULL, NULL),
('ws-target-resource-nopropagation', 'ALL', 'ALL', 1, NULL, 0, NULL, 'ALL', 0, 'ALL', NULL, 'fcf9f2b0-f7d6-42c9-84a6-61b28255a42b', '986d1236-3ac5-4a19-810c-5ab21d79cba1', NULL),
('ws-target-resource-nopropagation2', 'ALL', 'ALL', 1, NULL, 0, NULL, 'ALL', 0, 'ALL', NULL, 'fcf9f2b0-f7d6-42c9-84a6-61b28255a42b', NULL, NULL),
('ws-target-resource-nopropagation3', 'ALL', 'ALL', 1, NULL, 0, NULL, 'ALL', 0, 'ALL', NULL, 'fcf9f2b0-f7d6-42c9-84a6-61b28255a42b', NULL, NULL),
('ws-target-resource-nopropagation4', 'ALL', 'ALL', 1, NULL, 0, NULL, 'ALL', 0, 'ALL', NULL, 'fcf9f2b0-f7d6-42c9-84a6-61b28255a42b', NULL, NULL),
('resource-db-pull', 'ALL', 'ALL', 0, NULL, 0, NULL, 'ALL', 0, 'ALL', NULL, 'be24b061-019d-4e3e-baf0-0a6d0a45cb9c', NULL, NULL),
('resource-db-virattr', 'ALL', 'ALL', 0, NULL, 0, NULL, 'ALL', 0, 'ALL', NULL, 'be24b061-019d-4e3e-baf0-0a6d0a45cb9c', NULL, NULL),
('resource-db-scripted', 'ALL', 'ALL', 0, NULL, 0, NULL, 'ALL', 0, 'ALL', NULL, 'a6d017fd-a705-4507-bb7c-6ab6a6745997', NULL, NULL);           
INSERT INTO PUBLIC.EXTERNALRESOURCE(ID, CREATETRACELEVEL, DELETETRACELEVEL, ENFORCEMANDATORYCONDITION, JSONCONF, OVERRIDECAPABILITIES, PROPAGATIONPRIORITY, PROVISIONINGTRACELEVEL, RANDOMPWDIFNOTPROVIDED, UPDATETRACELEVEL, ACCOUNTPOLICY_ID, CONNECTOR_ID, PASSWORDPOLICY_ID, PULLPOLICY_ID) VALUES
('rest-target-resource', 'ALL', 'ALL', 1, NULL, 0, 0, 'ALL', 0, 'ALL', NULL, '44c02549-19c3-483c-8025-4919c3283c37', NULL, NULL);       
CREATE MEMORY TABLE PUBLIC.EXTERNALRESOURCEHISTORYCONF(
    ID VARCHAR(36) NOT NULL,
    CONF CLOB,
    CREATION TIMESTAMP,
    CREATOR VARCHAR(255) NOT NULL,
    ENTITY_ID VARCHAR(255)
);   
ALTER TABLE PUBLIC.EXTERNALRESOURCEHISTORYCONF ADD CONSTRAINT PUBLIC.CONSTRAINT_FBB PRIMARY KEY(ID);           
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.EXTERNALRESOURCEHISTORYCONF;              
CREATE MEMORY TABLE PUBLIC.EXTERNALRESOURCE_CAPOVERRIDE(
    RESOURCE_ID VARCHAR(255),
    CAPABILITYOVERRIDE VARCHAR(20)
);   
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.EXTERNALRESOURCE_CAPOVERRIDE;             
CREATE MEMORY TABLE PUBLIC.EXTERNALRESOURCE_PROPACTIONS(
    RESOURCE_ID VARCHAR(255),
    ACTIONCLASSNAME VARCHAR(255)
);     
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.EXTERNALRESOURCE_PROPACTIONS;             
INSERT INTO PUBLIC.EXTERNALRESOURCE_PROPACTIONS(RESOURCE_ID, ACTIONCLASSNAME) VALUES
('resource-ldap', 'org.apache.syncope.core.provisioning.java.propagation.LDAPMembershipPropagationActions');              
CREATE MEMORY TABLE PUBLIC.GPLAINATTR(
    ID VARCHAR(36) NOT NULL,
    SCHEMA_ID VARCHAR(255),
    OWNER_ID VARCHAR(36)
);    
ALTER TABLE PUBLIC.GPLAINATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_DC PRIMARY KEY(ID);             
-- 9 +/- SELECT COUNT(*) FROM PUBLIC.GPLAINATTR;               
INSERT INTO PUBLIC.GPLAINATTR(ID, SCHEMA_ID, OWNER_ID) VALUES
('86eeb796-e419-4409-b5e2-7c2adb342ca4', 'icon', '37d15e4c-cdc1-460b-a591-8505c8133806'),
('f82fc61f-8e74-4a4b-9f9e-b8a41f38aad9', 'icon', 'b1f7c12d-ec83-441f-a50e-1691daaedf3b'),
('8a9eb141-a946-4f50-9dfa-7a59b5e54e47', 'show', '37d15e4c-cdc1-460b-a591-8505c8133806'),
('03f91f9f-95ce-44f9-a3e2-681fba8a0bc9', 'icon', 'ebf97068-aa4b-4a85-9f01-680e8c4cf227'),
('cd3d4567-aeca-4f73-98c1-545136080abd', 'icon', '8fb2d51e-c605-4e80-a72b-13ffecf1aa9a'),
('ddfda04c-62ad-4a6f-bc15-f25f848a575e', 'rderived_sx', '37d15e4c-cdc1-460b-a591-8505c8133806'),
('4fcba413-8097-4cd3-8629-21a56ebb95ba', 'rderived_dx', '37d15e4c-cdc1-460b-a591-8505c8133806'),
('1be7cf7e-b05c-4089-8ecb-fcafe0a162b9', 'title', '0626100b-a4ba-4e00-9971-86fad52a6216'),
('22690472-ed3f-4972-8979-4c9251fab044', 'title', 'ba9ed509-b1f5-48ab-a334-c8530a6422dc');        
CREATE INDEX PUBLIC.GPLAINATTR_OWNER_INDEX ON PUBLIC.GPLAINATTR(OWNER_ID);     
CREATE INDEX PUBLIC.GPLAINATTR_SCHEMA_INDEX ON PUBLIC.GPLAINATTR(SCHEMA_ID);   
CREATE MEMORY TABLE PUBLIC.GPLAINATTRUNIQUEVALUE(
    ID VARCHAR(36) NOT NULL,
    BINARYVALUE BLOB,
    BOOLEANVALUE INTEGER,
    DATEVALUE TIMESTAMP,
    DOUBLEVALUE DOUBLE,
    LONGVALUE BIGINT,
    STRINGVALUE VARCHAR(255),
    ATTRIBUTE_ID VARCHAR(36),
    SCHEMA_ID VARCHAR(255)
);
ALTER TABLE PUBLIC.GPLAINATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_49F PRIMARY KEY(ID); 
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.GPLAINATTRUNIQUEVALUE;    
CREATE INDEX PUBLIC.GPATTRUNIQUEVALUE_ATTRINDEX ON PUBLIC.GPLAINATTRUNIQUEVALUE(ATTRIBUTE_ID); 
CREATE MEMORY TABLE PUBLIC.GPLAINATTRVALUE(
    ID VARCHAR(36) NOT NULL,
    BINARYVALUE BLOB,
    BOOLEANVALUE INTEGER,
    DATEVALUE TIMESTAMP,
    DOUBLEVALUE DOUBLE,
    LONGVALUE BIGINT,
    STRINGVALUE VARCHAR(255),
    ATTRIBUTE_ID VARCHAR(36)
);  
ALTER TABLE PUBLIC.GPLAINATTRVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_CF PRIMARY KEY(ID);        
-- 9 +/- SELECT COUNT(*) FROM PUBLIC.GPLAINATTRVALUE;          
INSERT INTO PUBLIC.GPLAINATTRVALUE(ID, BINARYVALUE, BOOLEANVALUE, DATEVALUE, DOUBLEVALUE, LONGVALUE, STRINGVALUE, ATTRIBUTE_ID) VALUES
('4a6a769e-a9c8-40f1-9746-b23d5af5a50a', NULL, NULL, NULL, NULL, NULL, 'niceIcon', '86eeb796-e419-4409-b5e2-7c2adb342ca4'),
('49f35879-2510-4f11-a901-24152f753538', NULL, NULL, NULL, NULL, NULL, 'badIcon', 'f82fc61f-8e74-4a4b-9f9e-b8a41f38aad9'),
('06dc6390-ca18-4d13-86e3-06aaae247c1b', NULL, 1, NULL, NULL, NULL, NULL, '8a9eb141-a946-4f50-9dfa-7a59b5e54e47'),
('88c44e8f-c3c6-40f6-a564-5872d1b14299', NULL, NULL, NULL, NULL, NULL, 'icon6', '03f91f9f-95ce-44f9-a3e2-681fba8a0bc9'),
('5d59450a-2f50-4249-8548-64e529b75e21', NULL, NULL, NULL, NULL, NULL, 'icon4', 'cd3d4567-aeca-4f73-98c1-545136080abd'),
('caf45fb5-f91d-4bdb-b9c5-c3fe75890f24', NULL, NULL, NULL, NULL, NULL, 'sx', 'ddfda04c-62ad-4a6f-bc15-f25f848a575e'),
('04b7b7ca-c2e9-44a4-8e86-000d9b982bf8', NULL, NULL, NULL, NULL, NULL, 'dx', '4fcba413-8097-4cd3-8629-21a56ebb95ba'),
('0f5255af-34f5-4372-93a3-ede2778303d8', NULL, NULL, NULL, NULL, NULL, 'r12', '1be7cf7e-b05c-4089-8ecb-fcafe0a162b9'),
('e16765e6-f806-469e-ae34-1ddf56f2102a', NULL, NULL, NULL, NULL, NULL, 'r13', '22690472-ed3f-4972-8979-4c9251fab044');   
CREATE INDEX PUBLIC.GATTRVALUE_DOUBLEVALUEINDEX ON PUBLIC.GPLAINATTRVALUE(DOUBLEVALUE);        
CREATE INDEX PUBLIC.GATTRVALUE_STRINGVALUEINDEX ON PUBLIC.GPLAINATTRVALUE(STRINGVALUE);        
CREATE INDEX PUBLIC.GATTRVALUE_DATEVALUEINDEX ON PUBLIC.GPLAINATTRVALUE(DATEVALUE);            
CREATE INDEX PUBLIC.GATTRVALUE_LONGVALUEINDEX ON PUBLIC.GPLAINATTRVALUE(LONGVALUE);            
CREATE INDEX PUBLIC.GATTRVALUE_BOOLEANVALUEINDEX ON PUBLIC.GPLAINATTRVALUE(BOOLEANVALUE);      
CREATE INDEX PUBLIC.GPLAINATTRVALUE_ATTRINDEX ON PUBLIC.GPLAINATTRVALUE(ATTRIBUTE_ID);         
CREATE MEMORY TABLE PUBLIC.MAILTEMPLATE(
    ID VARCHAR(255) NOT NULL,
    HTMLTEMPLATE CLOB,
    TEXTTEMPLATE CLOB
);         
ALTER TABLE PUBLIC.MAILTEMPLATE ADD CONSTRAINT PUBLIC.CONSTRAINT_AB PRIMARY KEY(ID);           
-- 4 +/- SELECT COUNT(*) FROM PUBLIC.MAILTEMPLATE;             
INSERT INTO PUBLIC.MAILTEMPLATE(ID, HTMLTEMPLATE, TEXTTEMPLATE) VALUES
('requestPasswordReset', '<html> <body> <p>Hi, a password reset was request for ${user.getUsername()}.</p>  <p>In order to complete this request, you need to visit this  <a href="http://localhost:9080/syncope-enduser/app/#!/confirmpasswordreset?token=${input.get(0).replaceAll('' '', ''%20'')}">link</a></p>.  <p>If you did not request this reset, just ignore the present e-mail.</p>  <p>Best regards.</p> </body> </html>', 'Hi, a password reset was request for ${user.getUsername()}.  In order to complete this request, you need to visit this link:  http://localhost:9080/syncope-enduser/app/#!/confirmpasswordreset?token=${input.get(0).replaceAll('' '', ''%20'')}  If you did not request this reset, just ignore the present e-mail.  Best regards.'),
('confirmPasswordReset', '<html> <body> <p>Hi,<br/> we are happy to inform you that the password request was successfully executed for your account.</p>  <p>Best regards.</p> </body> </html>', 'Hi, we are happy to inform you that the password request was successfully executed for your account.  Best regards.'),
('test', NULL, NULL),
('optin', STRINGDECODE('<html> <body> <h3>Hi ${user.getPlainAttr(\"firstname\").values[0]} ${user.getPlainAttr(\"surname\").values[0]}, welcome to Syncope!</h3>  <p>    Your username is ${user.username}.<br/>    Your email address is ${user.getPlainAttr(\"email\").values[0]}.    Your email address inside a <a href=\"http://localhost/?email=${user.getPlainAttr(\"email\").values[0].replace(''@'', ''%40'')}\">link</a>. </p>  <p>     This message was sent to the following recipients: <ul>\n $$ for (recipient: recipients) {\nNa   <li>${recipient.getPlainAttr(\"email\").values[0]}</li>\n $$ }\n </ul>\n  because one of the following events occurred: <ul>\n $$ for (event: events) {\n   <li>${event}</li>\n $$ }\n </ul>\n </p> \n $$ if (!empty(user.memberships)) {\n You have been provided with the following groups:\n <ul>\n $$ for(membership : user.memberships) {\n   <li>${membership.groupName}</li>\n $$ }\n </ul>\n $$ }\n </body> </html>'), STRINGDECODE('Hi ${user.getPlainAttr(\"firstname\").values[0]} ${user.getPlainAttr(\"surname\").values[0]}, welcome to Syncope!  Your username is ${user.username}. Your email address is ${user.getPlainAttr(\"email\").values[0]}. Your email address inside a link: http://localhost/?email=${user.getPlainAttr(\"email\").values[0].replace(''@'', ''%40'')}  This message was sent to the following recipients:\n $$ for (recipient: recipients) {\n   * ${recipient.getPlainAttr(\"email\").values[0]}\n $$ }\n \n because one of the following events occurred:\n $$ for (event: events) {\n   * ${event}\n $$ }\n \n $$ if (!empty(user.memberships)) {\n You have been provided with the following groups:\n $$ for(membership : user.memberships) {\n   * ${membership.groupName}\n $$ }\n $$ }\n'));        
CREATE MEMORY TABLE PUBLIC.MAPPING(
    ID VARCHAR(36) NOT NULL,
    CONNOBJECTLINK VARCHAR(255),
    PROVISION_ID VARCHAR(36)
);              
ALTER TABLE PUBLIC.MAPPING ADD CONSTRAINT PUBLIC.CONSTRAINT_5 PRIMARY KEY(ID); 
-- 21 +/- SELECT COUNT(*) FROM PUBLIC.MAPPING; 
INSERT INTO PUBLIC.MAPPING(ID, CONNOBJECTLINK, PROVISION_ID) VALUES
('bc0cf27b-16b7-4e83-a4b0-09af7ea4aacc', NULL, '209ea85f-f964-49c7-a498-6c9c2baa3bd8'),
('bf8afa4a-1522-44b9-91d0-c7b035e4fd99', NULL, '41a53a00-0b35-4047-831a-d5238f74c7ba'),
('b12c4fad-f0f1-406d-b143-f2d68ed28e3a', NULL, '09a65250-d9de-44b1-9412-11ed996d356d'),
('240a0291-f89d-4557-a547-2a3b9aad625b', NULL, '3d75991b-caee-4993-8e46-afb13d1bfbd4'),
('c17813c0-4e90-4118-bb28-cd36ad6d5a4d', NULL, '9ebc3237-49fa-4dce-9a4c-3070e931812f'),
('63ddd4c8-efed-4a22-a4b4-1f4e6f47c8d0', NULL, '8680bc79-dfa1-4719-9886-1d582bf1124f'),
('3f636292-6edb-4d20-ab24-fe0c5fc3dec3', NULL, '0bfa7c3e-2bb3-43d7-ac0e-d57cff7a18c8'),
('c2a0cec1-32c4-4493-8f01-d1176e557fc1', NULL, '5bd76fec-f8d7-4ab9-acd7-89e099d534e8'),
('906452d9-3eeb-4ef7-ac90-5ffc14513fbf', NULL, '18de6376-7051-4216-96f0-26629076abb9'),
('cb624b93-874b-40a0-8021-3b8116b781ab', NULL, '779fefb5-dd25-4078-915d-3c199ee32158'),
('935a0fc2-4a0b-4d82-9931-3c5ce44a33c1', NULL, '0359084d-68fe-4bf8-b42b-2ebe4f578ae7'),
('538c27dc-d260-4c53-9fc8-bf02ee226911', NULL, '2adb6537-e207-4d9b-804f-90bf18cd6f48'),
('23e20ce6-1ff9-495e-aa59-a58e5127a008', NULL, '1b53c74e-6a63-49ef-b2f1-96eeb7f1bbb8'),
('ae1c77c3-2f1d-4258-ad06-710bb09041a9', '''uid='' + username + '',ou=people,o=isp''', '8b938d63-aa92-448c-89a8-a685fc0a67c8'),
('128412c8-be4f-4d7b-8bed-5ab89134f718', '''cn='' + name + '',ou=groups,o=isp''', '20a75199-3f2e-4b9a-9510-c68dd7fc7b3d'),
('cda910bd-fc28-4f63-890e-66edc62d428b', NULL, '46b54e2a-e43e-4cd7-8c13-1af1bd65c3d3'),
('45280585-308f-4571-9788-c7a4734b3614', NULL, '6d7cb60a-c4ad-4a70-94ae-e5b88eb24930'),
('c71d690a-3dd9-48a5-b76f-32805186c4dc', NULL, 'cfa86cbe-94b6-4712-a40a-a4861be1d425'),
('72f590ae-2754-456b-aabb-eda7d8459dd3', NULL, 'ac1659dc-3ea3-45eb-8ae6-626e3d916492'),
('16439b5f-50c3-4604-97e9-f4004933abd8', NULL, 'f1b55b66-eb13-4a93-a49c-448e93756eb6'),
('e6b64584-94a2-4890-b645-8494a2089011', NULL, '2e372858-f43c-4e1c-b728-58f43c5e1c23');         
CREATE MEMORY TABLE PUBLIC.MAPPINGITEM(
    ID VARCHAR(36) NOT NULL,
    CONNOBJECTKEY INTEGER,
    EXTATTRNAME VARCHAR(255),
    INTATTRNAME VARCHAR(255),
    MANDATORYCONDITION VARCHAR(255),
    PASSWORD INTEGER,
    PROPJEXL VARCHAR(255),
    PULLJEXL VARCHAR(255),
    PURPOSE VARCHAR(20),
    MAPPING_ID VARCHAR(36)
);            
ALTER TABLE PUBLIC.MAPPINGITEM ADD CONSTRAINT PUBLIC.CONSTRAINT_39 PRIMARY KEY(ID);            
-- 70 +/- SELECT COUNT(*) FROM PUBLIC.MAPPINGITEM;             
INSERT INTO PUBLIC.MAPPINGITEM(ID, CONNOBJECTKEY, EXTATTRNAME, INTATTRNAME, MANDATORYCONDITION, PASSWORD, PROPJEXL, PULLJEXL, PURPOSE, MAPPING_ID) VALUES
('96aad4e0-2678-4903-a52f-0a7d090a2863', 1, 'userId', 'username', 'true', 0, NULL, NULL, 'PROPAGATION', 'bc0cf27b-16b7-4e83-a4b0-09af7ea4aacc'),
('7f55b09c-b573-41dc-a9eb-ccd80bd3ea7a', 0, 'email', 'email', 'true', 0, NULL, NULL, 'PROPAGATION', 'bc0cf27b-16b7-4e83-a4b0-09af7ea4aacc'),
('a9749641-0556-49e2-a519-9bec35a4e06e', 0, 'surname', 'surname', 'true', 0, NULL, NULL, 'PROPAGATION', 'bc0cf27b-16b7-4e83-a4b0-09af7ea4aacc'),
('d118671c-2e3e-4aa3-a3dd-fde2ba4c4ded', 0, '__PASSWORD__', 'password', 'true', 1, NULL, NULL, 'PROPAGATION', 'bc0cf27b-16b7-4e83-a4b0-09af7ea4aacc'),
('dca9de4f-9a5a-4280-8e9a-357e321ba7a5', 0, 'fullname', 'surname', 'true', 0, NULL, NULL, 'PROPAGATION', 'bc0cf27b-16b7-4e83-a4b0-09af7ea4aacc'),
('471f0e2e-2bde-4442-9abf-0effb533f2ee', 0, 'type', 'ctype', 'true', 0, NULL, NULL, 'PROPAGATION', 'bc0cf27b-16b7-4e83-a4b0-09af7ea4aacc'),
('72324cda-a66c-4ffe-b6b6-1d9b6cee9bf2', 0, 'name', 'firstname', 'false', 0, NULL, NULL, 'NONE', 'bc0cf27b-16b7-4e83-a4b0-09af7ea4aacc'),
('6f8d7b42-44f4-4697-aff5-1736c4b01ee4', 1, 'email', 'email', 'true', 0, NULL, NULL, 'PROPAGATION', 'bf8afa4a-1522-44b9-91d0-c7b035e4fd99'),
('8515e385-3bf1-4928-adc9-489dee65829a', 0, 'surname', 'surname', 'true', 0, NULL, NULL, 'PROPAGATION', 'bf8afa4a-1522-44b9-91d0-c7b035e4fd99'),
('55a4cf7f-ac96-4e8b-931c-2d0eab6a6bca', 1, 'userId', 'userId', 'true', 0, NULL, NULL, 'PROPAGATION', 'b12c4fad-f0f1-406d-b143-f2d68ed28e3a'),
('d5c4d467-cd18-4148-8195-015808b4b3e6', 1, 'fullname', 'fullname', 'true', 0, NULL, NULL, 'BOTH', '240a0291-f89d-4557-a547-2a3b9aad625b'),
('370a8673-f3f7-4328-a9ce-acd946f687c5', 0, '__PASSWORD__', 'password', 'true', 1, NULL, NULL, 'BOTH', '240a0291-f89d-4557-a547-2a3b9aad625b'),
('c8d1a47a-1846-47b8-9f68-30aa21e94dcc', 0, 'type', 'ctype', 'true', 0, NULL, NULL, 'BOTH', '240a0291-f89d-4557-a547-2a3b9aad625b'),
('f0a06b24-7d4d-480e-8188-e53045885569', 0, 'surname', 'surname', 'type == ''F''', 0, NULL, NULL, 'BOTH', '240a0291-f89d-4557-a547-2a3b9aad625b'),
('adc3c628-27b3-4740-be01-2f83c210ace9', 0, 'name', 'virtualdata', 'type == ''F''', 0, NULL, NULL, 'PROPAGATION', '240a0291-f89d-4557-a547-2a3b9aad625b'),
('6972a78b-2570-45d9-bc0b-31d2f2f9c860', 0, 'fullname', 'cn', 'true', 0, NULL, NULL, 'PROPAGATION', '240a0291-f89d-4557-a547-2a3b9aad625b'),
('cc973ed6-d031-4790-adab-fc059ac0c818', 0, 'email', 'email', 'false', 0, NULL, NULL, 'PROPAGATION', 'c17813c0-4e90-4118-bb28-cd36ad6d5a4d'),
('7a72c812-1897-4db0-bed4-4e7e8ea51afe', 1, 'userId', 'userId', 'false', 0, NULL, NULL, 'PROPAGATION', 'c17813c0-4e90-4118-bb28-cd36ad6d5a4d'),
('946a3c7f-6359-4ab7-8a5f-adb08bdb4b5b', 0, 'test3', 'fullname', 'false', 0, NULL, NULL, 'PROPAGATION', 'c17813c0-4e90-4118-bb28-cd36ad6d5a4d'),
('ffcfbb5e-7bbd-489a-a69e-2dd84f00731a', 1, 'fullname', 'fullname', 'true', 0, NULL, NULL, 'PROPAGATION', '63ddd4c8-efed-4a22-a4b4-1f4e6f47c8d0'),
('e34928b8-ca57-4b6c-81c1-70bc87ff3fdc', 1, 'fullname', 'fullname', 'true', 0, NULL, NULL, 'PROPAGATION', '3f636292-6edb-4d20-ab24-fe0c5fc3dec3'),
('f3ba0859-b0f0-44a5-abfd-4a1a5ca29fbf', 1, 'fullname', 'fullname', 'true', 0, NULL, NULL, 'PROPAGATION', 'c2a0cec1-32c4-4493-8f01-d1176e557fc1'),
('118', 1, 'fullname', 'fullname', 'true', 0, NULL, NULL, 'PROPAGATION', '906452d9-3eeb-4ef7-ac90-5ffc14513fbf'),
('1e0d30cd-2569-4a80-b9dc-af1467bd1c0b', 1, 'ID', 'username', 'true', 0, NULL, NULL, 'BOTH', 'cb624b93-874b-40a0-8021-3b8116b781ab'),
('7fd1a178-77a1-4c4c-aca2-3c3f1834b77b', 0, '__PASSWORD__', 'password', 'true', 1, NULL, NULL, 'BOTH', 'cb624b93-874b-40a0-8021-3b8116b781ab'),
('6d90658a-f470-4450-912d-6fe7d3bcda46', 1, 'ID', 'username', 'true', 0, NULL, NULL, 'PROPAGATION', '935a0fc2-4a0b-4d82-9931-3c5ce44a33c1'),
('2fb9eb01-50df-456e-86c1-b55f68cde2da', 0, '__PASSWORD__', 'password', 'true', 1, NULL, NULL, 'PROPAGATION', '935a0fc2-4a0b-4d82-9931-3c5ce44a33c1'),
('517dc983-99a2-43c9-b4b4-78fd838e5ad1', 0, 'id', 'username', 'true', 0, NULL, NULL, 'BOTH', '538c27dc-d260-4c53-9fc8-bf02ee226911');     
INSERT INTO PUBLIC.MAPPINGITEM(ID, CONNOBJECTKEY, EXTATTRNAME, INTATTRNAME, MANDATORYCONDITION, PASSWORD, PROPJEXL, PULLJEXL, PURPOSE, MAPPING_ID) VALUES
('ba6fb125-466e-4109-8e5d-133936437674', 0, 'id', 'fullname', 'true', 0, NULL, NULL, 'BOTH', '538c27dc-d260-4c53-9fc8-bf02ee226911'),
('c426b070-0290-42be-9ee1-4046c7649635', 0, '__PASSWORD__', 'password', 'true', 1, NULL, NULL, 'BOTH', '538c27dc-d260-4c53-9fc8-bf02ee226911'),
('20dbe358-5b71-4edd-8670-2bbde982e5c4', 0, 'name', 'firstname', 'false', 0, NULL, NULL, 'BOTH', '538c27dc-d260-4c53-9fc8-bf02ee226911'),
('4d70850e-9fc5-4e75-83ea-432fe090e1c0', 0, 'surname', 'surname', 'false', 0, NULL, NULL, 'BOTH', '538c27dc-d260-4c53-9fc8-bf02ee226911'),
('4b2f4292-d8ab-4948-a341-3f8c9e23e72d', 0, 'email', 'userId', 'true', 0, NULL, NULL, 'PULL', '538c27dc-d260-4c53-9fc8-bf02ee226911'),
('20d6c914-54e7-4968-b1fc-685ae9c2c4a4', 0, 'email', 'email', 'true', 0, NULL, NULL, 'PULL', '538c27dc-d260-4c53-9fc8-bf02ee226911'),
('09237f39-0d45-4258-a7cc-2400f7536b72', 1, '__NAME__', 'csvuserid', 'true', 0, NULL, NULL, 'PROPAGATION', '538c27dc-d260-4c53-9fc8-bf02ee226911'),
('63151b89-2eb3-4980-a682-0215d54ab4a2', 0, 'theirgroup', 'groups[root].rderToBePropagated', 'false', 0, NULL, NULL, 'PROPAGATION', '538c27dc-d260-4c53-9fc8-bf02ee226911'),
('608f01c5-eb7c-462a-b4d6-b7c3c9632a50', 1, 'userId', 'userId', 'false', 0, NULL, NULL, 'BOTH', '23e20ce6-1ff9-495e-aa59-a58e5127a008'),
('79ada054-5f8b-4e77-b405-bfec58b06e7b', 0, '__PASSWORD__', 'fullname', 'false', 1, NULL, NULL, 'BOTH', '23e20ce6-1ff9-495e-aa59-a58e5127a008'),
('9ff7d686-452c-4cec-a475-c1137c5d88c7', 1, 'cn', 'username', 'true', 0, NULL, NULL, 'BOTH', 'ae1c77c3-2f1d-4258-ad06-710bb09041a9'),
('73d97083-cfda-44e6-be62-3f9ac558b5eb', 0, '__PASSWORD__', 'password', 'true', 1, NULL, NULL, 'BOTH', 'ae1c77c3-2f1d-4258-ad06-710bb09041a9'),
('cf0a222c-36ea-41e6-987c-7908614ccd23', 0, 'sn', 'surname', 'true', 0, NULL, NULL, 'BOTH', 'ae1c77c3-2f1d-4258-ad06-710bb09041a9'),
('b3a12364-e471-4e37-83ad-476c33a43617', 0, 'cn', 'fullname', 'true', 0, NULL, NULL, 'BOTH', 'ae1c77c3-2f1d-4258-ad06-710bb09041a9'),
('aad2b7d7-3201-4bba-b496-f6587b4b7518', 0, 'mail', 'email', 'false', 0, NULL, NULL, 'BOTH', 'ae1c77c3-2f1d-4258-ad06-710bb09041a9'),
('81b83c98-127b-469b-a497-412ba50acbeb', 0, 'title', 'title', 'false', 0, NULL, NULL, 'BOTH', 'ae1c77c3-2f1d-4258-ad06-710bb09041a9'),
('318e92a1-3acb-49c5-b2fd-dba819c40ef1', 0, 'postalAddress', 'postalAddress', 'false', 0, NULL, NULL, 'BOTH', 'ae1c77c3-2f1d-4258-ad06-710bb09041a9'),
('78fa504f-213c-41ac-a922-7c9f98e5ce11', 0, 'mail', 'userId', 'false', 0, NULL, NULL, 'BOTH', 'ae1c77c3-2f1d-4258-ad06-710bb09041a9'),
('af6085cb-d0e8-47c9-b5f9-4b7d491a9750', 0, 'registeredAddress', 'obscure', 'false', 0, NULL, NULL, 'BOTH', 'ae1c77c3-2f1d-4258-ad06-710bb09041a9'),
('5bb62bd2-5007-4eb8-b4f9-9df8917dc767', 0, 'jpegPhoto', 'photo', 'false', 0, NULL, NULL, 'BOTH', 'ae1c77c3-2f1d-4258-ad06-710bb09041a9'),
('a2bf43c8-74cb-4250-92cf-fb8889409ac1', 1, 'cn', 'name', 'true', 0, NULL, NULL, 'BOTH', '128412c8-be4f-4d7b-8bed-5ab89134f718'),
('da2a69bc-5ca0-4657-9a18-ec1f8c986046', 0, 'owner', 'userOwner', 'false', 0, NULL, NULL, 'BOTH', '128412c8-be4f-4d7b-8bed-5ab89134f718'),
('9dde8bd5-f158-499e-9d81-3d7fcf9ea1e8', 0, 'description', 'title', 'false', 0, NULL, NULL, 'BOTH', '128412c8-be4f-4d7b-8bed-5ab89134f718'),
('1a345706-a498-41bb-a948-820307a4365e', 0, 'EMAIL', 'email', 'false', 0, NULL, NULL, 'BOTH', 'cda910bd-fc28-4f63-890e-66edc62d428b'),
('a234bde8-b431-408c-8ec9-c986c5b7f98d', 0, 'SURNAME', 'fullname', 'false', 0, NULL, NULL, 'PULL', 'cda910bd-fc28-4f63-890e-66edc62d428b'),
('51a856de-ae25-41cd-967a-86920c834b70', 1, 'ID', 'firstname', 'false', 0, NULL, NULL, 'BOTH', 'cda910bd-fc28-4f63-890e-66edc62d428b'),
('f4e5178e-ef37-4949-933a-7ec7eaea64c6', 0, 'SURNAME', 'surname', 'false', 0, NULL, NULL, 'BOTH', 'cda910bd-fc28-4f63-890e-66edc62d428b'),
('3ac0ecaf-d9a1-4fc1-9ae9-84dc34576810', 0, 'USERNAME', 'username', 'false', 0, NULL, NULL, 'BOTH', 'cda910bd-fc28-4f63-890e-66edc62d428b'),
('e7215305-93c9-460b-b862-46f7b60de72d', 0, 'EMAIL', 'userId', 'false', 0, NULL, NULL, 'PULL', 'cda910bd-fc28-4f63-890e-66edc62d428b');  
INSERT INTO PUBLIC.MAPPINGITEM(ID, CONNOBJECTKEY, EXTATTRNAME, INTATTRNAME, MANDATORYCONDITION, PASSWORD, PROPJEXL, PULLJEXL, PURPOSE, MAPPING_ID) VALUES
('fb59d169-cf59-43f6-a517-adfd9aacc609', 0, 'MUSTCHANGEPASSWORD', 'mustChangePassword', 'false', 0, NULL, NULL, 'PULL', 'cda910bd-fc28-4f63-890e-66edc62d428b'),
('6cb2f9f0-5fb4-4686-a375-31e2c34a6cd8', 1, 'ID', 'key', 'true', 0, NULL, NULL, 'BOTH', '45280585-308f-4571-9788-c7a4734b3614'),
('321bc904-e1fc-4a54-bf7c-74c8cbcc0815', 1, 'fullname', 'fullname', 'true', 0, NULL, NULL, 'PROPAGATION', 'c71d690a-3dd9-48a5-b76f-32805186c4dc'),
('4c98536f-10df-4953-b2df-59d7cd057fd2', 1, 'userId', 'username', 'true', 0, NULL, NULL, 'PROPAGATION', '72f590ae-2754-456b-aabb-eda7d8459dd3'),
('23aa0299-ddbb-4e59-8918-0ab2a32465fa', 1, 'ID', 'key', 'true', 0, NULL, NULL, 'BOTH', '16439b5f-50c3-4604-97e9-f4004933abd8'),
('3dc96af0-5d0a-4ec1-be84-244716d88401', 0, 'PRINTERNAME', 'name', 'true', 0, NULL, NULL, 'BOTH', '16439b5f-50c3-4604-97e9-f4004933abd8'),
('f3ef9f8b-e667-4b18-969f-ba98c3d78bc0', 0, 'LOCATION', 'location', 'false', 0, NULL, NULL, 'BOTH', '16439b5f-50c3-4604-97e9-f4004933abd8'),
('14726efb-09e1-441e-b26e-fb09e1841eb2', 0, 'firstName', 'firstname', 'true', 0, NULL, NULL, 'BOTH', 'e6b64584-94a2-4890-b645-8494a2089011'),
('4cdd1fd5-80cd-4fc1-9d1f-d580cd1fc11e', 1, 'key', 'key', 'true', 0, NULL, NULL, 'BOTH', 'e6b64584-94a2-4890-b645-8494a2089011'),
('4d7581b5-fe9b-49e6-b581-b5fe9bf9e60b', 0, '__PASSWORD__', 'password', 'true', 1, NULL, NULL, 'BOTH', 'e6b64584-94a2-4890-b645-8494a2089011'),
('98f96cf4-fba2-4c68-b96c-f4fba2fc6834', 0, 'username', 'username', 'true', 0, NULL, NULL, 'BOTH', 'e6b64584-94a2-4890-b645-8494a2089011'),
('f3312f8f-1c94-493a-b12f-8f1c94093aa9', 0, 'email', 'email', 'true', 0, NULL, NULL, 'BOTH', 'e6b64584-94a2-4890-b645-8494a2089011'),
('ff49e982-fe60-4c1e-89e9-82fe60dc1ef9', 0, 'surname', 'surname', 'true', 0, NULL, NULL, 'BOTH', 'e6b64584-94a2-4890-b645-8494a2089011');           
CREATE MEMORY TABLE PUBLIC.MAPPINGITEM_TRANSFORMER(
    MAPPINGITEM_ID VARCHAR(36),
    TRANSFORMERCLASSNAME VARCHAR(255)
);   
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.MAPPINGITEM_TRANSFORMER;  
CREATE MEMORY TABLE PUBLIC.NOTIFICATION(
    ID VARCHAR(36) NOT NULL,
    ACTIVE INTEGER,
    RECIPIENTATTRNAME VARCHAR(255),
    RECIPIENTSFIQL VARCHAR(255),
    RECIPIENTSPROVIDERCLASSNAME VARCHAR(255),
    SELFASRECIPIENT INTEGER,
    SENDER VARCHAR(255),
    SUBJECT VARCHAR(255),
    TRACELEVEL VARCHAR(20),
    TEMPLATE_ID VARCHAR(255)
);       
ALTER TABLE PUBLIC.NOTIFICATION ADD CONSTRAINT PUBLIC.CONSTRAINT_AD PRIMARY KEY(ID);           
-- 3 +/- SELECT COUNT(*) FROM PUBLIC.NOTIFICATION;             
INSERT INTO PUBLIC.NOTIFICATION(ID, ACTIVE, RECIPIENTATTRNAME, RECIPIENTSFIQL, RECIPIENTSPROVIDERCLASSNAME, SELFASRECIPIENT, SENDER, SUBJECT, TRACELEVEL, TEMPLATE_ID) VALUES
('e00945b5-1184-4d43-8e45-4318a8dcdfd4', 1, 'email', NULL, NULL, 1, 'admin@syncope.apache.org', 'Password Reset request', 'FAILURES', 'requestPasswordReset'),
('bef0c250-e8a7-4848-bb63-2564fc409ce2', 1, 'email', NULL, NULL, 1, 'admin@syncope.apache.org', 'Password Reset successful', 'FAILURES', 'confirmPasswordReset'),
('9e2b911c-25de-4c77-bcea-b86ed9451050', 1, 'email', '$groups==7', NULL, 0, 'test@syncope.apache.org', 'Test subject', 'FAILURES', 'test');     
CREATE MEMORY TABLE PUBLIC.NOTIFICATIONTASK_RECIPIENTS(
    NOTIFICATIONTASK_ID VARCHAR(36),
    ADDRESS VARCHAR(255)
);       
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.NOTIFICATIONTASK_RECIPIENTS;              
INSERT INTO PUBLIC.NOTIFICATIONTASK_RECIPIENTS(NOTIFICATIONTASK_ID, ADDRESS) VALUES
('e1e520f0-2cbd-4e11-9a89-ea58a0f957e7', 'recipient@prova.org');           
CREATE MEMORY TABLE PUBLIC.NOTIFICATION_EVENTS(
    NOTIFICATION_ID VARCHAR(36),
    EVENT VARCHAR(255)
);     
-- 4 +/- SELECT COUNT(*) FROM PUBLIC.NOTIFICATION_EVENTS;      
INSERT INTO PUBLIC.NOTIFICATION_EVENTS(NOTIFICATION_ID, EVENT) VALUES
('e00945b5-1184-4d43-8e45-4318a8dcdfd4', '[CUSTOM]:[]:[]:[requestPasswordReset]:[SUCCESS]'),
('bef0c250-e8a7-4848-bb63-2564fc409ce2', '[CUSTOM]:[]:[]:[confirmPasswordReset]:[SUCCESS]'),
('9e2b911c-25de-4c77-bcea-b86ed9451050', '[CUSTOM]:[]:[]:[unexisting1]:[FAILURE]'),
('9e2b911c-25de-4c77-bcea-b86ed9451050', '[CUSTOM]:[]:[]:[unexisting2]:[SUCCESS]');        
CREATE MEMORY TABLE PUBLIC.NOTIFICATION_STATICRECIPIENTS(
    NOTIFICATION_ID VARCHAR(36),
    STATICRECIPIENTS VARCHAR(255)
);
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.NOTIFICATION_STATICRECIPIENTS;            
CREATE MEMORY TABLE PUBLIC.OIDCPROVIDER(
    ID VARCHAR(36) NOT NULL,
    AUTHORIZATIONENDPOINT VARCHAR(255) NOT NULL,
    CLIENTID VARCHAR(255) NOT NULL,
    CLIENTSECRET VARCHAR(255) NOT NULL,
    CREATEUNMATCHING INTEGER NOT NULL,
    ENDSESSIONENDPOINT VARCHAR(255),
    HASDISCOVERY BOOLEAN NOT NULL,
    ISSUER VARCHAR(255) NOT NULL,
    JWKSURI VARCHAR(255) NOT NULL,
    NAME VARCHAR(255) NOT NULL,
    SELFREGUNMATCHING INTEGER NOT NULL,
    TOKENENDPOINT VARCHAR(255) NOT NULL,
    UPDATEMATCHING INTEGER NOT NULL,
    USERINFOENDPOINT VARCHAR(255)
);              
ALTER TABLE PUBLIC.OIDCPROVIDER ADD CONSTRAINT PUBLIC.CONSTRAINT_7 PRIMARY KEY(ID);            
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.OIDCPROVIDER;             
CREATE MEMORY TABLE PUBLIC.OIDCPROVIDERITEM(
    ID VARCHAR(36) NOT NULL,
    CONNOBJECTKEY INTEGER,
    EXTATTRNAME VARCHAR(255),
    INTATTRNAME VARCHAR(255),
    MANDATORYCONDITION VARCHAR(255),
    PASSWORD INTEGER,
    PROPJEXL VARCHAR(255),
    PULLJEXL VARCHAR(255),
    PURPOSE VARCHAR(20),
    OP_ID VARCHAR(36)
);            
ALTER TABLE PUBLIC.OIDCPROVIDERITEM ADD CONSTRAINT PUBLIC.CONSTRAINT_17F PRIMARY KEY(ID);      
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.OIDCPROVIDERITEM;         
CREATE MEMORY TABLE PUBLIC.OIDCPROVIDERITEM_TRANSFORMER(
    OIDCPROVIDERITEMITEM_ID VARCHAR(36),
    TRANSFORMERCLASSNAME VARCHAR(255)
);     
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.OIDCPROVIDERITEM_TRANSFORMER;             
CREATE MEMORY TABLE PUBLIC.OIDCPROVIDER_ACTIONSCLASSNAMES(
    OIDCOP_ID VARCHAR(36),
    ACTIONCLASSNAME VARCHAR(255)
);      
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.OIDCPROVIDER_ACTIONSCLASSNAMES;           
CREATE MEMORY TABLE PUBLIC.OIDCUSERTEMPLATE(
    ID VARCHAR(36) NOT NULL,
    TEMPLATE CLOB,
    OP_ID VARCHAR(36),
    ANYTYPE_ID VARCHAR(255)
);             
ALTER TABLE PUBLIC.OIDCUSERTEMPLATE ADD CONSTRAINT PUBLIC.CONSTRAINT_B0 PRIMARY KEY(ID);       
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.OIDCUSERTEMPLATE;         
CREATE MEMORY TABLE PUBLIC.ORGUNIT(
    ID VARCHAR(36) NOT NULL,
    CONNOBJECTLINK VARCHAR(255),
    OBJECTCLASS VARCHAR(255),
    SERIALIZEDSYNCTOKEN CLOB,
    RESOURCE_ID VARCHAR(255)
);  
ALTER TABLE PUBLIC.ORGUNIT ADD CONSTRAINT PUBLIC.CONSTRAINT_E3 PRIMARY KEY(ID);
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.ORGUNIT;  
INSERT INTO PUBLIC.ORGUNIT(ID, CONNOBJECTLINK, OBJECTCLASS, SERIALIZEDSYNCTOKEN, RESOURCE_ID) VALUES
('599a59cf-9a23-4447-9a59-cf9a2334473a', 'syncope:fullPath2Dn(fullPath, ''ou'') + '',o=isp''', 'organizationalUnit', NULL, 'resource-ldap-orgunit');      
CREATE MEMORY TABLE PUBLIC.ORGUNITITEM(
    ID VARCHAR(36) NOT NULL,
    CONNOBJECTKEY INTEGER,
    EXTATTRNAME VARCHAR(255),
    INTATTRNAME VARCHAR(255),
    MANDATORYCONDITION VARCHAR(255),
    PASSWORD INTEGER,
    PROPJEXL VARCHAR(255),
    PULLJEXL VARCHAR(255),
    PURPOSE VARCHAR(20),
    ORGUNIT_ID VARCHAR(36)
);            
ALTER TABLE PUBLIC.ORGUNITITEM ADD CONSTRAINT PUBLIC.CONSTRAINT_6E PRIMARY KEY(ID);            
-- 2 +/- SELECT COUNT(*) FROM PUBLIC.ORGUNITITEM;              
INSERT INTO PUBLIC.ORGUNITITEM(ID, CONNOBJECTKEY, EXTATTRNAME, INTATTRNAME, MANDATORYCONDITION, PASSWORD, PROPJEXL, PULLJEXL, PURPOSE, ORGUNIT_ID) VALUES
('5d0e7ad0-9026-42ad-be8a-32539389e7bd', 1, 'l', 'fullpath', 'true', NULL, NULL, NULL, 'BOTH', '599a59cf-9a23-4447-9a59-cf9a2334473a'),
('1df556d3-bc23-48b7-a09b-fc3794a00019', 0, 'ou', 'name', 'true', NULL, NULL, NULL, 'BOTH', '599a59cf-9a23-4447-9a59-cf9a2334473a');         
CREATE MEMORY TABLE PUBLIC.ORGUNITITEM_TRANSFORMER(
    ORGUNITITEM_ID VARCHAR(36),
    TRANSFORMERCLASSNAME VARCHAR(255)
);   
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ORGUNITITEM_TRANSFORMER;  
CREATE MEMORY TABLE PUBLIC.PASSWORDPOLICY(
    ID VARCHAR(36) NOT NULL,
    DESCRIPTION VARCHAR(255),
    ALLOWNULLPASSWORD INTEGER,
    HISTORYLENGTH INTEGER
);              
ALTER TABLE PUBLIC.PASSWORDPOLICY ADD CONSTRAINT PUBLIC.CONSTRAINT_8F PRIMARY KEY(ID);         
-- 3 +/- SELECT COUNT(*) FROM PUBLIC.PASSWORDPOLICY;           
INSERT INTO PUBLIC.PASSWORDPOLICY(ID, DESCRIPTION, ALLOWNULLPASSWORD, HISTORYLENGTH) VALUES
('ce93fcda-dc3a-4369-a7b0-a6108c261c85', 'a password policy', 1, 1),
('986d1236-3ac5-4a19-810c-5ab21d79cba1', 'sample password policy', 1, 0),
('55e5de0b-c79c-4e66-adda-251b6fb8579a', 'sample password policy', 0, 0);           
CREATE MEMORY TABLE PUBLIC.PASSWORDRULECONFINSTANCE(
    ID VARCHAR(36) NOT NULL,
    SERIALIZEDINSTANCE CLOB,
    PASSWORDPOLICY_ID VARCHAR(36)
);            
ALTER TABLE PUBLIC.PASSWORDRULECONFINSTANCE ADD CONSTRAINT PUBLIC.CONSTRAINT_8A PRIMARY KEY(ID);               
-- 3 +/- SELECT COUNT(*) FROM PUBLIC.PASSWORDRULECONFINSTANCE; 
INSERT INTO PUBLIC.PASSWORDRULECONFINSTANCE(ID, SERIALIZEDINSTANCE, PASSWORDPOLICY_ID) VALUES
('2e3fb762-d37a-46c6-a2e5-662b527dead3', '{"@class":"org.apache.syncope.common.lib.policy.DefaultPasswordRuleConf","maxLength":0,"minLength":8,"nonAlphanumericRequired":false,"alphanumericRequired":false,"digitRequired":false,"lowercaseRequired":false,"uppercaseRequired":false,"mustStartWithDigit":false,"mustntStartWithDigit":false,"mustEndWithDigit":false,"mustntEndWithDigit":false,"mustStartWithNonAlpha":false,"mustStartWithAlpha":false,"mustntStartWithNonAlpha":false,"mustntStartWithAlpha":false,"mustEndWithNonAlpha":false,"mustEndWithAlpha":false,"mustntEndWithNonAlpha":false,"mustntEndWithAlpha":false,"wordsNotPermitted":[],"schemasNotPermitted":[],"prefixesNotPermitted":["notpermitted1","notpermitted2"],"suffixesNotPermitted":[]}', 'ce93fcda-dc3a-4369-a7b0-a6108c261c85'),
('62fe25b4-9124-4f01-9bc4-0013399da893', '{"@class":"org.apache.syncope.common.lib.policy.DefaultPasswordRuleConf","maxLength":0,"minLength":10,"nonAlphanumericRequired":false,"alphanumericRequired":false,"digitRequired":true,"lowercaseRequired":false,"uppercaseRequired":false,"mustStartWithDigit":false,"mustntStartWithDigit":false,"mustEndWithDigit":false,"mustntEndWithDigit":false,"mustStartWithNonAlpha":false,"mustStartWithAlpha":false,"mustntStartWithNonAlpha":false,"mustntStartWithAlpha":false,"mustEndWithNonAlpha":false,"mustEndWithAlpha":false,"mustntEndWithNonAlpha":false,"mustntEndWithAlpha":false,"wordsNotPermitted":[],"schemasNotPermitted":[],"prefixesNotPermitted":["notpermitted1","notpermitted2"],"suffixesNotPermitted":[]}', '986d1236-3ac5-4a19-810c-5ab21d79cba1'),
('69b9d9fb-b37b-48f0-adba-5080f4768a8f', '{"@class":"org.apache.syncope.common.lib.policy.DefaultPasswordRuleConf","maxLength":0,"minLength":10,"nonAlphanumericRequired":true,"alphanumericRequired":false,"digitRequired":true,"lowercaseRequired":true,"uppercaseRequired":true,"mustStartWithDigit":true,"mustntStartWithDigit":false,"mustEndWithDigit":true,"mustntEndWithDigit":false,"mustStartWithNonAlpha":false,"mustStartWithAlpha":false,"mustntStartWithNonAlpha":false,"mustntStartWithAlpha":false,"mustEndWithNonAlpha":false,"mustEndWithAlpha":false,"mustntEndWithNonAlpha":false,"mustntEndWithAlpha":false,"wordsNotPermitted":[],"schemasNotPermitted":[],"prefixesNotPermitted":["notpermitted1","notpermitted2"],"suffixesNotPermitted":[]}', '55e5de0b-c79c-4e66-adda-251b6fb8579a');        
CREATE MEMORY TABLE PUBLIC.PLAINSCHEMA(
    ID VARCHAR(255) NOT NULL,
    CIPHERALGORITHM VARCHAR(20),
    CONVERSIONPATTERN VARCHAR(255),
    ENUMERATIONKEYS CLOB,
    ENUMERATIONVALUES CLOB,
    MANDATORYCONDITION VARCHAR(255),
    MIMETYPE VARCHAR(255),
    MULTIVALUE INTEGER,
    READONLY INTEGER,
    SECRETKEY VARCHAR(255),
    TYPE VARCHAR(20),
    UNIQUECONSTRAINT INTEGER,
    VALIDATORCLASS VARCHAR(255),
    ANYTYPECLASS_ID VARCHAR(255)
);            
ALTER TABLE PUBLIC.PLAINSCHEMA ADD CONSTRAINT PUBLIC.CONSTRAINT_175 PRIMARY KEY(ID);           
-- 42 +/- SELECT COUNT(*) FROM PUBLIC.PLAINSCHEMA;             
INSERT INTO PUBLIC.PLAINSCHEMA(ID, CIPHERALGORITHM, CONVERSIONPATTERN, ENUMERATIONKEYS, ENUMERATIONVALUES, MANDATORYCONDITION, MIMETYPE, MULTIVALUE, READONLY, SECRETKEY, TYPE, UNIQUECONSTRAINT, VALIDATORCLASS, ANYTYPECLASS_ID) VALUES
('password.cipher.algorithm', NULL, NULL, NULL, NULL, 'true', NULL, 0, 0, NULL, 'String', 0, NULL, NULL),
('notificationjob.cronExpression', NULL, NULL, NULL, NULL, 'false', NULL, 0, 0, NULL, 'String', 0, NULL, NULL),
('notification.maxRetries', NULL, NULL, NULL, NULL, 'true', NULL, 0, 0, NULL, 'Long', 0, NULL, NULL),
('token.length', NULL, NULL, NULL, NULL, 'true', NULL, 0, 0, NULL, 'Long', 0, NULL, NULL),
('token.expireTime', NULL, NULL, NULL, NULL, 'true', NULL, 0, 0, NULL, 'Long', 0, NULL, NULL),
('selfRegistration.allowed', NULL, NULL, NULL, NULL, 'true', NULL, 0, 0, NULL, 'Boolean', 0, NULL, NULL),
('passwordReset.allowed', NULL, NULL, NULL, NULL, 'true', NULL, 0, 0, NULL, 'Boolean', 0, NULL, NULL),
('passwordReset.securityQuestion', NULL, NULL, NULL, NULL, 'true', NULL, 0, 0, NULL, 'Boolean', 0, NULL, NULL),
('authentication.attributes', NULL, NULL, NULL, NULL, NULL, NULL, 1, 0, NULL, 'String', 0, NULL, NULL),
('authentication.statuses', NULL, NULL, NULL, NULL, NULL, NULL, 1, 0, NULL, 'String', 0, NULL, NULL),
('log.lastlogindate', NULL, NULL, NULL, NULL, 'true', NULL, 0, 0, NULL, 'Boolean', 0, NULL, NULL),
('return.password.value', NULL, NULL, NULL, NULL, 'false', NULL, 0, 0, NULL, 'Boolean', 0, NULL, NULL),
('jwt.lifetime.minutes', NULL, NULL, NULL, NULL, 'true', NULL, 0, 0, NULL, 'Long', 0, NULL, NULL),
('connector.conf.history.size', NULL, NULL, NULL, NULL, 'true', NULL, 0, 0, NULL, 'Long', 0, NULL, NULL),
('resource.conf.history.size', NULL, NULL, NULL, NULL, 'true', NULL, 0, 0, NULL, 'Long', 0, NULL, NULL),
('fullname', NULL, NULL, NULL, NULL, 'true', NULL, 0, 0, NULL, 'String', 1, NULL, 'minimal user'),
('userId', NULL, NULL, NULL, NULL, 'true', NULL, 0, 0, NULL, 'String', 1, 'org.apache.syncope.core.persistence.jpa.attrvalue.validation.EmailAddressValidator', 'minimal user'),
('loginDate', NULL, 'yyyy-MM-dd', NULL, NULL, 'false', NULL, 1, 0, NULL, 'Date', 0, NULL, 'other'),
('firstname', NULL, NULL, NULL, NULL, 'false', NULL, 0, 0, NULL, 'String', 0, NULL, 'minimal user'),
('surname', NULL, NULL, NULL, NULL, 'true', NULL, 0, 0, NULL, 'String', 0, NULL, 'minimal user'),
('ctype', NULL, NULL, NULL, NULL, 'false', NULL, 0, 0, NULL, 'String', 0, NULL, 'other'),
('email', NULL, NULL, NULL, NULL, 'false', NULL, 0, 0, NULL, 'String', 0, 'org.apache.syncope.core.persistence.jpa.attrvalue.validation.EmailAddressValidator', 'minimal user'),
('activationDate', NULL, 'yyyy-MM-dd''T''HH:mm:ss.SSSZ', NULL, NULL, 'false', NULL, 0, 0, NULL, 'Date', 0, NULL, 'other'),
('uselessReadonly', NULL, NULL, NULL, NULL, 'false', NULL, 0, 1, NULL, 'String', 0, NULL, 'other'),
('cool', NULL, NULL, NULL, NULL, 'false', NULL, 0, 0, NULL, 'Boolean', 0, NULL, 'other'),
('gender', NULL, NULL, NULL, 'M;F', 'false', NULL, 0, 0, NULL, 'Enum', 0, NULL, 'other'),
('aLong', NULL, NULL, NULL, NULL, 'false', NULL, 0, 0, NULL, 'Long', 0, NULL, 'other'),
('makeItDouble', NULL, NULL, NULL, NULL, 'false', NULL, 0, 0, NULL, 'Long', 0, NULL, 'other'),
('obscure', 'SHA', NULL, NULL, NULL, 'false', NULL, 0, 0, '7abcdefghilmnopqrstuvz9#', 'Encrypted', 0, NULL, 'other'),
('photo', NULL, NULL, NULL, NULL, 'false', 'image/jpeg', 0, 0, NULL, 'Binary', 0, NULL, 'other'),
('icon', NULL, NULL, NULL, NULL, 'false', NULL, 0, 0, NULL, 'String', 0, NULL, 'minimal group'),
('show', NULL, NULL, NULL, NULL, 'false', NULL, 0, 0, NULL, 'Boolean', 0, NULL, 'minimal group'),
('rderived_sx', NULL, NULL, NULL, NULL, 'false', NULL, 0, 0, NULL, 'String', 0, NULL, 'minimal group'),
('rderived_dx', NULL, NULL, NULL, NULL, 'false', NULL, 0, 0, NULL, 'String', 0, NULL, 'minimal group'),
('title', NULL, NULL, NULL, NULL, 'false', NULL, 1, 0, NULL, 'String', 0, NULL, 'minimal group'),
('subscriptionDate', NULL, 'yyyy-MM-dd''T''HH:mm:ss.SSSZ', NULL, NULL, 'false', NULL, 0, 0, NULL, 'Date', 0, NULL, 'generic membership');            
INSERT INTO PUBLIC.PLAINSCHEMA(ID, CIPHERALGORITHM, CONVERSIONPATTERN, ENUMERATIONKEYS, ENUMERATIONVALUES, MANDATORYCONDITION, MIMETYPE, MULTIVALUE, READONLY, SECRETKEY, TYPE, UNIQUECONSTRAINT, VALIDATORCLASS, ANYTYPECLASS_ID) VALUES
('mderived_sx', NULL, NULL, NULL, NULL, 'false', NULL, 0, 0, NULL, 'String', 0, NULL, 'generic membership'),
('mderived_dx', NULL, NULL, NULL, NULL, 'false', NULL, 0, 0, NULL, 'String', 0, NULL, 'generic membership'),
('postalAddress', NULL, NULL, NULL, NULL, 'false', NULL, 0, 0, NULL, 'String', 0, NULL, 'generic membership'),
('model', NULL, NULL, NULL, NULL, 'false', NULL, 0, 0, NULL, 'String', 0, NULL, 'minimal printer'),
('location', NULL, NULL, NULL, NULL, 'false', NULL, 0, 0, NULL, 'String', 0, NULL, 'minimal printer');  
CREATE MEMORY TABLE PUBLIC.PROVISION(
    ID VARCHAR(36) NOT NULL,
    OBJECTCLASS VARCHAR(255),
    SERIALIZEDSYNCTOKEN CLOB,
    ANYTYPE_ID VARCHAR(255),
    RESOURCE_ID VARCHAR(255)
);    
ALTER TABLE PUBLIC.PROVISION ADD CONSTRAINT PUBLIC.CONSTRAINT_85 PRIMARY KEY(ID);              
-- 21 +/- SELECT COUNT(*) FROM PUBLIC.PROVISION;               
INSERT INTO PUBLIC.PROVISION(ID, OBJECTCLASS, SERIALIZEDSYNCTOKEN, ANYTYPE_ID, RESOURCE_ID) VALUES
('209ea85f-f964-49c7-a498-6c9c2baa3bd8', '__ACCOUNT__', NULL, 'USER', 'ws-target-resource-1'),
('41a53a00-0b35-4047-831a-d5238f74c7ba', '__ACCOUNT__', NULL, 'USER', 'ws-target-resource-list-mappings-1'),
('09a65250-d9de-44b1-9412-11ed996d356d', '__ACCOUNT__', NULL, 'USER', 'ws-target-resource-list-mappings-2'),
('3d75991b-caee-4993-8e46-afb13d1bfbd4', '__ACCOUNT__', NULL, 'USER', 'ws-target-resource-2'),
('9ebc3237-49fa-4dce-9a4c-3070e931812f', '__ACCOUNT__', NULL, 'USER', 'ws-target-resource-update'),
('8680bc79-dfa1-4719-9886-1d582bf1124f', '__ACCOUNT__', NULL, 'USER', 'ws-target-resource-nopropagation'),
('0bfa7c3e-2bb3-43d7-ac0e-d57cff7a18c8', '__ACCOUNT__', NULL, 'USER', 'ws-target-resource-nopropagation2'),
('5bd76fec-f8d7-4ab9-acd7-89e099d534e8', '__ACCOUNT__', NULL, 'USER', 'ws-target-resource-nopropagation3'),
('18de6376-7051-4216-96f0-26629076abb9', '__ACCOUNT__', NULL, 'USER', 'ws-target-resource-nopropagation4'),
('779fefb5-dd25-4078-915d-3c199ee32158', '__ACCOUNT__', NULL, 'USER', 'resource-testdb'),
('0359084d-68fe-4bf8-b42b-2ebe4f578ae7', '__ACCOUNT__', NULL, 'USER', 'resource-testdb2'),
('2adb6537-e207-4d9b-804f-90bf18cd6f48', '__ACCOUNT__', NULL, 'USER', 'resource-csv'),
('1b53c74e-6a63-49ef-b2f1-96eeb7f1bbb8', '__ACCOUNT__', '{"value":null}', 'USER', 'ws-target-resource-update-resetsynctoken'),
('8b938d63-aa92-448c-89a8-a685fc0a67c8', '__ACCOUNT__', NULL, 'USER', 'resource-ldap'),
('20a75199-3f2e-4b9a-9510-c68dd7fc7b3d', '__GROUP__', NULL, 'GROUP', 'resource-ldap'),
('46b54e2a-e43e-4cd7-8c13-1af1bd65c3d3', '__ACCOUNT__', NULL, 'USER', 'resource-db-pull'),
('6d7cb60a-c4ad-4a70-94ae-e5b88eb24930', '__ACCOUNT__', NULL, 'USER', 'resource-db-virattr'),
('cfa86cbe-94b6-4712-a40a-a4861be1d425', '__ACCOUNT__', NULL, 'USER', 'ws-target-resource-timeout'),
('ac1659dc-3ea3-45eb-8ae6-626e3d916492', '__ACCOUNT__', NULL, 'USER', 'ws-target-resource-delete'),
('f1b55b66-eb13-4a93-a49c-448e93756eb6', '__PRINTER__', NULL, 'PRINTER', 'resource-db-scripted'),
('2e372858-f43c-4e1c-b728-58f43c5e1c23', '__ACCOUNT__', NULL, 'USER', 'rest-target-resource');     
CREATE MEMORY TABLE PUBLIC.PROVISION_ANYTYPECLASS(
    PROVISION_ID VARCHAR(36),
    ANYTYPECLASS_ID VARCHAR(255)
);           
-- 5 +/- SELECT COUNT(*) FROM PUBLIC.PROVISION_ANYTYPECLASS;   
INSERT INTO PUBLIC.PROVISION_ANYTYPECLASS(PROVISION_ID, ANYTYPECLASS_ID) VALUES
('2adb6537-e207-4d9b-804f-90bf18cd6f48', 'csv'),
('2adb6537-e207-4d9b-804f-90bf18cd6f48', 'generic membership'),
('2adb6537-e207-4d9b-804f-90bf18cd6f48', 'minimal group'),
('8b938d63-aa92-448c-89a8-a685fc0a67c8', 'generic membership'),
('8b938d63-aa92-448c-89a8-a685fc0a67c8', 'minimal group');         
CREATE MEMORY TABLE PUBLIC.PULLPOLICY(
    ID VARCHAR(36) NOT NULL,
    DESCRIPTION VARCHAR(255),
    SPECIFICATION CLOB
);    
ALTER TABLE PUBLIC.PULLPOLICY ADD CONSTRAINT PUBLIC.CONSTRAINT_A9 PRIMARY KEY(ID);             
-- 4 +/- SELECT COUNT(*) FROM PUBLIC.PULLPOLICY;               
INSERT INTO PUBLIC.PULLPOLICY(ID, DESCRIPTION, SPECIFICATION) VALUES
('66691e96-285f-4464-bc19-e68384ea4c85', 'a pull policy', '{"conflictResolutionAction":"IGNORE"}'),
('880f8553-069b-4aed-9930-2cd53873f544', 'another pull policy', '{"conflictResolutionAction":"ALL","correlationRules":{"USER":["username","firstname"]}}'),
('4ad10d94-e002-4b3f-b771-16089cc71da9', 'pull policy 1', '{"conflictResolutionAction":"IGNORE"}'),
('9454b0d7-2610-400a-be82-fc23cf553dd6', 'pull policy for java rule', '{"conflictResolutionAction":"IGNORE", "correlationRules":{"USER":"org.apache.syncope.fit.core.reference.TestPullRule"}}'); 
CREATE MEMORY TABLE PUBLIC.PULLTASK_ACTIONSCLASSNAMES(
    PULLTASK_ID VARCHAR(36),
    ACTIONCLASSNAME VARCHAR(255)
);        
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.PULLTASK_ACTIONSCLASSNAMES;               
INSERT INTO PUBLIC.PULLTASK_ACTIONSCLASSNAMES(PULLTASK_ID, ACTIONCLASSNAME) VALUES
('1e419ca4-ea81-4493-a14f-28b90113686d', 'org.apache.syncope.core.provisioning.java.pushpull.LDAPMembershipPullActions');   
CREATE MEMORY TABLE PUBLIC.PUSHPOLICY(
    ID VARCHAR(36) NOT NULL,
    DESCRIPTION VARCHAR(255),
    SPECIFICATION CLOB
);    
ALTER TABLE PUBLIC.PUSHPOLICY ADD CONSTRAINT PUBLIC.CONSTRAINT_AD6 PRIMARY KEY(ID);            
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.PUSHPOLICY;               
CREATE MEMORY TABLE PUBLIC.PUSHTASKANYFILTER(
    ID VARCHAR(36) NOT NULL,
    FIQL VARCHAR(255),
    ANYTYPE_ID VARCHAR(255),
    PUSHTASK_ID VARCHAR(36)
);  
ALTER TABLE PUBLIC.PUSHTASKANYFILTER ADD CONSTRAINT PUBLIC.CONSTRAINT_FD PRIMARY KEY(ID);      
-- 22 +/- SELECT COUNT(*) FROM PUBLIC.PUSHTASKANYFILTER;       
INSERT INTO PUBLIC.PUSHTASKANYFILTER(ID, FIQL, ANYTYPE_ID, PUSHTASK_ID) VALUES
('1fdcff65-765f-4a6e-98a7-13ef7cca47e2', 'surname==Vivaldi', 'USER', 'af558be4-9d2f-4359-bf85-a554e6e90be1'),
('3b564c51-5d64-48b3-8da5-fd4ebc10e0a8', 'name==_NO_ONE_', 'GROUP', 'af558be4-9d2f-4359-bf85-a554e6e90be1'),
('199efd21-5e89-46ac-95de-f47e9d0569fc', 'surname==Bellini', 'USER', '97f327b6-2eff-4d35-85e8-d581baaab855'),
('7672a167-77d6-4639-8b1d-0af561293c7d', 'name==_NO_ONE_', 'GROUP', '97f327b6-2eff-4d35-85e8-d581baaab855'),
('39a11ba6-397a-4c94-8bfe-1f4f757d6501', 'surname==Puccini', 'USER', '03aa2a04-4881-4573-9117-753f81b04865'),
('5bd7501e-8a18-4fbd-a3fe-a1e731ba95db', 'name==_NO_ONE_', 'GROUP', '03aa2a04-4881-4573-9117-753f81b04865'),
('0d0371a3-5772-4b4c-ad14-139adf1d346a', 'surname==Verdi', 'USER', '5e5f7c7e-9de7-4c6a-99f1-4df1af959807'),
('2e7488ae-a2fc-4657-a93b-159b8433c0e7', 'name==_NO_ONE_', 'GROUP', '5e5f7c7e-9de7-4c6a-99f1-4df1af959807'),
('41bf22fe-a014-41af-9a75-402b987eb433', 'username==_NO_ONE_', 'USER', '0bc11a19-6454-45c2-a4e3-ceef84e5d79b'),
('fa983fde-795e-4c89-a6f7-1ccd80a8adeb', 'name==_NO_ONE_', 'GROUP', '0bc11a19-6454-45c2-a4e3-ceef84e5d79b'),
('e238a6dc-0b04-46cf-9bfa-be68bd9f2da0', 'surname==Verdi', 'USER', 'ec674143-480a-4816-98ad-b61fa090821e'),
('0eaa643e-0add-4c46-8273-539f9d6abec5', 'name==_NO_ONE_', 'GROUP', 'ec674143-480a-4816-98ad-b61fa090821e'),
('335b4f11-589a-44c5-80b0-ba94892f0c62', 'surname==Rossini', 'USER', 'c46edc3a-a18b-4af2-b707-f4a415507496'),
('b32eecc2-aa4f-43c6-a501-a692c3e93113', 'name==_NO_ONE_', 'GROUP', 'c46edc3a-a18b-4af2-b707-f4a415507496'),
('9f974a0d-87d8-4cae-9ea9-1fc245bc1dbf', 'surname==Verdi', 'USER', '51318433-cce4-4f71-8f45-9534b6c9c819'),
('0dc46ba4-1270-4fa9-b3e1-79f940d4308f', 'name==_NO_ONE_', 'GROUP', '51318433-cce4-4f71-8f45-9534b6c9c819'),
('3aa3b0b8-7469-4859-89d5-476ae5915101', 'surname==Verdi', 'USER', '24b1be9c-7e3b-443a-86c9-798ebce5eaf2'),
('f054810e-6842-4017-8f60-5b4031fa2c72', 'name==_NO_ONE_', 'GROUP', '24b1be9c-7e3b-443a-86c9-798ebce5eaf2'),
('95f047fc-1a8a-45f4-b56c-6e04d8ca5567', 'surname==Verdi', 'USER', '375c7b7f-9e3a-4833-88c9-b7787b0a69f2'),
('013a4298-4b14-4f8b-9f59-191c2d53dbd8', 'name==_NO_ONE_', 'GROUP', '375c7b7f-9e3a-4833-88c9-b7787b0a69f2'),
('30842acc-f2dd-4d47-b359-20db06c30803', 'username==_NO_ONE_', 'USER', 'fd905ba5-9d56-4f51-83e2-859096a67b75'),
('9e4c0233-440e-4b5b-9563-11ec0f55a334', 'name==citizen', 'GROUP', 'fd905ba5-9d56-4f51-83e2-859096a67b75');               
CREATE MEMORY TABLE PUBLIC.PUSHTASK_ACTIONSCLASSNAMES(
    PUSHTASK_ID VARCHAR(36),
    ACTIONCLASSNAME VARCHAR(255)
);        
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.PUSHTASK_ACTIONSCLASSNAMES;               
CREATE MEMORY TABLE PUBLIC.REALM(
    ID VARCHAR(36) NOT NULL,
    NAME VARCHAR(255),
    ACCOUNTPOLICY_ID VARCHAR(36),
    PARENT_ID VARCHAR(36),
    PASSWORDPOLICY_ID VARCHAR(36)
);        
ALTER TABLE PUBLIC.REALM ADD CONSTRAINT PUBLIC.CONSTRAINT_4A PRIMARY KEY(ID);  
-- 4 +/- SELECT COUNT(*) FROM PUBLIC.REALM;    
INSERT INTO PUBLIC.REALM(ID, NAME, ACCOUNTPOLICY_ID, PARENT_ID, PASSWORDPOLICY_ID) VALUES
('e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', '/', NULL, NULL, '986d1236-3ac5-4a19-810c-5ab21d79cba1'),
('722f3d84-9c2b-4525-8f6e-e4b82c55a36c', 'odd', '06e2ed52-6966-44aa-a177-a0ca7434201f', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL),
('c5b75db1-fce7-470f-b780-3b9934d82a9d', 'even', NULL, 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL),
('0679e069-7355-4b20-bd11-a5a0a5453c7c', 'two', '20ab5a8c-4b0c-432c-b957-f7fb9784d9f7', 'c5b75db1-fce7-470f-b780-3b9934d82a9d', 'ce93fcda-dc3a-4369-a7b0-a6108c261c85');             
CREATE MEMORY TABLE PUBLIC.REALM_ACTIONSCLASSNAMES(
    REALM_ID VARCHAR(36),
    ACTIONCLASSNAME VARCHAR(255)
);              
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.REALM_ACTIONSCLASSNAMES;  
CREATE MEMORY TABLE PUBLIC.REALM_EXTERNALRESOURCE(
    REALM_ID VARCHAR(36),
    RESOURCE_ID VARCHAR(255)
);   
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.REALM_EXTERNALRESOURCE;   
CREATE MEMORY TABLE PUBLIC.RELATIONSHIPTYPE(
    ID VARCHAR(255) NOT NULL,
    DESCRIPTION VARCHAR(255)
);     
ALTER TABLE PUBLIC.RELATIONSHIPTYPE ADD CONSTRAINT PUBLIC.CONSTRAINT_B0E PRIMARY KEY(ID);      
-- 2 +/- SELECT COUNT(*) FROM PUBLIC.RELATIONSHIPTYPE;         
INSERT INTO PUBLIC.RELATIONSHIPTYPE(ID, DESCRIPTION) VALUES
('inclusion', 'Models the act that an object is included in another'),
('neighborhood', 'Models the act that an object is near another');          
CREATE MEMORY TABLE PUBLIC.REPORT(
    ID VARCHAR(36) NOT NULL,
    ACTIVE INTEGER,
    CRONEXPRESSION VARCHAR(255),
    NAME VARCHAR(255) NOT NULL,
    TEMPLATE_ID VARCHAR(255)
);           
ALTER TABLE PUBLIC.REPORT ADD CONSTRAINT PUBLIC.CONSTRAINT_8FD PRIMARY KEY(ID);
-- 2 +/- SELECT COUNT(*) FROM PUBLIC.REPORT;   
INSERT INTO PUBLIC.REPORT(ID, ACTIVE, CRONEXPRESSION, NAME, TEMPLATE_ID) VALUES
('0062ea9c-924d-4ecf-9961-4492a8cc6d1b', 1, NULL, 'test', 'sample'),
('c3520ad9-179f-49e7-b315-d684d216dd97', 1, NULL, 'reconciliation', 'empty');             
CREATE MEMORY TABLE PUBLIC.REPORTEXEC(
    ID VARCHAR(36) NOT NULL,
    ENDDATE TIMESTAMP,
    MESSAGE CLOB,
    STARTDATE TIMESTAMP,
    STATUS VARCHAR(255),
    EXECRESULT BLOB,
    REPORT_ID VARCHAR(36)
);               
ALTER TABLE PUBLIC.REPORTEXEC ADD CONSTRAINT PUBLIC.CONSTRAINT_90 PRIMARY KEY(ID);             
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.REPORTEXEC;               
INSERT INTO PUBLIC.REPORTEXEC(ID, ENDDATE, MESSAGE, STARTDATE, STATUS, EXECRESULT, REPORT_ID) VALUES
('c13f39c5-0d35-4bff-ba79-3cd5de940369', TIMESTAMP '2012-02-26 15:41:04', NULL, TIMESTAMP '2012-02-26 15:40:04', 'SUCCESS', NULL, '0062ea9c-924d-4ecf-9961-4492a8cc6d1b');
CREATE MEMORY TABLE PUBLIC.REPORTLETCONFINSTANCE(
    ID VARCHAR(36) NOT NULL,
    SERIALIZEDINSTANCE CLOB,
    REPORT_ID VARCHAR(36)
);       
ALTER TABLE PUBLIC.REPORTLETCONFINSTANCE ADD CONSTRAINT PUBLIC.CONSTRAINT_4F PRIMARY KEY(ID);  
-- 2 +/- SELECT COUNT(*) FROM PUBLIC.REPORTLETCONFINSTANCE;    
INSERT INTO PUBLIC.REPORTLETCONFINSTANCE(ID, SERIALIZEDINSTANCE, REPORT_ID) VALUES
('5874f3fa-578c-42c6-83b0-c11adafc98b2', '{"@class":"org.apache.syncope.common.lib.report.UserReportletConf","name":"testUserReportlet","matchingCond":null,"plainAttrs":["fullname","gender"],"derAttrs":["cn"],"virAttrs":["virtualdata"],"features":["key","username","status","creationDate","lastLoginDate","changePwdDate","passwordHistorySize","failedLoginCount","memberships","resources"]}', '0062ea9c-924d-4ecf-9961-4492a8cc6d1b'),
('d6c2b475-4860-4eb1-8fde-618299c2a97c', '{"@class":"org.apache.syncope.common.lib.report.ReconciliationReportletConf","name":"dashboardReconciliationReportlet","userMatchingCond":null,"groupMatchingCond":null,"anyObjectMatchingCond":null,"features":["key","username","groupName"]}', 'c3520ad9-179f-49e7-b315-d684d216dd97');          
CREATE MEMORY TABLE PUBLIC.REPORTTEMPLATE(
    ID VARCHAR(255) NOT NULL,
    CSVTEMPLATE CLOB,
    FOTEMPLATE CLOB,
    HTMLTEMPLATE CLOB
);   
ALTER TABLE PUBLIC.REPORTTEMPLATE ADD CONSTRAINT PUBLIC.CONSTRAINT_C2 PRIMARY KEY(ID);         
-- 2 +/- SELECT COUNT(*) FROM PUBLIC.REPORTTEMPLATE;           
INSERT INTO SYSTEM_LOB_STREAM VALUES(4, 0, STRINGDECODE('<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n <xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n                 version=\"1.0\">\n  \n   <xsl:param name=\"status\"/>\n   <xsl:param name=\"message\"/>\n   <xsl:param name=\"start\"/>\n   <xsl:param name=\"end\"/>\n     \n   <xsl:template match=\"/\">\n     <xsl:apply-templates/>\n   </xsl:template>\n \n   <xsl:variable name=\"delimiter\" select=\"'';''\"/>\n    \n   <xsl:template match=\"reportlet[@class=''org.apache.syncope.core.provisioning.java.job.report.StaticReportlet'']\">\n     <xsl:call-template name=\"header\">\n       <xsl:with-param name=\"node\" select=\"configurations/staticAttributes\"/>\n     </xsl:call-template>\n     \n     <xsl:call-template name=\"staticAttributes\">\n       <xsl:with-param name=\"header\" select=\"configurations/staticAttributes\"/>\n     </xsl:call-template>\n   </xsl:template>\n   \n   <xsl:template name=\"header\">\n     <xsl:param name=\"node\"/>  \n     <xsl:for-each select=\"$node/*\">\n       <xsl:text>\"</xsl:text>\n       <xsl:value-of select=\"text()\"/>\n       <xsl:text>\"</xsl:text> \n       <xsl:if test=\"position() != last()\">\n         <xsl:value-of select=\"$delimiter\"/>\n       </xsl:if>\n     </xsl:for-each>\n     <xsl:text>&#10;</xsl:text>\n   </xsl:template>\n     \n   <xsl:template name=\"staticAttributes\">\n     <xsl:param name=\"header\"/>\n     \n     <xsl:variable name=\"attrs\" select=\".\"/>\n     <xsl:for-each select=\"$header/*\">\n       <xsl:variable name=\"nameAttr\" select=\"text()\"/> \n       <xsl:if test=\"string-length($attrs/*[name(.)=$nameAttr]/text()) &gt; 0 \n                       and count($attrs/*[name(.)=$nameAttr]/*/node()) = 0\">\n         <xsl:variable name=\"value\" select=\"$attrs/*[name(.)=$nameAttr]/text()\"/>\n         <xsl:text>\"</xsl:text>\n         <xsl:value-of select=\"$value\"/>\n         <xsl:text>\"</xsl:text>\n       </xsl:if>\n       \n       <xsl:if test=\"string-length($attrs/*[name(.)=$nameAttr]/*/text()) &gt; 0 \n                       and count($attrs/*[name(.)=$nameAttr]/*/node()) &gt; 0\">\n         <xsl:text>\"</xsl:text>\n         <xsl:for-each select=\"$attrs/*[name(.)=$nameAttr]/*\">\n           <xsl:variable name=\"value\" select=\"text()\"/>\n           <xsl:text></xsl:text>\n           <xsl:value-of select=\"$value\"/>\n           <xsl:if test=\"position() != last()\">\n             <xsl:value-of select=\"$delimiter\"/>\n           </xsl:if>\n         </xsl:for-each>\n         <xsl:text>\"</xsl:text>\n       </xsl:if>\n       \n       <xsl:if test=\"position() != last()\">\n         <xsl:value-of select=\"$delimiter\"/>\n       </xsl:if>\n     \n     </xsl:for-each>\n   </xsl:template>\n   \n   <xsl:template match=\"reportlet[@class=''org.apache.syncope.core.provisioning.java.job.report.UserReportlet'']\">\n     \n     <xsl:call-template name=\"header\">\n       <xsl:with-param name=\"node\" select=\"configurations/userAttributes\"/>\n     </xsl:call-template>\n     <xsl:for-each select=\"user\">\n       <xsl:call-template name=\"userAttributes\">\n         <xsl:with-param name=\"header\" select=\"../configurations/userAttributes\"/>\n       </xsl:call-template>\n       <xsl:text>&#10;</xsl:text>\n     </xsl:for-each>\n   </xsl:template>\n     \n   <xsl:template name=\"userAttributes\">\n     <xsl:param name=\"header\"/>\n   \n     <xsl:variable name=\"attrs\" select=\".\"/>\n     <xsl:for-each select=\"$header/*\">\n       <xsl:variable name=\"nameAttr\" select=\"text()\"/>\n       <xsl:choose>      \n         <xsl:when test=\"count($attrs/@*[name()=$nameAttr]) &gt; 0\">\n           <xsl:variable name=\"userAttr\" select=\"$attrs/@*[name()=$nameAttr]\"/>\n           <xsl:text>\"</xsl:text>\n           <xsl:value-of select=\"$userAttr/.\"/>\n           <xsl:text>\"</xsl:text>\n         </xsl:when>\n         <xsl:when test=\"string-length($attrs/*/*[@name=$nameAttr]/value/text()) &gt; 0 \n                         and count($attrs/*/*[@name=$nameAttr]/node()) = 0\">\n           <xsl:variable name=\"value\" select=\"$attrs/*/*[@name=$nameAttr]/value/text()\"/>\n           <xsl:text>\"</xsl:text>\n           <xsl:value-of select=\"$value\"/>\n           <xsl:text>\"</xsl:text>\n         </xsl:when>\n         <xsl:when test=\"string-length($attrs/*/*[@name=$nameAttr]/value/text()) &gt; 0 \n     '), NULL);          
INSERT INTO SYSTEM_LOB_STREAM VALUES(4, 1, STRINGDECODE('                    and count($attrs/*/*[@name=$nameAttr]/node()) &gt; 0\">\n           <xsl:text>\"</xsl:text>\n           <xsl:for-each select=\"$attrs/*/*[@name=$nameAttr]/*\">\n             <xsl:variable name=\"value\" select=\"$attrs/*/*[@name=$nameAttr]/value/text()\"/>\n             <xsl:value-of select=\"$value\"/>\n             <xsl:if test=\"position() != last()\">\n               <xsl:value-of select=\"$delimiter\"/>\n             </xsl:if>\n           </xsl:for-each>\n           <xsl:text>\"</xsl:text>\n         </xsl:when>\n         <xsl:when test=\"name($attrs/*[name(.)=$nameAttr]/*[name(.)=''membership'']) \n                         and count($attrs/*[name(.)=$nameAttr]/node()) &gt; 0\">\n           <xsl:text>\"</xsl:text>       \n           <xsl:variable name=\"value\" select=\"@groupName\"/>\n           <xsl:for-each select=\"$attrs/*/membership\">\n             <xsl:variable name=\"value\" select=\"@groupName\"/>\n             <xsl:value-of select=\"$value\"/>\n             <xsl:if test=\"position() != last()\">\n               <xsl:value-of select=\"$delimiter\"/>\n             </xsl:if>\n           </xsl:for-each>\n           <xsl:text>\"</xsl:text>\n         </xsl:when>\n         <xsl:when test=\"name($attrs/*[name(.)=$nameAttr]/*[name(.)=''resource'']) \n                         and count($attrs/*[name(.)=$nameAttr]/node()) &gt; 0\">\n           <xsl:text>\"</xsl:text>\n           <xsl:variable name=\"value\" select=\"@name\"/>\n           <xsl:for-each select=\"$attrs/*/resource\">\n             <xsl:variable name=\"value\" select=\"@name\"/>\n             <xsl:value-of select=\"$value\"/>\n             <xsl:if test=\"position() != last()\">\n               <xsl:value-of select=\"$delimiter\"/>\n             </xsl:if>\n           </xsl:for-each>\n           <xsl:text>\"</xsl:text>\n         </xsl:when>\n         <xsl:otherwise>\n           <xsl:text>\"\"</xsl:text> \n         </xsl:otherwise>  \n       </xsl:choose>\n       <xsl:if test=\"position() != last()\">\n         <xsl:value-of select=\"$delimiter\"/>\n       </xsl:if>  \n     </xsl:for-each>\n   </xsl:template>\n   \n   <xsl:template match=\"reportlet[@class=''org.apache.syncope.core.provisioning.java.job.report.GroupReportlet'']\">\n     \n     <xsl:call-template name=\"header\">\n       <xsl:with-param name=\"node\" select=\"configurations/groupAttributes\"/>\n     </xsl:call-template>\n     <xsl:for-each select=\"group\">\n       <xsl:call-template name=\"groupAttributes\">\n         <xsl:with-param name=\"header\" select=\"../configurations/groupAttributes\"/>\n         <xsl:with-param name=\"attrs\" select=\".\"/>\n       </xsl:call-template>\n       <xsl:text>&#10;</xsl:text>\n     </xsl:for-each>\n   </xsl:template>\n     \n   <xsl:template name=\"groupAttributes\">\n     <xsl:param name=\"header\"/>\n     <xsl:param name=\"attrs\"/>\n     \n     <xsl:for-each select=\"$header/*\">\n       <xsl:variable name=\"nameAttr\" select=\"text()\"/>\n       \n       <xsl:choose> \n         <xsl:when test=\"string-length($attrs/@*[name()=$nameAttr]) &gt; 0\">\n           <xsl:variable name=\"groupAttr\" select=\"$attrs/@*[name()=$nameAttr]\"/>\n           <xsl:text>\"</xsl:text>\n           <xsl:value-of select=\"$groupAttr/.\"/>\n           <xsl:text>\"</xsl:text>\n         </xsl:when>\n         <xsl:when test=\"name($attrs/*[name(.)=$nameAttr]/*[name(.)=''resource'']) \n                         and count($attrs/*[name(.)=$nameAttr]/node()) &gt; 0\">\n           <xsl:text>\"</xsl:text>       \n           <xsl:for-each select=\"$attrs/*/resource\">\n             <xsl:variable name=\"value\" select=\"@name\"/>\n             <xsl:value-of select=\"$value\"/>\n             <xsl:if test=\"position() != last()\">\n               <xsl:value-of select=\"$delimiter\"/>\n             </xsl:if>\n           </xsl:for-each>\n           <xsl:text>\"</xsl:text>\n         </xsl:when>\n         <xsl:when test=\"name($attrs/*[name(.)=$nameAttr]/*[name(.)=''user'']) \n                         and count($attrs/*[name(.)=$nameAttr]/node()) &gt; 0\">\n           <xsl:text>\"</xsl:text>       \n           <xsl:for-each select=\"$attrs/*/user\">\n             <xsl:variable name=\"value\" select=\"@userUsername\"/>\n             <xsl:value-of select=\"$value\"/>\n             <xsl:if test=\"posi'), NULL);  
INSERT INTO SYSTEM_LOB_STREAM VALUES(4, 2, STRINGDECODE('tion() != last()\">\n               <xsl:value-of select=\"$delimiter\"/>\n             </xsl:if>\n           </xsl:for-each>\n           <xsl:text>\"</xsl:text>\n         </xsl:when>\n         <xsl:otherwise>\n           <xsl:text>\"</xsl:text>\n           <xsl:if test=\"string-length($attrs/*/*[@name=$nameAttr]/value/text()) &gt; 0\"> \n             <xsl:variable name=\"value\" select=\"$attrs/*/*[@name=$nameAttr]/value/text()\"/>\n             <xsl:value-of select=\"$value\"/>\n           </xsl:if>\n           <xsl:text>\"</xsl:text>\n         </xsl:otherwise>\n       </xsl:choose>\n       <xsl:if test=\"position() != last()\">\n         <xsl:value-of select=\"$delimiter\"/>\n       </xsl:if>\n     \n     </xsl:for-each>\n   </xsl:template>\n </xsl:stylesheet>\n'), NULL);     
INSERT INTO SYSTEM_LOB_STREAM VALUES(5, 0, STRINGDECODE('<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n <xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n                 xmlns:fo=\"http://www.w3.org/1999/XSL/Format\"\n                 version=\"1.0\">\n \n   <xsl:param name=\"status\"/>\n   <xsl:param name=\"message\"/>\n   <xsl:param name=\"start\"/>\n   <xsl:param name=\"end\"/>\n   \n   <xsl:template match=\"/\">\n     <fo:root xmlns:fo=\"http://www.w3.org/1999/XSL/Format\" font-family=\"Helvetica\" font-size=\"10pt\">\n       \n       <!-- defines the layout master -->\n       <fo:layout-master-set>\n         <fo:simple-page-master master-name=\"first\" page-height=\"29.7cm\" page-width=\"21cm\" \n                                margin-top=\"1cm\" margin-bottom=\"2cm\" margin-left=\"2.5cm\" margin-right=\"2.5cm\">\n           <fo:region-body margin-top=\"1cm\"/>\n           <fo:region-before extent=\"1cm\"/>\n           <fo:region-after extent=\"1.5cm\"/>\n         </fo:simple-page-master>\n       </fo:layout-master-set>\n \n       <!-- starts actual layout -->\n       <fo:page-sequence master-reference=\"first\">\n         \n         <fo:flow flow-name=\"xsl-region-body\">\n           <fo:block font-size=\"24pt\" font-weight=\"bold\" text-align=\"center\" space-after=\"1cm\">\n             Apache Syncope Report - <xsl:value-of select=\"report/@name\"/>\n           </fo:block>\n \n           <fo:table table-layout=\"fixed\" border-width=\"0.5mm\" border-style=\"solid\" width=\"100%\" space-after=\"1cm\">\n             <fo:table-column column-width=\"proportional-column-width(1)\"/>\n             <fo:table-column column-width=\"proportional-column-width(1)\"/>\n             <fo:table-body>\n               <fo:table-row>\n                 <fo:table-cell>\n                   <fo:block font-size=\"18pt\" font-weight=\"bold\">Report Name:</fo:block>\n                 </fo:table-cell>\n                 <fo:table-cell>\n                   <fo:block font-size=\"18pt\" font-weight=\"bold\">\n                     <xsl:value-of select=\"report/@name\"/>\n                   </fo:block>\n                 </fo:table-cell>\n               </fo:table-row>\n               <fo:table-row>\n                 <fo:table-cell>\n                   <fo:block font-size=\"18pt\" font-weight=\"bold\">Start Date:</fo:block>\n                 </fo:table-cell>\n                 <fo:table-cell>\n                   <fo:block font-size=\"18pt\" font-weight=\"bold\">\n                     <xsl:value-of select=\"$start\"/>\n                   </fo:block>\n                 </fo:table-cell>\n               </fo:table-row>\n               <fo:table-row>\n                 <fo:table-cell>\n                   <fo:block font-size=\"18pt\" font-weight=\"bold\">End Date:</fo:block>\n                 </fo:table-cell>\n                 <fo:table-cell>\n                   <fo:block font-size=\"18pt\" font-weight=\"bold\">\n                     <xsl:value-of select=\"$end\"/>\n                   </fo:block>\n                 </fo:table-cell>\n               </fo:table-row>\n             </fo:table-body>\n           </fo:table>\n \n           <xsl:apply-templates/>\n         </fo:flow>\n       </fo:page-sequence>\n     </fo:root>\n   </xsl:template>\n \n   <xsl:template match=\"reportlet[@class=''org.apache.syncope.core.provisioning.java.job.report.StaticReportlet'']\">\n \n     <fo:block font-size=\"14pt\" font-weight=\"bold\" space-after=\"0.5cm\">Reportlet: \n       <xsl:value-of select=\"@name\"/>\n     </fo:block>\n \n     <xsl:if test=\"string-length(string/text()) &gt; 0\">\n       <fo:block font-size=\"11pt\">String value: \n         <xsl:value-of select=\"string/text()\"/>\n       </fo:block>\n     </xsl:if>\n \n     <xsl:if test=\"string-length(long/text()) &gt; 0\">\n       <fo:block font-size=\"11pt\">Long value: \n         <xsl:value-of select=\"long/text()\"/>\n       </fo:block>\n     </xsl:if>\n \n     <xsl:if test=\"string-length(double/text()) &gt; 0\">\n       <fo:block font-size=\"11pt\">Double value: \n         <xsl:value-of select=\"double/text()\"/>\n       </fo:block>\n     </xsl:if>\n \n     <xsl:if test=\"string-length(date/text()) &gt; 0\">\n       <fo:block font-size=\"11pt\">Date value: \n         <xsl:value-of select=\"date/text()\"/>\n       </fo:block>\n     </xsl:if>\n \n     <xsl:if test=\"string-length(enum/text'), NULL);       
INSERT INTO SYSTEM_LOB_STREAM VALUES(5, 1, STRINGDECODE('()) &gt; 0\">\n       <fo:block font-size=\"11pt\">Enum value: \n         <xsl:value-of select=\"enum/text()\"/>\n       </fo:block>\n     </xsl:if>\n \n     <xsl:if test=\"string-length(list) &gt; 0\">\n       <fo:block font-size=\"11pt\">List values:</fo:block>\n             \n       <fo:list-block provisional-label-separation=\"4mm\" provisional-distance-between-starts=\"2mm\">\n         <xsl:for-each select=\"list/string\">\n           <xsl:if test=\"string-length(string/text()) &gt; 0\">\n             <fo:list-item>\n               <fo:list-item-label end-indent=\"label-end()\">\n                 <fo:block>\u2022</fo:block>\n               </fo:list-item-label>\n               <fo:list-item-body start-indent=\"body-start()\">\n                 <fo:block>\n                   <xsl:value-of select=\"text()\"/>\n                 </fo:block>\n               </fo:list-item-body>\n             </fo:list-item>\n           </xsl:if>\n         </xsl:for-each>\n       </fo:list-block>\n     </xsl:if>\n         \n   </xsl:template>\n   \n   <xsl:template match=\"reportlet[@class=''org.apache.syncope.core.provisioning.java.job.report.UserReportlet'']\">\n    \n     <fo:block font-size=\"16pt\" font-weight=\"bold\" space-after=\"0.5cm\" space-before=\"5mm\">Reportlet: <xsl:value-of select=\"@name\"/></fo:block>\n         \n     <xsl:for-each select=\"user\">\n       <fo:block font-size=\"14pt\" font-weight=\"bold\" space-before=\"15mm\" space-after=\"5mm\" background-color=\"(#8888ff)\">User <xsl:value-of select=\"@username\"/></fo:block>\n       <fo:table table-layout=\"fixed\" space-after=\"7mm\">\n         <fo:table-column/>\n         <fo:table-column/>\n         <fo:table-body>\n           <fo:table-row background-color=\"(#ccccff)\">\n             <fo:table-cell>\n               <fo:block>Status:</fo:block>\n             </fo:table-cell>\n             <fo:table-cell>\n               <fo:block font-style=\"italic\">\n                 <xsl:value-of select=\"@status\"/>\n               </fo:block>\n             </fo:table-cell>\n           </fo:table-row>\n           <xsl:if test=\"string-length(@creationDate) &gt; 0\">\n             <fo:table-row background-color=\"(#ccccff)\">\n               <fo:table-cell>\n                 <fo:block>Creation Date:</fo:block>\n               </fo:table-cell>\n               <fo:table-cell>\n                 <fo:block font-style=\"italic\">\n                   <xsl:value-of select=\"@creationDate\"/>\n                 </fo:block>\n               </fo:table-cell>\n             </fo:table-row>\n           </xsl:if>\n           <xsl:if test=\"string-length(@lastLoginDate) &gt; 0\">\n             <fo:table-row background-color=\"(#ccccff)\">\n               <fo:table-cell>\n                 <fo:block>Last Login Date:</fo:block>\n               </fo:table-cell>\n               <fo:table-cell>\n                 <fo:block font-style=\"italic\">\n                   <xsl:value-of select=\"@lastLoginDate\"/>\n                 </fo:block>\n               </fo:table-cell>\n             </fo:table-row>\n           </xsl:if>\n           <xsl:if test=\"string-length(@changePwdDate) &gt; 0\">\n             <fo:table-row background-color=\"(#ccccff)\">\n               <fo:table-cell>\n                 <fo:block>Change Password Date:</fo:block>\n               </fo:table-cell>\n               <fo:table-cell>\n                 <fo:block font-style=\"italic\">\n                   <xsl:value-of select=\"@changePwdDate\"/>\n                 </fo:block>\n               </fo:table-cell>\n             </fo:table-row>\n           </xsl:if>\n           <xsl:if test=\"string-length(@passwordHistorySize) &gt; 0\">\n             <fo:table-row background-color=\"(#ccccff)\">\n               <fo:table-cell>\n                 <fo:block>Password History Size:</fo:block>\n               </fo:table-cell>\n               <fo:table-cell>\n                 <fo:block font-style=\"italic\">\n                   <xsl:value-of select=\"@passwordHistorySize\"/>\n                 </fo:block>\n               </fo:table-cell>\n             </fo:table-row>\n           </xsl:if>\n           <xsl:if test=\"string-length(@failedLoginCount) &gt; 0\">\n             <fo:table-row background-color=\"(#ccccff)\">\n               <fo:table-cell>'), NULL);   
INSERT INTO SYSTEM_LOB_STREAM VALUES(5, 2, STRINGDECODE('\n                 <fo:block>Number of Failed Login Attempts:</fo:block>\n               </fo:table-cell>\n               <fo:table-cell>\n                 <fo:block font-style=\"italic\">\n                   <xsl:value-of select=\"@failedLoginCount\"/>\n                 </fo:block>\n               </fo:table-cell>\n             </fo:table-row>\n           </xsl:if>\n         </fo:table-body>\n       </fo:table>\n       <xsl:call-template name=\"attributes\">\n         <xsl:with-param name=\"label\">Attributes</xsl:with-param>\n         <xsl:with-param name=\"node\" select=\"attributes/attribute\"/>\n       </xsl:call-template>\n       <xsl:choose>\n         <xsl:when test=\"string-length(derivedAttributes/derivedAttribute) &gt; 0\">\n           <xsl:call-template name=\"attributes\">\n             <xsl:with-param name=\"label\">Derived Attributes</xsl:with-param>\n             <xsl:with-param name=\"node\" select=\"derivedAttributes/derivedAttribute\"/>\n           </xsl:call-template>\n         </xsl:when>\n         <xsl:otherwise>\n           <fo:block color=\"red\" font-size=\"9pt\" space-after=\"3mm\">THIS USER HASN''T ANY DERIVED ATTRIBUTE</fo:block>\n         </xsl:otherwise>\n       </xsl:choose>\n       <xsl:choose>\n         <xsl:when test=\"string-length(virtualAttributes/virtualAttribute) &gt; 0\">\n           <xsl:call-template name=\"attributes\">\n             <xsl:with-param name=\"label\">Virtual Attributes</xsl:with-param>\n             <xsl:with-param name=\"node\" select=\"virtualAttributes/virtualAttribute\"/>\n           </xsl:call-template>\n         </xsl:when>\n         <xsl:otherwise>\n           <fo:block color=\"red\" font-size=\"9pt\" space-after=\"3mm\">THIS USER HASN''T ANY VIRTUAL ATTRIBUTE</fo:block>\n         </xsl:otherwise>\n       </xsl:choose>\n       <xsl:choose>\n         <xsl:when test=\"string-length(memberships/membership) &gt; 0\">\n           <fo:block font-size=\"11pt\" font-weight=\"bold\">Memberships</fo:block>\n           <xsl:for-each select=\"memberships/membership\">\n             <fo:block font-size=\"10pt\" font-weight=\"bold\" space-before=\"2mm\">Group: <xsl:value-of select=\"@groupName\"/>(<xsl:value-of select=\"@groupId\"/>)</fo:block>\n             <fo:block start-indent=\"1cm\" space-before=\"3mm\" space-after=\"0.5cm\">\n               <xsl:choose>\n                 <xsl:when test=\"string-length(attributes/attribute) &gt; 0\">\n                   <xsl:call-template name=\"attributes\">\n                     <xsl:with-param name=\"label\">Attributes</xsl:with-param>\n                     <xsl:with-param name=\"node\" select=\"attributes/attribute\"/>\n                   </xsl:call-template>\n                 </xsl:when>\n                 <xsl:otherwise>\n                   <fo:block color=\"red\" font-size=\"8pt\" space-after=\"2mm\">THIS GROUP HASN''T ANY ATTRIBUTE</fo:block>\n                 </xsl:otherwise>\n               </xsl:choose>\n               <xsl:choose>\n                 <xsl:when test=\"string-length(derivedAttributes/derivedAttribute) &gt; 0\">\n                   <xsl:call-template name=\"attributes\">\n                     <xsl:with-param name=\"label\">Derived Attributes</xsl:with-param>\n                     <xsl:with-param name=\"node\" select=\"derivedAttributes/derivedAttribute\"/>\n                   </xsl:call-template>\n                 </xsl:when>\n                 <xsl:otherwise>\n                   <fo:block color=\"red\" font-size=\"8pt\" space-after=\"2mm\">THIS GROUP HASN''T ANY DERIVED ATTRIBUTE</fo:block>\n                 </xsl:otherwise>\n               </xsl:choose>\n               <xsl:choose>\n                 <xsl:when test=\"string-length(virtualAttributes/virtualAttribute) &gt; 0\">\n                   <xsl:call-template name=\"attributes\">\n                     <xsl:with-param name=\"label\">Virtual Attributes</xsl:with-param>\n                     <xsl:with-param name=\"node\" select=\"virtualAttributes/virtualAttribute\"/>\n                   </xsl:call-template>\n                 </xsl:when>\n                 <xsl:otherwise>\n                   <fo:block color=\"red\" font-size=\"8pt\" space-after=\"2mm\">THIS GROUP HASN''T ANY VIRTUAL ATTRIBUTE</fo:block>\n                 </xsl:otherwise>\n              '), NULL);       
INSERT INTO SYSTEM_LOB_STREAM VALUES(5, 3, STRINGDECODE(' </xsl:choose>\n               <!-- ''groupResources\" is defined in groupReportlet2fo.xsl -->\n               <xsl:call-template name=\"groupResources\">\n                 <xsl:with-param name=\"node\" select=\"resources/resource\"/>\n               </xsl:call-template>\n             </fo:block>\n           </xsl:for-each>\n         </xsl:when>\n         <xsl:otherwise>\n           <fo:block color=\"red\" font-size=\"9pt\" space-after=\"3mm\">THIS USER HASN''T BEEN ASSIGNED TO ANY GROUP</fo:block>\n         </xsl:otherwise>\n       </xsl:choose>\n       <xsl:call-template name=\"resources\">\n         <xsl:with-param name=\"node\" select=\"resources/resource\"/>\n       </xsl:call-template>\n     </xsl:for-each>\n   </xsl:template>\n   \n   <xsl:template match=\"reportlet[@class=''org.apache.syncope.core.provisioning.java.job.report.GroupReportlet'']\">\n    \n     <fo:block font-size=\"16pt\" font-weight=\"bold\" space-after=\"0.5cm\" space-before=\"5mm\">Reportlet: <xsl:value-of select=\"@name\"/></fo:block>\n         \n     <xsl:for-each select=\"group\">\n       <fo:block font-size=\"14pt\" font-weight=\"bold\" space-before=\"15mm\" space-after=\"5mm\" background-color=\"(#8888ff)\">Group <xsl:value-of select=\"@name\"/></fo:block>\n       <fo:table table-layout=\"fixed\" space-after=\"7mm\">\n         <fo:table-column/>\n         <fo:table-column/>\n         <fo:table-body>\n           <fo:table-row background-color=\"(#ccccff)\">\n             <fo:table-cell>\n               <fo:block>Id:</fo:block>\n             </fo:table-cell>\n             <fo:table-cell>\n               <fo:block font-style=\"italic\">\n                 <xsl:value-of select=\"@id\"/>\n               </fo:block>\n             </fo:table-cell>\n           </fo:table-row>\n           <xsl:if test=\"@groupOwner != ''null''\">\n             <fo:table-row background-color=\"(#ccccff)\">\n               <fo:table-cell>\n                 <fo:block>Group Owner:</fo:block>\n               </fo:table-cell>\n               <fo:table-cell>\n                 <fo:block font-style=\"italic\">\n                   <xsl:value-of select=\"@groupOwner\"/>\n                 </fo:block>\n               </fo:table-cell>\n             </fo:table-row>\n           </xsl:if>\n           <xsl:if test=\"@userOwner != ''null''\">\n             <fo:table-row background-color=\"(#ccccff)\">\n               <fo:table-cell>\n                 <fo:block>Last Login Date:</fo:block>\n               </fo:table-cell>\n               <fo:table-cell>\n                 <fo:block font-style=\"italic\">\n                   <xsl:value-of select=\"@userOwner\"/>\n                 </fo:block>\n               </fo:table-cell>\n             </fo:table-row>\n           </xsl:if>\n         </fo:table-body>\n       </fo:table>\n       <xsl:choose>\n         <xsl:when test=\"string-length(attributes/attribute) &gt; 0\">\n           <xsl:call-template name=\"attributes\">\n             <xsl:with-param name=\"label\">Attributes</xsl:with-param>\n             <xsl:with-param name=\"node\" select=\"attributes/attribute\"/>\n           </xsl:call-template>\n         </xsl:when>\n         <xsl:otherwise>\n           <fo:block color=\"red\" font-size=\"9pt\" space-after=\"3mm\">THIS GROUP HASN''T ANY ATTRIBUTE</fo:block>\n         </xsl:otherwise>\n       </xsl:choose>\n       \n       <xsl:choose>\n         <xsl:when test=\"string-length(derivedAttributes/derivedAttribute) &gt; 0\">\n           <xsl:call-template name=\"attributes\">\n             <xsl:with-param name=\"label\">Derived Attributes</xsl:with-param>\n             <xsl:with-param name=\"node\" select=\"derivedAttributes/derivedAttribute\"/>\n           </xsl:call-template>\n         </xsl:when>\n         <xsl:otherwise>\n           <fo:block color=\"red\" font-size=\"9pt\" space-after=\"3mm\">THIS GROUP HASN''T ANY DERIVED ATTRIBUTE</fo:block>\n         </xsl:otherwise>\n       </xsl:choose>\n       <xsl:choose>\n         <xsl:when test=\"string-length(virtualAttributes/virtualAttribute) &gt; 0\">\n           <xsl:call-template name=\"attributes\">\n             <xsl:with-param name=\"label\">Virtual Attributes</xsl:with-param>\n             <xsl:with-param name=\"node\" select=\"virtualAttributes/virtualAttribute\"/>\n           </xsl:call-template>'), NULL);     
INSERT INTO SYSTEM_LOB_STREAM VALUES(5, 4, STRINGDECODE('\n         </xsl:when>\n         <xsl:otherwise>\n           <fo:block color=\"red\" font-size=\"9pt\" space-after=\"3mm\">THIS GROUP HASN''T ANY VIRTUAL ATTRIBUTE</fo:block>\n         </xsl:otherwise>\n       </xsl:choose>\n       \n       <xsl:choose>\n         <xsl:when test=\"users/user\">\n           <fo:block font-size=\"11pt\" font-weight=\"bold\">Users</fo:block>\n           <xsl:for-each select=\"users/user\">\n             <fo:block background-color=\"(#ccccff)\" font-size=\"9pt\" font-weight=\"bold\" space-before=\"4mm\">User: <xsl:value-of select=\"@userUsername\"/> (Id: <xsl:value-of select=\"@userId\"/>)</fo:block>\n                  \n           </xsl:for-each> \n         </xsl:when>\n         <xsl:otherwise>\n           <fo:block color=\"red\" font-size=\"9pt\" space-after=\"3mm\">THIS GROUP HASN''T ANY USER ASSIGNED TO</fo:block>\n         </xsl:otherwise>\n       </xsl:choose>\n       <xsl:call-template name=\"groupResources\">\n         <xsl:with-param name=\"node\" select=\"resources/resource\"/>\n       </xsl:call-template>\n     </xsl:for-each>\n \n   </xsl:template>\n   \n   <xsl:template name=\"attributes\">\n     <xsl:param name=\"label\"/>\n     <xsl:param name=\"node\"/>\n     <fo:block font-size=\"11pt\" font-weight=\"bold\" space-after=\"2mm\">\n       <xsl:value-of select=\"$label\"/>\n     </fo:block>\n     <fo:table table-layout=\"fixed\" space-after=\"7mm\">\n       <fo:table-column/>\n       <fo:table-column/>\n       <fo:table-header>\n         <fo:table-row height=\"7mm\" background-color=\"(#ccccba)\">\n           <fo:table-cell>\n             <fo:block font-weight=\"bold\">Schema name</fo:block>\n           </fo:table-cell>\n           <fo:table-cell>\n             <fo:block font-weight=\"bold\">Value(s)</fo:block>\n           </fo:table-cell>\n         </fo:table-row>\n       </fo:table-header>\n       <fo:table-body>\n         <xsl:for-each select=\"$node\">\n           <xsl:if test=\"string-length(value/text()) &gt; 0\">\n             <fo:table-row height=\"4mm\" background-color=\"(#ccccff)\">\n               <fo:table-cell>\n                 <fo:block>\n                   <xsl:value-of select=\"@name\"/>\n                 </fo:block>\n               </fo:table-cell>\n               <fo:table-cell>\n                 <xsl:for-each select=\"value\">\n                   <fo:block></fo:block>\n                   <fo:block font-style=\"italic\">\n                     <xsl:value-of select=\"text()\"/>\n                   </fo:block>\n                 </xsl:for-each>\n               </fo:table-cell>\n             </fo:table-row>\n           </xsl:if>\n           <fo:table-row>\n             <fo:table-cell>\n               <fo:block></fo:block>\n             </fo:table-cell>\n             <fo:table-cell>\n               <fo:block></fo:block>\n             </fo:table-cell>\n           </fo:table-row>\n         </xsl:for-each>\n       </fo:table-body>\n     </fo:table>\n   </xsl:template>\n   \n   <xsl:template name=\"resources\">\n     <xsl:param name=\"node\"/>\n     <fo:block font-size=\"11pt\" font-weight=\"bold\" space-after=\"3mm\">Resources</fo:block>\n     <xsl:for-each select=\"$node\">\n       <fo:block></fo:block> <!--            <fo:block>\u2022</fo:block>-->\n       <fo:block background-color=\"(#ccccff)\">\n         <xsl:value-of select=\"@name\"/>\n       </fo:block>\n     </xsl:for-each>\n   </xsl:template>\n \n   <xsl:template name=\"groupResources\">\n     <xsl:param name=\"node\"/>\n     <fo:block font-size=\"11pt\" font-weight=\"bold\" space-after=\"3mm\" space-before=\"5mm\">Group Resources</fo:block>\n     <xsl:for-each select=\"$node\">\n       <fo:block></fo:block> <!--            <fo:block>\u2022</fo:block>-->\n       <fo:block background-color=\"(#ccccff)\">\n         <xsl:value-of select=\"@name\"/>\n       </fo:block>\n     </xsl:for-each>\n   </xsl:template>\n \n </xsl:stylesheet>\n'), NULL);  
INSERT INTO SYSTEM_LOB_STREAM VALUES(6, 0, STRINGDECODE('<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n <xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n                 version=\"1.0\">\n \n   <xsl:param name=\"status\"/>\n   <xsl:param name=\"message\"/>\n   <xsl:param name=\"start\"/>\n   <xsl:param name=\"end\"/>\n   \n   <xsl:template match=\"/\">\n     <html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">\n       <head>\n         <meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\" />\n         <title>Apache Syncope Report - <xsl:value-of select=\"report/@name\"/></title>\n       </head>\n       <body>\n         <table style=\"border: 1px solid black;\">\n           <tr>\n             <td>\n               <h1>Report Name:</h1>\n             </td>\n             <td>\n               <h1>\n                 <xsl:value-of select=\"report/@name\"/>\n               </h1>\n             </td>\n           </tr>\n           <tr>\n             <td>\n               <h2>Start Date:</h2>\n             </td>\n             <td>\n               <h2>\n                 <xsl:value-of select=\"$start\"/>\n               </h2>\n             </td>\n           </tr>\n           <tr>\n             <td>\n               <h2>End Date:</h2>\n             </td>\n             <td>\n               <h2>\n                 <xsl:value-of select=\"$end\"/>\n               </h2>\n             </td>\n           </tr>\n         </table>\n \n         <xsl:apply-templates/>\n       </body>\n     </html>\n   </xsl:template>\n \n   <xsl:template match=\"reportlet[@class=''org.apache.syncope.core.provisioning.java.job.report.StaticReportlet'']\">\n     <h2>Reportlet: \n       <xsl:value-of select=\"@name\"/>\n     </h2>\n         \n     <xsl:if test=\"string-length(string/text()) &gt; 0\">\n       <p>String value:                 \n         <xsl:value-of select=\"string/text()\"/>\n       </p>\n     </xsl:if>\n \n     <xsl:if test=\"string-length(long/text()) &gt; 0\">\n       <p>Long value: \n         <xsl:value-of select=\"long/text()\"/>\n       </p>\n     </xsl:if>\n \n     <xsl:if test=\"string-length(double/text()) &gt; 0\">\n       <p>Double value: \n         <xsl:value-of select=\"double/text()\"/>\n       </p>\n     </xsl:if>\n \n     <xsl:if test=\"string-length(date/text()) &gt; 0\">\n       <p>Date value: \n         <xsl:value-of select=\"date/text()\"/>\n       </p>\n     </xsl:if>\n \n     <xsl:if test=\"string-length(enum/text()) &gt; 0\">\n       <p>Enum value: \n         <xsl:value-of select=\"enum/text()\"/>\n       </p>\n     </xsl:if>\n \n     <xsl:if test=\"string-length(list) &gt; 0\">\n       <p>List values:</p>\n             \n       <ul>\n         <xsl:for-each select=\"list/string\">\n           <xsl:if test=\"string-length(string/text()) &gt; 0\">\n             <li>\n               <xsl:value-of select=\"text()\"/>\n             </li>\n           </xsl:if>\n         </xsl:for-each>\n       </ul>\n     </xsl:if>\n   </xsl:template>\n   \n   <xsl:template match=\"reportlet[@class=''org.apache.syncope.core.provisioning.java.job.report.UserReportlet'']\">\n     \n     <h3>Reportlet: <xsl:value-of select=\"@name\"/></h3>\n     \n     <xsl:for-each select=\"user\">\n       <h4>User <xsl:value-of select=\"@username\"/></h4>\n       \n       <table style=\"border: 1px solid black;\">\n         <tr>\n           <td>Status:</td>\n           <td>\n             <xsl:value-of select=\"@status\"/>\n           </td>\n         </tr>\n         <xsl:if test=\"string-length(@creationDate) &gt; 0\">\n           <tr>\n             <td>Creation Date:</td>\n             <td>\n               <xsl:value-of select=\"@creationDate\"/>\n             </td>\n           </tr>\n         </xsl:if>\n         <xsl:if test=\"string-length(@lastLoginDate) &gt; 0\">\n           <tr>\n             <td>Last Login Date:</td>\n             <td>\n               <xsl:value-of select=\"@lastLoginDate\"/>\n             </td>\n           </tr>\n         </xsl:if>\n         <xsl:if test=\"string-length(@changePwdDate) &gt; 0\">\n           <tr>\n             <td>Change Password Date:</td>\n             <td>\n               <xsl:value-of select=\"@changePwdDate\"/>\n             </td>\n           </tr>\n         </xsl:if>\n         <xsl:if test=\"string-length(@passwordHistorySize) &gt; 0\">\n           <tr>\n             '), NULL);        
INSERT INTO SYSTEM_LOB_STREAM VALUES(6, 1, STRINGDECODE('<td>Password History Size:</td>\n             <td>\n               <xsl:value-of select=\"@passwordHistorySize\"/>\n             </td>\n           </tr>\n         </xsl:if>\n         <xsl:if test=\"string-length(@failedLoginCount) &gt; 0\">\n           <tr>\n             <td>Number of Failed Login Attempts:</td>\n             <td>\n               <xsl:value-of select=\"@failedLoginCount\"/>\n             </td>\n           </tr>\n         </xsl:if>\n       </table>\n \n       <xsl:call-template name=\"attributes\">\n         <xsl:with-param name=\"label\">Attributes</xsl:with-param>\n         <xsl:with-param name=\"node\" select=\"attributes/attribute\"/>\n       </xsl:call-template>\n \n       <!--<xsl:if test=\"string-length(derivedAttributes/derivedAttribute) &gt; 0\">-->\n       <xsl:choose>\n         <xsl:when test=\"string-length(derivedAttributes/derivedAttribute) &gt; 0\">\n           <xsl:call-template name=\"attributes\">\n             <xsl:with-param name=\"label\">Derived Attributes</xsl:with-param>\n             <xsl:with-param name=\"node\" select=\"derivedAttributes/derivedAttribute\"/>\n           </xsl:call-template>\n         </xsl:when>\n         <xsl:otherwise>\n           <h5>THIS USER HASN''T DERIVED ATTRIBUTES</h5>\n         </xsl:otherwise>\n       </xsl:choose>\n       <!--</xsl:if>-->\n       <xsl:choose>\n         <xsl:when test=\"string-length(virtualAttributes/virtualAttribute) &gt; 0\">\n           <xsl:call-template name=\"attributes\">\n             <xsl:with-param name=\"label\">Virtual Attributes</xsl:with-param>\n             <xsl:with-param name=\"node\" select=\"virtualAttributes/virtualAttribute\"/>\n           </xsl:call-template>\n         </xsl:when>\n         <xsl:otherwise>\n           <h5>THIS USER HASN''T VIRTUAL ATTRIBUTES</h5>\n         </xsl:otherwise>\n       </xsl:choose>\n       \n       <xsl:choose>\n         <xsl:when test=\"string-length(memberships/membership) &gt; 0\">\n           <h4>Memberships</h4>\n           <xsl:for-each select=\"memberships/membership\">\n             <h5>Group: <xsl:value-of select=\"@groupName\"/>(<xsl:value-of select=\"@groupId\"/>)</h5>\n             <blockquote>\n               <xsl:choose>\n                 <xsl:when test=\"string-length(attributes/attribute) &gt; 0\">\n                   <xsl:call-template name=\"attributes\">\n                     <xsl:with-param name=\"label\">Attributes</xsl:with-param>\n                     <xsl:with-param name=\"node\" select=\"attributes/attribute\"/>\n                   </xsl:call-template>\n                 </xsl:when>\n                 <xsl:otherwise>\n                   <h5>THIS GROUP HASN''T ATTRIBUTES</h5>\n                 </xsl:otherwise>\n               </xsl:choose>\n               <xsl:choose>\n                 <xsl:when test=\"string-length(derivedAttributes/derivedAttribute) &gt; 0\">\n                   <xsl:call-template name=\"attributes\">\n                     <xsl:with-param name=\"label\">Derived Attributes</xsl:with-param>\n                     <xsl:with-param name=\"node\" select=\"derivedAttributes/derivedAttribute\"/>\n                   </xsl:call-template>\n                 </xsl:when>\n                 <xsl:otherwise>\n                   <h5>THIS GROUP HASN''T DERIVED ATTRIBUTES</h5>\n                 </xsl:otherwise>\n               </xsl:choose>\n               <xsl:choose>\n                 <xsl:when test=\"string-length(virtualAttributes/virtualAttribute) &gt; 0\">\n                   <xsl:call-template name=\"attributes\">\n                     <xsl:with-param name=\"label\">Virtual Attributes</xsl:with-param>\n                     <xsl:with-param name=\"node\" select=\"virtualAttributes/virtualAttribute\"/>\n                   </xsl:call-template>\n                 </xsl:when>\n                 <xsl:otherwise>\n                   <h5>THIS GROUP HASN''T VIRTUAL ATTRIBUTES</h5>\n                 </xsl:otherwise>\n               </xsl:choose>\n               <xsl:call-template name=\"groupResources\">\n                 <xsl:with-param name=\"node\" select=\"resources/resource\"/>\n               </xsl:call-template>\n             </blockquote>\n           </xsl:for-each>\n         </xsl:when>\n         <xsl:otherwise>\n           <h5>THIS US'), NULL);           
INSERT INTO SYSTEM_LOB_STREAM VALUES(6, 2, STRINGDECODE('ER ISN''T ASSIGNED TO A GROUP</h5>\n         </xsl:otherwise>\n       </xsl:choose>\n       <xsl:if test=\"string-length(resources) &gt; 0\">\n         <xsl:call-template name=\"resources\">\n           <xsl:with-param name=\"node\" select=\"resources/resource\"/>\n         </xsl:call-template>\n       </xsl:if>\n       <hr/>\n     </xsl:for-each>\n        \n   </xsl:template>\n \n   <xsl:template match=\"reportlet[@class=''org.apache.syncope.core.provisioning.java.job.report.GroupReportlet'']\">\n     <h2>Reportlet: <xsl:value-of select=\"@name\"/></h2>\n     <xsl:for-each select=\"group\">\n       <h3>Group <xsl:value-of select=\"@name\"/></h3>\n       \n       <table style=\"border: 1px solid black;\">\n         <tr>\n           <td>Id:</td>\n           <td>\n             <xsl:value-of select=\"@id\"/>\n           </td>\n         </tr>\n         <xsl:if test=\"@groupOwner != ''null''\"> <!--!= null test=\"not(USER/FIRSTNAME)\" -->\n           <tr>\n             <td>Group Owner:</td>\n             <td>\n               <xsl:value-of select=\"@groupOwner\"/>\n             </td>\n           </tr>\n         </xsl:if>\n         <xsl:if test=\"@userOwner != ''null''\">\n           <tr>\n             <td>User Owner:</td>\n             <td>\n               <xsl:value-of select=\"@userOwner\"/>\n             </td>\n           </tr>\n         </xsl:if>\n         \n       </table>\n \n       <xsl:choose>\n         <xsl:when test=\"string-length(attributes/attribute) &gt; 0\">\n           <xsl:call-template name=\"attributes\">\n             <xsl:with-param name=\"label\">Attributes</xsl:with-param>\n             <xsl:with-param name=\"node\" select=\"attributes/attribute\"/>\n           </xsl:call-template>\n         </xsl:when>\n         <xsl:otherwise>\n           <h5>THIS GROUP HASN''T ANY ATTRIBUTE</h5>\n         </xsl:otherwise>\n       </xsl:choose>\n \n       <xsl:choose>\n         <xsl:when test=\"string-length(derivedAttributes/derivedAttribute) &gt; 0\">\n           <xsl:call-template name=\"attributes\">\n             <xsl:with-param name=\"label\">Derived Attributes</xsl:with-param>\n             <xsl:with-param name=\"node\" select=\"derivedAttributes/derivedAttribute\"/>\n           </xsl:call-template>\n         </xsl:when>\n         <xsl:otherwise>\n           <h5>THIS GROUP HASN''T ANY DERIVED ATTRIBUTE</h5>\n         </xsl:otherwise>\n       </xsl:choose>\n       <!--</xsl:if>-->\n       <xsl:choose>\n         <xsl:when test=\"string-length(virtualAttributes/virtualAttribute) &gt; 0\">\n           <xsl:call-template name=\"attributes\">\n             <xsl:with-param name=\"label\">Virtual Attributes</xsl:with-param>\n             <xsl:with-param name=\"node\" select=\"virtualAttributes/virtualAttribute\"/>\n           </xsl:call-template>\n         </xsl:when>\n         <xsl:otherwise>\n           <h5>THIS GROUP HASN''T ANY VIRTUAL ATTRIBUTE</h5>\n         </xsl:otherwise>\n       </xsl:choose>\n       \n       <xsl:choose>\n         <xsl:when test=\"users/user\">\n           <h4>Users</h4>\n           <xsl:for-each select=\"users/user\">\n             <h5>User: <xsl:value-of select=\"@userUsername\"/> (Id: <xsl:value-of select=\"@userId\"/>)</h5>\n           </xsl:for-each>\n         </xsl:when>\n         <xsl:otherwise>\n           <h5>THIS GROUP HASN''T ANY USER ASSIGNED TO</h5>\n         </xsl:otherwise>\n       </xsl:choose>\n       \n       <xsl:call-template name=\"groupResources\">\n         <xsl:with-param name=\"node\" select=\"resources/resource\"/>\n       </xsl:call-template>\n       <hr/>\n       \n     </xsl:for-each>\n   </xsl:template>\n   \n   <xsl:template name=\"attributes\">\n     <xsl:param name=\"label\"/>\n     <xsl:param name=\"node\"/>\n \n     <h4>\n       <xsl:value-of select=\"$label\"/>\n     </h4>\n     \n     <table>\n       <thead>\n         <tr>\n           <th>Schema name</th>\n           <th>Value(s)</th>\n         </tr>\n       </thead>\n       <tbody>\n         <xsl:for-each select=\"$node\">\n           <xsl:if test=\"string-length(value/text()) &gt; 0\">\n             <tr>\n               <td>\n                 <xsl:value-of select=\"@name\"/>\n               </td>\n               <td>\n                 <ul>\n                   <xsl:for-each select=\"value\">\n                     <li>\n        '), NULL);         
INSERT INTO SYSTEM_LOB_STREAM VALUES(6, 3, STRINGDECODE('               <xsl:value-of select=\"text()\"/>\n                     </li>\n                   </xsl:for-each>\n                 </ul>\n               </td>\n             </tr>\n           </xsl:if>\n         </xsl:for-each>\n       </tbody>\n     </table>\n   </xsl:template>\n \n   <xsl:template name=\"resources\">\n     <xsl:param name=\"node\"/>\n     \n     <h4>Resources</h4>\n     <ul>\n       <xsl:for-each select=\"$node\">\n         <li>\n           <xsl:value-of select=\"@name\"/>\n         </li>\n       </xsl:for-each>\n     </ul>\n   </xsl:template>\n   \n   <xsl:template name=\"groupResources\">\n     <xsl:param name=\"node\"/>\n     \n     <h4>Group Resources</h4>\n     <ul>\n       <xsl:for-each select=\"$node\">\n         <li>\n           <xsl:value-of select=\"@name\"/>\n         </li>\n       </xsl:for-each>\n     </ul>\n   </xsl:template>\n </xsl:stylesheet>\n'), NULL); 
INSERT INTO PUBLIC.REPORTTEMPLATE(ID, CSVTEMPLATE, FOTEMPLATE, HTMLTEMPLATE) VALUES
('empty', NULL, NULL, NULL),
('sample', SYSTEM_COMBINE_CLOB(4), SYSTEM_COMBINE_CLOB(5), SYSTEM_COMBINE_CLOB(6));           
CREATE MEMORY TABLE PUBLIC.SAML2IDP(
    ID VARCHAR(36) NOT NULL,
    BINDINGTYPE SMALLINT NOT NULL,
    CREATEUNMATCHING INTEGER NOT NULL,
    ENTITYID VARCHAR(255) NOT NULL,
    METADATA BLOB,
    NAME VARCHAR(255) NOT NULL,
    SELFREGUNMATCHING INTEGER NOT NULL,
    SUPPORTUNSOLICITED INTEGER NOT NULL,
    UPDATEMATCHING INTEGER NOT NULL,
    USEDEFLATEENCODING INTEGER NOT NULL
);            
ALTER TABLE PUBLIC.SAML2IDP ADD CONSTRAINT PUBLIC.CONSTRAINT_A4 PRIMARY KEY(ID);               
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.SAML2IDP; 
CREATE MEMORY TABLE PUBLIC.SAML2IDPITEM(
    ID VARCHAR(36) NOT NULL,
    CONNOBJECTKEY INTEGER,
    EXTATTRNAME VARCHAR(255),
    INTATTRNAME VARCHAR(255),
    MANDATORYCONDITION VARCHAR(255),
    PASSWORD INTEGER,
    PROPJEXL VARCHAR(255),
    PULLJEXL VARCHAR(255),
    PURPOSE VARCHAR(20),
    IDP_ID VARCHAR(36)
);               
ALTER TABLE PUBLIC.SAML2IDPITEM ADD CONSTRAINT PUBLIC.CONSTRAINT_A3 PRIMARY KEY(ID);           
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.SAML2IDPITEM;             
CREATE MEMORY TABLE PUBLIC.SAML2IDPITEM_TRANSFORMER(
    SAML2IDPITEMITEM_ID VARCHAR(36),
    TRANSFORMERCLASSNAME VARCHAR(255)
);             
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.SAML2IDPITEM_TRANSFORMER; 
CREATE MEMORY TABLE PUBLIC.SAML2IDP_ACTIONSCLASSNAMES(
    SAML2IDP_ID VARCHAR(36),
    ACTIONCLASSNAME VARCHAR(255)
);        
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.SAML2IDP_ACTIONSCLASSNAMES;               
CREATE MEMORY TABLE PUBLIC.SAML2USERTEMPLATE(
    ID VARCHAR(36) NOT NULL,
    TEMPLATE CLOB,
    IDP_ID VARCHAR(36),
    ANYTYPE_ID VARCHAR(255)
);           
ALTER TABLE PUBLIC.SAML2USERTEMPLATE ADD CONSTRAINT PUBLIC.CONSTRAINT_21 PRIMARY KEY(ID);      
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.SAML2USERTEMPLATE;        
CREATE MEMORY TABLE PUBLIC.SECURITYQUESTION(
    ID VARCHAR(36) NOT NULL,
    CONTENT VARCHAR(255)
);          
ALTER TABLE PUBLIC.SECURITYQUESTION ADD CONSTRAINT PUBLIC.CONSTRAINT_32 PRIMARY KEY(ID);       
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.SECURITYQUESTION;         
INSERT INTO PUBLIC.SECURITYQUESTION(ID, CONTENT) VALUES
('887028ea-66fc-41e7-b397-620d7ea6dfbb', 'What''s your mother''s maiden name?');       
CREATE MEMORY TABLE PUBLIC.SYNCOPECONF(
    ID VARCHAR(255) NOT NULL
);        
ALTER TABLE PUBLIC.SYNCOPECONF ADD CONSTRAINT PUBLIC.CONSTRAINT_6F PRIMARY KEY(ID);            
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.SYNCOPECONF;              
INSERT INTO PUBLIC.SYNCOPECONF(ID) VALUES
('cd64d66f-6fff-4008-b966-a06b1cc1436d');            
CREATE MEMORY TABLE PUBLIC.SYNCOPEDOMAIN(
    ID VARCHAR(255) NOT NULL,
    ADMINCIPHERALGORITHM VARCHAR(20),
    ADMINPWD VARCHAR(255)
);     
ALTER TABLE PUBLIC.SYNCOPEDOMAIN ADD CONSTRAINT PUBLIC.CONSTRAINT_40 PRIMARY KEY(ID);          
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.SYNCOPEDOMAIN;            
INSERT INTO PUBLIC.SYNCOPEDOMAIN(ID, ADMINCIPHERALGORITHM, ADMINPWD) VALUES
('Two', 'SHA', '2AA60A8FF7FCD473D321E0146AFD9E26DF395147');        
CREATE MEMORY TABLE PUBLIC.SYNCOPEGROUP(
    ID VARCHAR(36) NOT NULL,
    CREATIONDATE TIMESTAMP,
    CREATOR VARCHAR(255),
    LASTCHANGEDATE TIMESTAMP,
    LASTMODIFIER VARCHAR(255),
    STATUS VARCHAR(255),
    WORKFLOWID VARCHAR(255),
    NAME VARCHAR(255),
    REALM_ID VARCHAR(36),
    GROUPOWNER_ID VARCHAR(36),
    USEROWNER_ID VARCHAR(36)
); 
ALTER TABLE PUBLIC.SYNCOPEGROUP ADD CONSTRAINT PUBLIC.CONSTRAINT_8E PRIMARY KEY(ID);           
-- 16 +/- SELECT COUNT(*) FROM PUBLIC.SYNCOPEGROUP;            
INSERT INTO PUBLIC.SYNCOPEGROUP(ID, CREATIONDATE, CREATOR, LASTCHANGEDATE, LASTMODIFIER, STATUS, NAME, REALM_ID, GROUPOWNER_ID, USEROWNER_ID) VALUES
('37d15e4c-cdc1-460b-a591-8505c8133806', TIMESTAMP '2010-10-20 11:00:00', 'admin', TIMESTAMP '2010-10-20 11:00:00', 'admin', NULL, 'root', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL, NULL),
('b1f7c12d-ec83-441f-a50e-1691daaedf3b', TIMESTAMP '2010-10-20 11:00:00', 'admin', TIMESTAMP '2010-10-20 11:00:00', 'admin', NULL, 'child', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL, NULL),
('29f96485-729e-4d31-88a1-6fc60e4677f3', TIMESTAMP '2010-10-20 11:00:00', 'admin', TIMESTAMP '2010-10-20 11:00:00', 'admin', NULL, 'citizen', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL, NULL),
('8fb2d51e-c605-4e80-a72b-13ffecf1aa9a', TIMESTAMP '2010-10-20 11:00:00', 'admin', TIMESTAMP '2010-10-20 11:00:00', 'admin', NULL, 'employee', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL, NULL),
('a3c1a693-a6be-483f-a2b3-5cfec146f4bf', TIMESTAMP '2010-10-20 11:00:00', 'admin', TIMESTAMP '2010-10-20 11:00:00', 'admin', NULL, 'secretary', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL, NULL),
('ebf97068-aa4b-4a85-9f01-680e8c4cf227', TIMESTAMP '2010-10-20 11:00:00', 'admin', TIMESTAMP '2010-10-20 11:00:00', 'admin', NULL, 'director', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL, '823074dc-d280-436d-a7dd-07399fae48ec'),
('bf825fe1-7320-4a54-bd64-143b5c18ab97', TIMESTAMP '2010-10-20 11:00:00', 'admin', TIMESTAMP '2010-10-20 11:00:00', 'admin', NULL, 'managingDirector', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL, NULL),
('f779c0d4-633b-4be5-8f57-32eb478a3ca5', TIMESTAMP '2010-10-20 11:00:00', 'admin', TIMESTAMP '2010-10-20 11:00:00', 'admin', NULL, 'otherchild', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL, NULL),
('0cbcabd2-4410-4b6b-8f05-a052b451d18f', TIMESTAMP '2010-10-20 11:00:00', 'admin', TIMESTAMP '2010-10-20 11:00:00', 'admin', NULL, 'groupForWorkflowApproval', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL, NULL),
('b8d38784-57e7-4595-859a-076222644b55', TIMESTAMP '2010-10-20 11:00:00', 'admin', TIMESTAMP '2010-10-20 11:00:00', 'admin', NULL, 'managingConsultant', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL, NULL),
('268fed79-f440-4390-9435-b273768eb5d6', TIMESTAMP '2010-10-20 11:00:00', 'admin', TIMESTAMP '2010-10-20 11:00:00', 'admin', NULL, 'groupForWorkflowOptIn', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL, NULL),
('0626100b-a4ba-4e00-9971-86fad52a6216', TIMESTAMP '2010-10-20 11:00:00', 'admin', TIMESTAMP '2010-10-20 11:00:00', 'admin', NULL, 'aGroupForPropagation', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL, NULL),
('ba9ed509-b1f5-48ab-a334-c8530a6422dc', TIMESTAMP '2010-10-20 11:00:00', 'admin', TIMESTAMP '2010-10-20 11:00:00', 'admin', NULL, 'bGroupForPropagation', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL, NULL),
('ece66293-8f31-4a84-8e8d-23da36e70846', TIMESTAMP '2010-10-20 11:00:00', 'admin', TIMESTAMP '2010-10-20 11:00:00', 'admin', NULL, 'artDirector', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL, NULL),
('034740a9-fa10-453b-af37-dc7897e98fb1', TIMESTAMP '2010-10-20 11:00:00', 'admin', TIMESTAMP '2010-10-20 11:00:00', 'admin', NULL, 'additional', 'c5b75db1-fce7-470f-b780-3b9934d82a9d', NULL, NULL),
('e7ff94e8-19c9-4f0a-b8b7-28327edbf6ed', TIMESTAMP '2010-10-20 11:00:00', 'admin', TIMESTAMP '2010-10-20 11:00:00', 'admin', NULL, 'fake', '722f3d84-9c2b-4525-8f6e-e4b82c55a36c', NULL, NULL);          
CREATE MEMORY TABLE PUBLIC.SYNCOPEGROUP_ANYTYPECLASS(
    GROUP_ID VARCHAR(36),
    ANYTYPECLASS_ID VARCHAR(255)
);            
-- 2 +/- SELECT COUNT(*) FROM PUBLIC.SYNCOPEGROUP_ANYTYPECLASS;
INSERT INTO PUBLIC.SYNCOPEGROUP_ANYTYPECLASS(GROUP_ID, ANYTYPECLASS_ID) VALUES
('0626100b-a4ba-4e00-9971-86fad52a6216', 'csv'),
('ba9ed509-b1f5-48ab-a334-c8530a6422dc', 'csv');               
CREATE MEMORY TABLE PUBLIC.SYNCOPEGROUP_EXTERNALRESOURCE(
    GROUP_ID VARCHAR(36),
    RESOURCE_ID VARCHAR(255)
);            
-- 7 +/- SELECT COUNT(*) FROM PUBLIC.SYNCOPEGROUP_EXTERNALRESOURCE;            
INSERT INTO PUBLIC.SYNCOPEGROUP_EXTERNALRESOURCE(GROUP_ID, RESOURCE_ID) VALUES
('29f96485-729e-4d31-88a1-6fc60e4677f3', 'ws-target-resource-list-mappings-1'),
('f779c0d4-633b-4be5-8f57-32eb478a3ca5', 'ws-target-resource-2'),
('29f96485-729e-4d31-88a1-6fc60e4677f3', 'ws-target-resource-list-mappings-2'),
('bf825fe1-7320-4a54-bd64-143b5c18ab97', 'ws-target-resource-nopropagation'),
('b8d38784-57e7-4595-859a-076222644b55', 'ws-target-resource-nopropagation3'),
('0626100b-a4ba-4e00-9971-86fad52a6216', 'resource-csv'),
('ba9ed509-b1f5-48ab-a334-c8530a6422dc', 'resource-csv');              
CREATE MEMORY TABLE PUBLIC.SYNCOPELOGGER(
    LOGNAME VARCHAR(255) NOT NULL,
    LOGLEVEL VARCHAR(20) NOT NULL,
    LOGTYPE VARCHAR(20) NOT NULL
);            
ALTER TABLE PUBLIC.SYNCOPELOGGER ADD CONSTRAINT PUBLIC.CONSTRAINT_4D PRIMARY KEY(LOGNAME);     
-- 30 +/- SELECT COUNT(*) FROM PUBLIC.SYNCOPELOGGER;           
INSERT INTO PUBLIC.SYNCOPELOGGER(LOGNAME, LOGLEVEL, LOGTYPE) VALUES
('syncope.audit.[LOGIC]:[SyncopeLogic]:[]:[isSelfRegAllowed]:[SUCCESS]', 'DEBUG', 'AUDIT'),
('ROOT', 'INFO', 'LOG'),
('org.apache.wss4j', 'ERROR', 'LOG'),
('io.swagger', 'ERROR', 'LOG'),
('org.springframework.orm', 'INFO', 'LOG'),
('org.activiti', 'ERROR', 'LOG'),
('org.apache.syncope.core.provisioning', 'INFO', 'LOG'),
('syncope.audit.Master', 'DEBUG', 'LOG'),
('org.apache.xml', 'ERROR', 'LOG'),
('org.springframework', 'INFO', 'LOG'),
('org.elasticsearch', 'INFO', 'LOG'),
('com.zaxxer.hikari', 'ERROR', 'LOG'),
('net.tirasa.connid', 'DEBUG', 'LOG'),
('org.apache.syncope', 'INFO', 'LOG'),
('org.quartz', 'INFO', 'LOG'),
('org.apache.syncope.core.logic', 'INFO', 'LOG'),
('org.apache.ibatis', 'INFO', 'LOG'),
('org.apache.fop', 'ERROR', 'LOG'),
('org.apache.syncope.core.persistence', 'INFO', 'LOG'),
('org.apache.cxf', 'ERROR', 'LOG'),
('org.reflections', 'ERROR', 'LOG'),
('org.apache.cocoon', 'ERROR', 'LOG'),
('org.springframework.web', 'INFO', 'LOG'),
('org.apache.http', 'INFO', 'LOG'),
('org.opensaml', 'ERROR', 'LOG'),
('io.netty', 'ERROR', 'LOG'),
('org.apache.camel', 'ERROR', 'LOG'),
('org.apache.syncope.core.rest', 'INFO', 'LOG'),
('org.apache.syncope.core.provisioning.api.ConnIdBundleManager', 'INFO', 'LOG'),
('org.identityconnectors', 'DEBUG', 'LOG');  
CREATE MEMORY TABLE PUBLIC.SYNCOPEROLE(
    ID VARCHAR(255) NOT NULL,
    CONSOLELAYOUTINFO CLOB
);            
ALTER TABLE PUBLIC.SYNCOPEROLE ADD CONSTRAINT PUBLIC.CONSTRAINT_6FF PRIMARY KEY(ID);           
-- 5 +/- SELECT COUNT(*) FROM PUBLIC.SYNCOPEROLE;              
INSERT INTO PUBLIC.SYNCOPEROLE(ID, CONSOLELAYOUTINFO) VALUES
('User reviewer', NULL),
('User manager', NULL),
('Other', NULL),
('Search for realm evenTwo', NULL),
('Connector and Resource for realm evenTwo', '{"USER" : {"formClass" : "org.apache.syncope.client.console.wizards.any.GFSUserWizardBuilder","auxClasses" : false,"groups" : true,"plainAttrs" : true,"whichPlainAttrs" : [ ],"derAttrs" : false,"whichDerAttrs" : [ ],"virAttrs" : false,"whichVirAttrs" : [ ],"resources" : true,"passwordManagement" : true,"roles" : false,"relationships" : false},"GROUP" : {"formClass" : "org.apache.syncope.client.console.wizards.any.GFSGroupWizardBuilder","auxClasses" : false,"groups" : true,"plainAttrs" : true,"whichPlainAttrs" : [ ],"derAttrs" : false,"whichDerAttrs" : [ ],"virAttrs" : false,"whichVirAttrs" : [ ],"resources" : false,"ownership" : false,"dynamicMemberships" : false,"typeExtensions" : false}}');         
CREATE MEMORY TABLE PUBLIC.SYNCOPEROLE_DYNREALM(
    ROLE_ID VARCHAR(255),
    DYNAMICREALM_ID VARCHAR(255)
); 
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.SYNCOPEROLE_DYNREALM;     
CREATE MEMORY TABLE PUBLIC.SYNCOPEROLE_ENTITLEMENTS(
    ROLE_ID VARCHAR(255),
    ENTITLEMENT VARCHAR(255)
); 
-- 29 +/- SELECT COUNT(*) FROM PUBLIC.SYNCOPEROLE_ENTITLEMENTS;
INSERT INTO PUBLIC.SYNCOPEROLE_ENTITLEMENTS(ROLE_ID, ENTITLEMENT) VALUES
('User reviewer', 'USER_READ'),
('User reviewer', 'USER_LIST'),
('User reviewer', 'USER_SEARCH'),
('User reviewer', 'ANYTYPE_LIST'),
('User reviewer', 'ANYTYPE_READ'),
('User reviewer', 'ANYTYPECLASS_LIST'),
('User reviewer', 'ANYTYPECLASS_READ'),
('User manager', 'USER_READ'),
('User manager', 'USER_LIST'),
('User manager', 'USER_SEARCH'),
('User manager', 'ANYTYPE_LIST'),
('User manager', 'ANYTYPE_READ'),
('User manager', 'ANYTYPECLASS_LIST'),
('User manager', 'ANYTYPECLASS_READ'),
('User manager', 'WORKFLOW_FORM_CLAIM'),
('User manager', 'WORKFLOW_FORM_SUBMIT'),
('Other', 'SCHEMA_READ'),
('Other', 'GROUP_READ'),
('Other', 'WORKFLOW_FORM_CLAIM'),
('Search for realm evenTwo', 'USER_READ'),
('Search for realm evenTwo', 'USER_SEARCH'),
('Connector and Resource for realm evenTwo', 'CONNECTOR_READ'),
('Connector and Resource for realm evenTwo', 'CONNECTOR_UPDATE'),
('Connector and Resource for realm evenTwo', 'CONNECTOR_DELETE'),
('Connector and Resource for realm evenTwo', 'CONNECTOR_LIST'),
('Connector and Resource for realm evenTwo', 'RESOURCE_READ'),
('Connector and Resource for realm evenTwo', 'RESOURCE_UPDATE'),
('Connector and Resource for realm evenTwo', 'RESOURCE_DELETE'),
('Connector and Resource for realm evenTwo', 'RESOURCE_LIST');          
CREATE MEMORY TABLE PUBLIC.SYNCOPEROLE_REALM(
    ROLE_ID VARCHAR(255),
    REALM_ID VARCHAR(36)
);            
-- 6 +/- SELECT COUNT(*) FROM PUBLIC.SYNCOPEROLE_REALM;        
INSERT INTO PUBLIC.SYNCOPEROLE_REALM(ROLE_ID, REALM_ID) VALUES
('User reviewer', '722f3d84-9c2b-4525-8f6e-e4b82c55a36c'),
('User reviewer', 'c5b75db1-fce7-470f-b780-3b9934d82a9d'),
('User manager', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28'),
('Other', '722f3d84-9c2b-4525-8f6e-e4b82c55a36c'),
('Search for realm evenTwo', '0679e069-7355-4b20-bd11-a5a0a5453c7c'),
('Connector and Resource for realm evenTwo', '0679e069-7355-4b20-bd11-a5a0a5453c7c');  
CREATE MEMORY TABLE PUBLIC.SYNCOPESCHEMA(
    ID VARCHAR(255) NOT NULL
);      
ALTER TABLE PUBLIC.SYNCOPESCHEMA ADD CONSTRAINT PUBLIC.CONSTRAINT_59 PRIMARY KEY(ID);          
-- 55 +/- SELECT COUNT(*) FROM PUBLIC.SYNCOPESCHEMA;           
INSERT INTO PUBLIC.SYNCOPESCHEMA(ID) VALUES
('password.cipher.algorithm'),
('notificationjob.cronExpression'),
('notification.maxRetries'),
('token.length'),
('token.expireTime'),
('selfRegistration.allowed'),
('passwordReset.allowed'),
('passwordReset.securityQuestion'),
('authentication.attributes'),
('authentication.statuses'),
('log.lastlogindate'),
('return.password.value'),
('jwt.lifetime.minutes'),
('connector.conf.history.size'),
('resource.conf.history.size'),
('fullname'),
('userId'),
('loginDate'),
('firstname'),
('surname'),
('ctype'),
('email'),
('activationDate'),
('uselessReadonly'),
('cool'),
('gender'),
('aLong'),
('makeItDouble'),
('obscure'),
('photo'),
('csvuserid'),
('cn'),
('noschema'),
('info'),
('icon'),
('show'),
('rderived_sx'),
('rderived_dx'),
('title'),
('rderiveddata'),
('displayProperty'),
('rderToBePropagated'),
('rderivedschema'),
('subscriptionDate'),
('mderived_sx'),
('mderived_dx'),
('postalAddress'),
('mderiveddata'),
('mderToBePropagated'),
('model'),
('location'),
('virtualReadOnly'),
('rvirtualdata'),
('virtualdata');   
CREATE MEMORY TABLE PUBLIC.SYNCOPEUSER(
    ID VARCHAR(36) NOT NULL,
    CREATIONDATE TIMESTAMP,
    CREATOR VARCHAR(255),
    LASTCHANGEDATE TIMESTAMP,
    LASTMODIFIER VARCHAR(255),
    STATUS VARCHAR(255),
    WORKFLOWID VARCHAR(255),
    CHANGEPWDDATE TIMESTAMP,
    CIPHERALGORITHM VARCHAR(20),
    FAILEDLOGINS INTEGER,
    LASTLOGINDATE TIMESTAMP,
    MUSTCHANGEPASSWORD INTEGER,
    PASSWORD VARCHAR(255),
    SECURITYANSWER VARCHAR(255),
    SUSPENDED INTEGER,
    TOKEN CLOB,
    TOKENEXPIRETIME TIMESTAMP,
    USERNAME VARCHAR(255),
    REALM_ID VARCHAR(36),
    SECURITYQUESTION_ID VARCHAR(36)
);       
ALTER TABLE PUBLIC.SYNCOPEUSER ADD CONSTRAINT PUBLIC.CONSTRAINT_6FFB PRIMARY KEY(ID);          
-- 5 +/- SELECT COUNT(*) FROM PUBLIC.SYNCOPEUSER;              
INSERT INTO PUBLIC.SYNCOPEUSER(ID, CREATIONDATE, CREATOR, LASTCHANGEDATE, LASTMODIFIER, STATUS, WORKFLOWID, CHANGEPWDDATE, CIPHERALGORITHM, FAILEDLOGINS, LASTLOGINDATE, MUSTCHANGEPASSWORD, PASSWORD, SECURITYANSWER, SUSPENDED, TOKEN, TOKENEXPIRETIME, USERNAME, REALM_ID, SECURITYQUESTION_ID) VALUES
('1417acbe-cbf6-4277-9372-e75e04f97000', TIMESTAMP '2010-10-20 11:00:00', 'admin', TIMESTAMP '2010-10-20 11:00:00', 'admin', 'active', '4', NULL, 'SHA1', NULL, NULL, NULL, '5baa61e4c9b93f3f0682250b6cf8331b7ee68fd8', NULL, 0, NULL, NULL, 'rossini', 'c5b75db1-fce7-470f-b780-3b9934d82a9d', NULL),
('74cd8ece-715a-44a4-a736-e17b46c4e7e6', TIMESTAMP '2010-10-20 11:00:00', 'admin', TIMESTAMP '2010-10-20 11:00:00', 'admin', 'active', '6', NULL, 'SHA1', NULL, NULL, NULL, '5baa61e4c9b93f3f0682250b6cf8331b7ee68fd8', NULL, 0, NULL, NULL, 'verdi', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL),
('b3cbc78d-32e6-4bd4-92e0-bbe07566a2ee', TIMESTAMP '2010-10-20 11:00:00', 'admin', TIMESTAMP '2010-10-20 11:00:00', 'admin', 'active', '8', NULL, 'SHA1', NULL, NULL, NULL, '5baa61e4c9b93f3f0682250b6cf8331b7ee68fd8', NULL, 0, NULL, NULL, 'vivaldi', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL),
('c9b2dec2-00a7-4855-97c0-d854842b4b24', TIMESTAMP '2010-10-20 11:00:00', 'admin', TIMESTAMP '2010-10-20 11:00:00', 'admin', 'active', '10', NULL, 'SHA1', NULL, NULL, NULL, '5baa61e4c9b93f3f0682250b6cf8331b7ee68fd8', NULL, 0, NULL, NULL, 'bellini', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL),
('823074dc-d280-436d-a7dd-07399fae48ec', TIMESTAMP '2010-10-20 11:00:00', 'admin', TIMESTAMP '2010-10-20 11:00:00', 'admin', 'active', '12', NULL, 'SHA1', NULL, NULL, NULL, '5baa61e4c9b93f3f0682250b6cf8331b7ee68fd8', NULL, 0, NULL, NULL, 'puccini', 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL);              
CREATE MEMORY TABLE PUBLIC.SYNCOPEUSER_ANYTYPECLASS(
    USER_ID VARCHAR(36),
    ANYTYPECLASS_ID VARCHAR(255)
);              
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.SYNCOPEUSER_ANYTYPECLASS; 
CREATE MEMORY TABLE PUBLIC.SYNCOPEUSER_EXTERNALRESOURCE(
    USER_ID VARCHAR(36),
    RESOURCE_ID VARCHAR(255)
);              
-- 5 +/- SELECT COUNT(*) FROM PUBLIC.SYNCOPEUSER_EXTERNALRESOURCE;             
INSERT INTO PUBLIC.SYNCOPEUSER_EXTERNALRESOURCE(USER_ID, RESOURCE_ID) VALUES
('1417acbe-cbf6-4277-9372-e75e04f97000', 'resource-testdb2'),
('b3cbc78d-32e6-4bd4-92e0-bbe07566a2ee', 'ws-target-resource-delete'),
('b3cbc78d-32e6-4bd4-92e0-bbe07566a2ee', 'ws-target-resource-2'),
('b3cbc78d-32e6-4bd4-92e0-bbe07566a2ee', 'ws-target-resource-1'),
('823074dc-d280-436d-a7dd-07399fae48ec', 'resource-testdb2');            
CREATE MEMORY TABLE PUBLIC.SYNCOPEUSER_PASSWORDHISTORY(
    USER_ID VARCHAR(36),
    PASSWORDHISTORYVALUE VARCHAR(255)
);      
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.SYNCOPEUSER_PASSWORDHISTORY;              
CREATE MEMORY TABLE PUBLIC.SYNCOPEUSER_SYNCOPEROLE(
    USER_ID VARCHAR(36),
    ROLE_ID VARCHAR(255)
);       
-- 5 +/- SELECT COUNT(*) FROM PUBLIC.SYNCOPEUSER_SYNCOPEROLE;  
INSERT INTO PUBLIC.SYNCOPEUSER_SYNCOPEROLE(USER_ID, ROLE_ID) VALUES
('1417acbe-cbf6-4277-9372-e75e04f97000', 'Other'),
('c9b2dec2-00a7-4855-97c0-d854842b4b24', 'User reviewer'),
('c9b2dec2-00a7-4855-97c0-d854842b4b24', 'User manager'),
('823074dc-d280-436d-a7dd-07399fae48ec', 'Search for realm evenTwo'),
('823074dc-d280-436d-a7dd-07399fae48ec', 'Connector and Resource for realm evenTwo');        
CREATE MEMORY TABLE PUBLIC.TASK(
    ID VARCHAR(36) NOT NULL,
    DTYPE VARCHAR(31),
    ACTIVE INTEGER,
    CRONEXPRESSION VARCHAR(255),
    DESCRIPTION VARCHAR(255),
    JOBDELEGATECLASSNAME VARCHAR(255),
    NAME VARCHAR(255),
    STARTAT TIMESTAMP,
    ANYTYPE VARCHAR(255),
    ANYTYPEKIND VARCHAR(20),
    ATTRIBUTES CLOB,
    CONNOBJECTKEY VARCHAR(255),
    ENTITYKEY VARCHAR(255),
    OBJECTCLASSNAME VARCHAR(255),
    OLDCONNOBJECTKEY VARCHAR(255),
    OPERATION VARCHAR(20),
    RESOURCE_ID VARCHAR(255),
    MATCHINGRULE VARCHAR(20),
    PERFORMCREATE INTEGER,
    PERFORMDELETE INTEGER,
    PERFORMUPDATE INTEGER,
    SYNCSTATUS INTEGER,
    UNMATCHINGRULE VARCHAR(20),
    PULLMODE VARCHAR(23),
    RECONCILIATIONFILTERBUILDERCLASSNAME VARCHAR(255),
    DESTINATIONREALM_ID VARCHAR(36),
    EXECUTED INTEGER,
    HTMLBODY CLOB,
    SENDER VARCHAR(255),
    SUBJECT VARCHAR(255),
    TEXTBODY CLOB,
    TRACELEVEL VARCHAR(20),
    NOTIFICATION_ID VARCHAR(36),
    SOURCEREALM_ID VARCHAR(36)
);  
ALTER TABLE PUBLIC.TASK ADD CONSTRAINT PUBLIC.CONSTRAINT_27 PRIMARY KEY(ID);   
-- 30 +/- SELECT COUNT(*) FROM PUBLIC.TASK;    
INSERT INTO PUBLIC.TASK(ID, DTYPE, ACTIVE, CRONEXPRESSION, DESCRIPTION, JOBDELEGATECLASSNAME, NAME, STARTAT, ANYTYPE, ANYTYPEKIND, ATTRIBUTES, CONNOBJECTKEY, ENTITYKEY, OBJECTCLASSNAME, OLDCONNOBJECTKEY, OPERATION, RESOURCE_ID, MATCHINGRULE, PERFORMCREATE, PERFORMDELETE, PERFORMUPDATE, SYNCSTATUS, UNMATCHINGRULE, PULLMODE, RECONCILIATIONFILTERBUILDERCLASSNAME, DESTINATIONREALM_ID, EXECUTED, HTMLBODY, SENDER, SUBJECT, TEXTBODY, TRACELEVEL, NOTIFICATION_ID, SOURCEREALM_ID) VALUES
('1e697572-b896-484c-ae7f-0c8f63fcbc6c', 'PropagationTask', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'USER', '[{"name":"__PASSWORD__","value":[{"readOnly":false,"disposed":false,"encryptedBytes":"m9nh2US0Sa6m+cXccCq0Xw==","base64SHA1Hash":"GFJ69qfjxEOdrmt+9q+0Cw2uz60="}]},{"name":"__NAME__","value":["userId"],"nameValue":"userId"},{"name":"fullname","value":["fullname"]},{"name":"type","value":["type"]}]', NULL, '1417acbe-cbf6-4277-9372-e75e04f97000', '__ACCOUNT__', NULL, 'UPDATE', 'ws-target-resource-2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
('b8870cfb-3c1e-4fc4-abcb-2559826232e6', 'PropagationTask', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'USER', '[{"name":"__PASSWORD__","value":[{"readOnly":false,"disposed":false,"encryptedBytes":"m9nh2US0Sa6m+cXccCq0Xw==","base64SHA1Hash":"GFJ69qfjxEOdrmt+9q+0Cw2uz60="}]},{"name":"__NAME__","value":["userId"],"nameValue":"userId"},{"name":"fullname","value":["fullname"]},{"name":"type","value":["type"]}]', NULL, '1417acbe-cbf6-4277-9372-e75e04f97000', '__ACCOUNT__', NULL, 'CREATE', 'ws-target-resource-2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
('316285cc-ae52-4ea2-a33b-7355e189ac3f', 'PropagationTask', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'USER', '[{"name":"__PASSWORD__","value":[{"readOnly":false,"disposed":false,"encryptedBytes":"m9nh2US0Sa6m+cXccCq0Xw==","base64SHA1Hash":"GFJ69qfjxEOdrmt+9q+0Cw2uz60="}]},{"name":"__NAME__","value":["userId"],"nameValue":"userId"},{"name":"type","value":["type"]}]', NULL, '1417acbe-cbf6-4277-9372-e75e04f97000', '__ACCOUNT__', NULL, 'DELETE', 'ws-target-resource-2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
('c41b9b71-9bfa-4f90-89f2-84787def4c5c', 'PullTask', 1, NULL, NULL, NULL, 'CSV (update matching; assign unmatching)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'resource-csv', 'UPDATE', 1, 1, 1, 1, 'ASSIGN', 'INCREMENTAL', NULL, 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
('e95555d2-1b09-42c8-b25b-f4c4ec597979', 'SchedTask', 1, '0 0 0 1 * ?', NULL, 'org.apache.syncope.fit.core.reference.TestSampleJobDelegate', 'SampleJob Task', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
('89de5014-e3f5-4462-84d8-d97575740baf', 'SchedTask', 1, '0 0/5 * * * ?', NULL, 'org.apache.syncope.core.provisioning.java.job.ExpiredAccessTokenCleanup', 'Access Token Cleanup Task', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
('d6c2d6d3-6329-44c1-9187-f1469ead1cfa', 'PropagationTask', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'USER', '[{"name":"__PASSWORD__","value":[{"readOnly":false,"disposed":false,"encryptedBytes":"m9nh2US0Sa6m+cXccCq0Xw==","base64SHA1Hash":"GFJ69qfjxEOdrmt+9q+0Cw2uz60="}]},{"name":"__NAME__","value":["userId"],"nameValue":"userId"},{"name":"fullname","value":["fullname"]},{"name":"type","value":["type"]}]', NULL, '1417acbe-cbf6-4277-9372-e75e04f97000', '__ACCOUNT__', NULL, 'UPDATE', 'ws-target-resource-nopropagation', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);     
INSERT INTO PUBLIC.TASK(ID, DTYPE, ACTIVE, CRONEXPRESSION, DESCRIPTION, JOBDELEGATECLASSNAME, NAME, STARTAT, ANYTYPE, ANYTYPEKIND, ATTRIBUTES, CONNOBJECTKEY, ENTITYKEY, OBJECTCLASSNAME, OLDCONNOBJECTKEY, OPERATION, RESOURCE_ID, MATCHINGRULE, PERFORMCREATE, PERFORMDELETE, PERFORMUPDATE, SYNCSTATUS, UNMATCHINGRULE, PULLMODE, RECONCILIATIONFILTERBUILDERCLASSNAME, DESTINATIONREALM_ID, EXECUTED, HTMLBODY, SENDER, SUBJECT, TEXTBODY, TRACELEVEL, NOTIFICATION_ID, SOURCEREALM_ID) VALUES
('83f7e85d-9774-43fe-adba-ccd856312994', 'PullTask', 1, NULL, NULL, NULL, 'TestDB Task', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'resource-testdb', 'UPDATE', 1, 0, 1, 1, 'PROVISION', 'FULL_RECONCILIATION', NULL, 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
('81d88f73-d474-4450-9031-605daa4e313f', 'PullTask', 1, NULL, NULL, NULL, 'TestDB2 Task', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'resource-testdb2', 'UPDATE', 1, 0, 1, 1, 'PROVISION', 'FULL_RECONCILIATION', NULL, 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
('7c2242f4-14af-4ab5-af31-cdae23783655', 'PullTask', 1, NULL, NULL, NULL, 'TestDB Pull Task', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'resource-db-pull', 'UPDATE', 1, 1, 1, 0, 'PROVISION', 'FULL_RECONCILIATION', NULL, 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
('1e419ca4-ea81-4493-a14f-28b90113686d', 'PullTask', 1, NULL, NULL, NULL, 'LDAP Pull Task', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'resource-ldap', 'UPDATE', 1, 1, 1, 0, 'PROVISION', 'FULL_RECONCILIATION', NULL, 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
('38abbf9e-a1a3-40a1-a15f-7d0ac02f47f1', 'PullTask', 1, NULL, NULL, NULL, 'VirAttrCache test', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'resource-csv', 'UPDATE', 0, 0, 1, 0, 'PROVISION', 'FULL_RECONCILIATION', NULL, 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
('af558be4-9d2f-4359-bf85-a554e6e90be1', 'PushTask', 1, NULL, NULL, NULL, 'Export on resource-testdb2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'resource-testdb2', 'IGNORE', 1, 1, 1, 1, 'ASSIGN', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28'),
('97f327b6-2eff-4d35-85e8-d581baaab855', 'PushTask', 1, NULL, NULL, NULL, 'Export on resource-testdb2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'resource-testdb2', 'IGNORE', 1, 1, 1, 1, 'PROVISION', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28'),
('03aa2a04-4881-4573-9117-753f81b04865', 'PushTask', 1, NULL, NULL, NULL, 'Export on resource-testdb2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'resource-testdb2', 'IGNORE', 1, 1, 1, 1, 'UNLINK', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28'),
('5e5f7c7e-9de7-4c6a-99f1-4df1af959807', 'PushTask', 1, NULL, NULL, NULL, 'Export on resource-testdb2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'resource-testdb2', 'IGNORE', 1, 1, 1, 1, 'IGNORE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28'),
('0bc11a19-6454-45c2-a4e3-ceef84e5d79b', 'PushTask', 1, NULL, NULL, NULL, 'Export on resource-testdb2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'resource-testdb2', 'UPDATE', 1, 1, 1, 1, 'ASSIGN', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28'),
('ec674143-480a-4816-98ad-b61fa090821e', 'PushTask', 1, NULL, NULL, NULL, 'Export on resource-testdb2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'resource-testdb2', 'DEPROVISION', 1, 1, 1, 1, 'IGNORE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28'),
('c46edc3a-a18b-4af2-b707-f4a415507496', 'PushTask', 1, NULL, NULL, NULL, 'Export on resource-testdb2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'resource-testdb2', 'UNASSIGN', 1, 1, 1, 1, 'IGNORE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28');               
INSERT INTO PUBLIC.TASK(ID, DTYPE, ACTIVE, CRONEXPRESSION, DESCRIPTION, JOBDELEGATECLASSNAME, NAME, STARTAT, ANYTYPE, ANYTYPEKIND, ATTRIBUTES, CONNOBJECTKEY, ENTITYKEY, OBJECTCLASSNAME, OLDCONNOBJECTKEY, OPERATION, RESOURCE_ID, MATCHINGRULE, PERFORMCREATE, PERFORMDELETE, PERFORMUPDATE, SYNCSTATUS, UNMATCHINGRULE, PULLMODE, RECONCILIATIONFILTERBUILDERCLASSNAME, DESTINATIONREALM_ID, EXECUTED, HTMLBODY, SENDER, SUBJECT, TEXTBODY, TRACELEVEL, NOTIFICATION_ID, SOURCEREALM_ID) VALUES
('51318433-cce4-4f71-8f45-9534b6c9c819', 'PushTask', 1, NULL, NULL, NULL, 'Export on resource-testdb2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'resource-testdb2', 'LINK', 1, 1, 1, 1, 'IGNORE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28'),
('24b1be9c-7e3b-443a-86c9-798ebce5eaf2', 'PushTask', 1, NULL, NULL, NULL, 'Export on resource-testdb2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'resource-testdb2', 'UNLINK', 1, 1, 1, 1, 'IGNORE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28'),
('375c7b7f-9e3a-4833-88c9-b7787b0a69f2', 'PushTask', 1, NULL, NULL, NULL, 'Export on resource-testdb2', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'resource-testdb2', 'UPDATE', 1, 1, 1, 1, 'IGNORE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28'),
('fd905ba5-9d56-4f51-83e2-859096a67b75', 'PushTask', 1, NULL, NULL, NULL, 'Export on resource-ldap', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'resource-ldap', 'UNLINK', 1, 1, 1, 1, 'ASSIGN', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28'),
('986867e2-993b-430e-8feb-aa9abb4c1dcd', 'PullTask', 1, NULL, NULL, NULL, 'CSV Task (update matching; provision unmatching)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'resource-csv', 'UPDATE', 1, 1, 1, 1, 'PROVISION', 'INCREMENTAL', NULL, 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
('feae4e57-15ca-40d9-b973-8b9015efca49', 'PullTask', 1, NULL, NULL, NULL, 'CSV (unlink matching; ignore unmatching)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'resource-csv', 'UNLINK', 1, 1, 1, 1, 'IGNORE', 'FULL_RECONCILIATION', NULL, 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
('55d5e74b-497e-4bc0-9156-73abef4b9adc', 'PullTask', 1, NULL, NULL, NULL, 'CSV (ignore matching; assign unmatching)', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'resource-csv', 'IGNORE', 1, 1, 1, 1, 'ASSIGN', 'FULL_RECONCILIATION', NULL, 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
('0f618183-17ce-48bc-80bc-cc535f38983a', 'PropagationTask', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'USER', '[{"name":"__PASSWORD__","value":[{"readOnly":false,"disposed":false,"encryptedBytes":"m9nh2US0Sa6m+cXccCq0Xw==","base64SHA1Hash":"GFJ69qfjxEOdrmt+9q+0Cw2uz60="}]},{"name":"__NAME__","value":["userId"],"nameValue":"userId"},{"name":"fullname","value":["fullname"]},{"name":"type","value":["type"]}]', NULL, '1417acbe-cbf6-4277-9372-e75e04f97000', '__ACCOUNT__', NULL, 'CREATE', 'resource-testdb', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
('30cfd653-257b-495f-8665-281281dbcb3d', 'PullTask', 1, NULL, NULL, NULL, 'Scripted SQL', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'resource-db-scripted', 'UPDATE', 1, 0, 1, 0, 'PROVISION', 'INCREMENTAL', NULL, 'e4c28e7a-9dbf-4ee7-9441-93812a0d4a28', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
('e1e520f0-2cbd-4e11-9a89-ea58a0f957e7', 'NotificationTask', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'NOTIFICATION-81', 'admin@prova.org', 'Notification for SYNCOPE-81', 'NOTIFICATION-81', 'ALL', 'e00945b5-1184-4d43-8e45-4318a8dcdfd4', NULL);    
CREATE INDEX PUBLIC.I_TASK_DTYPE ON PUBLIC.TASK(DTYPE);        
CREATE INDEX PUBLIC.TASK_EXECUTEDINDEX ON PUBLIC.TASK(EXECUTED);               
CREATE MEMORY TABLE PUBLIC.TASKEXEC(
    ID VARCHAR(36) NOT NULL,
    ENDDATE TIMESTAMP,
    MESSAGE CLOB,
    STARTDATE TIMESTAMP,
    STATUS VARCHAR(255),
    TASK_ID VARCHAR(36)
);        
ALTER TABLE PUBLIC.TASKEXEC ADD CONSTRAINT PUBLIC.CONSTRAINT_16 PRIMARY KEY(ID);               
-- 2 +/- SELECT COUNT(*) FROM PUBLIC.TASKEXEC; 
INSERT INTO PUBLIC.TASKEXEC(ID, ENDDATE, MESSAGE, STARTDATE, STATUS, TASK_ID) VALUES
('e58ca1c7-178a-4012-8a71-8aa14eaf0655', TIMESTAMP '2015-12-17 09:42:00.506', NULL, TIMESTAMP '2015-12-17 09:40:00.506', 'SUCCESS', '1e697572-b896-484c-ae7f-0c8f63fcbc6c'),
('d789462f-e395-424f-bd8e-0db44a93222f', TIMESTAMP '2015-12-17 09:42:00.506', NULL, TIMESTAMP '2015-12-17 09:40:00.506', 'SUCCESS', 'd6c2d6d3-6329-44c1-9187-f1469ead1cfa'); 
CREATE MEMORY TABLE PUBLIC.TYPEEXTENSION(
    ID VARCHAR(36) NOT NULL,
    GROUP_ID VARCHAR(36),
    ANYTYPE_ID VARCHAR(255)
);
ALTER TABLE PUBLIC.TYPEEXTENSION ADD CONSTRAINT PUBLIC.CONSTRAINT_D0 PRIMARY KEY(ID);          
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.TYPEEXTENSION;            
INSERT INTO PUBLIC.TYPEEXTENSION(ID, GROUP_ID, ANYTYPE_ID) VALUES
('84c1490c-a1d9-4b91-859c-fafbb0113a85', '034740a9-fa10-453b-af37-dc7897e98fb1', 'USER');    
CREATE MEMORY TABLE PUBLIC.TYPEEXTENSION_ANYTYPECLASS(
    TYPEEXTENSION_ID VARCHAR(36),
    ANYTYPECLASS_ID VARCHAR(255)
);   
-- 2 +/- SELECT COUNT(*) FROM PUBLIC.TYPEEXTENSION_ANYTYPECLASS;               
INSERT INTO PUBLIC.TYPEEXTENSION_ANYTYPECLASS(TYPEEXTENSION_ID, ANYTYPECLASS_ID) VALUES
('84c1490c-a1d9-4b91-859c-fafbb0113a85', 'csv'),
('84c1490c-a1d9-4b91-859c-fafbb0113a85', 'other');    
CREATE MEMORY TABLE PUBLIC.UDYNGROUPMEMBERSHIP(
    ID VARCHAR(36) NOT NULL,
    FIQL VARCHAR(255),
    GROUP_ID VARCHAR(36)
);
ALTER TABLE PUBLIC.UDYNGROUPMEMBERSHIP ADD CONSTRAINT PUBLIC.CONSTRAINT_7A PRIMARY KEY(ID);    
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.UDYNGROUPMEMBERSHIP;      
CREATE MEMORY TABLE PUBLIC.UMEMBERSHIP(
    ID VARCHAR(36) NOT NULL,
    USER_ID VARCHAR(36),
    GROUP_ID VARCHAR(36)
);      
ALTER TABLE PUBLIC.UMEMBERSHIP ADD CONSTRAINT PUBLIC.CONSTRAINT_3C PRIMARY KEY(ID);            
-- 7 +/- SELECT COUNT(*) FROM PUBLIC.UMEMBERSHIP;              
INSERT INTO PUBLIC.UMEMBERSHIP(ID, USER_ID, GROUP_ID) VALUES
('3d5e91f6-305e-45f9-ad30-4897d3d43bd9', '1417acbe-cbf6-4277-9372-e75e04f97000', '37d15e4c-cdc1-460b-a591-8505c8133806'),
('d53f7657-2b22-4e10-a2cd-c3379a4d1a31', '74cd8ece-715a-44a4-a736-e17b46c4e7e6', '37d15e4c-cdc1-460b-a591-8505c8133806'),
('8e42a132-55ae-4860-bebd-2ca00ba5e959', '74cd8ece-715a-44a4-a736-e17b46c4e7e6', 'b1f7c12d-ec83-441f-a50e-1691daaedf3b'),
('40e409a4-d870-4792-b820-30668f1269b9', 'c9b2dec2-00a7-4855-97c0-d854842b4b24', 'bf825fe1-7320-4a54-bd64-143b5c18ab97'),
('6d8a7dc0-d4bc-4b7e-b058-abcd3df28f28', '1417acbe-cbf6-4277-9372-e75e04f97000', 'f779c0d4-633b-4be5-8f57-32eb478a3ca5'),
('34f2d776-58b1-4640-8e64-e979b4242a18', '74cd8ece-715a-44a4-a736-e17b46c4e7e6', '29f96485-729e-4d31-88a1-6fc60e4677f3'),
('8cfb78fc-d0e7-4f08-a0ae-d7abf3223b6f', '823074dc-d280-436d-a7dd-07399fae48ec', 'ece66293-8f31-4a84-8e8d-23da36e70846');             
CREATE INDEX PUBLIC.UMEMBERSHIP_GROUPINDEX ON PUBLIC.UMEMBERSHIP(GROUP_ID);    
CREATE INDEX PUBLIC.UMEMBERSHIP_USERINDEX ON PUBLIC.UMEMBERSHIP(USER_ID);      
CREATE MEMORY TABLE PUBLIC.UPLAINATTR(
    ID VARCHAR(36) NOT NULL,
    OWNER_ID VARCHAR(36),
    SCHEMA_ID VARCHAR(255),
    MEMBERSHIP_ID VARCHAR(36)
);     
ALTER TABLE PUBLIC.UPLAINATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_38 PRIMARY KEY(ID);             
-- 28 +/- SELECT COUNT(*) FROM PUBLIC.UPLAINATTR;              
INSERT INTO PUBLIC.UPLAINATTR(ID, OWNER_ID, SCHEMA_ID, MEMBERSHIP_ID) VALUES
('57eed138-a94f-475c-b2de-fdb4ae8cb0fb', '1417acbe-cbf6-4277-9372-e75e04f97000', 'ctype', NULL),
('01f22fbd-b672-40af-b528-686d9b27ebc4', '1417acbe-cbf6-4277-9372-e75e04f97000', 'fullname', NULL),
('9d137d0c-1b04-4e9c-81f6-6203ae8baab4', '1417acbe-cbf6-4277-9372-e75e04f97000', 'firstname', NULL),
('65f4ef2c-f249-424b-9390-7faacebf1725', '1417acbe-cbf6-4277-9372-e75e04f97000', 'surname', NULL),
('1861e249-fc54-4aea-b8b8-3eed7a4d14c8', '1417acbe-cbf6-4277-9372-e75e04f97000', 'userId', NULL),
('9d0d9e40-1b18-488e-9482-37dab82163c9', '1417acbe-cbf6-4277-9372-e75e04f97000', 'loginDate', NULL),
('b8cde98a-16e7-446c-9bf3-db0fac6bc5cf', '74cd8ece-715a-44a4-a736-e17b46c4e7e6', 'fullname', NULL),
('f67e6ade-5d5e-467a-869a-b29653ec8c89', '74cd8ece-715a-44a4-a736-e17b46c4e7e6', 'firstname', NULL),
('24348fd6-d6a6-4cb7-a97e-f184b91395bc', '74cd8ece-715a-44a4-a736-e17b46c4e7e6', 'surname', NULL),
('bf296d5f-10df-421d-a2c0-bc489371b48c', '74cd8ece-715a-44a4-a736-e17b46c4e7e6', 'userId', NULL),
('ef97c9bd-f899-4d23-b43f-2fb27064fee5', 'b3cbc78d-32e6-4bd4-92e0-bbe07566a2ee', 'firstname', NULL),
('d610b2e3-81d9-4a9a-8a1e-26a96e7eeb6e', 'b3cbc78d-32e6-4bd4-92e0-bbe07566a2ee', 'surname', NULL),
('75c2e13f-8d17-4232-ae70-6ac8d6b6b95e', 'b3cbc78d-32e6-4bd4-92e0-bbe07566a2ee', 'fullname', NULL),
('d4fe3920-903a-4168-b151-d53dc0297284', 'b3cbc78d-32e6-4bd4-92e0-bbe07566a2ee', 'userId', NULL),
('c2511535-dfc1-4141-8ffd-9bbbca4b0f6b', 'c9b2dec2-00a7-4855-97c0-d854842b4b24', 'firstname', NULL),
('05b10553-343b-4703-977f-21b2e16c64ab', 'c9b2dec2-00a7-4855-97c0-d854842b4b24', 'surname', NULL),
('33cefe5c-c708-46f5-9588-d9bd862e9b51', 'c9b2dec2-00a7-4855-97c0-d854842b4b24', 'fullname', NULL),
('0f71c875-82dd-40d6-b352-ced78e041be5', 'c9b2dec2-00a7-4855-97c0-d854842b4b24', 'userId', NULL),
('35f407a2-d254-4890-9e45-5a7dd8c8df7d', 'c9b2dec2-00a7-4855-97c0-d854842b4b24', 'loginDate', NULL),
('a38423c2-4c29-4eeb-aa14-d984f78c083d', 'c9b2dec2-00a7-4855-97c0-d854842b4b24', 'cool', NULL),
('3e86f9fa-a19b-4f7b-b19a-f28e1b052a68', 'c9b2dec2-00a7-4855-97c0-d854842b4b24', 'gender', NULL),
('185ce8e4-fc28-4b0b-9f41-595b6ca53e6f', '823074dc-d280-436d-a7dd-07399fae48ec', 'firstname', NULL),
('28023d9c-18bc-431c-80e2-412741d235e6', '823074dc-d280-436d-a7dd-07399fae48ec', 'surname', NULL),
('17141999-5e09-4364-9cd2-dc05632e0a63', '823074dc-d280-436d-a7dd-07399fae48ec', 'fullname', NULL),
('15704022-315d-4740-8f79-7d60dd6165d4', '823074dc-d280-436d-a7dd-07399fae48ec', 'userId', NULL),
('cf2eb45f-0877-49f3-9eb7-844fea0e1a64', '74cd8ece-715a-44a4-a736-e17b46c4e7e6', 'email', NULL),
('514f586e-fd38-45a8-a2af-730d297f1022', 'b3cbc78d-32e6-4bd4-92e0-bbe07566a2ee', 'email', NULL),
('4192de6e-11dd-4435-80a8-4340d3586af1', 'b3cbc78d-32e6-4bd4-92e0-bbe07566a2ee', 'ctype', NULL);             
CREATE INDEX PUBLIC.UPLAINATTR_SCHEMA_INDEX ON PUBLIC.UPLAINATTR(SCHEMA_ID);   
CREATE INDEX PUBLIC.UPLAINATTR_MEMBERSHIP_INDEX ON PUBLIC.UPLAINATTR(MEMBERSHIP_ID);           
CREATE INDEX PUBLIC.UPLAINATTR_OWNER_INDEX ON PUBLIC.UPLAINATTR(OWNER_ID);     
CREATE MEMORY TABLE PUBLIC.UPLAINATTRUNIQUEVALUE(
    ID VARCHAR(36) NOT NULL,
    BINARYVALUE BLOB,
    BOOLEANVALUE INTEGER,
    DATEVALUE TIMESTAMP,
    DOUBLEVALUE DOUBLE,
    LONGVALUE BIGINT,
    STRINGVALUE VARCHAR(255),
    ATTRIBUTE_ID VARCHAR(36),
    SCHEMA_ID VARCHAR(255)
);
ALTER TABLE PUBLIC.UPLAINATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_FA PRIMARY KEY(ID);  
-- 10 +/- SELECT COUNT(*) FROM PUBLIC.UPLAINATTRUNIQUEVALUE;   
INSERT INTO PUBLIC.UPLAINATTRUNIQUEVALUE(ID, BINARYVALUE, BOOLEANVALUE, DATEVALUE, DOUBLEVALUE, LONGVALUE, STRINGVALUE, ATTRIBUTE_ID, SCHEMA_ID) VALUES
('5e06f081-4859-422c-bbac-e44f2e09a7fc', NULL, NULL, NULL, NULL, NULL, 'Gioacchino Rossini', '01f22fbd-b672-40af-b528-686d9b27ebc4', 'fullname'),
('25b0bdc7-ef0d-4aca-8cb6-fcaff45a1041', NULL, NULL, NULL, NULL, NULL, 'rossini@apache.org', '1861e249-fc54-4aea-b8b8-3eed7a4d14c8', 'userId'),
('1fbda591-9421-4511-ae8e-35b59b68487c', NULL, NULL, NULL, NULL, NULL, 'Giuseppe Verdi', 'b8cde98a-16e7-446c-9bf3-db0fac6bc5cf', 'fullname'),
('5812647b-86b3-4cd9-85db-2639dd19af3d', NULL, NULL, NULL, NULL, NULL, 'verdi@apache.org', 'bf296d5f-10df-421d-a2c0-bc489371b48c', 'userId'),
('fbbdc4cb-c7da-42dd-9fc2-1516ac2a8672', NULL, NULL, NULL, NULL, NULL, 'Antonio Vivaldi', '75c2e13f-8d17-4232-ae70-6ac8d6b6b95e', 'fullname'),
('aa8a6cbf-5afb-43a6-862b-f2da32c71d09', NULL, NULL, NULL, NULL, NULL, 'vivaldi@apache.org', 'd4fe3920-903a-4168-b151-d53dc0297284', 'userId'),
('14da5ad6-8204-45c6-81e5-332a1260837e', NULL, NULL, NULL, NULL, NULL, 'Vincenzo Bellini', '33cefe5c-c708-46f5-9588-d9bd862e9b51', 'fullname'),
('c052271f-84ac-4cc4-9156-2159544e5ae2', NULL, NULL, NULL, NULL, NULL, 'bellini@apache.org', '0f71c875-82dd-40d6-b352-ced78e041be5', 'userId'),
('c9afa8f6-9a8a-4c8e-b4d1-a46f50996a38', NULL, NULL, NULL, NULL, NULL, 'Giacomo Puccini', '17141999-5e09-4364-9cd2-dc05632e0a63', 'fullname'),
('1e565925-30e3-4ed0-8894-2b70d2ebaa6a', NULL, NULL, NULL, NULL, NULL, 'puccini@apache.org', '15704022-315d-4740-8f79-7d60dd6165d4', 'userId');            
CREATE INDEX PUBLIC.UPATTRUNIQUEVALUE_ATTRINDEX ON PUBLIC.UPLAINATTRUNIQUEVALUE(ATTRIBUTE_ID); 
CREATE MEMORY TABLE PUBLIC.UPLAINATTRVALUE(
    ID VARCHAR(36) NOT NULL,
    BINARYVALUE BLOB,
    BOOLEANVALUE INTEGER,
    DATEVALUE TIMESTAMP,
    DOUBLEVALUE DOUBLE,
    LONGVALUE BIGINT,
    STRINGVALUE VARCHAR(255),
    ATTRIBUTE_ID VARCHAR(36)
);  
ALTER TABLE PUBLIC.UPLAINATTRVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_B9 PRIMARY KEY(ID);        
-- 19 +/- SELECT COUNT(*) FROM PUBLIC.UPLAINATTRVALUE;         
INSERT INTO PUBLIC.UPLAINATTRVALUE(ID, BINARYVALUE, BOOLEANVALUE, DATEVALUE, DOUBLEVALUE, LONGVALUE, STRINGVALUE, ATTRIBUTE_ID) VALUES
('56189459-5ea3-4051-8f88-39c5c07d3e44', NULL, NULL, NULL, NULL, NULL, 'G', '57eed138-a94f-475c-b2de-fdb4ae8cb0fb'),
('c56d9faa-4192-4e6c-92c5-345189352d2e', NULL, NULL, NULL, NULL, NULL, 'Gioacchino', '9d137d0c-1b04-4e9c-81f6-6203ae8baab4'),
('c8d941b5-b64b-44ed-8f5d-a87520f773cb', NULL, NULL, NULL, NULL, NULL, 'Rossini', '65f4ef2c-f249-424b-9390-7faacebf1725'),
('7034de3b-3687-4db5-8454-363468f1a9de', NULL, NULL, TIMESTAMP '2009-05-26 00:00:00', NULL, NULL, NULL, '9d0d9e40-1b18-488e-9482-37dab82163c9'),
('bd8278a7-adcd-4627-9fba-3b621c26b64d', NULL, NULL, TIMESTAMP '2010-05-26 15:40:04', NULL, NULL, NULL, '9d0d9e40-1b18-488e-9482-37dab82163c9'),
('f80b0c29-99db-47a7-a5aa-b4e054d25741', NULL, NULL, NULL, NULL, NULL, 'Giuseppe', 'f67e6ade-5d5e-467a-869a-b29653ec8c89'),
('4d19a121-511d-414e-b082-c72581700961', NULL, NULL, NULL, NULL, NULL, 'Verdi', '24348fd6-d6a6-4cb7-a97e-f184b91395bc'),
('39ee0a93-0cb9-4921-b033-2715b2b72131', NULL, NULL, NULL, NULL, NULL, 'Antonio', 'ef97c9bd-f899-4d23-b43f-2fb27064fee5'),
('8531b8d3-0214-412f-b115-f6cc81124576', NULL, NULL, NULL, NULL, NULL, 'Vivaldi', 'd610b2e3-81d9-4a9a-8a1e-26a96e7eeb6e'),
('24', NULL, NULL, NULL, NULL, NULL, 'Vincenzo', 'c2511535-dfc1-4141-8ffd-9bbbca4b0f6b'),
('e88156c6-73eb-47a5-985c-878b8d18cca4', NULL, NULL, NULL, NULL, NULL, 'Bellini', '05b10553-343b-4703-977f-21b2e16c64ab'),
('0c67225a-030a-4c56-b337-17cf7a311f0f', NULL, NULL, TIMESTAMP '2009-06-24 00:00:00', NULL, NULL, NULL, '35f407a2-d254-4890-9e45-5a7dd8c8df7d'),
('16dd73d3-4f89-4ebc-a446-41a06848bdb3', NULL, 1, NULL, NULL, NULL, NULL, 'a38423c2-4c29-4eeb-aa14-d984f78c083d'),
('55efeccf-c124-4115-99e1-50e04dfc18e1', NULL, NULL, NULL, NULL, NULL, 'M', '3e86f9fa-a19b-4f7b-b19a-f28e1b052a68'),
('1e76b9b8-2fa3-4a96-8098-f96b6bfe3284', NULL, NULL, NULL, NULL, NULL, 'Giacomo', '185ce8e4-fc28-4b0b-9f41-595b6ca53e6f'),
('506d5503-d963-4005-aae9-22c16a20e81d', NULL, NULL, NULL, NULL, NULL, 'Puccini', '28023d9c-18bc-431c-80e2-412741d235e6'),
('e5cfa8e0-6089-415a-bf5d-54a123c2cb6b', NULL, NULL, NULL, NULL, NULL, 'verdi@syncope.org', 'cf2eb45f-0877-49f3-9eb7-844fea0e1a64'),
('272b5971-15b5-4435-b816-34ca3b8184f3', NULL, NULL, NULL, NULL, NULL, 'vivaldi@syncope.org', '514f586e-fd38-45a8-a2af-730d297f1022'),
('e171e555-b47e-45b9-b291-d027a5bf9596', NULL, NULL, NULL, NULL, NULL, 'F', '4192de6e-11dd-4435-80a8-4340d3586af1');         
CREATE INDEX PUBLIC.UATTRVALUE_STRINGVALUEINDEX ON PUBLIC.UPLAINATTRVALUE(STRINGVALUE);        
CREATE INDEX PUBLIC.UATTRVALUE_BOOLEANVALUEINDEX ON PUBLIC.UPLAINATTRVALUE(BOOLEANVALUE);      
CREATE INDEX PUBLIC.UPLAINATTRVALUE_ATTRINDEX ON PUBLIC.UPLAINATTRVALUE(ATTRIBUTE_ID);         
CREATE INDEX PUBLIC.UATTRVALUE_DATEVALUEINDEX ON PUBLIC.UPLAINATTRVALUE(DATEVALUE);            
CREATE INDEX PUBLIC.UATTRVALUE_LONGVALUEINDEX ON PUBLIC.UPLAINATTRVALUE(LONGVALUE);            
CREATE INDEX PUBLIC.UATTRVALUE_DOUBLEVALUEINDEX ON PUBLIC.UPLAINATTRVALUE(DOUBLEVALUE);        
CREATE MEMORY TABLE PUBLIC.URELATIONSHIP(
    ID VARCHAR(36) NOT NULL,
    USER_ID VARCHAR(36),
    ANYOBJECT_ID VARCHAR(36),
    TYPE_ID VARCHAR(255)
);      
ALTER TABLE PUBLIC.URELATIONSHIP ADD CONSTRAINT PUBLIC.CONSTRAINT_AC PRIMARY KEY(ID);          
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.URELATIONSHIP;            
INSERT INTO PUBLIC.URELATIONSHIP(ID, USER_ID, ANYOBJECT_ID, TYPE_ID) VALUES
('ca20ffca-1305-442f-be9a-3723a0cd88ca', 'c9b2dec2-00a7-4855-97c0-d854842b4b24', 'fc6dbc3a-6c07-4965-8781-921e7401a4a5', 'neighborhood');          
CREATE INDEX PUBLIC.URELATIONSHIP_RIGHTINDEX ON PUBLIC.URELATIONSHIP(ANYOBJECT_ID);            
CREATE INDEX PUBLIC.URELATIONSHIP_LEFTINDEX ON PUBLIC.URELATIONSHIP(USER_ID);  
CREATE MEMORY TABLE PUBLIC.VIRSCHEMA(
    ID VARCHAR(255) NOT NULL,
    EXTATTRNAME VARCHAR(255),
    READONLY INTEGER,
    ANYTYPECLASS_ID VARCHAR(255),
    PROVISION_ID VARCHAR(36)
);      
ALTER TABLE PUBLIC.VIRSCHEMA ADD CONSTRAINT PUBLIC.CONSTRAINT_F1 PRIMARY KEY(ID);              
-- 3 +/- SELECT COUNT(*) FROM PUBLIC.VIRSCHEMA;
INSERT INTO PUBLIC.VIRSCHEMA(ID, EXTATTRNAME, READONLY, ANYTYPECLASS_ID, PROVISION_ID) VALUES
('virtualReadOnly', 'givenname', 1, 'minimal user', '8b938d63-aa92-448c-89a8-a685fc0a67c8'),
('rvirtualdata', 'businessCategory', NULL, 'minimal group', '20a75199-3f2e-4b9a-9510-c68dd7fc7b3d'),
('virtualdata', 'USERNAME', NULL, 'minimal user', '6d7cb60a-c4ad-4a70-94ae-e5b88eb24930');     
CREATE MEMORY TABLE PUBLIC.ACT_GE_PROPERTY(
    NAME_ VARCHAR(64) NOT NULL,
    VALUE_ VARCHAR(300),
    REV_ INTEGER
);       
ALTER TABLE PUBLIC.ACT_GE_PROPERTY ADD CONSTRAINT PUBLIC.CONSTRAINT_27B PRIMARY KEY(NAME_);    
-- 3 +/- SELECT COUNT(*) FROM PUBLIC.ACT_GE_PROPERTY;          
INSERT INTO PUBLIC.ACT_GE_PROPERTY(NAME_, VALUE_, REV_) VALUES
('schema.version', '5.22.0.0', 1),
('schema.history', 'create(5.22.0.0)', 1),
('next.dbid', '5001', 3);         
CREATE MEMORY TABLE PUBLIC.ACT_GE_BYTEARRAY(
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER,
    NAME_ VARCHAR(255),
    DEPLOYMENT_ID_ VARCHAR(64),
    BYTES_ LONGVARBINARY,
    GENERATED_ BIT
);           
ALTER TABLE PUBLIC.ACT_GE_BYTEARRAY ADD CONSTRAINT PUBLIC.CONSTRAINT_80 PRIMARY KEY(ID_);      
-- 3 +/- SELECT COUNT(*) FROM PUBLIC.ACT_GE_BYTEARRAY;         
INSERT INTO PUBLIC.ACT_GE_BYTEARRAY(ID_, REV_, NAME_, DEPLOYMENT_ID_, BYTES_, GENERATED_) VALUES
('2', 1, 'userWorkflow.bpmn20.xml', '1', X'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', FALSE);   
INSERT INTO PUBLIC.ACT_GE_BYTEARRAY(ID_, REV_, NAME_, DEPLOYMENT_ID_, BYTES_, GENERATED_) VALUES
('3', 1, 'userWorkflow.userWorkflow.png', '1', X'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', TRUE);  
INSERT INTO PUBLIC.ACT_GE_BYTEARRAY(ID_, REV_, NAME_, DEPLOYMENT_ID_, BYTES_, GENERATED_) VALUES
('6', 1, 'source', NULL, X'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', NULL);        
CREATE MEMORY TABLE PUBLIC.ACT_RE_DEPLOYMENT(
    ID_ VARCHAR(64) NOT NULL,
    NAME_ VARCHAR(255),
    CATEGORY_ VARCHAR(255),
    TENANT_ID_ VARCHAR(255) DEFAULT '',
    DEPLOY_TIME_ TIMESTAMP
);          
ALTER TABLE PUBLIC.ACT_RE_DEPLOYMENT ADD CONSTRAINT PUBLIC.CONSTRAINT_1B PRIMARY KEY(ID_);     
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.ACT_RE_DEPLOYMENT;        
INSERT INTO PUBLIC.ACT_RE_DEPLOYMENT(ID_, NAME_, CATEGORY_, TENANT_ID_, DEPLOY_TIME_) VALUES
('1', NULL, NULL, '', TIMESTAMP '2018-07-04 12:04:11.991');       
CREATE MEMORY TABLE PUBLIC.ACT_RE_MODEL(
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER,
    NAME_ VARCHAR(255),
    KEY_ VARCHAR(255),
    CATEGORY_ VARCHAR(255),
    CREATE_TIME_ TIMESTAMP,
    LAST_UPDATE_TIME_ TIMESTAMP,
    VERSION_ INTEGER,
    META_INFO_ VARCHAR(4000),
    DEPLOYMENT_ID_ VARCHAR(64),
    EDITOR_SOURCE_VALUE_ID_ VARCHAR(64),
    EDITOR_SOURCE_EXTRA_VALUE_ID_ VARCHAR(64),
    TENANT_ID_ VARCHAR(255) DEFAULT ''
);         
ALTER TABLE PUBLIC.ACT_RE_MODEL ADD CONSTRAINT PUBLIC.CONSTRAINT_48 PRIMARY KEY(ID_);          
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.ACT_RE_MODEL;             
INSERT INTO PUBLIC.ACT_RE_MODEL(ID_, REV_, NAME_, KEY_, CATEGORY_, CREATE_TIME_, LAST_UPDATE_TIME_, VERSION_, META_INFO_, DEPLOYMENT_ID_, EDITOR_SOURCE_VALUE_ID_, EDITOR_SOURCE_EXTRA_VALUE_ID_, TENANT_ID_) VALUES
('5', 2, 'User Workflow', NULL, NULL, TIMESTAMP '2018-07-04 12:04:12.752', TIMESTAMP '2018-07-04 12:04:12.811', 1, '{"name":"User Workflow"}', '1', '6', NULL, '');       
CREATE MEMORY TABLE PUBLIC.ACT_RU_EXECUTION(
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER,
    PROC_INST_ID_ VARCHAR(64),
    BUSINESS_KEY_ VARCHAR(255),
    PARENT_ID_ VARCHAR(64),
    PROC_DEF_ID_ VARCHAR(64),
    SUPER_EXEC_ VARCHAR(64),
    ACT_ID_ VARCHAR(255),
    IS_ACTIVE_ BIT,
    IS_CONCURRENT_ BIT,
    IS_SCOPE_ BIT,
    IS_EVENT_SCOPE_ BIT,
    SUSPENSION_STATE_ INTEGER,
    CACHED_ENT_STATE_ INTEGER,
    TENANT_ID_ VARCHAR(255) DEFAULT '',
    NAME_ VARCHAR(255),
    LOCK_TIME_ TIMESTAMP
); 
ALTER TABLE PUBLIC.ACT_RU_EXECUTION ADD CONSTRAINT PUBLIC.CONSTRAINT_5D PRIMARY KEY(ID_);      
-- 5 +/- SELECT COUNT(*) FROM PUBLIC.ACT_RU_EXECUTION;         
INSERT INTO PUBLIC.ACT_RU_EXECUTION(ID_, REV_, PROC_INST_ID_, BUSINESS_KEY_, PARENT_ID_, PROC_DEF_ID_, SUPER_EXEC_, ACT_ID_, IS_ACTIVE_, IS_CONCURRENT_, IS_SCOPE_, IS_EVENT_SCOPE_, SUSPENSION_STATE_, CACHED_ENT_STATE_, TENANT_ID_, NAME_, LOCK_TIME_) VALUES
('4', 2, '4', NULL, NULL, 'userWorkflow:1:4', NULL, 'active', TRUE, FALSE, TRUE, FALSE, 1, NULL, '', NULL, NULL),
('6', 2, '6', NULL, NULL, 'userWorkflow:1:4', NULL, 'active', TRUE, FALSE, TRUE, FALSE, 1, NULL, '', NULL, NULL),
('8', 2, '8', NULL, NULL, 'userWorkflow:1:4', NULL, 'active', TRUE, FALSE, TRUE, FALSE, 1, NULL, '', NULL, NULL),
('10', 2, '10', NULL, NULL, 'userWorkflow:1:4', NULL, 'active', TRUE, FALSE, TRUE, FALSE, 1, NULL, '', NULL, NULL),
('12', 2, '12', NULL, NULL, 'userWorkflow:1:4', NULL, 'active', TRUE, FALSE, TRUE, FALSE, 1, NULL, '', NULL, NULL); 
CREATE INDEX PUBLIC.ACT_IDX_EXEC_BUSKEY ON PUBLIC.ACT_RU_EXECUTION(BUSINESS_KEY_);             
CREATE MEMORY TABLE PUBLIC.ACT_RU_JOB(
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER,
    TYPE_ VARCHAR(255) NOT NULL,
    LOCK_EXP_TIME_ TIMESTAMP,
    LOCK_OWNER_ VARCHAR(255),
    EXCLUSIVE_ BOOLEAN,
    EXECUTION_ID_ VARCHAR(64),
    PROCESS_INSTANCE_ID_ VARCHAR(64),
    PROC_DEF_ID_ VARCHAR(64),
    RETRIES_ INTEGER,
    EXCEPTION_STACK_ID_ VARCHAR(64),
    EXCEPTION_MSG_ VARCHAR(4000),
    DUEDATE_ TIMESTAMP,
    REPEAT_ VARCHAR(255),
    HANDLER_TYPE_ VARCHAR(255),
    HANDLER_CFG_ VARCHAR(4000),
    TENANT_ID_ VARCHAR(255) DEFAULT ''
);        
ALTER TABLE PUBLIC.ACT_RU_JOB ADD CONSTRAINT PUBLIC.CONSTRAINT_1C PRIMARY KEY(ID_);            
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACT_RU_JOB;               
CREATE MEMORY TABLE PUBLIC.ACT_RE_PROCDEF(
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER,
    CATEGORY_ VARCHAR(255),
    NAME_ VARCHAR(255),
    KEY_ VARCHAR(255) NOT NULL,
    VERSION_ INTEGER NOT NULL,
    DEPLOYMENT_ID_ VARCHAR(64),
    RESOURCE_NAME_ VARCHAR(4000),
    DGRM_RESOURCE_NAME_ VARCHAR(4000),
    DESCRIPTION_ VARCHAR(4000),
    HAS_START_FORM_KEY_ BIT,
    HAS_GRAPHICAL_NOTATION_ BIT,
    SUSPENSION_STATE_ INTEGER,
    TENANT_ID_ VARCHAR(255) DEFAULT ''
);  
ALTER TABLE PUBLIC.ACT_RE_PROCDEF ADD CONSTRAINT PUBLIC.CONSTRAINT_67A PRIMARY KEY(ID_);       
-- 1 +/- SELECT COUNT(*) FROM PUBLIC.ACT_RE_PROCDEF;           
INSERT INTO PUBLIC.ACT_RE_PROCDEF(ID_, REV_, CATEGORY_, NAME_, KEY_, VERSION_, DEPLOYMENT_ID_, RESOURCE_NAME_, DGRM_RESOURCE_NAME_, DESCRIPTION_, HAS_START_FORM_KEY_, HAS_GRAPHICAL_NOTATION_, SUSPENSION_STATE_, TENANT_ID_) VALUES
('userWorkflow:1:4', 1, 'http://activiti.org/bpmn20', 'User Workflow', 'userWorkflow', 1, '1', 'userWorkflow.bpmn20.xml', 'userWorkflow.userWorkflow.png', NULL, FALSE, TRUE, 1, '');    
CREATE MEMORY TABLE PUBLIC.ACT_RU_TASK(
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER,
    EXECUTION_ID_ VARCHAR(64),
    PROC_INST_ID_ VARCHAR(64),
    PROC_DEF_ID_ VARCHAR(64),
    NAME_ VARCHAR(255),
    PARENT_TASK_ID_ VARCHAR(64),
    DESCRIPTION_ VARCHAR(4000),
    TASK_DEF_KEY_ VARCHAR(255),
    OWNER_ VARCHAR(255),
    ASSIGNEE_ VARCHAR(255),
    DELEGATION_ VARCHAR(64),
    PRIORITY_ INTEGER,
    CREATE_TIME_ TIMESTAMP,
    DUE_DATE_ TIMESTAMP,
    CATEGORY_ VARCHAR(255),
    SUSPENSION_STATE_ INTEGER,
    TENANT_ID_ VARCHAR(255) DEFAULT '',
    FORM_KEY_ VARCHAR(255)
);    
ALTER TABLE PUBLIC.ACT_RU_TASK ADD CONSTRAINT PUBLIC.CONSTRAINT_787 PRIMARY KEY(ID_);          
-- 5 +/- SELECT COUNT(*) FROM PUBLIC.ACT_RU_TASK;              
INSERT INTO PUBLIC.ACT_RU_TASK(ID_, REV_, EXECUTION_ID_, PROC_INST_ID_, PROC_DEF_ID_, NAME_, PARENT_TASK_ID_, DESCRIPTION_, TASK_DEF_KEY_, OWNER_, ASSIGNEE_, DELEGATION_, PRIORITY_, CREATE_TIME_, DUE_DATE_, CATEGORY_, SUSPENSION_STATE_, TENANT_ID_, FORM_KEY_) VALUES
('5', 2, '4', '4', 'userWorkflow:1:4', 'Active', NULL, NULL, 'active', NULL, NULL, NULL, 50, TIMESTAMP '2013-02-25 17:19:03', NULL, NULL, NULL, '', NULL),
('7', 2, '6', '6', 'userWorkflow:1:4', 'Active', NULL, NULL, 'active', NULL, NULL, NULL, 50, TIMESTAMP '2013-02-25 17:19:03', NULL, NULL, NULL, '', NULL),
('9', 2, '8', '8', 'userWorkflow:1:4', 'Active', NULL, NULL, 'active', NULL, NULL, NULL, 50, TIMESTAMP '2013-02-25 17:19:03', NULL, NULL, NULL, '', NULL),
('11', 2, '10', '10', 'userWorkflow:1:4', 'Active', NULL, NULL, 'active', NULL, NULL, NULL, 50, TIMESTAMP '2013-02-25 17:19:03', NULL, NULL, NULL, '', NULL),
('13', 2, '12', '12', 'userWorkflow:1:4', 'Active', NULL, NULL, 'active', NULL, NULL, NULL, 50, TIMESTAMP '2013-02-25 17:19:03', NULL, NULL, NULL, '', NULL);        
CREATE INDEX PUBLIC.ACT_IDX_TASK_CREATE ON PUBLIC.ACT_RU_TASK(CREATE_TIME_);   
CREATE MEMORY TABLE PUBLIC.ACT_RU_IDENTITYLINK(
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER,
    GROUP_ID_ VARCHAR(255),
    TYPE_ VARCHAR(255),
    USER_ID_ VARCHAR(255),
    TASK_ID_ VARCHAR(64),
    PROC_INST_ID_ VARCHAR(64),
    PROC_DEF_ID_ VARCHAR(64)
);        
ALTER TABLE PUBLIC.ACT_RU_IDENTITYLINK ADD CONSTRAINT PUBLIC.CONSTRAINT_A3D PRIMARY KEY(ID_);  
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACT_RU_IDENTITYLINK;      
CREATE INDEX PUBLIC.ACT_IDX_IDENT_LNK_USER ON PUBLIC.ACT_RU_IDENTITYLINK(USER_ID_);            
CREATE INDEX PUBLIC.ACT_IDX_IDENT_LNK_GROUP ON PUBLIC.ACT_RU_IDENTITYLINK(GROUP_ID_);          
CREATE INDEX PUBLIC.ACT_IDX_ATHRZ_PROCEDEF ON PUBLIC.ACT_RU_IDENTITYLINK(PROC_DEF_ID_);        
CREATE MEMORY TABLE PUBLIC.ACT_RU_VARIABLE(
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER,
    TYPE_ VARCHAR(255) NOT NULL,
    NAME_ VARCHAR(255) NOT NULL,
    EXECUTION_ID_ VARCHAR(64),
    PROC_INST_ID_ VARCHAR(64),
    TASK_ID_ VARCHAR(64),
    BYTEARRAY_ID_ VARCHAR(64),
    DOUBLE_ DOUBLE,
    LONG_ BIGINT,
    TEXT_ VARCHAR(4000),
    TEXT2_ VARCHAR(4000)
);
ALTER TABLE PUBLIC.ACT_RU_VARIABLE ADD CONSTRAINT PUBLIC.CONSTRAINT_C2E PRIMARY KEY(ID_);      
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACT_RU_VARIABLE;          
CREATE INDEX PUBLIC.ACT_IDX_VARIABLE_TASK_ID ON PUBLIC.ACT_RU_VARIABLE(TASK_ID_);              
CREATE MEMORY TABLE PUBLIC.ACT_RU_EVENT_SUBSCR(
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER,
    EVENT_TYPE_ VARCHAR(255) NOT NULL,
    EVENT_NAME_ VARCHAR(255),
    EXECUTION_ID_ VARCHAR(64),
    PROC_INST_ID_ VARCHAR(64),
    ACTIVITY_ID_ VARCHAR(64),
    CONFIGURATION_ VARCHAR(255),
    CREATED_ TIMESTAMP NOT NULL,
    PROC_DEF_ID_ VARCHAR(64),
    TENANT_ID_ VARCHAR(255) DEFAULT ''
);     
ALTER TABLE PUBLIC.ACT_RU_EVENT_SUBSCR ADD CONSTRAINT PUBLIC.CONSTRAINT_86 PRIMARY KEY(ID_);   
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACT_RU_EVENT_SUBSCR;      
CREATE INDEX PUBLIC.ACT_IDX_EVENT_SUBSCR_CONFIG_ ON PUBLIC.ACT_RU_EVENT_SUBSCR(CONFIGURATION_);
CREATE MEMORY TABLE PUBLIC.ACT_EVT_LOG(
    LOG_NR_ BIGINT DEFAULT (NEXT VALUE FOR PUBLIC.SYSTEM_SEQUENCE_59F7B0CC_7480_4829_9E5B_C3B02CB5126B) NOT NULL NULL_TO_DEFAULT SEQUENCE PUBLIC.SYSTEM_SEQUENCE_59F7B0CC_7480_4829_9E5B_C3B02CB5126B,
    TYPE_ VARCHAR(64),
    PROC_DEF_ID_ VARCHAR(64),
    PROC_INST_ID_ VARCHAR(64),
    EXECUTION_ID_ VARCHAR(64),
    TASK_ID_ VARCHAR(64),
    TIME_STAMP_ TIMESTAMP NOT NULL,
    USER_ID_ VARCHAR(255),
    DATA_ LONGVARBINARY,
    LOCK_OWNER_ VARCHAR(255),
    LOCK_TIME_ TIMESTAMP,
    IS_PROCESSED_ BIT DEFAULT 0
); 
ALTER TABLE PUBLIC.ACT_EVT_LOG ADD CONSTRAINT PUBLIC.CONSTRAINT_C9 PRIMARY KEY(LOG_NR_);       
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACT_EVT_LOG;              
CREATE MEMORY TABLE PUBLIC.ACT_PROCDEF_INFO(
    ID_ VARCHAR(64) NOT NULL,
    PROC_DEF_ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER,
    INFO_JSON_ID_ VARCHAR(64)
);           
ALTER TABLE PUBLIC.ACT_PROCDEF_INFO ADD CONSTRAINT PUBLIC.CONSTRAINT_9E1 PRIMARY KEY(ID_);     
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACT_PROCDEF_INFO;         
CREATE INDEX PUBLIC.ACT_IDX_INFO_PROCDEF ON PUBLIC.ACT_PROCDEF_INFO(PROC_DEF_ID_);             
CREATE MEMORY TABLE PUBLIC.ACT_HI_PROCINST(
    ID_ VARCHAR(64) NOT NULL,
    PROC_INST_ID_ VARCHAR(64) NOT NULL,
    BUSINESS_KEY_ VARCHAR(255),
    PROC_DEF_ID_ VARCHAR(64) NOT NULL,
    START_TIME_ TIMESTAMP NOT NULL,
    END_TIME_ TIMESTAMP,
    DURATION_ BIGINT,
    START_USER_ID_ VARCHAR(255),
    START_ACT_ID_ VARCHAR(255),
    END_ACT_ID_ VARCHAR(255),
    SUPER_PROCESS_INSTANCE_ID_ VARCHAR(64),
    DELETE_REASON_ VARCHAR(4000),
    TENANT_ID_ VARCHAR(255) DEFAULT '',
    NAME_ VARCHAR(255)
);     
ALTER TABLE PUBLIC.ACT_HI_PROCINST ADD CONSTRAINT PUBLIC.CONSTRAINT_8D PRIMARY KEY(ID_);       
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACT_HI_PROCINST;          
CREATE INDEX PUBLIC.ACT_IDX_HI_PRO_INST_END ON PUBLIC.ACT_HI_PROCINST(END_TIME_);              
CREATE INDEX PUBLIC.ACT_IDX_HI_PRO_I_BUSKEY ON PUBLIC.ACT_HI_PROCINST(BUSINESS_KEY_);          
CREATE MEMORY TABLE PUBLIC.ACT_HI_ACTINST(
    ID_ VARCHAR(64) NOT NULL,
    PROC_DEF_ID_ VARCHAR(64) NOT NULL,
    PROC_INST_ID_ VARCHAR(64) NOT NULL,
    EXECUTION_ID_ VARCHAR(64) NOT NULL,
    ACT_ID_ VARCHAR(255) NOT NULL,
    TASK_ID_ VARCHAR(64),
    CALL_PROC_INST_ID_ VARCHAR(64),
    ACT_NAME_ VARCHAR(255),
    ACT_TYPE_ VARCHAR(255) NOT NULL,
    ASSIGNEE_ VARCHAR(255),
    START_TIME_ TIMESTAMP NOT NULL,
    END_TIME_ TIMESTAMP,
    DURATION_ BIGINT,
    TENANT_ID_ VARCHAR(255) DEFAULT ''
);     
ALTER TABLE PUBLIC.ACT_HI_ACTINST ADD CONSTRAINT PUBLIC.CONSTRAINT_FB0 PRIMARY KEY(ID_);       
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACT_HI_ACTINST;           
CREATE INDEX PUBLIC.ACT_IDX_HI_ACT_INST_START ON PUBLIC.ACT_HI_ACTINST(START_TIME_);           
CREATE INDEX PUBLIC.ACT_IDX_HI_ACT_INST_END ON PUBLIC.ACT_HI_ACTINST(END_TIME_);               
CREATE INDEX PUBLIC.ACT_IDX_HI_ACT_INST_PROCINST ON PUBLIC.ACT_HI_ACTINST(PROC_INST_ID_, ACT_ID_);             
CREATE INDEX PUBLIC.ACT_IDX_HI_ACT_INST_EXEC ON PUBLIC.ACT_HI_ACTINST(EXECUTION_ID_, ACT_ID_); 
CREATE MEMORY TABLE PUBLIC.ACT_HI_TASKINST(
    ID_ VARCHAR(64) NOT NULL,
    PROC_DEF_ID_ VARCHAR(64),
    TASK_DEF_KEY_ VARCHAR(255),
    PROC_INST_ID_ VARCHAR(64),
    EXECUTION_ID_ VARCHAR(64),
    NAME_ VARCHAR(255),
    PARENT_TASK_ID_ VARCHAR(64),
    DESCRIPTION_ VARCHAR(4000),
    OWNER_ VARCHAR(255),
    ASSIGNEE_ VARCHAR(255),
    START_TIME_ TIMESTAMP NOT NULL,
    CLAIM_TIME_ TIMESTAMP,
    END_TIME_ TIMESTAMP,
    DURATION_ BIGINT,
    DELETE_REASON_ VARCHAR(4000),
    PRIORITY_ INTEGER,
    DUE_DATE_ TIMESTAMP,
    FORM_KEY_ VARCHAR(255),
    CATEGORY_ VARCHAR(255),
    TENANT_ID_ VARCHAR(255) DEFAULT ''
);          
ALTER TABLE PUBLIC.ACT_HI_TASKINST ADD CONSTRAINT PUBLIC.CONSTRAINT_B09 PRIMARY KEY(ID_);      
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACT_HI_TASKINST;          
CREATE INDEX PUBLIC.ACT_IDX_HI_TASK_INST_PROCINST ON PUBLIC.ACT_HI_TASKINST(PROC_INST_ID_);    
CREATE MEMORY TABLE PUBLIC.ACT_HI_VARINST(
    ID_ VARCHAR(64) NOT NULL,
    PROC_INST_ID_ VARCHAR(64),
    EXECUTION_ID_ VARCHAR(64),
    TASK_ID_ VARCHAR(64),
    NAME_ VARCHAR(255) NOT NULL,
    VAR_TYPE_ VARCHAR(100),
    REV_ INTEGER,
    BYTEARRAY_ID_ VARCHAR(64),
    DOUBLE_ DOUBLE,
    LONG_ BIGINT,
    TEXT_ VARCHAR(4000),
    TEXT2_ VARCHAR(4000),
    CREATE_TIME_ TIMESTAMP,
    LAST_UPDATED_TIME_ TIMESTAMP
);        
ALTER TABLE PUBLIC.ACT_HI_VARINST ADD CONSTRAINT PUBLIC.CONSTRAINT_4E PRIMARY KEY(ID_);        
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACT_HI_VARINST;           
CREATE INDEX PUBLIC.ACT_IDX_HI_PROCVAR_PROC_INST ON PUBLIC.ACT_HI_VARINST(PROC_INST_ID_);      
CREATE INDEX PUBLIC.ACT_IDX_HI_PROCVAR_NAME_TYPE ON PUBLIC.ACT_HI_VARINST(NAME_, VAR_TYPE_);   
CREATE INDEX PUBLIC.ACT_IDX_HI_PROCVAR_TASK_ID ON PUBLIC.ACT_HI_VARINST(TASK_ID_);             
CREATE MEMORY TABLE PUBLIC.ACT_HI_DETAIL(
    ID_ VARCHAR(64) NOT NULL,
    TYPE_ VARCHAR(255) NOT NULL,
    TIME_ TIMESTAMP NOT NULL,
    NAME_ VARCHAR(255),
    PROC_INST_ID_ VARCHAR(64),
    EXECUTION_ID_ VARCHAR(64),
    TASK_ID_ VARCHAR(64),
    ACT_INST_ID_ VARCHAR(64),
    VAR_TYPE_ VARCHAR(255),
    REV_ INTEGER,
    BYTEARRAY_ID_ VARCHAR(64),
    DOUBLE_ DOUBLE,
    LONG_ BIGINT,
    TEXT_ VARCHAR(4000),
    TEXT2_ VARCHAR(4000)
);   
ALTER TABLE PUBLIC.ACT_HI_DETAIL ADD CONSTRAINT PUBLIC.CONSTRAINT_80F PRIMARY KEY(ID_);        
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACT_HI_DETAIL;            
CREATE INDEX PUBLIC.ACT_IDX_HI_DETAIL_PROC_INST ON PUBLIC.ACT_HI_DETAIL(PROC_INST_ID_);        
CREATE INDEX PUBLIC.ACT_IDX_HI_DETAIL_ACT_INST ON PUBLIC.ACT_HI_DETAIL(ACT_INST_ID_);          
CREATE INDEX PUBLIC.ACT_IDX_HI_DETAIL_TIME ON PUBLIC.ACT_HI_DETAIL(TIME_);     
CREATE INDEX PUBLIC.ACT_IDX_HI_DETAIL_NAME ON PUBLIC.ACT_HI_DETAIL(NAME_);     
CREATE INDEX PUBLIC.ACT_IDX_HI_DETAIL_TASK_ID ON PUBLIC.ACT_HI_DETAIL(TASK_ID_);               
CREATE MEMORY TABLE PUBLIC.ACT_HI_COMMENT(
    ID_ VARCHAR(64) NOT NULL,
    TYPE_ VARCHAR(255),
    TIME_ TIMESTAMP NOT NULL,
    USER_ID_ VARCHAR(255),
    TASK_ID_ VARCHAR(64),
    PROC_INST_ID_ VARCHAR(64),
    ACTION_ VARCHAR(255),
    MESSAGE_ VARCHAR(4000),
    FULL_MSG_ LONGVARBINARY
);        
ALTER TABLE PUBLIC.ACT_HI_COMMENT ADD CONSTRAINT PUBLIC.CONSTRAINT_78F PRIMARY KEY(ID_);       
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACT_HI_COMMENT;           
CREATE MEMORY TABLE PUBLIC.ACT_HI_ATTACHMENT(
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER,
    USER_ID_ VARCHAR(255),
    NAME_ VARCHAR(255),
    DESCRIPTION_ VARCHAR(4000),
    TYPE_ VARCHAR(255),
    TASK_ID_ VARCHAR(64),
    PROC_INST_ID_ VARCHAR(64),
    URL_ VARCHAR(4000),
    CONTENT_ID_ VARCHAR(64),
    TIME_ TIMESTAMP
);  
ALTER TABLE PUBLIC.ACT_HI_ATTACHMENT ADD CONSTRAINT PUBLIC.CONSTRAINT_DCB PRIMARY KEY(ID_);    
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACT_HI_ATTACHMENT;        
CREATE MEMORY TABLE PUBLIC.ACT_HI_IDENTITYLINK(
    ID_ VARCHAR(64) NOT NULL,
    GROUP_ID_ VARCHAR(255),
    TYPE_ VARCHAR(255),
    USER_ID_ VARCHAR(255),
    TASK_ID_ VARCHAR(64),
    PROC_INST_ID_ VARCHAR(64)
);        
ALTER TABLE PUBLIC.ACT_HI_IDENTITYLINK ADD CONSTRAINT PUBLIC.CONSTRAINT_8AD PRIMARY KEY(ID_);  
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACT_HI_IDENTITYLINK;      
CREATE INDEX PUBLIC.ACT_IDX_HI_IDENT_LNK_USER ON PUBLIC.ACT_HI_IDENTITYLINK(USER_ID_);         
CREATE INDEX PUBLIC.ACT_IDX_HI_IDENT_LNK_TASK ON PUBLIC.ACT_HI_IDENTITYLINK(TASK_ID_);         
CREATE INDEX PUBLIC.ACT_IDX_HI_IDENT_LNK_PROCINST ON PUBLIC.ACT_HI_IDENTITYLINK(PROC_INST_ID_);
CREATE MEMORY TABLE PUBLIC.ACT_ID_GROUP(
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER,
    NAME_ VARCHAR(255),
    TYPE_ VARCHAR(255)
);     
ALTER TABLE PUBLIC.ACT_ID_GROUP ADD CONSTRAINT PUBLIC.CONSTRAINT_6B PRIMARY KEY(ID_);          
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACT_ID_GROUP;             
CREATE MEMORY TABLE PUBLIC.ACT_ID_MEMBERSHIP(
    USER_ID_ VARCHAR(64) NOT NULL,
    GROUP_ID_ VARCHAR(64) NOT NULL
);         
ALTER TABLE PUBLIC.ACT_ID_MEMBERSHIP ADD CONSTRAINT PUBLIC.CONSTRAINT_EE PRIMARY KEY(USER_ID_, GROUP_ID_);     
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACT_ID_MEMBERSHIP;        
CREATE MEMORY TABLE PUBLIC.ACT_ID_USER(
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER,
    FIRST_ VARCHAR(255),
    LAST_ VARCHAR(255),
    EMAIL_ VARCHAR(255),
    PWD_ VARCHAR(255),
    PICTURE_ID_ VARCHAR(64)
);        
ALTER TABLE PUBLIC.ACT_ID_USER ADD CONSTRAINT PUBLIC.CONSTRAINT_7F6 PRIMARY KEY(ID_);          
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACT_ID_USER;              
CREATE MEMORY TABLE PUBLIC.ACT_ID_INFO(
    ID_ VARCHAR(64) NOT NULL,
    REV_ INTEGER,
    USER_ID_ VARCHAR(64),
    TYPE_ VARCHAR(64),
    KEY_ VARCHAR(255),
    VALUE_ VARCHAR(255),
    PASSWORD_ LONGVARBINARY,
    PARENT_ID_ VARCHAR(255)
);           
ALTER TABLE PUBLIC.ACT_ID_INFO ADD CONSTRAINT PUBLIC.CONSTRAINT_7F5 PRIMARY KEY(ID_);          
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ACT_ID_INFO;              
CREATE FORCE VIEW PUBLIC.ANYOBJECT_SEARCH_RESOURCE(ANY_ID, RESOURCE_ID) AS
SELECT
    ST.ANYOBJECT_ID AS ANY_ID,
    ST.RESOURCE_ID AS RESOURCE_ID
FROM PUBLIC.ANYOBJECT_EXTERNALRESOURCE ST;  
CREATE FORCE VIEW PUBLIC.ANYOBJECT_SEARCH_GROUP_RES(ANY_ID, RESOURCE_ID) AS
SELECT
    M.ANYOBJECT_ID AS ANY_ID,
    ST.RESOURCE_ID AS RESOURCE_ID
FROM PUBLIC.AMEMBERSHIP M
INNER JOIN PUBLIC.SYNCOPEGROUP R
    ON 1=1
INNER JOIN PUBLIC.SYNCOPEGROUP_EXTERNALRESOURCE ST
    ON 1=1
WHERE (M.GROUP_ID = ST.GROUP_ID)
    AND (((M.GROUP_ID = R.ID)
    AND (ST.GROUP_ID = R.ID))
    AND (M.GROUP_ID = ST.GROUP_ID));       
CREATE FORCE VIEW PUBLIC.GROUP_SEARCH_UNIQUE_ATTR(ANY_ID, SCHEMA_ID, BOOLEANVALUE, DATEVALUE, DOUBLEVALUE, LONGVALUE, STRINGVALUE) AS
SELECT
    UA.OWNER_ID AS ANY_ID,
    UA.SCHEMA_ID AS SCHEMA_ID,
    UAV.BOOLEANVALUE AS BOOLEANVALUE,
    UAV.DATEVALUE AS DATEVALUE,
    UAV.DOUBLEVALUE AS DOUBLEVALUE,
    UAV.LONGVALUE AS LONGVALUE,
    UAV.STRINGVALUE AS STRINGVALUE
FROM PUBLIC.GPLAINATTRUNIQUEVALUE UAV
INNER JOIN PUBLIC.GPLAINATTR UA
    ON 1=1
WHERE UAV.ATTRIBUTE_ID = UA.ID;           
CREATE FORCE VIEW PUBLIC.USER_SEARCH_ROLE(ANY_ID, ROLE_ID) AS
SELECT
    SS.USER_ID AS ANY_ID,
    SS.ROLE_ID AS ROLE_ID
FROM PUBLIC.SYNCOPEUSER_SYNCOPEROLE SS;               
CREATE FORCE VIEW PUBLIC.ANYOBJECT_SEARCH(ANY_ID, ID, CREATIONDATE, CREATOR, LASTCHANGEDATE, LASTMODIFIER, STATUS, NAME, REALM_ID, TYPE_ID) AS
SELECT
    A.ID AS ANY_ID,
    A.ID,
    A.CREATIONDATE,
    A.CREATOR,
    A.LASTCHANGEDATE,
    A.LASTMODIFIER,
    A.STATUS,
    A.NAME,
    A.REALM_ID,
    A.TYPE_ID
FROM PUBLIC.ANYOBJECT A;
CREATE FORCE VIEW PUBLIC.USER_SEARCH_URELATIONSHIP(ANY_ID, RIGHT_ANY_ID, TYPE) AS
SELECT
    M.USER_ID AS ANY_ID,
    M.ANYOBJECT_ID AS RIGHT_ANY_ID,
    M.TYPE_ID AS TYPE
FROM PUBLIC.URELATIONSHIP M;       
CREATE FORCE VIEW PUBLIC.USER_SEARCH(ANY_ID, ID, CREATIONDATE, CREATOR, LASTCHANGEDATE, LASTMODIFIER, STATUS, CHANGEPWDDATE, CIPHERALGORITHM, FAILEDLOGINS, LASTLOGINDATE, MUSTCHANGEPASSWORD, PASSWORD, SECURITYANSWER, SUSPENDED, TOKEN, TOKENEXPIRETIME, USERNAME, REALM_ID, SECURITYQUESTION_ID) AS
SELECT
    U.ID AS ANY_ID,
    U.ID,
    U.CREATIONDATE,
    U.CREATOR,
    U.LASTCHANGEDATE,
    U.LASTMODIFIER,
    U.STATUS,
    U.CHANGEPWDDATE,
    U.CIPHERALGORITHM,
    U.FAILEDLOGINS,
    U.LASTLOGINDATE,
    U.MUSTCHANGEPASSWORD,
    U.PASSWORD,
    U.SECURITYANSWER,
    U.SUSPENDED,
    U.TOKEN,
    U.TOKENEXPIRETIME,
    U.USERNAME,
    U.REALM_ID,
    U.SECURITYQUESTION_ID
FROM PUBLIC.SYNCOPEUSER U;             
CREATE FORCE VIEW PUBLIC.USER_SEARCH_RESOURCE(ANY_ID, RESOURCE_ID) AS
SELECT
    ST.USER_ID AS ANY_ID,
    ST.RESOURCE_ID AS RESOURCE_ID
FROM PUBLIC.SYNCOPEUSER_EXTERNALRESOURCE ST;          
CREATE FORCE VIEW PUBLIC.ANYOBJECT_SEARCH_ATTR(ANY_ID, SCHEMA_ID, BOOLEANVALUE, DATEVALUE, DOUBLEVALUE, LONGVALUE, STRINGVALUE) AS
SELECT
    UA.OWNER_ID AS ANY_ID,
    UA.SCHEMA_ID AS SCHEMA_ID,
    UAV.BOOLEANVALUE AS BOOLEANVALUE,
    UAV.DATEVALUE AS DATEVALUE,
    UAV.DOUBLEVALUE AS DOUBLEVALUE,
    UAV.LONGVALUE AS LONGVALUE,
    UAV.STRINGVALUE AS STRINGVALUE
FROM PUBLIC.APLAINATTRVALUE UAV
INNER JOIN PUBLIC.APLAINATTR UA
    ON 1=1
WHERE UAV.ATTRIBUTE_ID = UA.ID;    
CREATE FORCE VIEW PUBLIC.ANYOBJECT_SEARCH_ARELATIONSHIP(ANY_ID, RIGHT_ANY_ID, TYPE) AS
SELECT
    M.LEFT_ANYOBJECT_ID AS ANY_ID,
    M.RIGHT_ANYOBJECT_ID AS RIGHT_ANY_ID,
    M.TYPE_ID AS TYPE
FROM PUBLIC.ARELATIONSHIP M;  
CREATE FORCE VIEW PUBLIC.USER_SEARCH_GROUP_RES(ANY_ID, RESOURCE_ID) AS
SELECT
    M.USER_ID AS ANY_ID,
    ST.RESOURCE_ID AS RESOURCE_ID
FROM PUBLIC.UMEMBERSHIP M
INNER JOIN PUBLIC.SYNCOPEGROUP R
    ON 1=1
INNER JOIN PUBLIC.SYNCOPEGROUP_EXTERNALRESOURCE ST
    ON 1=1
WHERE (M.GROUP_ID = ST.GROUP_ID)
    AND (((M.GROUP_ID = R.ID)
    AND (ST.GROUP_ID = R.ID))
    AND (M.GROUP_ID = ST.GROUP_ID)); 
CREATE FORCE VIEW PUBLIC.GROUP_SEARCH_ATTR(ANY_ID, SCHEMA_ID, BOOLEANVALUE, DATEVALUE, DOUBLEVALUE, LONGVALUE, STRINGVALUE) AS
SELECT
    UA.OWNER_ID AS ANY_ID,
    UA.SCHEMA_ID AS SCHEMA_ID,
    UAV.BOOLEANVALUE AS BOOLEANVALUE,
    UAV.DATEVALUE AS DATEVALUE,
    UAV.DOUBLEVALUE AS DOUBLEVALUE,
    UAV.LONGVALUE AS LONGVALUE,
    UAV.STRINGVALUE AS STRINGVALUE
FROM PUBLIC.GPLAINATTRVALUE UAV
INNER JOIN PUBLIC.GPLAINATTR UA
    ON 1=1
WHERE UAV.ATTRIBUTE_ID = UA.ID;        
CREATE MEMORY TABLE PUBLIC.UDYNGROUPMEMBERS(
    ANY_ID CHAR(36),
    GROUP_ID CHAR(36)
);     
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.UDYNGROUPMEMBERS;         
CREATE INDEX PUBLIC.UDYNGROUPMEMBERS_ANY_ID ON PUBLIC.UDYNGROUPMEMBERS(ANY_ID);
CREATE INDEX PUBLIC.UDYNGROUPMEMBERS_GROUP_ID ON PUBLIC.UDYNGROUPMEMBERS(GROUP_ID);            
CREATE FORCE VIEW PUBLIC.USER_SEARCH_UMEMBERSHIP(ANY_ID, GROUP_ID, GROUP_NAME) AS
SELECT
    M.USER_ID AS ANY_ID,
    G.ID AS GROUP_ID,
    G.NAME AS GROUP_NAME
FROM PUBLIC.UMEMBERSHIP M
INNER JOIN PUBLIC.SYNCOPEGROUP G
    ON 1=1
WHERE M.GROUP_ID = G.ID;
CREATE FORCE VIEW PUBLIC.USER_SEARCH_UNIQUE_ATTR(ANY_ID, SCHEMA_ID, BOOLEANVALUE, DATEVALUE, DOUBLEVALUE, LONGVALUE, STRINGVALUE) AS
SELECT
    UA.OWNER_ID AS ANY_ID,
    UA.SCHEMA_ID AS SCHEMA_ID,
    UAV.BOOLEANVALUE AS BOOLEANVALUE,
    UAV.DATEVALUE AS DATEVALUE,
    UAV.DOUBLEVALUE AS DOUBLEVALUE,
    UAV.LONGVALUE AS LONGVALUE,
    UAV.STRINGVALUE AS STRINGVALUE
FROM PUBLIC.UPLAINATTRUNIQUEVALUE UAV
INNER JOIN PUBLIC.UPLAINATTR UA
    ON 1=1
WHERE UAV.ATTRIBUTE_ID = UA.ID;            
CREATE MEMORY TABLE PUBLIC.DYNREALMMEMBERS(
    ANY_ID CHAR(36),
    DYNREALM_ID VARCHAR(255)
);               
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.DYNREALMMEMBERS;          
CREATE INDEX PUBLIC.DYNREALMMEMBERS_DYNREALM_ID ON PUBLIC.DYNREALMMEMBERS(DYNREALM_ID);        
CREATE INDEX PUBLIC.DYNREALMMEMBERS_ANY_ID ON PUBLIC.DYNREALMMEMBERS(ANY_ID);  
CREATE FORCE VIEW PUBLIC.ANYOBJECT_SEARCH_AMEMBERSHIP(ANY_ID, GROUP_ID, GROUP_NAME) AS
SELECT
    M.ANYOBJECT_ID AS ANY_ID,
    G.ID AS GROUP_ID,
    G.NAME AS GROUP_NAME
FROM PUBLIC.AMEMBERSHIP M
INNER JOIN PUBLIC.SYNCOPEGROUP G
    ON 1=1
WHERE M.GROUP_ID = G.ID;      
CREATE FORCE VIEW PUBLIC.GROUP_SEARCH(ANY_ID, ID, CREATIONDATE, CREATOR, LASTCHANGEDATE, LASTMODIFIER, STATUS, NAME, REALM_ID, GROUPOWNER_ID, USEROWNER_ID) AS
SELECT
    R.ID AS ANY_ID,
    R.ID,
    R.CREATIONDATE,
    R.CREATOR,
    R.LASTCHANGEDATE,
    R.LASTMODIFIER,
    R.STATUS,
    R.NAME,
    R.REALM_ID,
    R.GROUPOWNER_ID,
    R.USEROWNER_ID
FROM PUBLIC.SYNCOPEGROUP R;   
CREATE FORCE VIEW PUBLIC.ANYOBJECT_SEARCH_UNIQUE_ATTR(ANY_ID, SCHEMA_ID, BOOLEANVALUE, DATEVALUE, DOUBLEVALUE, LONGVALUE, STRINGVALUE) AS
SELECT
    UA.OWNER_ID AS ANY_ID,
    UA.SCHEMA_ID AS SCHEMA_ID,
    UAV.BOOLEANVALUE AS BOOLEANVALUE,
    UAV.DATEVALUE AS DATEVALUE,
    UAV.DOUBLEVALUE AS DOUBLEVALUE,
    UAV.LONGVALUE AS LONGVALUE,
    UAV.STRINGVALUE AS STRINGVALUE
FROM PUBLIC.APLAINATTRUNIQUEVALUE UAV
INNER JOIN PUBLIC.APLAINATTR UA
    ON 1=1
WHERE UAV.ATTRIBUTE_ID = UA.ID;       
CREATE MEMORY TABLE PUBLIC.ADYNGROUPMEMBERS(
    ANYTYPE_ID VARCHAR(255),
    ANY_ID CHAR(36),
    GROUP_ID CHAR(36)
);        
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.ADYNGROUPMEMBERS;         
CREATE INDEX PUBLIC.ADYNGROUPMEMBERS_GROUP_ID ON PUBLIC.ADYNGROUPMEMBERS(GROUP_ID);            
CREATE INDEX PUBLIC.ADYNGROUPMEMBERS_ANY_ID ON PUBLIC.ADYNGROUPMEMBERS(ANY_ID);
CREATE FORCE VIEW PUBLIC.GROUP_SEARCH_RESOURCE(ANY_ID, RESOURCE_ID) AS
SELECT
    ST.GROUP_ID AS ANY_ID,
    ST.RESOURCE_ID AS RESOURCE_ID
FROM PUBLIC.SYNCOPEGROUP_EXTERNALRESOURCE ST;       
CREATE MEMORY TABLE PUBLIC.DYNROLEMEMBERS(
    ANY_ID CHAR(36),
    ROLE_ID VARCHAR(255)
);    
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.DYNROLEMEMBERS;           
CREATE INDEX PUBLIC.DYNROLEMEMBERS_ROLE_ID ON PUBLIC.DYNROLEMEMBERS(ROLE_ID);  
CREATE INDEX PUBLIC.DYNROLEMEMBERS_ANY_ID ON PUBLIC.DYNROLEMEMBERS(ANY_ID);    
CREATE FORCE VIEW PUBLIC.USER_SEARCH_NULL_ATTR(ANY_ID, SCHEMA_ID, BOOLEANVALUE, DATEVALUE, DOUBLEVALUE, LONGVALUE, STRINGVALUE) AS
SELECT
    U.ID AS ANY_ID,
    PLAINSCHEMA.ID AS SCHEMA_ID,
    NULL AS BOOLEANVALUE,
    NULL AS DATEVALUE,
    NULL AS DOUBLEVALUE,
    NULL AS LONGVALUE,
    NULL AS STRINGVALUE
FROM PUBLIC.SYNCOPEUSER U
INNER JOIN PUBLIC.PLAINSCHEMA
    ON 1=1
LEFT OUTER JOIN PUBLIC.UPLAINATTR UA
    ON (PLAINSCHEMA.ID = UA.SCHEMA_ID)
    AND (UA.OWNER_ID = U.ID)
WHERE UA.ID IS NULL;       
CREATE FORCE VIEW PUBLIC.USER_SEARCH_ATTR(ANY_ID, SCHEMA_ID, BOOLEANVALUE, DATEVALUE, DOUBLEVALUE, LONGVALUE, STRINGVALUE) AS
SELECT
    UA.OWNER_ID AS ANY_ID,
    UA.SCHEMA_ID AS SCHEMA_ID,
    UAV.BOOLEANVALUE AS BOOLEANVALUE,
    UAV.DATEVALUE AS DATEVALUE,
    UAV.DOUBLEVALUE AS DOUBLEVALUE,
    UAV.LONGVALUE AS LONGVALUE,
    UAV.STRINGVALUE AS STRINGVALUE
FROM PUBLIC.UPLAINATTRVALUE UAV
INNER JOIN PUBLIC.UPLAINATTR UA
    ON 1=1
WHERE UAV.ATTRIBUTE_ID = UA.ID;         
CREATE FORCE VIEW PUBLIC.ANYOBJECT_SEARCH_NULL_ATTR(ANY_ID, SCHEMA_ID, BOOLEANVALUE, DATEVALUE, DOUBLEVALUE, LONGVALUE, STRINGVALUE) AS
SELECT
    U.ID AS ANY_ID,
    PLAINSCHEMA.ID AS SCHEMA_ID,
    NULL AS BOOLEANVALUE,
    NULL AS DATEVALUE,
    NULL AS DOUBLEVALUE,
    NULL AS LONGVALUE,
    NULL AS STRINGVALUE
FROM PUBLIC.ANYOBJECT U
INNER JOIN PUBLIC.PLAINSCHEMA
    ON 1=1
LEFT OUTER JOIN PUBLIC.APLAINATTR UA
    ON (PLAINSCHEMA.ID = UA.SCHEMA_ID)
    AND (UA.OWNER_ID = U.ID)
WHERE UA.ID IS NULL;    
CREATE FORCE VIEW PUBLIC.GROUP_SEARCH_NULL_ATTR(ANY_ID, SCHEMA_ID, BOOLEANVALUE, DATEVALUE, DOUBLEVALUE, LONGVALUE, STRINGVALUE) AS
SELECT
    U.ID AS ANY_ID,
    PLAINSCHEMA.ID AS SCHEMA_ID,
    NULL AS BOOLEANVALUE,
    NULL AS DATEVALUE,
    NULL AS DOUBLEVALUE,
    NULL AS LONGVALUE,
    NULL AS STRINGVALUE
FROM PUBLIC.SYNCOPEGROUP U
INNER JOIN PUBLIC.PLAINSCHEMA
    ON 1=1
LEFT OUTER JOIN PUBLIC.GPLAINATTR UA
    ON (PLAINSCHEMA.ID = UA.SCHEMA_ID)
    AND (UA.OWNER_ID = U.ID)
WHERE UA.ID IS NULL;     
CREATE MEMORY TABLE PUBLIC.SYNCOPEAUDIT(
    EVENT_DATE TIMESTAMP,
    LOGGER_LEVEL VARCHAR(255) NOT NULL,
    LOGGER VARCHAR(255) NOT NULL,
    MESSAGE TEXT NOT NULL,
    THROWABLE TEXT
);  
-- 0 +/- SELECT COUNT(*) FROM PUBLIC.SYNCOPEAUDIT;             
DROP TABLE IF EXISTS SYSTEM_LOB_STREAM;        
CALL SYSTEM_COMBINE_BLOB(-1);  
DROP ALIAS IF EXISTS SYSTEM_COMBINE_CLOB;      
DROP ALIAS IF EXISTS SYSTEM_COMBINE_BLOB;      
ALTER TABLE PUBLIC.REPORT ADD CONSTRAINT PUBLIC.U_REPORT_NAME UNIQUE(NAME);    
ALTER TABLE PUBLIC.CPLAINATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_CPLNQVL_DATEVALUE UNIQUE(DATEVALUE, SCHEMA_ID);               
ALTER TABLE PUBLIC.TYPEEXTENSION ADD CONSTRAINT PUBLIC.U_TYPXNSN_GROUP_ID UNIQUE(GROUP_ID, ANYTYPE_ID);        
ALTER TABLE PUBLIC.UPLAINATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_PLNTQVL_STRINGVALUE UNIQUE(STRINGVALUE, SCHEMA_ID);           
ALTER TABLE PUBLIC.ACT_HI_PROCINST ADD CONSTRAINT PUBLIC.CONSTRAINT_8D1 UNIQUE(PROC_INST_ID_); 
ALTER TABLE PUBLIC.GPLAINATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_GPLNQVL_DOUBLEVALUE UNIQUE(DOUBLEVALUE, SCHEMA_ID);           
ALTER TABLE PUBLIC.APLAINATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_PLNTQVL_STRINGVALUE1 UNIQUE(STRINGVALUE, SCHEMA_ID);          
ALTER TABLE PUBLIC.ARELATIONSHIP ADD CONSTRAINT PUBLIC.U_RLTNSHP_TYPE_ID1 UNIQUE(TYPE_ID, LEFT_ANYOBJECT_ID, RIGHT_ANYOBJECT_ID);              
ALTER TABLE PUBLIC.ACT_PROCDEF_INFO ADD CONSTRAINT PUBLIC.ACT_UNIQ_INFO_PROCDEF UNIQUE(PROC_DEF_ID_);          
ALTER TABLE PUBLIC.DYNROLEMEMBERS ADD CONSTRAINT PUBLIC.CONSTRAINT_BD UNIQUE(ANY_ID, ROLE_ID); 
ALTER TABLE PUBLIC.SECURITYQUESTION ADD CONSTRAINT PUBLIC.U_SCRTSTN_CONTENT UNIQUE(CONTENT);   
ALTER TABLE PUBLIC.ANYTEMPLATEPULLTASK ADD CONSTRAINT PUBLIC.U_NYTMTSK_PULLTASK_ID UNIQUE(PULLTASK_ID, ANYTYPE_ID);            
ALTER TABLE PUBLIC.UPLAINATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_PLNTQVL_BOOLEANVALUE UNIQUE(BOOLEANVALUE, SCHEMA_ID);         
ALTER TABLE PUBLIC.APLAINATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_PLNTQVL_LONGVALUE1 UNIQUE(LONGVALUE, SCHEMA_ID);              
ALTER TABLE PUBLIC.OIDCPROVIDER ADD CONSTRAINT PUBLIC.U_DCPRVDR_CLIENTID UNIQUE(CLIENTID);     
ALTER TABLE PUBLIC.CPLAINATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_CPLNQVL_BOOLEANVALUE UNIQUE(BOOLEANVALUE, SCHEMA_ID);         
ALTER TABLE PUBLIC.APLAINATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_PLNTQVL_BOOLEANVALUE1 UNIQUE(BOOLEANVALUE, SCHEMA_ID);        
ALTER TABLE PUBLIC.URELATIONSHIP ADD CONSTRAINT PUBLIC.U_RLTNSHP_TYPE_ID UNIQUE(TYPE_ID, USER_ID, ANYOBJECT_ID);               
ALTER TABLE PUBLIC.OIDCPROVIDER ADD CONSTRAINT PUBLIC.U_DCPRVDR_CLIENTSECRET UNIQUE(CLIENTSECRET);             
ALTER TABLE PUBLIC.CPLAINATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_CPLNQVL_LONGVALUE UNIQUE(LONGVALUE, SCHEMA_ID);               
ALTER TABLE PUBLIC.REALM ADD CONSTRAINT PUBLIC.U_REALM_NAME UNIQUE(NAME, PARENT_ID);           
ALTER TABLE PUBLIC.UDYNGROUPMEMBERS ADD CONSTRAINT PUBLIC.CONSTRAINT_405 UNIQUE(ANY_ID, GROUP_ID);             
ALTER TABLE PUBLIC.GPLAINATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_GPLNQVL_BOOLEANVALUE UNIQUE(BOOLEANVALUE, SCHEMA_ID);         
ALTER TABLE PUBLIC.OIDCPROVIDER ADD CONSTRAINT PUBLIC.U_DCPRVDR_NAME UNIQUE(NAME);             
ALTER TABLE PUBLIC.CPLAINATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_CPLNQVL_STRINGVALUE UNIQUE(STRINGVALUE, SCHEMA_ID);           
ALTER TABLE PUBLIC.OIDCUSERTEMPLATE ADD CONSTRAINT PUBLIC.U_DCSRPLT_OP_ID UNIQUE(OP_ID);       
ALTER TABLE PUBLIC.SAML2IDP ADD CONSTRAINT PUBLIC.U_SML2IDP_NAME UNIQUE(NAME); 
ALTER TABLE PUBLIC.GPLAINATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_GPLNQVL_DATEVALUE UNIQUE(DATEVALUE, SCHEMA_ID);               
ALTER TABLE PUBLIC.SAML2IDP ADD CONSTRAINT PUBLIC.U_SML2IDP_ENTITYID UNIQUE(ENTITYID);         
ALTER TABLE PUBLIC.CPLAINATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_CPLNQVL_DOUBLEVALUE UNIQUE(DOUBLEVALUE, SCHEMA_ID);           
ALTER TABLE PUBLIC.PUSHTASKANYFILTER ADD CONSTRAINT PUBLIC.U_PSHTLTR_PUSHTASK_ID UNIQUE(PUSHTASK_ID, ANYTYPE_ID);              
ALTER TABLE PUBLIC.ACCESSTOKEN ADD CONSTRAINT PUBLIC.U_CCSSTKN_OWNER UNIQUE(OWNER);            
ALTER TABLE PUBLIC.UPLAINATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_PLNTQVL_LONGVALUE UNIQUE(LONGVALUE, SCHEMA_ID);               
ALTER TABLE PUBLIC.SAML2USERTEMPLATE ADD CONSTRAINT PUBLIC.U_SML2PLT_IDP_ID UNIQUE(IDP_ID);    
ALTER TABLE PUBLIC.GPLAINATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_GPLNQVL_STRINGVALUE UNIQUE(STRINGVALUE, SCHEMA_ID);           
ALTER TABLE PUBLIC.CONNINSTANCE ADD CONSTRAINT PUBLIC.U_CNNNTNC_DISPLAYNAME UNIQUE(DISPLAYNAME);               
ALTER TABLE PUBLIC.UPLAINATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_PLNTQVL_DOUBLEVALUE UNIQUE(DOUBLEVALUE, SCHEMA_ID);           
ALTER TABLE PUBLIC.SYNCOPEUSER ADD CONSTRAINT PUBLIC.U_SYNCPSR_USERNAME UNIQUE(USERNAME);      
ALTER TABLE PUBLIC.GPLAINATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_GPLNQVL_LONGVALUE UNIQUE(LONGVALUE, SCHEMA_ID);               
ALTER TABLE PUBLIC.UPLAINATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_PLNTQVL_DATEVALUE UNIQUE(DATEVALUE, SCHEMA_ID);               
ALTER TABLE PUBLIC.ANYABOUT ADD CONSTRAINT PUBLIC.U_NYABOUT_NOTIFICATION_ID UNIQUE(NOTIFICATION_ID, ANYTYPE_ID);               
ALTER TABLE PUBLIC.APLAINATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_PLNTQVL_DATEVALUE1 UNIQUE(DATEVALUE, SCHEMA_ID);              
ALTER TABLE PUBLIC.ANYTEMPLATEREALM ADD CONSTRAINT PUBLIC.U_NYTMRLM_REALM_ID UNIQUE(REALM_ID, ANYTYPE_ID);     
ALTER TABLE PUBLIC.SYNCOPEGROUP ADD CONSTRAINT PUBLIC.U_SYNCGRP_NAME UNIQUE(NAME);             
ALTER TABLE PUBLIC.ACT_RE_PROCDEF ADD CONSTRAINT PUBLIC.ACT_UNIQ_PROCDEF UNIQUE(KEY_, VERSION_, TENANT_ID_);   
ALTER TABLE PUBLIC.PROVISION ADD CONSTRAINT PUBLIC.U_PROVSON_RESOURCE_ID UNIQUE(RESOURCE_ID, ANYTYPE_ID);      
ALTER TABLE PUBLIC.ADYNGROUPMEMBERS ADD CONSTRAINT PUBLIC.CONSTRAINT_A0F UNIQUE(ANYTYPE_ID, ANY_ID, GROUP_ID); 
ALTER TABLE PUBLIC.ANYOBJECT ADD CONSTRAINT PUBLIC.U_NYOBJCT_NAME UNIQUE(NAME);
ALTER TABLE PUBLIC.DYNREALMMEMBERS ADD CONSTRAINT PUBLIC.CONSTRAINT_55 UNIQUE(ANY_ID, DYNREALM_ID);            
ALTER TABLE PUBLIC.APLAINATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.U_PLNTQVL_DOUBLEVALUE1 UNIQUE(DOUBLEVALUE, SCHEMA_ID);          
ALTER TABLE PUBLIC.EXTERNALRESOURCE ADD CONSTRAINT PUBLIC.CONSTRAINT_FB20CD FOREIGN KEY(PULLPOLICY_ID) REFERENCES PUBLIC.PULLPOLICY(ID) NOCHECK;               
ALTER TABLE PUBLIC.UPLAINATTRVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_B95 FOREIGN KEY(ATTRIBUTE_ID) REFERENCES PUBLIC.UPLAINATTR(ID) NOCHECK;    
ALTER TABLE PUBLIC.UPLAINATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_380F FOREIGN KEY(SCHEMA_ID) REFERENCES PUBLIC.PLAINSCHEMA(ID) NOCHECK;          
ALTER TABLE PUBLIC.PROVISION ADD CONSTRAINT PUBLIC.CONSTRAINT_857 FOREIGN KEY(ANYTYPE_ID) REFERENCES PUBLIC.ANYTYPE(ID) NOCHECK;               
ALTER TABLE PUBLIC.ANYOBJECT_ANYTYPECLASS ADD CONSTRAINT PUBLIC.CONSTRAINT_F0D FOREIGN KEY(ANYTYPECLASS_ID) REFERENCES PUBLIC.ANYTYPECLASS(ID) NOCHECK;        
ALTER TABLE PUBLIC.UPLAINATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_FA5 FOREIGN KEY(ATTRIBUTE_ID) REFERENCES PUBLIC.UPLAINATTR(ID) NOCHECK;              
ALTER TABLE PUBLIC.SYNCOPEGROUP ADD CONSTRAINT PUBLIC.CONSTRAINT_8EA FOREIGN KEY(REALM_ID) REFERENCES PUBLIC.REALM(ID) NOCHECK;
ALTER TABLE PUBLIC.SYNCOPEGROUP ADD CONSTRAINT PUBLIC.CONSTRAINT_8EA10 FOREIGN KEY(USEROWNER_ID) REFERENCES PUBLIC.SYNCOPEUSER(ID) NOCHECK;    
ALTER TABLE PUBLIC.CPLAINATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_179 FOREIGN KEY(ATTRIBUTE_ID) REFERENCES PUBLIC.CPLAINATTR(ID) NOCHECK;              
ALTER TABLE PUBLIC.PULLTASK_ACTIONSCLASSNAMES ADD CONSTRAINT PUBLIC.CONSTRAINT_A0 FOREIGN KEY(PULLTASK_ID) REFERENCES PUBLIC.TASK(ID) NOCHECK; 
ALTER TABLE PUBLIC.SYNCOPEUSER_SYNCOPEROLE ADD CONSTRAINT PUBLIC.CONSTRAINT_84B FOREIGN KEY(ROLE_ID) REFERENCES PUBLIC.SYNCOPEROLE(ID) NOCHECK;
ALTER TABLE PUBLIC.TASK ADD CONSTRAINT PUBLIC.CONSTRAINT_272D8 FOREIGN KEY(NOTIFICATION_ID) REFERENCES PUBLIC.NOTIFICATION(ID) NOCHECK;        
ALTER TABLE PUBLIC.UMEMBERSHIP ADD CONSTRAINT PUBLIC.CONSTRAINT_3CF6 FOREIGN KEY(GROUP_ID) REFERENCES PUBLIC.SYNCOPEGROUP(ID) NOCHECK;         
ALTER TABLE PUBLIC.OIDCPROVIDERITEM ADD CONSTRAINT PUBLIC.CONSTRAINT_17F7 FOREIGN KEY(OP_ID) REFERENCES PUBLIC.OIDCPROVIDER(ID) NOCHECK;       
ALTER TABLE PUBLIC.TASK ADD CONSTRAINT PUBLIC.CONSTRAINT_272D FOREIGN KEY(DESTINATIONREALM_ID) REFERENCES PUBLIC.REALM(ID) NOCHECK;            
ALTER TABLE PUBLIC.ANYTEMPLATEPULLTASK ADD CONSTRAINT PUBLIC.CONSTRAINT_9E9B FOREIGN KEY(PULLTASK_ID) REFERENCES PUBLIC.TASK(ID) NOCHECK;      
ALTER TABLE PUBLIC.PLAINSCHEMA ADD CONSTRAINT PUBLIC.CONSTRAINT_175A FOREIGN KEY(ID) REFERENCES PUBLIC.SYNCOPESCHEMA(ID) NOCHECK;              
ALTER TABLE PUBLIC.SYNCOPEUSER ADD CONSTRAINT PUBLIC.CONSTRAINT_6FFB0D FOREIGN KEY(SECURITYQUESTION_ID) REFERENCES PUBLIC.SECURITYQUESTION(ID) NOCHECK;        
ALTER TABLE PUBLIC.TASKEXEC ADD CONSTRAINT PUBLIC.CONSTRAINT_163 FOREIGN KEY(TASK_ID) REFERENCES PUBLIC.TASK(ID) NOCHECK;      
ALTER TABLE PUBLIC.ACT_RE_MODEL ADD CONSTRAINT PUBLIC.ACT_FK_MODEL_SOURCE FOREIGN KEY(EDITOR_SOURCE_VALUE_ID_) REFERENCES PUBLIC.ACT_GE_BYTEARRAY(ID_) NOCHECK;
ALTER TABLE PUBLIC.MAPPINGITEM ADD CONSTRAINT PUBLIC.CONSTRAINT_39F FOREIGN KEY(MAPPING_ID) REFERENCES PUBLIC.MAPPING(ID) NOCHECK;             
ALTER TABLE PUBLIC.SYNCOPEUSER ADD CONSTRAINT PUBLIC.CONSTRAINT_6FFB0 FOREIGN KEY(REALM_ID) REFERENCES PUBLIC.REALM(ID) NOCHECK;               
ALTER TABLE PUBLIC.SYNCOPEGROUP_EXTERNALRESOURCE ADD CONSTRAINT PUBLIC.CONSTRAINT_23 FOREIGN KEY(GROUP_ID) REFERENCES PUBLIC.SYNCOPEGROUP(ID) NOCHECK;         
ALTER TABLE PUBLIC.EXTERNALRESOURCE_PROPACTIONS ADD CONSTRAINT PUBLIC.CONSTRAINT_25 FOREIGN KEY(RESOURCE_ID) REFERENCES PUBLIC.EXTERNALRESOURCE(ID) NOCHECK;   
ALTER TABLE PUBLIC.ACCOUNTRULECONFINSTANCE ADD CONSTRAINT PUBLIC.CONSTRAINT_24 FOREIGN KEY(ACCOUNTPOLICY_ID) REFERENCES PUBLIC.ACCOUNTPOLICY(ID) NOCHECK;      
ALTER TABLE PUBLIC.ACT_RU_EXECUTION ADD CONSTRAINT PUBLIC.ACT_FK_EXE_PARENT FOREIGN KEY(PARENT_ID_) REFERENCES PUBLIC.ACT_RU_EXECUTION(ID_) NOCHECK;           
ALTER TABLE PUBLIC.CPLAINATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_AE5 FOREIGN KEY(SCHEMA_ID) REFERENCES PUBLIC.PLAINSCHEMA(ID) NOCHECK;           
ALTER TABLE PUBLIC.ANYTEMPLATEPULLTASK ADD CONSTRAINT PUBLIC.CONSTRAINT_9E9 FOREIGN KEY(ANYTYPE_ID) REFERENCES PUBLIC.ANYTYPE(ID) NOCHECK;     
ALTER TABLE PUBLIC.TASK ADD CONSTRAINT PUBLIC.CONSTRAINT_272 FOREIGN KEY(RESOURCE_ID) REFERENCES PUBLIC.EXTERNALRESOURCE(ID) NOCHECK;          
ALTER TABLE PUBLIC.ANYTYPE_ANYTYPECLASS ADD CONSTRAINT PUBLIC.CONSTRAINT_30 FOREIGN KEY(ANYTYPE_ID) REFERENCES PUBLIC.ANYTYPE(ID) NOCHECK;     
ALTER TABLE PUBLIC.CONNINSTANCEHISTORYCONF ADD CONSTRAINT PUBLIC.CONSTRAINT_C3 FOREIGN KEY(ENTITY_ID) REFERENCES PUBLIC.CONNINSTANCE(ID) NOCHECK;              
ALTER TABLE PUBLIC.SYNCOPEROLE_ENTITLEMENTS ADD CONSTRAINT PUBLIC.CONSTRAINT_2B FOREIGN KEY(ROLE_ID) REFERENCES PUBLIC.SYNCOPEROLE(ID) NOCHECK;
ALTER TABLE PUBLIC.UDYNGROUPMEMBERSHIP ADD CONSTRAINT PUBLIC.CONSTRAINT_7A1 FOREIGN KEY(GROUP_ID) REFERENCES PUBLIC.SYNCOPEGROUP(ID) NOCHECK;  
ALTER TABLE PUBLIC.TYPEEXTENSION_ANYTYPECLASS ADD CONSTRAINT PUBLIC.CONSTRAINT_C8 FOREIGN KEY(TYPEEXTENSION_ID) REFERENCES PUBLIC.TYPEEXTENSION(ID) NOCHECK;   
ALTER TABLE PUBLIC.SYNCOPEUSER_EXTERNALRESOURCE ADD CONSTRAINT PUBLIC.CONSTRAINT_C7 FOREIGN KEY(USER_ID) REFERENCES PUBLIC.SYNCOPEUSER(ID) NOCHECK;            
ALTER TABLE PUBLIC.TYPEEXTENSION_ANYTYPECLASS ADD CONSTRAINT PUBLIC.CONSTRAINT_C83 FOREIGN KEY(ANYTYPECLASS_ID) REFERENCES PUBLIC.ANYTYPECLASS(ID) NOCHECK;    
ALTER TABLE PUBLIC.ANYABOUT ADD CONSTRAINT PUBLIC.CONSTRAINT_19 FOREIGN KEY(NOTIFICATION_ID) REFERENCES PUBLIC.NOTIFICATION(ID) NOCHECK;       
ALTER TABLE PUBLIC.NOTIFICATION ADD CONSTRAINT PUBLIC.CONSTRAINT_AD9 FOREIGN KEY(TEMPLATE_ID) REFERENCES PUBLIC.MAILTEMPLATE(ID) NOCHECK;      
ALTER TABLE PUBLIC.AMEMBERSHIP ADD CONSTRAINT PUBLIC.CONSTRAINT_9B18 FOREIGN KEY(GROUP_ID) REFERENCES PUBLIC.SYNCOPEGROUP(ID) NOCHECK;         
ALTER TABLE PUBLIC.CPLAINATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_AE FOREIGN KEY(OWNER_ID) REFERENCES PUBLIC.SYNCOPECONF(ID) NOCHECK;             
ALTER TABLE PUBLIC.SYNCOPEUSER_EXTERNALRESOURCE ADD CONSTRAINT PUBLIC.CONSTRAINT_C7A FOREIGN KEY(RESOURCE_ID) REFERENCES PUBLIC.EXTERNALRESOURCE(ID) NOCHECK;  
ALTER TABLE PUBLIC.UPLAINATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_380 FOREIGN KEY(OWNER_ID) REFERENCES PUBLIC.SYNCOPEUSER(ID) NOCHECK;            
ALTER TABLE PUBLIC.SAML2USERTEMPLATE ADD CONSTRAINT PUBLIC.CONSTRAINT_2144 FOREIGN KEY(ANYTYPE_ID) REFERENCES PUBLIC.ANYTYPE(ID) NOCHECK;      
ALTER TABLE PUBLIC.ACT_PROCDEF_INFO ADD CONSTRAINT PUBLIC.ACT_FK_INFO_JSON_BA FOREIGN KEY(INFO_JSON_ID_) REFERENCES PUBLIC.ACT_GE_BYTEARRAY(ID_) NOCHECK;      
ALTER TABLE PUBLIC.NOTIFICATION_STATICRECIPIENTS ADD CONSTRAINT PUBLIC.CONSTRAINT_B7 FOREIGN KEY(NOTIFICATION_ID) REFERENCES PUBLIC.NOTIFICATION(ID) NOCHECK;  
ALTER TABLE PUBLIC.SAML2IDPITEM ADD CONSTRAINT PUBLIC.CONSTRAINT_A34 FOREIGN KEY(IDP_ID) REFERENCES PUBLIC.SAML2IDP(ID) NOCHECK;               
ALTER TABLE PUBLIC.ACT_RU_TASK ADD CONSTRAINT PUBLIC.ACT_FK_TASK_PROCDEF FOREIGN KEY(PROC_DEF_ID_) REFERENCES PUBLIC.ACT_RE_PROCDEF(ID_) NOCHECK;              
ALTER TABLE PUBLIC.APLAINATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_FE69 FOREIGN KEY(SCHEMA_ID) REFERENCES PUBLIC.PLAINSCHEMA(ID) NOCHECK;               
ALTER TABLE PUBLIC.PLAINSCHEMA ADD CONSTRAINT PUBLIC.CONSTRAINT_175A3 FOREIGN KEY(ANYTYPECLASS_ID) REFERENCES PUBLIC.ANYTYPECLASS(ID) NOCHECK; 
ALTER TABLE PUBLIC.APLAINATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_FE6 FOREIGN KEY(ATTRIBUTE_ID) REFERENCES PUBLIC.APLAINATTR(ID) NOCHECK;              
ALTER TABLE PUBLIC.ACT_RU_VARIABLE ADD CONSTRAINT PUBLIC.ACT_FK_VAR_BYTEARRAY FOREIGN KEY(BYTEARRAY_ID_) REFERENCES PUBLIC.ACT_GE_BYTEARRAY(ID_) NOCHECK;      
ALTER TABLE PUBLIC.TYPEEXTENSION ADD CONSTRAINT PUBLIC.CONSTRAINT_D09 FOREIGN KEY(GROUP_ID) REFERENCES PUBLIC.SYNCOPEGROUP(ID) NOCHECK;        
ALTER TABLE PUBLIC.SYNCOPEROLE_REALM ADD CONSTRAINT PUBLIC.CONSTRAINT_F49 FOREIGN KEY(REALM_ID) REFERENCES PUBLIC.REALM(ID) NOCHECK;           
ALTER TABLE PUBLIC.URELATIONSHIP ADD CONSTRAINT PUBLIC.CONSTRAINT_AC04 FOREIGN KEY(ANYOBJECT_ID) REFERENCES PUBLIC.ANYOBJECT(ID) NOCHECK;      
ALTER TABLE PUBLIC.ARELATIONSHIP ADD CONSTRAINT PUBLIC.CONSTRAINT_9C80 FOREIGN KEY(RIGHT_ANYOBJECT_ID) REFERENCES PUBLIC.ANYOBJECT(ID) NOCHECK;
ALTER TABLE PUBLIC.ORGUNITITEM ADD CONSTRAINT PUBLIC.CONSTRAINT_6E5 FOREIGN KEY(ORGUNIT_ID) REFERENCES PUBLIC.ORGUNIT(ID) NOCHECK;             
ALTER TABLE PUBLIC.REALM ADD CONSTRAINT PUBLIC.CONSTRAINT_4A3 FOREIGN KEY(ACCOUNTPOLICY_ID) REFERENCES PUBLIC.ACCOUNTPOLICY(ID) NOCHECK;       
ALTER TABLE PUBLIC.SYNCOPEGROUP ADD CONSTRAINT PUBLIC.CONSTRAINT_8EA1 FOREIGN KEY(GROUPOWNER_ID) REFERENCES PUBLIC.SYNCOPEGROUP(ID) NOCHECK;   
ALTER TABLE PUBLIC.DYNROLEMEMBERSHIP ADD CONSTRAINT PUBLIC.CONSTRAINT_649 FOREIGN KEY(ROLE_ID) REFERENCES PUBLIC.SYNCOPEROLE(ID) NOCHECK;      
ALTER TABLE PUBLIC.CPLAINATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_179B FOREIGN KEY(SCHEMA_ID) REFERENCES PUBLIC.PLAINSCHEMA(ID) NOCHECK;               
ALTER TABLE PUBLIC.PUSHTASKANYFILTER ADD CONSTRAINT PUBLIC.CONSTRAINT_FD6 FOREIGN KEY(ANYTYPE_ID) REFERENCES PUBLIC.ANYTYPE(ID) NOCHECK;       
ALTER TABLE PUBLIC.OIDCUSERTEMPLATE ADD CONSTRAINT PUBLIC.CONSTRAINT_B082 FOREIGN KEY(ANYTYPE_ID) REFERENCES PUBLIC.ANYTYPE(ID) NOCHECK;       
ALTER TABLE PUBLIC.SYNCOPEROLE_DYNREALM ADD CONSTRAINT PUBLIC.CONSTRAINT_887 FOREIGN KEY(DYNAMICREALM_ID) REFERENCES PUBLIC.DYNREALM(ID) NOCHECK;              
ALTER TABLE PUBLIC.QRTZ_SIMPROP_TRIGGERS ADD CONSTRAINT PUBLIC.FK_QRTZ_SIMPROP_TRIGGERS_QRTZ_TRIGGERS FOREIGN KEY(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP) REFERENCES PUBLIC.QRTZ_TRIGGERS(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP) ON DELETE CASCADE NOCHECK; 
ALTER TABLE PUBLIC.REALM ADD CONSTRAINT PUBLIC.CONSTRAINT_4A3E FOREIGN KEY(PARENT_ID) REFERENCES PUBLIC.REALM(ID) NOCHECK;     
ALTER TABLE PUBLIC.ANYABOUT ADD CONSTRAINT PUBLIC.CONSTRAINT_19E FOREIGN KEY(ANYTYPE_ID) REFERENCES PUBLIC.ANYTYPE(ID) NOCHECK;
ALTER TABLE PUBLIC.SYNCOPEUSER_ANYTYPECLASS ADD CONSTRAINT PUBLIC.CONSTRAINT_871 FOREIGN KEY(ANYTYPECLASS_ID) REFERENCES PUBLIC.ANYTYPECLASS(ID) NOCHECK;      
ALTER TABLE PUBLIC.ACT_RU_IDENTITYLINK ADD CONSTRAINT PUBLIC.ACT_FK_ATHRZ_PROCEDEF FOREIGN KEY(PROC_DEF_ID_) REFERENCES PUBLIC.ACT_RE_PROCDEF(ID_) NOCHECK;    
ALTER TABLE PUBLIC.APLAINATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_22528 FOREIGN KEY(MEMBERSHIP_ID) REFERENCES PUBLIC.AMEMBERSHIP(ID) NOCHECK;     
ALTER TABLE PUBLIC.ARELATIONSHIP ADD CONSTRAINT PUBLIC.CONSTRAINT_9C804 FOREIGN KEY(TYPE_ID) REFERENCES PUBLIC.RELATIONSHIPTYPE(ID) NOCHECK;   
ALTER TABLE PUBLIC.ACT_RU_EXECUTION ADD CONSTRAINT PUBLIC.ACT_FK_EXE_PROCINST FOREIGN KEY(PROC_INST_ID_) REFERENCES PUBLIC.ACT_RU_EXECUTION(ID_) NOCHECK;      
ALTER TABLE PUBLIC.EXTERNALRESOURCE ADD CONSTRAINT PUBLIC.CONSTRAINT_FB2 FOREIGN KEY(ACCOUNTPOLICY_ID) REFERENCES PUBLIC.ACCOUNTPOLICY(ID) NOCHECK;            
ALTER TABLE PUBLIC.ACT_PROCDEF_INFO ADD CONSTRAINT PUBLIC.ACT_FK_INFO_PROCDEF FOREIGN KEY(PROC_DEF_ID_) REFERENCES PUBLIC.ACT_RE_PROCDEF(ID_) NOCHECK;         
ALTER TABLE PUBLIC.VIRSCHEMA ADD CONSTRAINT PUBLIC.CONSTRAINT_F16 FOREIGN KEY(ID) REFERENCES PUBLIC.SYNCOPESCHEMA(ID) NOCHECK; 
ALTER TABLE PUBLIC.GPLAINATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_49FEF FOREIGN KEY(SCHEMA_ID) REFERENCES PUBLIC.PLAINSCHEMA(ID) NOCHECK;              
ALTER TABLE PUBLIC.ACT_GE_BYTEARRAY ADD CONSTRAINT PUBLIC.ACT_FK_BYTEARR_DEPL FOREIGN KEY(DEPLOYMENT_ID_) REFERENCES PUBLIC.ACT_RE_DEPLOYMENT(ID_) NOCHECK;    
ALTER TABLE PUBLIC.SYNCOPEUSER_ANYTYPECLASS ADD CONSTRAINT PUBLIC.CONSTRAINT_87 FOREIGN KEY(USER_ID) REFERENCES PUBLIC.SYNCOPEUSER(ID) NOCHECK;
ALTER TABLE PUBLIC.UMEMBERSHIP ADD CONSTRAINT PUBLIC.CONSTRAINT_3CF FOREIGN KEY(USER_ID) REFERENCES PUBLIC.SYNCOPEUSER(ID) NOCHECK;            
ALTER TABLE PUBLIC.SYNCOPEROLE_DYNREALM ADD CONSTRAINT PUBLIC.CONSTRAINT_88 FOREIGN KEY(ROLE_ID) REFERENCES PUBLIC.SYNCOPEROLE(ID) NOCHECK;    
ALTER TABLE PUBLIC.SAML2USERTEMPLATE ADD CONSTRAINT PUBLIC.CONSTRAINT_214 FOREIGN KEY(IDP_ID) REFERENCES PUBLIC.SAML2IDP(ID) NOCHECK;          
ALTER TABLE PUBLIC.TASK ADD CONSTRAINT PUBLIC.CONSTRAINT_272D85_0 FOREIGN KEY(SOURCEREALM_ID) REFERENCES PUBLIC.REALM(ID) NOCHECK;             
ALTER TABLE PUBLIC.ACT_RU_VARIABLE ADD CONSTRAINT PUBLIC.ACT_FK_VAR_PROCINST FOREIGN KEY(PROC_INST_ID_) REFERENCES PUBLIC.ACT_RU_EXECUTION(ID_) NOCHECK;       
ALTER TABLE PUBLIC.OIDCUSERTEMPLATE ADD CONSTRAINT PUBLIC.CONSTRAINT_B08 FOREIGN KEY(OP_ID) REFERENCES PUBLIC.OIDCPROVIDER(ID) NOCHECK;        
ALTER TABLE PUBLIC.SYNCOPEGROUP_ANYTYPECLASS ADD CONSTRAINT PUBLIC.CONSTRAINT_E64 FOREIGN KEY(ANYTYPECLASS_ID) REFERENCES PUBLIC.ANYTYPECLASS(ID) NOCHECK;     
ALTER TABLE PUBLIC.ACT_RU_JOB ADD CONSTRAINT PUBLIC.ACT_FK_JOB_EXCEPTION FOREIGN KEY(EXCEPTION_STACK_ID_) REFERENCES PUBLIC.ACT_GE_BYTEARRAY(ID_) NOCHECK;     
ALTER TABLE PUBLIC.REALM_ACTIONSCLASSNAMES ADD CONSTRAINT PUBLIC.CONSTRAINT_78 FOREIGN KEY(REALM_ID) REFERENCES PUBLIC.REALM(ID) NOCHECK;      
ALTER TABLE PUBLIC.REALM_EXTERNALRESOURCE ADD CONSTRAINT PUBLIC.CONSTRAINT_79 FOREIGN KEY(REALM_ID) REFERENCES PUBLIC.REALM(ID) NOCHECK;       
ALTER TABLE PUBLIC.ANYTEMPLATEREALM ADD CONSTRAINT PUBLIC.CONSTRAINT_DD0 FOREIGN KEY(ANYTYPE_ID) REFERENCES PUBLIC.ANYTYPE(ID) NOCHECK;        
ALTER TABLE PUBLIC.SYNCOPEUSER_SYNCOPEROLE ADD CONSTRAINT PUBLIC.CONSTRAINT_84 FOREIGN KEY(USER_ID) REFERENCES PUBLIC.SYNCOPEUSER(ID) NOCHECK; 
ALTER TABLE PUBLIC.NOTIFICATION_EVENTS ADD CONSTRAINT PUBLIC.CONSTRAINT_7F FOREIGN KEY(NOTIFICATION_ID) REFERENCES PUBLIC.NOTIFICATION(ID) NOCHECK;            
ALTER TABLE PUBLIC.ACT_RU_IDENTITYLINK ADD CONSTRAINT PUBLIC.ACT_FK_TSKASS_TASK FOREIGN KEY(TASK_ID_) REFERENCES PUBLIC.ACT_RU_TASK(ID_) NOCHECK;              
ALTER TABLE PUBLIC.DERSCHEMA ADD CONSTRAINT PUBLIC.CONSTRAINT_E51 FOREIGN KEY(ID) REFERENCES PUBLIC.SYNCOPESCHEMA(ID) NOCHECK; 
ALTER TABLE PUBLIC.ACT_RU_TASK ADD CONSTRAINT PUBLIC.ACT_FK_TASK_EXE FOREIGN KEY(EXECUTION_ID_) REFERENCES PUBLIC.ACT_RU_EXECUTION(ID_) NOCHECK;               
ALTER TABLE PUBLIC.EXTERNALRESOURCE ADD CONSTRAINT PUBLIC.CONSTRAINT_FB20C FOREIGN KEY(PASSWORDPOLICY_ID) REFERENCES PUBLIC.PASSWORDPOLICY(ID) NOCHECK;        
ALTER TABLE PUBLIC.ACT_RU_EVENT_SUBSCR ADD CONSTRAINT PUBLIC.ACT_FK_EVENT_EXEC FOREIGN KEY(EXECUTION_ID_) REFERENCES PUBLIC.ACT_RU_EXECUTION(ID_) NOCHECK;     
ALTER TABLE PUBLIC.ACT_RU_VARIABLE ADD CONSTRAINT PUBLIC.ACT_FK_VAR_EXE FOREIGN KEY(EXECUTION_ID_) REFERENCES PUBLIC.ACT_RU_EXECUTION(ID_) NOCHECK;            
ALTER TABLE PUBLIC.PUSHTASKANYFILTER ADD CONSTRAINT PUBLIC.CONSTRAINT_FD6D FOREIGN KEY(PUSHTASK_ID) REFERENCES PUBLIC.TASK(ID) NOCHECK;        
ALTER TABLE PUBLIC.REALM_EXTERNALRESOURCE ADD CONSTRAINT PUBLIC.CONSTRAINT_795 FOREIGN KEY(RESOURCE_ID) REFERENCES PUBLIC.EXTERNALRESOURCE(ID) NOCHECK;        
ALTER TABLE PUBLIC.GPLAINATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_DC0 FOREIGN KEY(SCHEMA_ID) REFERENCES PUBLIC.PLAINSCHEMA(ID) NOCHECK;           
ALTER TABLE PUBLIC.ANYOBJECT ADD CONSTRAINT PUBLIC.CONSTRAINT_3A9 FOREIGN KEY(TYPE_ID) REFERENCES PUBLIC.ANYTYPE(ID) NOCHECK;  
ALTER TABLE PUBLIC.ACT_ID_MEMBERSHIP ADD CONSTRAINT PUBLIC.ACT_FK_MEMB_GROUP FOREIGN KEY(GROUP_ID_) REFERENCES PUBLIC.ACT_ID_GROUP(ID_) NOCHECK;               
ALTER TABLE PUBLIC.QRTZ_SIMPLE_TRIGGERS ADD CONSTRAINT PUBLIC.FK_QRTZ_SIMPLE_TRIGGERS_QRTZ_TRIGGERS FOREIGN KEY(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP) REFERENCES PUBLIC.QRTZ_TRIGGERS(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP) ON DELETE CASCADE NOCHECK;   
ALTER TABLE PUBLIC.ADYNGROUPMEMBERSHIP ADD CONSTRAINT PUBLIC.CONSTRAINT_F65 FOREIGN KEY(ANYTYPE_ID) REFERENCES PUBLIC.ANYTYPE(ID) NOCHECK;     
ALTER TABLE PUBLIC.DYNREALMMEMBERSHIP ADD CONSTRAINT PUBLIC.CONSTRAINT_1322 FOREIGN KEY(ANYTYPE_ID) REFERENCES PUBLIC.ANYTYPE(ID) NOCHECK;     
ALTER TABLE PUBLIC.ANYTYPE_ANYTYPECLASS ADD CONSTRAINT PUBLIC.CONSTRAINT_30B FOREIGN KEY(ANYTYPECLASS_ID) REFERENCES PUBLIC.ANYTYPECLASS(ID) NOCHECK;          
ALTER TABLE PUBLIC.QRTZ_TRIGGERS ADD CONSTRAINT PUBLIC.FK_QRTZ_TRIGGERS_QRTZ_JOB_DETAILS FOREIGN KEY(SCHED_NAME, JOB_NAME, JOB_GROUP) REFERENCES PUBLIC.QRTZ_JOB_DETAILS(SCHED_NAME, JOB_NAME, JOB_GROUP) NOCHECK;             
ALTER TABLE PUBLIC.REPORT ADD CONSTRAINT PUBLIC.CONSTRAINT_8FDF FOREIGN KEY(TEMPLATE_ID) REFERENCES PUBLIC.REPORTTEMPLATE(ID) NOCHECK;         
ALTER TABLE PUBLIC.ACT_ID_MEMBERSHIP ADD CONSTRAINT PUBLIC.ACT_FK_MEMB_USER FOREIGN KEY(USER_ID_) REFERENCES PUBLIC.ACT_ID_USER(ID_) NOCHECK;  
ALTER TABLE PUBLIC.ANYOBJECT_EXTERNALRESOURCE ADD CONSTRAINT PUBLIC.CONSTRAINT_543 FOREIGN KEY(RESOURCE_ID) REFERENCES PUBLIC.EXTERNALRESOURCE(ID) NOCHECK;    
ALTER TABLE PUBLIC.ACCOUNTPOLICY_EXTERNALRESOURCE ADD CONSTRAINT PUBLIC.CONSTRAINT_ED3 FOREIGN KEY(RESOURCE_ID) REFERENCES PUBLIC.EXTERNALRESOURCE(ID) NOCHECK;
ALTER TABLE PUBLIC.EXTERNALRESOURCEHISTORYCONF ADD CONSTRAINT PUBLIC.CONSTRAINT_FBB9 FOREIGN KEY(ENTITY_ID) REFERENCES PUBLIC.EXTERNALRESOURCE(ID) NOCHECK;    
ALTER TABLE PUBLIC.ORGUNITITEM_TRANSFORMER ADD CONSTRAINT PUBLIC.CONSTRAINT_E36 FOREIGN KEY(ORGUNITITEM_ID) REFERENCES PUBLIC.ORGUNITITEM(ID) NOCHECK;         
ALTER TABLE PUBLIC.NOTIFICATIONTASK_RECIPIENTS ADD CONSTRAINT PUBLIC.CONSTRAINT_E32 FOREIGN KEY(NOTIFICATIONTASK_ID) REFERENCES PUBLIC.TASK(ID) NOCHECK;       
ALTER TABLE PUBLIC.EXTERNALRESOURCE_CAPOVERRIDE ADD CONSTRAINT PUBLIC.CONSTRAINT_E31 FOREIGN KEY(RESOURCE_ID) REFERENCES PUBLIC.EXTERNALRESOURCE(ID) NOCHECK;  
ALTER TABLE PUBLIC.EXTERNALRESOURCE ADD CONSTRAINT PUBLIC.CONSTRAINT_FB20 FOREIGN KEY(CONNECTOR_ID) REFERENCES PUBLIC.CONNINSTANCE(ID) NOCHECK;
ALTER TABLE PUBLIC.GPLAINATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_49FE FOREIGN KEY(ATTRIBUTE_ID) REFERENCES PUBLIC.GPLAINATTR(ID) NOCHECK;             
ALTER TABLE PUBLIC.ORGUNIT ADD CONSTRAINT PUBLIC.CONSTRAINT_E30 FOREIGN KEY(RESOURCE_ID) REFERENCES PUBLIC.EXTERNALRESOURCE(ID) NOCHECK;       
ALTER TABLE PUBLIC.CONNINSTANCE_CAPABILITIES ADD CONSTRAINT PUBLIC.CONSTRAINT_9CD FOREIGN KEY(CONNINSTANCE_ID) REFERENCES PUBLIC.CONNINSTANCE(ID) NOCHECK;     
ALTER TABLE PUBLIC.CONNINSTANCE ADD CONSTRAINT PUBLIC.CONSTRAINT_E1 FOREIGN KEY(ADMINREALM_ID) REFERENCES PUBLIC.REALM(ID) NOCHECK;            
ALTER TABLE PUBLIC.ANYTEMPLATEREALM ADD CONSTRAINT PUBLIC.CONSTRAINT_DD FOREIGN KEY(REALM_ID) REFERENCES PUBLIC.REALM(ID) NOCHECK;             
ALTER TABLE PUBLIC.ACT_RE_MODEL ADD CONSTRAINT PUBLIC.ACT_FK_MODEL_DEPLOYMENT FOREIGN KEY(DEPLOYMENT_ID_) REFERENCES PUBLIC.ACT_RE_DEPLOYMENT(ID_) NOCHECK;    
ALTER TABLE PUBLIC.SAML2IDP_ACTIONSCLASSNAMES ADD CONSTRAINT PUBLIC.CONSTRAINT_46 FOREIGN KEY(SAML2IDP_ID) REFERENCES PUBLIC.SAML2IDP(ID) NOCHECK;             
ALTER TABLE PUBLIC.ACT_RU_EXECUTION ADD CONSTRAINT PUBLIC.ACT_FK_EXE_PROCDEF FOREIGN KEY(PROC_DEF_ID_) REFERENCES PUBLIC.ACT_RE_PROCDEF(ID_) NOCHECK;          
ALTER TABLE PUBLIC.DYNREALMMEMBERSHIP ADD CONSTRAINT PUBLIC.CONSTRAINT_132 FOREIGN KEY(DYNREALM_ID) REFERENCES PUBLIC.DYNREALM(ID) NOCHECK;    
ALTER TABLE PUBLIC.PROVISION ADD CONSTRAINT PUBLIC.CONSTRAINT_857B FOREIGN KEY(RESOURCE_ID) REFERENCES PUBLIC.EXTERNALRESOURCE(ID) NOCHECK;    
ALTER TABLE PUBLIC.ARELATIONSHIP ADD CONSTRAINT PUBLIC.CONSTRAINT_9C8 FOREIGN KEY(LEFT_ANYOBJECT_ID) REFERENCES PUBLIC.ANYOBJECT(ID) NOCHECK;  
ALTER TABLE PUBLIC.GPLAINATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_DC0B FOREIGN KEY(OWNER_ID) REFERENCES PUBLIC.SYNCOPEGROUP(ID) NOCHECK;          
ALTER TABLE PUBLIC.URELATIONSHIP ADD CONSTRAINT PUBLIC.CONSTRAINT_AC0 FOREIGN KEY(USER_ID) REFERENCES PUBLIC.SYNCOPEUSER(ID) NOCHECK;          
ALTER TABLE PUBLIC.REALM ADD CONSTRAINT PUBLIC.CONSTRAINT_4A3E2 FOREIGN KEY(PASSWORDPOLICY_ID) REFERENCES PUBLIC.PASSWORDPOLICY(ID) NOCHECK;   
ALTER TABLE PUBLIC.PASSWORDRULECONFINSTANCE ADD CONSTRAINT PUBLIC.CONSTRAINT_8A1 FOREIGN KEY(PASSWORDPOLICY_ID) REFERENCES PUBLIC.PASSWORDPOLICY(ID) NOCHECK;  
ALTER TABLE PUBLIC.SYNCOPEUSER_PASSWORDHISTORY ADD CONSTRAINT PUBLIC.CONSTRAINT_9C3 FOREIGN KEY(USER_ID) REFERENCES PUBLIC.SYNCOPEUSER(ID) NOCHECK;            
ALTER TABLE PUBLIC.SYNCOPEGROUP_ANYTYPECLASS ADD CONSTRAINT PUBLIC.CONSTRAINT_E6 FOREIGN KEY(GROUP_ID) REFERENCES PUBLIC.SYNCOPEGROUP(ID) NOCHECK;             
ALTER TABLE PUBLIC.APLAINATTRVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_B43 FOREIGN KEY(ATTRIBUTE_ID) REFERENCES PUBLIC.APLAINATTR(ID) NOCHECK;    
ALTER TABLE PUBLIC.APLAINATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_2252 FOREIGN KEY(SCHEMA_ID) REFERENCES PUBLIC.PLAINSCHEMA(ID) NOCHECK;          
ALTER TABLE PUBLIC.UPLAINATTRUNIQUEVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_FA5C FOREIGN KEY(SCHEMA_ID) REFERENCES PUBLIC.PLAINSCHEMA(ID) NOCHECK;               
ALTER TABLE PUBLIC.UPLAINATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_380F5 FOREIGN KEY(MEMBERSHIP_ID) REFERENCES PUBLIC.UMEMBERSHIP(ID) NOCHECK;     
ALTER TABLE PUBLIC.QRTZ_CRON_TRIGGERS ADD CONSTRAINT PUBLIC.FK_QRTZ_CRON_TRIGGERS_QRTZ_TRIGGERS FOREIGN KEY(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP) REFERENCES PUBLIC.QRTZ_TRIGGERS(SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP) ON DELETE CASCADE NOCHECK;       
ALTER TABLE PUBLIC.VIRSCHEMA ADD CONSTRAINT PUBLIC.CONSTRAINT_F166 FOREIGN KEY(ANYTYPECLASS_ID) REFERENCES PUBLIC.ANYTYPECLASS(ID) NOCHECK;    
ALTER TABLE PUBLIC.OIDCPROVIDER_ACTIONSCLASSNAMES ADD CONSTRAINT PUBLIC.CONSTRAINT_35 FOREIGN KEY(OIDCOP_ID) REFERENCES PUBLIC.OIDCPROVIDER(ID) NOCHECK;       
ALTER TABLE PUBLIC.GPLAINATTRVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_CF5 FOREIGN KEY(ATTRIBUTE_ID) REFERENCES PUBLIC.GPLAINATTR(ID) NOCHECK;    
ALTER TABLE PUBLIC.DERSCHEMA ADD CONSTRAINT PUBLIC.CONSTRAINT_E511 FOREIGN KEY(ANYTYPECLASS_ID) REFERENCES PUBLIC.ANYTYPECLASS(ID) NOCHECK;    
ALTER TABLE PUBLIC.PROVISION_ANYTYPECLASS ADD CONSTRAINT PUBLIC.CONSTRAINT_3FB FOREIGN KEY(ANYTYPECLASS_ID) REFERENCES PUBLIC.ANYTYPECLASS(ID) NOCHECK;        
ALTER TABLE PUBLIC.ACT_RU_IDENTITYLINK ADD CONSTRAINT PUBLIC.ACT_FK_IDL_PROCINST FOREIGN KEY(PROC_INST_ID_) REFERENCES PUBLIC.ACT_RU_EXECUTION(ID_) NOCHECK;   
ALTER TABLE PUBLIC.AMEMBERSHIP ADD CONSTRAINT PUBLIC.CONSTRAINT_9B1 FOREIGN KEY(ANYOBJECT_ID) REFERENCES PUBLIC.ANYOBJECT(ID) NOCHECK;         
ALTER TABLE PUBLIC.ANYOBJECT ADD CONSTRAINT PUBLIC.CONSTRAINT_3A FOREIGN KEY(REALM_ID) REFERENCES PUBLIC.REALM(ID) NOCHECK;    
ALTER TABLE PUBLIC.OIDCPROVIDERITEM_TRANSFORMER ADD CONSTRAINT PUBLIC.CONSTRAINT_D2 FOREIGN KEY(OIDCPROVIDERITEMITEM_ID) REFERENCES PUBLIC.OIDCPROVIDERITEM(ID) NOCHECK;       
ALTER TABLE PUBLIC.PROVISION_ANYTYPECLASS ADD CONSTRAINT PUBLIC.CONSTRAINT_3F FOREIGN KEY(PROVISION_ID) REFERENCES PUBLIC.PROVISION(ID) NOCHECK;               
ALTER TABLE PUBLIC.ACT_RU_TASK ADD CONSTRAINT PUBLIC.ACT_FK_TASK_PROCINST FOREIGN KEY(PROC_INST_ID_) REFERENCES PUBLIC.ACT_RU_EXECUTION(ID_) NOCHECK;          
ALTER TABLE PUBLIC.SYNCOPEGROUP_EXTERNALRESOURCE ADD CONSTRAINT PUBLIC.CONSTRAINT_23D FOREIGN KEY(RESOURCE_ID) REFERENCES PUBLIC.EXTERNALRESOURCE(ID) NOCHECK; 
ALTER TABLE PUBLIC.CPLAINATTRVALUE ADD CONSTRAINT PUBLIC.CONSTRAINT_67 FOREIGN KEY(ATTRIBUTE_ID) REFERENCES PUBLIC.CPLAINATTR(ID) NOCHECK;     
ALTER TABLE PUBLIC.TYPEEXTENSION ADD CONSTRAINT PUBLIC.CONSTRAINT_D099 FOREIGN KEY(ANYTYPE_ID) REFERENCES PUBLIC.ANYTYPE(ID) NOCHECK;          
ALTER TABLE PUBLIC.ACT_RE_MODEL ADD CONSTRAINT PUBLIC.ACT_FK_MODEL_SOURCE_EXTRA FOREIGN KEY(EDITOR_SOURCE_EXTRA_VALUE_ID_) REFERENCES PUBLIC.ACT_GE_BYTEARRAY(ID_) NOCHECK;    
ALTER TABLE PUBLIC.VIRSCHEMA ADD CONSTRAINT PUBLIC.CONSTRAINT_F1663 FOREIGN KEY(PROVISION_ID) REFERENCES PUBLIC.PROVISION(ID) NOCHECK;         
ALTER TABLE PUBLIC.ANYOBJECT_ANYTYPECLASS ADD CONSTRAINT PUBLIC.CONSTRAINT_F0 FOREIGN KEY(ANYOBJECT_ID) REFERENCES PUBLIC.ANYOBJECT(ID) NOCHECK;               
ALTER TABLE PUBLIC.PUSHTASK_ACTIONSCLASSNAMES ADD CONSTRAINT PUBLIC.CONSTRAINT_5B FOREIGN KEY(PUSHTASK_ID) REFERENCES PUBLIC.TASK(ID) NOCHECK; 
ALTER TABLE PUBLIC.REPORTEXEC ADD CONSTRAINT PUBLIC.CONSTRAINT_901 FOREIGN KEY(REPORT_ID) REFERENCES PUBLIC.REPORT(ID) NOCHECK;
ALTER TABLE PUBLIC.ACCOUNTPOLICY_EXTERNALRESOURCE ADD CONSTRAINT PUBLIC.CONSTRAINT_ED FOREIGN KEY(ACCOUNTPOLICY_ID) REFERENCES PUBLIC.ACCOUNTPOLICY(ID) NOCHECK;               
ALTER TABLE PUBLIC.ANYOBJECT_EXTERNALRESOURCE ADD CONSTRAINT PUBLIC.CONSTRAINT_54 FOREIGN KEY(ANYOBJECT_ID) REFERENCES PUBLIC.ANYOBJECT(ID) NOCHECK;           
ALTER TABLE PUBLIC.MAPPINGITEM_TRANSFORMER ADD CONSTRAINT PUBLIC.CONSTRAINT_53 FOREIGN KEY(MAPPINGITEM_ID) REFERENCES PUBLIC.MAPPINGITEM(ID) NOCHECK;          
ALTER TABLE PUBLIC.REPORTLETCONFINSTANCE ADD CONSTRAINT PUBLIC.CONSTRAINT_4FF FOREIGN KEY(REPORT_ID) REFERENCES PUBLIC.REPORT(ID) NOCHECK;     
ALTER TABLE PUBLIC.URELATIONSHIP ADD CONSTRAINT PUBLIC.CONSTRAINT_AC048 FOREIGN KEY(TYPE_ID) REFERENCES PUBLIC.RELATIONSHIPTYPE(ID) NOCHECK;   
ALTER TABLE PUBLIC.ACT_RU_EXECUTION ADD CONSTRAINT PUBLIC.ACT_FK_EXE_SUPER FOREIGN KEY(SUPER_EXEC_) REFERENCES PUBLIC.ACT_RU_EXECUTION(ID_) NOCHECK;           
ALTER TABLE PUBLIC.APLAINATTR ADD CONSTRAINT PUBLIC.CONSTRAINT_225 FOREIGN KEY(OWNER_ID) REFERENCES PUBLIC.ANYOBJECT(ID) NOCHECK;              
ALTER TABLE PUBLIC.MAPPING ADD CONSTRAINT PUBLIC.CONSTRAINT_5C FOREIGN KEY(PROVISION_ID) REFERENCES PUBLIC.PROVISION(ID) NOCHECK;              
ALTER TABLE PUBLIC.SYNCOPEROLE_REALM ADD CONSTRAINT PUBLIC.CONSTRAINT_F4 FOREIGN KEY(ROLE_ID) REFERENCES PUBLIC.SYNCOPEROLE(ID) NOCHECK;       
ALTER TABLE PUBLIC.ADYNGROUPMEMBERSHIP ADD CONSTRAINT PUBLIC.CONSTRAINT_F6 FOREIGN KEY(GROUP_ID) REFERENCES PUBLIC.SYNCOPEGROUP(ID) NOCHECK;   
ALTER TABLE PUBLIC.SAML2IDPITEM_TRANSFORMER ADD CONSTRAINT PUBLIC.CONSTRAINT_5E FOREIGN KEY(SAML2IDPITEMITEM_ID) REFERENCES PUBLIC.SAML2IDPITEM(ID) NOCHECK;   
