/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.schema;

import java.util.LinkedHashMap;
import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.schema.AbstractSchemaCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaDetails
extends AbstractSchemaCommand {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaDetails.class);
    private static final String DETAILS_HELP_MESSAGE = "schema --details";
    private final Input input;

    public SchemaDetails(Input input) {
        this.input = input;
    }

    public void details() {
        if (this.input.parameterNumber() == 0) {
            try {
                LinkedHashMap<String, String> details = new LinkedHashMap<String, String>();
                int plainSchemaSize = this.schemaSyncopeOperations.listPlain().size();
                int derivedSchemaSize = this.schemaSyncopeOperations.listDerived().size();
                int virtualSchemaSize = this.schemaSyncopeOperations.listVirtual().size();
                details.put("total number", String.valueOf(plainSchemaSize + derivedSchemaSize + virtualSchemaSize));
                details.put("plain schema", String.valueOf(plainSchemaSize));
                details.put("derived schema", String.valueOf(derivedSchemaSize));
                details.put("virtual schema", String.valueOf(virtualSchemaSize));
                this.schemaResultManager.printDetails(details);
            }
            catch (WebServiceException | SyncopeClientException ex) {
                LOG.error("Error reading details about schema", ex);
                this.schemaResultManager.genericError(ex.getMessage());
            }
        } else {
            this.schemaResultManager.unnecessaryParameters(this.input.listParameters(), DETAILS_HELP_MESSAGE);
        }
    }
}

