/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.entitlement;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.cli.Command;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.AbstractCommand;
import org.apache.syncope.client.cli.commands.entitlement.EntitlementList;
import org.apache.syncope.client.cli.commands.entitlement.EntitlementListRole;
import org.apache.syncope.client.cli.commands.entitlement.EntitlementReadByUserKey;
import org.apache.syncope.client.cli.commands.entitlement.EntitlementReadByUsername;
import org.apache.syncope.client.cli.commands.entitlement.EntitlementResultManager;
import org.apache.syncope.client.cli.commands.entitlement.EntitlementSearchByRole;

@Command(name="entitlement")
public class EntitlementCommand
extends AbstractCommand {
    private final EntitlementResultManager entitlementResultManager = new EntitlementResultManager();

    @Override
    public void execute(Input input) {
        if (StringUtils.isBlank((CharSequence)input.getOption())) {
            input.setOption(EntitlementOptions.HELP.getOptionName());
        }
        switch (EntitlementOptions.fromName(input.getOption())) {
            case LIST: {
                new EntitlementList(input).list();
                break;
            }
            case READ_BY_USERNAME: {
                new EntitlementReadByUsername(input).read();
                break;
            }
            case READ_BY_USERKEY: {
                new EntitlementReadByUserKey(input).read();
                break;
            }
            case SEARCH_BY_ROLE: {
                new EntitlementSearchByRole(input).search();
                break;
            }
            case LIST_ROLE: {
                new EntitlementListRole(input).list();
                break;
            }
            case HELP: {
                System.out.println(this.getHelpMessage());
                break;
            }
            default: {
                this.entitlementResultManager.defaultOptionMessage(input.getOption(), this.getHelpMessage());
            }
        }
    }

    @Override
    public String getHelpMessage() {
        return this.entitlementResultManager.commandHelpMessage(this.getClass());
    }

    public static enum EntitlementOptions {
        HELP("--help"),
        LIST("--list"),
        READ_BY_USERNAME("--read-by-username"),
        READ_BY_USERKEY("--read-by-userkey"),
        SEARCH_BY_ROLE("--search-by-role"),
        LIST_ROLE("--list-role");

        private final String optionName;

        private EntitlementOptions(String optionName) {
            this.optionName = optionName;
        }

        public String getOptionName() {
            return this.optionName;
        }

        public boolean equalsOptionName(String otherName) {
            return otherName == null ? false : this.optionName.equals(otherName);
        }

        public static EntitlementOptions fromName(String name) {
            EntitlementOptions optionToReturn = HELP;
            for (EntitlementOptions option : EntitlementOptions.values()) {
                if (!option.equalsOptionName(name)) continue;
                optionToReturn = option;
            }
            return optionToReturn;
        }

        public static List<String> toList() {
            ArrayList<String> options = new ArrayList<String>();
            for (EntitlementOptions value : EntitlementOptions.values()) {
                options.add(value.getOptionName());
            }
            return options;
        }
    }
}

