/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.syncope.client.cli.Command;
import org.apache.syncope.client.cli.view.Messages;
import org.apache.syncope.client.cli.view.Table;
import org.apache.syncope.common.lib.types.ConnConfProperty;

public abstract class CommonsResultManager {
    public void numberFormatException(String what, String key) {
        Messages.printIdNotNumberDeletedMessage(what, key);
    }

    public void unnecessaryParameters(List<String> parameters, String helpMessage) {
        Messages.printUnnecessaryParameters(parameters, helpMessage);
    }

    public void deletedMessage(String what, String key) {
        Messages.printDeletedMessage(what, key);
    }

    public void notFoundError(String what, String parameter) {
        Messages.printNofFoundMessage(what, parameter);
    }

    public void notBooleanDeletedError(String what, String key) {
        Messages.printNotBooleanDeletedMessage(what, key);
    }

    public void typeNotValidError(String what, String parameter, String[] options) {
        Messages.printTypeNotValidMessage(what, parameter, options);
    }

    public void commandOptionError(String message) {
        Messages.printCommandOptionMessage(message);
    }

    public void defaultOptionMessage(String option, String helpMessage) {
        Messages.printDefaultMessage(option, helpMessage);
    }

    public void genericMessage(String ... messages) {
        Messages.printMessage(messages);
    }

    public void genericError(String error) {
        Messages.printMessage("Error: " + error);
    }

    public String commandHelpMessage(Class<?> name) {
        return Messages.commandHelpMessage(name.getAnnotation(Command.class).name());
    }

    protected void printConfiguration(Collection<ConnConfProperty> props) {
        props.forEach(prop -> {
            System.out.println("       name: " + prop.getSchema().getName());
            System.out.println("       values: " + prop.getValues());
            System.out.println("       type: " + prop.getSchema().getType());
            System.out.println("       display name: " + prop.getSchema().getDisplayName());
            System.out.println("       help message: " + prop.getSchema().getHelpMessage());
            System.out.println("       order: " + prop.getSchema().getOrder());
            System.out.println("       default values: " + prop.getSchema().getDefaultValues());
            System.out.println("       confidential: " + prop.getSchema().isConfidential());
            System.out.println("       required: " + prop.getSchema().isRequired());
            System.out.println("       overridable: " + prop.isOverridable());
            System.out.println("");
        });
    }

    protected void printDetails(String title, Map<String, String> details) {
        Table.TableBuilder tableBuilder = new Table.TableBuilder(title).header("detail").header("value");
        details.forEach((key, value) -> tableBuilder.rowValues(Arrays.asList(key, value)));
        tableBuilder.build().print();
    }
}

