/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import javax.sql.DataSource;
import org.apache.openjpa.jdbc.sql.AbstractDB2Dictionary;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;

public class DerbyDictionary
extends AbstractDB2Dictionary {
    public boolean shutdownOnClose = true;

    public DerbyDictionary() {
        this.platform = "Apache Derby";
        this.validationSQL = "VALUES(1)";
        this.stringLengthFunction = "LENGTH({0})";
        this.substringFunctionName = "SUBSTR";
        this.toUpperCaseFunction = "UPPER(CAST({0} AS VARCHAR(" + this.varcharCastLength + ")))";
        this.toLowerCaseFunction = "LOWER(CAST({0} AS VARCHAR(" + this.varcharCastLength + ")))";
        this.maxConstraintNameLength = 128;
        this.maxIndexNameLength = 128;
        this.maxColumnNameLength = 128;
        this.maxTableNameLength = 128;
        this.useGetBytesForBlobs = true;
        this.useSetBytesForBlobs = true;
        this.allowsAliasInBulkClause = false;
        this.supportsDeferredConstraints = false;
        this.supportsParameterInSelect = false;
        this.supportsSelectForUpdate = true;
        this.supportsDefaultDeleteAction = false;
        this.requiresCastForMathFunctions = true;
        this.requiresCastForComparisons = true;
        this.supportsSimpleCaseExpression = false;
        this.supportsNullUniqueColumn = false;
        this.supportsComments = true;
        this.fixedSizeTypeNameSet.addAll(Arrays.asList("BIGINT", "INTEGER", "TEXT"));
        this.reservedWordSet.addAll(Arrays.asList("BOOLEAN", "CALL", "ENDEXEC", "EXPLAIN", "FUNCTION", "GET_CURRENT_CONNECTION", "INOUT", "LONGINT", "LTRIM", "NONE", "NVARCHAR", "OFF", "OUT", "RTRIM", "SUBSTR", "XML", "XMLEXISTS", "XMLPARSE", "XMLSERIALIZE"));
        this.invalidColumnWordSet.addAll(Arrays.asList("ADD", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "AS", "ASC", "ASSERTION", "AT", "AUTHORIZATION", "AVG", "BEGIN", "BETWEEN", "BIT", "BOOLEAN", "BOTH", "BY", "CALL", "CASCADE", "CASCADED", "CASE", "CAST", "CHAR", "CHARACTER", "CHARACTER_LENGTH", "CHECK", "CLOSE", "COALESCE", "COLLATE", "COLLATION", "COLUMN", "COMMIT", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONTINUE", "CONVERT", "CORRESPONDING", "CREATE", "CURRENT", "CURRENT_DATE", "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DESC", "DESCRIBE", "DIAGNOSTICS", "DISCONNECT", "DISTINCT", "DOUBLE", "DROP", "ELSE", "END", "END-EXEC", "ESCAPE", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXISTS", "EXPLAIN", "EXTERNAL", "FALSE", "FETCH", "FIRST", "FLOAT", "FOR", "FOREIGN", "FOUND", "FROM", "FULL", "FUNCTION", "GET", "GETCURRENTCONNECTION", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "HAVING", "HOUR", "IDENTITY", "IMMEDIATE", "IN", "INDICATOR", "INITIALLY", "INNER", "INOUT", "INPUT", "INSENSITIVE", "INSERT", "INT", "INTEGER", "INTERSECT", "INTO", "IS", "ISOLATION", "JOIN", "KEY", "LAST", "LEADING", "LEFT", "LIKE", "LOWER", "LTRIM", "MATCH", "MAX", "MIN", "MINUTE", "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NO", "NONE", "NOT", "NULL", "NULLIF", "NUMERIC", "NVARCHAR", "OF", "ON", "ONLY", "OPEN", "OPTION", "OR", "ORDER", "OUT", "OUTER", "OUTPUT", "OVER", "OVERLAPS", "PAD", "PARTIAL", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURE", "PUBLIC", "READ", "REAL", "REFERENCES", "RELATIVE", "RESTRICT", "REVOKE", "RIGHT", "ROLLBACK", "ROWS", "ROW_NUMBER", "RTRIM", "SCHEMA", "SCROLL", "SECOND", "SELECT", "SESSION_USER", "SET", "SMALLINT", "SOME", "SPACE", "SQL", "SQLCODE", "SQLERROR", "SQLSTATE", "SUBSTR", "SUBSTRING", "SUM", "SYSTEM_USER", "TABLE", "TEMPORARY", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRAILING", "TRANSACTION", "TRANSLATE", "TRANSLATION", "TRIM", "TRUE", "UNION", "UNIQUE", "UNKNOWN", "UPDATE", "UPPER", "USER", "USING", "VALUES", "VARCHAR", "VARYING", "VIEW", "WHENEVER", "WHERE", "WITH", "WORK", "WRITE", "XML", "XMLEXISTS", "XMLPARSE", "XMLQUERY", "XMLSERIALIZE", "YEAR"));
    }

    @Override
    public void connectedConfiguration(Connection conn) throws SQLException {
        super.connectedConfiguration(conn);
        if (this.versionEqualOrLaterThan(10, 5)) {
            this.supportsSelectStartIndex = true;
            this.supportsSelectEndIndex = true;
        }
    }

    @Override
    protected void appendSelectRange(SQLBuffer buf, long start, long end, boolean subselect) {
        if (subselect) {
            return;
        }
        if (this.supportsSelectStartIndex && this.supportsSelectEndIndex) {
            if (this.isUsingOffset(start)) {
                buf.append(" OFFSET ").append(Long.toString(start)).append(" ROWS ");
            }
            if (this.isUsingLimit(end)) {
                long rowCount = end - start;
                buf.append(" FETCH NEXT ").append(Long.toString(rowCount)).append(" ROWS ONLY");
            }
        } else if (this.isUsingLimit(end)) {
            buf.append(" FETCH FIRST ").append(Long.toString(end)).append(" ROWS ONLY");
        }
    }

    @Override
    public void closeDataSource(DataSource dataSource) {
        super.closeDataSource(dataSource);
        if (!this.shutdownOnClose) {
            return;
        }
        if (this.conf != null && this.conf.getConnectionDriverName() != null && this.conf.getConnectionDriverName().indexOf("EmbeddedDriver") != -1) {
            try {
                DriverManager.getConnection(this.conf.getConnectionURL() + ";shutdown=true");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isFatalException(int subtype, SQLException ex) {
        int errorCode = ex.getErrorCode();
        if ((subtype == 1 || subtype == 6) && errorCode <= 30000) {
            return false;
        }
        return super.isFatalException(subtype, ex);
    }

    @Override
    public int applyRange(Select select, int count) {
        long start = select.getStartIndex();
        long end = select.getEndIndex();
        if (this.supportsSelectStartIndex) {
            if (start > 0L) {
                count = (int)((long)count - start);
            }
            if (end != Long.MAX_VALUE) {
                long size = end - start;
                count = (int)Math.min((long)count, size);
            }
        }
        return count;
    }

    @Override
    public int getPreferredType(int type) {
        switch (type) {
            case 2013: {
                return 92;
            }
            case 2014: {
                return 93;
            }
        }
        return type;
    }
}

