/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.patch.AbstractReplacePatchItem;
import org.apache.syncope.common.lib.patch.AnyObjectPatch;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.AttrPatch;
import org.apache.syncope.common.lib.patch.BooleanReplacePatchItem;
import org.apache.syncope.common.lib.patch.GroupPatch;
import org.apache.syncope.common.lib.patch.MembershipPatch;
import org.apache.syncope.common.lib.patch.PasswordPatch;
import org.apache.syncope.common.lib.patch.RelationshipPatch;
import org.apache.syncope.common.lib.patch.StringPatchItem;
import org.apache.syncope.common.lib.patch.StringReplacePatchItem;
import org.apache.syncope.common.lib.patch.UserPatch;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.RelationshipTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnyOperations {
    private static final Logger LOG = LoggerFactory.getLogger(AnyOperations.class);
    private static final Set<String> NULL_SINGLETON = Collections.singleton(null);

    private AnyOperations() {
    }

    private static <T, K extends AbstractReplacePatchItem<T>> K replacePatchItem(T updated, T original, K proto) {
        if (original == null && updated == null || original != null && original.equals(updated)) {
            return null;
        }
        proto.setValue(updated);
        return proto;
    }

    private static void diff(AnyTO updated, AnyTO original, AnyPatch result, boolean incremental) {
        if (updated.getKey() == null && original.getKey() != null || updated.getKey() != null && !updated.getKey().equals(original.getKey())) {
            throw new IllegalArgumentException("AnyTO's key must be the same");
        }
        result.setKey(updated.getKey());
        result.setRealm(AnyOperations.replacePatchItem(updated.getRealm(), original.getRealm(), new StringReplacePatchItem()));
        result.getAuxClasses().clear();
        if (!incremental) {
            original.getAuxClasses().stream().filter(auxClass -> !updated.getAuxClasses().contains(auxClass)).forEach(auxClass -> result.getAuxClasses().add((StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.DELETE)).value(auxClass)).build()));
        }
        updated.getAuxClasses().stream().filter(auxClass -> !original.getAuxClasses().contains(auxClass)).forEach(auxClass -> result.getAuxClasses().add((StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.ADD_REPLACE)).value(auxClass)).build()));
        Map<String, AttrTO> updatedAttrs = EntityTOUtils.buildAttrMap(updated.getPlainAttrs());
        Map<String, AttrTO> originalAttrs = EntityTOUtils.buildAttrMap(original.getPlainAttrs());
        result.getPlainAttrs().clear();
        if (!incremental) {
            originalAttrs.keySet().stream().filter(attr -> !updatedAttrs.containsKey(attr)).forEach(schema -> result.getPlainAttrs().add((AttrPatch)((AttrPatch.Builder)new AttrPatch.Builder().operation(PatchOperation.DELETE)).attrTO(new AttrTO.Builder().schema((String)schema).build()).build()));
        }
        updatedAttrs.values().forEach(attrTO -> {
            AttrPatch patch;
            if (AnyOperations.isEmpty(attrTO)) {
                if (!incremental) {
                    result.getPlainAttrs().add((AttrPatch)((AttrPatch.Builder)new AttrPatch.Builder().operation(PatchOperation.DELETE)).attrTO(new AttrTO.Builder().schema(attrTO.getSchema()).build()).build());
                }
            } else if (!(originalAttrs.containsKey(attrTO.getSchema()) && ((AttrTO)originalAttrs.get(attrTO.getSchema())).getValues().equals(attrTO.getValues()) || (patch = (AttrPatch)((AttrPatch.Builder)new AttrPatch.Builder().operation(PatchOperation.ADD_REPLACE)).attrTO((AttrTO)attrTO).build()).isEmpty())) {
                result.getPlainAttrs().add(patch);
            }
        });
        result.getVirAttrs().clear();
        result.getVirAttrs().addAll(updated.getVirAttrs());
        result.getResources().clear();
        if (!incremental) {
            original.getResources().stream().filter(resource -> !updated.getResources().contains(resource)).forEach(resource -> result.getResources().add((StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.DELETE)).value(resource)).build()));
        }
        updated.getResources().stream().filter(resource -> !original.getResources().contains(resource)).forEach(resource -> result.getResources().add((StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.ADD_REPLACE)).value(resource)).build()));
    }

    public static AnyObjectPatch diff(AnyObjectTO updated, AnyObjectTO original, boolean incremental) {
        AnyObjectPatch result = new AnyObjectPatch();
        AnyOperations.diff(updated, original, result, incremental);
        result.setName(AnyOperations.replacePatchItem(updated.getName(), original.getName(), new StringReplacePatchItem()));
        Map<Pair<String, String>, RelationshipTO> updatedRels = EntityTOUtils.buildRelationshipMap(updated.getRelationships());
        Map<Pair<String, String>, RelationshipTO> originalRels = EntityTOUtils.buildRelationshipMap(original.getRelationships());
        updatedRels.entrySet().stream().filter(entry -> !originalRels.containsKey(entry.getKey())).forEachOrdered(entry -> result.getRelationships().add((RelationshipPatch)((RelationshipPatch.Builder)new RelationshipPatch.Builder().operation(PatchOperation.ADD_REPLACE)).relationshipTO((RelationshipTO)entry.getValue()).build()));
        if (!incremental) {
            originalRels.keySet().stream().filter(relationship -> !updatedRels.containsKey(relationship)).forEach(key -> result.getRelationships().add((RelationshipPatch)((RelationshipPatch.Builder)new RelationshipPatch.Builder().operation(PatchOperation.DELETE)).relationshipTO((RelationshipTO)originalRels.get(key)).build()));
        }
        Map<String, MembershipTO> updatedMembs = EntityTOUtils.buildMembershipMap(updated.getMemberships());
        Map<String, MembershipTO> originalMembs = EntityTOUtils.buildMembershipMap(original.getMemberships());
        updatedMembs.forEach((key, value) -> {
            MembershipPatch membershipPatch = (MembershipPatch)((MembershipPatch.Builder)new MembershipPatch.Builder().operation(PatchOperation.ADD_REPLACE)).group(value.getGroupKey()).build();
            AnyOperations.diff(value, membershipPatch);
            if (!(originalMembs.containsKey(key) && membershipPatch.getPlainAttrs().isEmpty() && membershipPatch.getVirAttrs().isEmpty())) {
                result.getMemberships().add(membershipPatch);
            }
        });
        if (!incremental) {
            originalMembs.keySet().stream().filter(membership -> !updatedMembs.containsKey(membership)).forEach(key -> result.getMemberships().add((MembershipPatch)((MembershipPatch.Builder)new MembershipPatch.Builder().operation(PatchOperation.DELETE)).group(((MembershipTO)originalMembs.get(key)).getGroupKey()).build()));
        }
        return result;
    }

    private static void diff(MembershipTO updated, MembershipPatch result) {
        result.getPlainAttrs().addAll(updated.getPlainAttrs().stream().filter(attrTO -> !AnyOperations.isEmpty(attrTO)).collect(Collectors.toSet()));
        result.getVirAttrs().clear();
        result.getVirAttrs().addAll(updated.getVirAttrs());
    }

    public static UserPatch diff(UserTO updated, UserTO original, boolean incremental) {
        UserPatch result = new UserPatch();
        AnyOperations.diff(updated, original, result, incremental);
        if (!(updated.getPassword() == null || original.getPassword() != null && original.getPassword().equals(updated.getPassword()))) {
            result.setPassword((PasswordPatch)((PasswordPatch.Builder)new PasswordPatch.Builder().value(updated.getPassword())).resources(updated.getResources()).build());
        }
        result.setUsername(AnyOperations.replacePatchItem(updated.getUsername(), original.getUsername(), new StringReplacePatchItem()));
        if (updated.getSecurityQuestion() == null) {
            result.setSecurityQuestion(null);
            result.setSecurityAnswer(null);
        } else if (!updated.getSecurityQuestion().equals(original.getSecurityQuestion()) || StringUtils.isNotBlank((CharSequence)updated.getSecurityAnswer())) {
            result.setSecurityQuestion((StringReplacePatchItem)((StringReplacePatchItem.Builder)new StringReplacePatchItem.Builder().value(updated.getSecurityQuestion())).build());
            result.setSecurityAnswer((StringReplacePatchItem)((StringReplacePatchItem.Builder)new StringReplacePatchItem.Builder().value(updated.getSecurityAnswer())).build());
        }
        result.setMustChangePassword(AnyOperations.replacePatchItem(updated.isMustChangePassword(), original.isMustChangePassword(), new BooleanReplacePatchItem()));
        if (!incremental) {
            original.getRoles().stream().filter(role -> !updated.getRoles().contains(role)).forEach(toRemove -> result.getRoles().add((StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.DELETE)).value(toRemove)).build()));
        }
        updated.getRoles().stream().filter(role -> !original.getRoles().contains(role)).forEach(toAdd -> result.getRoles().add((StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.ADD_REPLACE)).value(toAdd)).build()));
        Map<Pair<String, String>, RelationshipTO> updatedRels = EntityTOUtils.buildRelationshipMap(updated.getRelationships());
        Map<Pair<String, String>, RelationshipTO> originalRels = EntityTOUtils.buildRelationshipMap(original.getRelationships());
        updatedRels.entrySet().stream().filter(entry -> !originalRels.containsKey(entry.getKey())).forEachOrdered(entry -> result.getRelationships().add((RelationshipPatch)((RelationshipPatch.Builder)new RelationshipPatch.Builder().operation(PatchOperation.ADD_REPLACE)).relationshipTO((RelationshipTO)entry.getValue()).build()));
        if (!incremental) {
            originalRels.keySet().stream().filter(relationship -> !updatedRels.containsKey(relationship)).forEach(key -> result.getRelationships().add((RelationshipPatch)((RelationshipPatch.Builder)new RelationshipPatch.Builder().operation(PatchOperation.DELETE)).relationshipTO((RelationshipTO)originalRels.get(key)).build()));
        }
        Map<String, MembershipTO> updatedMembs = EntityTOUtils.buildMembershipMap(updated.getMemberships());
        Map<String, MembershipTO> originalMembs = EntityTOUtils.buildMembershipMap(original.getMemberships());
        updatedMembs.forEach((key, value) -> {
            MembershipPatch membershipPatch = (MembershipPatch)((MembershipPatch.Builder)new MembershipPatch.Builder().operation(PatchOperation.ADD_REPLACE)).group(value.getGroupKey()).build();
            AnyOperations.diff(value, membershipPatch);
            if (!(originalMembs.containsKey(key) && membershipPatch.getPlainAttrs().isEmpty() && membershipPatch.getVirAttrs().isEmpty())) {
                result.getMemberships().add(membershipPatch);
            }
        });
        if (!incremental) {
            originalMembs.keySet().stream().filter(membership -> !updatedMembs.containsKey(membership)).forEach(key -> result.getMemberships().add((MembershipPatch)((MembershipPatch.Builder)new MembershipPatch.Builder().operation(PatchOperation.DELETE)).group(((MembershipTO)originalMembs.get(key)).getGroupKey()).build()));
        }
        return result;
    }

    public static GroupPatch diff(GroupTO updated, GroupTO original, boolean incremental) {
        GroupPatch result = new GroupPatch();
        AnyOperations.diff(updated, original, result, incremental);
        result.setName(AnyOperations.replacePatchItem(updated.getName(), original.getName(), new StringReplacePatchItem()));
        result.setUserOwner(AnyOperations.replacePatchItem(updated.getUserOwner(), original.getUserOwner(), new StringReplacePatchItem()));
        result.setGroupOwner(AnyOperations.replacePatchItem(updated.getGroupOwner(), original.getGroupOwner(), new StringReplacePatchItem()));
        result.setUDynMembershipCond(updated.getUDynMembershipCond());
        result.getADynMembershipConds().putAll(updated.getADynMembershipConds());
        result.getTypeExtensions().addAll(updated.getTypeExtensions());
        return result;
    }

    public static <TO extends AnyTO, P extends AnyPatch> P diff(TO updated, TO original, boolean incremental) {
        if (updated instanceof UserTO && original instanceof UserTO) {
            return (P)AnyOperations.diff((UserTO)updated, (UserTO)original, incremental);
        }
        if (updated instanceof GroupTO && original instanceof GroupTO) {
            return (P)AnyOperations.diff((GroupTO)updated, (GroupTO)original, incremental);
        }
        if (updated instanceof AnyObjectTO && original instanceof AnyObjectTO) {
            return (P)AnyOperations.diff((AnyObjectTO)updated, (AnyObjectTO)original, incremental);
        }
        throw new IllegalArgumentException("Unsupported: " + updated.getClass().getName());
    }

    private static Collection<AttrTO> patch(Map<String, AttrTO> attrs, Set<AttrPatch> attrPatches) {
        HashMap<String, AttrTO> rwattrs = new HashMap<String, AttrTO>(attrs);
        attrPatches.forEach(patch -> {
            if (patch.getAttrTO() == null) {
                LOG.warn("Invalid {} specified: {}", (Object)AttrPatch.class.getName(), patch);
            } else {
                AttrTO removed = (AttrTO)rwattrs.remove(patch.getAttrTO().getSchema());
                if (patch.getOperation() == PatchOperation.ADD_REPLACE && !patch.getAttrTO().getValues().isEmpty()) {
                    rwattrs.put(patch.getAttrTO().getSchema(), patch.getAttrTO());
                }
            }
        });
        return rwattrs.values();
    }

    private static <T extends AnyTO, K extends AnyPatch> void patch(T to, K patch, T result) {
        if (to.getKey() == null || !to.getKey().equals(patch.getKey())) {
            throw new IllegalArgumentException(to.getClass().getSimpleName() + " and " + patch.getClass().getSimpleName() + " keys must be the same");
        }
        if (patch.getRealm() != null) {
            result.setRealm((String)patch.getRealm().getValue());
        }
        block6: for (StringPatchItem auxClassPatch : patch.getAuxClasses()) {
            switch (auxClassPatch.getOperation()) {
                case ADD_REPLACE: {
                    result.getAuxClasses().add((String)auxClassPatch.getValue());
                    continue block6;
                }
            }
            result.getAuxClasses().remove(auxClassPatch.getValue());
        }
        result.getPlainAttrs().clear();
        result.getPlainAttrs().addAll(AnyOperations.patch(EntityTOUtils.buildAttrMap(to.getPlainAttrs()), patch.getPlainAttrs()));
        result.getVirAttrs().clear();
        result.getVirAttrs().addAll(patch.getVirAttrs());
        block7: for (StringPatchItem resourcePatch : patch.getResources()) {
            switch (resourcePatch.getOperation()) {
                case ADD_REPLACE: {
                    result.getResources().add((String)resourcePatch.getValue());
                    continue block7;
                }
            }
            result.getResources().remove(resourcePatch.getValue());
        }
    }

    public static AnyTO patch(AnyTO anyTO, AnyPatch anyPatch) {
        if (anyTO instanceof UserTO) {
            return AnyOperations.patch((UserTO)anyTO, (UserPatch)anyPatch);
        }
        if (anyTO instanceof GroupTO) {
            return AnyOperations.patch((GroupTO)anyTO, (GroupPatch)anyPatch);
        }
        if (anyTO instanceof AnyObjectTO) {
            return AnyOperations.patch((AnyObjectTO)anyTO, (AnyObjectPatch)anyPatch);
        }
        return null;
    }

    public static GroupTO patch(GroupTO groupTO, GroupPatch groupPatch) {
        GroupTO result = (GroupTO)SerializationUtils.clone((Serializable)groupTO);
        AnyOperations.patch(groupTO, groupPatch, result);
        if (groupPatch.getName() != null) {
            result.setName((String)groupPatch.getName().getValue());
        }
        if (groupPatch.getUserOwner() != null) {
            result.setGroupOwner((String)groupPatch.getUserOwner().getValue());
        }
        if (groupPatch.getGroupOwner() != null) {
            result.setGroupOwner((String)groupPatch.getGroupOwner().getValue());
        }
        result.setUDynMembershipCond(groupPatch.getUDynMembershipCond());
        result.getADynMembershipConds().clear();
        result.getADynMembershipConds().putAll(groupPatch.getADynMembershipConds());
        return result;
    }

    public static AnyObjectTO patch(AnyObjectTO anyObjectTO, AnyObjectPatch anyObjectPatch) {
        AnyObjectTO result = (AnyObjectTO)SerializationUtils.clone((Serializable)anyObjectTO);
        AnyOperations.patch(anyObjectTO, anyObjectPatch, result);
        if (anyObjectPatch.getName() != null) {
            result.setName((String)anyObjectPatch.getName().getValue());
        }
        anyObjectPatch.getRelationships().forEach(relPatch -> {
            if (relPatch.getRelationshipTO() == null) {
                LOG.warn("Invalid {} specified: {}", (Object)RelationshipPatch.class.getName(), relPatch);
            } else {
                result.getRelationships().remove(relPatch.getRelationshipTO());
                if (relPatch.getOperation() == PatchOperation.ADD_REPLACE) {
                    result.getRelationships().add(relPatch.getRelationshipTO());
                }
            }
        });
        anyObjectPatch.getMemberships().forEach(membPatch -> {
            if (membPatch.getGroup() == null) {
                LOG.warn("Invalid {} specified: {}", (Object)MembershipPatch.class.getName(), membPatch);
            } else {
                result.getMemberships().stream().filter(membership -> membPatch.getGroup().equals(membership.getGroupKey())).findFirst().ifPresent(memb -> result.getMemberships().remove(memb));
                if (membPatch.getOperation() == PatchOperation.ADD_REPLACE) {
                    MembershipTO newMembershipTO = new MembershipTO.Builder().group(membPatch.getGroup()).build();
                    newMembershipTO.getPlainAttrs().addAll(membPatch.getPlainAttrs());
                    newMembershipTO.getVirAttrs().addAll(membPatch.getVirAttrs());
                    result.getMemberships().add(newMembershipTO);
                }
            }
        });
        return result;
    }

    public static UserTO patch(UserTO userTO, UserPatch userPatch) {
        UserTO result = (UserTO)SerializationUtils.clone((Serializable)userTO);
        AnyOperations.patch(userTO, userPatch, result);
        if (userPatch.getPassword() != null) {
            result.setPassword((String)userPatch.getPassword().getValue());
        }
        if (userPatch.getUsername() != null) {
            result.setUsername((String)userPatch.getUsername().getValue());
        }
        userPatch.getRelationships().forEach(relPatch -> {
            if (relPatch.getRelationshipTO() == null) {
                LOG.warn("Invalid {} specified: {}", (Object)RelationshipPatch.class.getName(), relPatch);
            } else {
                result.getRelationships().remove(relPatch.getRelationshipTO());
                if (relPatch.getOperation() == PatchOperation.ADD_REPLACE) {
                    result.getRelationships().add(relPatch.getRelationshipTO());
                }
            }
        });
        userPatch.getMemberships().forEach(membPatch -> {
            if (membPatch.getGroup() == null) {
                LOG.warn("Invalid {} specified: {}", (Object)MembershipPatch.class.getName(), membPatch);
            } else {
                result.getMemberships().stream().filter(membership -> membPatch.getGroup().equals(membership.getGroupKey())).findFirst().ifPresent(memb -> result.getMemberships().remove(memb));
                if (membPatch.getOperation() == PatchOperation.ADD_REPLACE) {
                    MembershipTO newMembershipTO = new MembershipTO.Builder().group(membPatch.getGroup()).build();
                    newMembershipTO.getPlainAttrs().addAll(membPatch.getPlainAttrs());
                    newMembershipTO.getVirAttrs().addAll(membPatch.getVirAttrs());
                    result.getMemberships().add(newMembershipTO);
                }
            }
        });
        block3: for (StringPatchItem rolePatch : userPatch.getRoles()) {
            switch (rolePatch.getOperation()) {
                case ADD_REPLACE: {
                    result.getRoles().add((String)rolePatch.getValue());
                    continue block3;
                }
            }
            result.getRoles().remove(rolePatch.getValue());
        }
        return result;
    }

    public static void cleanEmptyAttrs(AnyTO anyTO, AnyPatch patch) {
        patch.getPlainAttrs().addAll(anyTO.getPlainAttrs().stream().filter(plainAttrTO -> AnyOperations.isEmpty(plainAttrTO)).map(plainAttrTO -> (AttrPatch)((AttrPatch.Builder)new AttrPatch.Builder().operation(PatchOperation.DELETE)).attrTO(new AttrTO.Builder().schema(plainAttrTO.getSchema()).build()).build()).collect(Collectors.toSet()));
    }

    private static boolean isEmpty(AttrTO attrTO) {
        return attrTO.getValues().isEmpty() || NULL_SINGLETON.equals(attrTO.getValues());
    }
}

