/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.resource;

import java.util.ArrayList;
import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.resource.AbstractResourceCommand;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRead
extends AbstractResourceCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceRead.class);
    private static final String READ_HELP_MESSAGE = "resource --read {RESOURCE-KEY} {RESOURCE-KEY} [...]";
    private final Input input;

    public ResourceRead(Input input) {
        this.input = input;
    }

    public void read() {
        if (this.input.getParameters().length >= 1) {
            ArrayList<ResourceTO> resourceTOs = new ArrayList<ResourceTO>();
            for (String parameter : this.input.getParameters()) {
                try {
                    resourceTOs.add(this.resourceSyncopeOperations.read(parameter));
                }
                catch (NumberFormatException ex) {
                    LOG.error("Error reading resource", (Throwable)ex);
                    this.resourceResultManager.numberFormatException("resource", parameter);
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error reading resource", ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.resourceResultManager.notFoundError("Resource", parameter);
                        break;
                    }
                    this.resourceResultManager.genericError(ex.getMessage());
                    break;
                }
            }
            this.resourceResultManager.printResources(resourceTOs);
        } else {
            this.resourceResultManager.commandOptionError(READ_HELP_MESSAGE);
        }
    }
}

