/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.cli.commands.policy;

import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.ws.WebServiceException;
import org.apache.syncope.client.cli.Input;
import org.apache.syncope.client.cli.commands.policy.AbstractPolicyCommand;
import org.apache.syncope.client.cli.util.CommandUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.policy.PolicyTO;
import org.apache.syncope.common.lib.types.PolicyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyRead
extends AbstractPolicyCommand {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyRead.class);
    private static final String READ_HELP_MESSAGE = "policy --read {POLICY-TYPE} {POLICY-KEY}\n   Policy type:  ACCOUNT / PASSWORD / PULL / PUSH";
    private final Input input;

    public PolicyRead(Input input) {
        this.input = input;
    }

    public void read() {
        block7: {
            if (this.input.parameterNumber() >= 2) {
                String[] parameters = Arrays.copyOfRange(this.input.getParameters(), 1, this.input.parameterNumber());
                try {
                    ArrayList<PolicyTO> policyTOs = new ArrayList<PolicyTO>();
                    for (String parameter : parameters) {
                        policyTOs.add((PolicyTO)this.policySyncopeOperations.read(this.input.firstParameter(), parameter));
                    }
                    this.policyResultManager.printPolicies(policyTOs);
                }
                catch (WebServiceException | SyncopeClientException ex) {
                    LOG.error("Error reading policy", ex);
                    if (ex.getMessage().startsWith("NotFound")) {
                        this.policyResultManager.notFoundError("Policy", parameters[0]);
                        break block7;
                    }
                    this.policyResultManager.genericError(ex.getMessage());
                }
                catch (IllegalArgumentException ex) {
                    LOG.error("Error reading policy", (Throwable)ex);
                    this.policyResultManager.typeNotValidError("policy", this.input.firstParameter(), CommandUtils.fromEnumToArray(PolicyType.class));
                }
            } else {
                this.policyResultManager.commandOptionError(READ_HELP_MESSAGE);
            }
        }
    }
}

