/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.annotations.Resource;
import org.apache.syncope.client.enduser.resources.BaseResource;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.rest.api.beans.UserRequestQuery;
import org.apache.syncope.common.rest.api.service.UserRequestService;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.string.StringValue;

@Resource(key="userRequests", path="/api/flowable/userRequests")
public class UserRequestsResource
extends BaseResource {
    private static final long serialVersionUID = 7273151109078469253L;

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        response.setContentType("application/json");
        StringValue username = StringValue.valueOf((String)SyncopeEnduserSession.get().getSelfTO().getUsername());
        try {
            HttpServletRequest request = (HttpServletRequest)attributes.getRequest().getContainerRequest();
            if (!this.xsrfCheck(request)) {
                LOG.error("XSRF TOKEN does not match");
                response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "XSRF TOKEN does not match");
                return response;
            }
            IRequestParameters requestParameters = attributes.getRequest().getQueryParameters();
            switch (request.getMethod()) {
                case "DELETE": {
                    StringValue executionId = requestParameters.getParameterValue("executionId");
                    StringValue reason = requestParameters.getParameterValue("reason");
                    LOG.debug("Cancel Flowable User Request with execution id [{}] for user [{}] with reason [{}]", new Object[]{executionId, SyncopeEnduserSession.get().getSelfTO().getUsername(), reason});
                    if (executionId.isEmpty()) {
                        throw new IllegalArgumentException("Empty executionId, please provide a value");
                    }
                    ((UserRequestService)SyncopeEnduserSession.get().getService(UserRequestService.class)).cancel(executionId.toString(), reason.toString());
                    response.setStatusCode(Integer.valueOf(Response.Status.NO_CONTENT.getStatusCode()));
                    response.setWriteCallback(new AbstractResource.WriteCallback(){

                        public void writeData(IResource.Attributes attributes) throws IOException {
                        }
                    });
                    break;
                }
                case "GET": {
                    StringValue page = requestParameters.getParameterValue("page");
                    StringValue size = requestParameters.getParameterValue("size");
                    LOG.debug("List available Flowable User Requests for user [{}]", (Object)username);
                    final PagedResult userRequests = ((UserRequestService)SyncopeEnduserSession.get().getService(UserRequestService.class)).list((UserRequestQuery)((UserRequestQuery.Builder)((UserRequestQuery.Builder)new UserRequestQuery.Builder().user(username.isEmpty() ? SyncopeEnduserSession.get().getSelfTO().getUsername() : username.toString()).page(Integer.valueOf(page.isEmpty() ? 1 : Integer.parseInt(page.toString())))).size(Integer.valueOf(size.isEmpty() ? 10 : Integer.parseInt(size.toString())))).build());
                    response.setWriteCallback(new AbstractResource.WriteCallback(){

                        public void writeData(IResource.Attributes attributes) throws IOException {
                            attributes.getResponse().write((CharSequence)BaseResource.MAPPER.writeValueAsString((Object)userRequests));
                        }
                    });
                    break;
                }
                default: {
                    LOG.error("Method [{}] not supported", (Object)request.getMethod());
                    response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "ErrorMessage{{ " + "Method not supported" + " }}");
                }
            }
            response.setContentType("application/json");
            response.setTextEncoding(StandardCharsets.UTF_8.name());
            response.setStatusCode(Integer.valueOf(Response.Status.OK.getStatusCode()));
        }
        catch (Exception e) {
            LOG.error("Error retrieving user requests for [{}]", (Object)username, (Object)e);
            response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "ErrorMessage{{ " + e.getMessage() + " }}");
        }
        return response;
    }
}

