/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser.resources;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.syncope.client.enduser.SyncopeEnduserSession;
import org.apache.syncope.client.enduser.annotations.Resource;
import org.apache.syncope.client.enduser.resources.BaseResource;
import org.apache.syncope.common.lib.to.UserRequestForm;
import org.apache.syncope.common.rest.api.service.UserRequestService;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.string.StringValue;

@Resource(key="userRequestCancelByUsername", path="/api/flowable/userRequests/forms/${taskId}/claim")
public class UserRequestFormClaimResource
extends BaseResource {
    private static final long serialVersionUID = 7273151109078469253L;

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse response = new AbstractResource.ResourceResponse();
        response.setContentType("application/json");
        try {
            HttpServletRequest request = (HttpServletRequest)attributes.getRequest().getContainerRequest();
            if (!this.xsrfCheck(request)) {
                LOG.error("XSRF TOKEN does not match");
                response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "XSRF TOKEN does not match");
                return response;
            }
            PageParameters parameters = attributes.getParameters();
            StringValue taskId = parameters.get("taskId");
            LOG.debug("Claim Flowable User Request Form with task id [{}] for user [{}] with reason [{}]", (Object)taskId, (Object)SyncopeEnduserSession.get().getSelfTO().getUsername());
            if (taskId.isEmpty()) {
                throw new IllegalArgumentException("Empty taskId, please provide a value");
            }
            final UserRequestForm requestForm = ((UserRequestService)SyncopeEnduserSession.get().getService(UserRequestService.class)).claimForm(taskId.toString());
            response.setWriteCallback(new AbstractResource.WriteCallback(){

                public void writeData(IResource.Attributes attributes) throws IOException {
                    attributes.getResponse().write((CharSequence)BaseResource.MAPPER.writeValueAsString((Object)requestForm));
                }
            });
            response.setContentType("application/json");
            response.setTextEncoding(StandardCharsets.UTF_8.name());
            response.setStatusCode(Integer.valueOf(Response.Status.OK.getStatusCode()));
        }
        catch (Exception e) {
            LOG.error("Error claiming User Request Form for [{}]", (Object)SyncopeEnduserSession.get().getSelfTO().getUsername(), (Object)e);
            response.setError(Integer.valueOf(Response.Status.BAD_REQUEST.getStatusCode()), "ErrorMessage{{ " + e.getMessage() + " }}");
        }
        return response;
    }
}

