/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Base64;
import org.identityconnectors.common.security.EncryptorFactory;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GuardedStringSerializer
extends JsonSerializer<GuardedString> {
    private static final Logger LOG = LoggerFactory.getLogger(GuardedStringSerializer.class);

    GuardedStringSerializer() {
    }

    public void serialize(GuardedString source, JsonGenerator jgen, SerializerProvider sp) throws IOException {
        jgen.writeStartObject();
        boolean readOnly = false;
        try {
            Field field = GuardedString.class.getDeclaredField("readOnly");
            field.setAccessible(true);
            readOnly = field.getBoolean(source);
        }
        catch (Exception e) {
            LOG.error("Could not get field value", (Throwable)e);
        }
        jgen.writeBooleanField("readOnly", readOnly);
        boolean disposed = false;
        try {
            Field field = GuardedString.class.getDeclaredField("disposed");
            field.setAccessible(true);
            disposed = field.getBoolean(source);
        }
        catch (Exception e) {
            LOG.error("Could not get field value", (Throwable)e);
        }
        jgen.writeBooleanField("disposed", disposed);
        byte[] encryptedBytes = EncryptorFactory.getInstance().getDefaultEncryptor().encrypt(SecurityUtil.decrypt((GuardedString)source).getBytes());
        jgen.writeStringField("encryptedBytes", Base64.getEncoder().encodeToString(encryptedBytes));
        String base64SHA1Hash = null;
        try {
            Field field = GuardedString.class.getDeclaredField("base64SHA1Hash");
            field.setAccessible(true);
            base64SHA1Hash = field.get(source).toString();
        }
        catch (Exception e) {
            LOG.error("Could not get field value", (Throwable)e);
        }
        if (base64SHA1Hash != null) {
            jgen.writeStringField("base64SHA1Hash", base64SHA1Hash);
        }
        jgen.writeEndObject();
    }
}

