/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api.pushpull;

import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.common.lib.types.TraceLevel;

public class ProvisioningReport {
    private String message;
    private Status status;
    private String anyType;
    private ResourceOperation operation;
    private String key;
    private String name;
    private String uidValue;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getAnyType() {
        return this.anyType;
    }

    public void setAnyType(String anyType) {
        this.anyType = anyType;
    }

    public ResourceOperation getOperation() {
        return this.operation;
    }

    public void setOperation(ResourceOperation operation) {
        this.operation = operation;
    }

    public String getUidValue() {
        return this.uidValue;
    }

    public void setUidValue(String uidValue) {
        this.uidValue = uidValue;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.message).append((Object)this.status).append((Object)this.anyType).append((Object)this.operation).append((Object)this.key).append((Object)this.name).append((Object)this.uidValue).build();
    }

    public String getReportString(TraceLevel level) {
        if (level == TraceLevel.SUMMARY) {
            return null;
        }
        if (level == TraceLevel.FAILURES && this.status == Status.FAILURE) {
            return String.format("Failed %s (key/name): %s/%s with message: %s", this.operation, this.key, this.name, this.message);
        }
        return String.format("%s %s (key/name): %s/%s %s", new Object[]{this.operation, this.status, this.key, this.name, StringUtils.isBlank((CharSequence)this.message) ? "" : "with message: " + this.message});
    }

    public static String generate(Collection<ProvisioningReport> results, TraceLevel level) {
        StringBuilder sb = new StringBuilder();
        for (ProvisioningReport result : results) {
            sb.append(result.getReportString(level)).append('\n');
        }
        return sb.toString();
    }

    public static enum Status {
        SUCCESS,
        IGNORE,
        FAILURE;

    }
}

