/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.api.dao.search;

import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.syncope.core.persistence.api.dao.search.AbstractSearchCond;
import org.apache.syncope.core.persistence.api.dao.search.AnyCond;
import org.apache.syncope.core.persistence.api.dao.search.AnyTypeCond;
import org.apache.syncope.core.persistence.api.dao.search.AssignableCond;
import org.apache.syncope.core.persistence.api.dao.search.AttributeCond;
import org.apache.syncope.core.persistence.api.dao.search.DynRealmCond;
import org.apache.syncope.core.persistence.api.dao.search.MemberCond;
import org.apache.syncope.core.persistence.api.dao.search.MembershipCond;
import org.apache.syncope.core.persistence.api.dao.search.PrivilegeCond;
import org.apache.syncope.core.persistence.api.dao.search.RelationshipCond;
import org.apache.syncope.core.persistence.api.dao.search.RelationshipTypeCond;
import org.apache.syncope.core.persistence.api.dao.search.ResourceCond;
import org.apache.syncope.core.persistence.api.dao.search.RoleCond;

public class SearchCond
extends AbstractSearchCond {
    private static final long serialVersionUID = 661560782247499526L;
    private Type type;
    private AnyTypeCond anyTypeCond;
    private AnyCond anyCond;
    private AttributeCond attributeCond;
    private RelationshipCond relationshipCond;
    private RelationshipTypeCond relationshipTypeCond;
    private MembershipCond membershipCond;
    private RoleCond roleCond;
    private PrivilegeCond privilegeCond;
    private DynRealmCond dynRealmCond;
    private ResourceCond resourceCond;
    private AssignableCond assignableCond;
    private MemberCond memberCond;
    private SearchCond leftSearchCond;
    private SearchCond rightSearchCond;

    public static SearchCond getLeafCond(AnyTypeCond anyTypeCond) {
        SearchCond nodeCond = new SearchCond();
        nodeCond.type = Type.LEAF;
        nodeCond.anyTypeCond = anyTypeCond;
        return nodeCond;
    }

    public static SearchCond getLeafCond(AttributeCond attributeCond) {
        SearchCond nodeCond = new SearchCond();
        nodeCond.type = Type.LEAF;
        if (attributeCond instanceof AnyCond) {
            nodeCond.anyCond = (AnyCond)attributeCond;
        } else {
            nodeCond.attributeCond = attributeCond;
        }
        return nodeCond;
    }

    public static SearchCond getLeafCond(RelationshipCond relationshipCond) {
        SearchCond nodeCond = new SearchCond();
        nodeCond.type = Type.LEAF;
        nodeCond.relationshipCond = relationshipCond;
        return nodeCond;
    }

    public static SearchCond getLeafCond(RelationshipTypeCond relationshipTypeCond) {
        SearchCond nodeCond = new SearchCond();
        nodeCond.type = Type.LEAF;
        nodeCond.relationshipTypeCond = relationshipTypeCond;
        return nodeCond;
    }

    public static SearchCond getLeafCond(MembershipCond membershipCond) {
        SearchCond nodeCond = new SearchCond();
        nodeCond.type = Type.LEAF;
        nodeCond.membershipCond = membershipCond;
        return nodeCond;
    }

    public static SearchCond getLeafCond(RoleCond roleCond) {
        SearchCond nodeCond = new SearchCond();
        nodeCond.type = Type.LEAF;
        nodeCond.roleCond = roleCond;
        return nodeCond;
    }

    public static SearchCond getLeafCond(PrivilegeCond privilegeCond) {
        SearchCond nodeCond = new SearchCond();
        nodeCond.type = Type.LEAF;
        nodeCond.privilegeCond = privilegeCond;
        return nodeCond;
    }

    public static SearchCond getLeafCond(DynRealmCond dynRealmCond) {
        SearchCond nodeCond = new SearchCond();
        nodeCond.type = Type.LEAF;
        nodeCond.dynRealmCond = dynRealmCond;
        return nodeCond;
    }

    public static SearchCond getLeafCond(ResourceCond resourceCond) {
        SearchCond nodeCond = new SearchCond();
        nodeCond.type = Type.LEAF;
        nodeCond.resourceCond = resourceCond;
        return nodeCond;
    }

    public static SearchCond getLeafCond(AssignableCond assignableCond) {
        SearchCond nodeCond = new SearchCond();
        nodeCond.type = Type.LEAF;
        nodeCond.assignableCond = assignableCond;
        return nodeCond;
    }

    public static SearchCond getLeafCond(MemberCond memberCond) {
        SearchCond nodeCond = new SearchCond();
        nodeCond.type = Type.LEAF;
        nodeCond.memberCond = memberCond;
        return nodeCond;
    }

    public static SearchCond getNotLeafCond(AttributeCond attributeCond) {
        SearchCond nodeCond = SearchCond.getLeafCond(attributeCond);
        nodeCond.type = Type.NOT_LEAF;
        return nodeCond;
    }

    public static SearchCond getNotLeafCond(RelationshipCond relationshipCond) {
        SearchCond nodeCond = SearchCond.getLeafCond(relationshipCond);
        nodeCond.type = Type.NOT_LEAF;
        return nodeCond;
    }

    public static SearchCond getNotLeafCond(MembershipCond membershipCond) {
        SearchCond nodeCond = SearchCond.getLeafCond(membershipCond);
        nodeCond.type = Type.NOT_LEAF;
        return nodeCond;
    }

    public static SearchCond getNotLeafCond(RoleCond roleCond) {
        SearchCond nodeCond = SearchCond.getLeafCond(roleCond);
        nodeCond.type = Type.NOT_LEAF;
        return nodeCond;
    }

    public static SearchCond getNotLeafCond(PrivilegeCond privilegeCond) {
        SearchCond nodeCond = SearchCond.getLeafCond(privilegeCond);
        nodeCond.type = Type.NOT_LEAF;
        return nodeCond;
    }

    public static SearchCond getNotLeafCond(ResourceCond resourceCond) {
        SearchCond nodeCond = SearchCond.getLeafCond(resourceCond);
        nodeCond.type = Type.NOT_LEAF;
        return nodeCond;
    }

    public static SearchCond getNotLeafCond(MemberCond memberCond) {
        SearchCond nodeCond = SearchCond.getLeafCond(memberCond);
        nodeCond.type = Type.NOT_LEAF;
        return nodeCond;
    }

    public static SearchCond getNotLeafCond(SearchCond nodeCond) {
        nodeCond.type = Type.NOT_LEAF;
        return nodeCond;
    }

    public static SearchCond getAndCond(SearchCond leftCond, SearchCond rightCond) {
        SearchCond nodeCond = new SearchCond();
        nodeCond.type = Type.AND;
        nodeCond.leftSearchCond = leftCond;
        nodeCond.rightSearchCond = rightCond;
        return nodeCond;
    }

    public static SearchCond getAndCond(List<SearchCond> conditions) {
        if (conditions.size() == 1) {
            return conditions.get(0);
        }
        if (conditions.size() > 2) {
            SearchCond removed = conditions.remove(0);
            return SearchCond.getAndCond(removed, SearchCond.getAndCond(conditions));
        }
        return SearchCond.getAndCond(conditions.get(0), conditions.get(1));
    }

    public static SearchCond getOrCond(SearchCond leftCond, SearchCond rightCond) {
        SearchCond nodeCond = new SearchCond();
        nodeCond.type = Type.OR;
        nodeCond.leftSearchCond = leftCond;
        nodeCond.rightSearchCond = rightCond;
        return nodeCond;
    }

    public static SearchCond getOrCond(List<SearchCond> conditions) {
        if (conditions.size() == 1) {
            return conditions.get(0);
        }
        if (conditions.size() > 2) {
            SearchCond removed = conditions.remove(0);
            return SearchCond.getOrCond(removed, SearchCond.getOrCond(conditions));
        }
        return SearchCond.getOrCond(conditions.get(0), conditions.get(1));
    }

    public AnyTypeCond getAnyTypeCond() {
        return this.anyTypeCond;
    }

    public void setAnyTypeCond(AnyTypeCond anyTypeCond) {
        this.anyTypeCond = anyTypeCond;
    }

    public String hasAnyTypeCond() {
        String anyTypeName = null;
        if (this.type == null) {
            return anyTypeName;
        }
        switch (this.type) {
            case LEAF: 
            case NOT_LEAF: {
                if (this.anyTypeCond == null) break;
                anyTypeName = this.anyTypeCond.getAnyTypeKey();
                break;
            }
            case AND: 
            case OR: {
                if (this.leftSearchCond != null) {
                    anyTypeName = this.leftSearchCond.hasAnyTypeCond();
                }
                if (anyTypeName != null || this.rightSearchCond == null) break;
                anyTypeName = this.rightSearchCond.hasAnyTypeCond();
                break;
            }
        }
        return anyTypeName;
    }

    public AnyCond getAnyCond() {
        return this.anyCond;
    }

    public AttributeCond getAttributeCond() {
        return this.attributeCond;
    }

    public RelationshipCond getRelationshipCond() {
        return this.relationshipCond;
    }

    public RelationshipTypeCond getRelationshipTypeCond() {
        return this.relationshipTypeCond;
    }

    public MembershipCond getMembershipCond() {
        return this.membershipCond;
    }

    public RoleCond getRoleCond() {
        return this.roleCond;
    }

    public PrivilegeCond getPrivilegeCond() {
        return this.privilegeCond;
    }

    public DynRealmCond getDynRealmCond() {
        return this.dynRealmCond;
    }

    public ResourceCond getResourceCond() {
        return this.resourceCond;
    }

    public AssignableCond getAssignableCond() {
        return this.assignableCond;
    }

    public MemberCond getMemberCond() {
        return this.memberCond;
    }

    public SearchCond getLeftSearchCond() {
        return this.leftSearchCond;
    }

    public SearchCond getRightSearchCond() {
        return this.rightSearchCond;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public boolean isValid() {
        boolean isValid = false;
        if (this.type == null) {
            return isValid;
        }
        switch (this.type) {
            case LEAF: 
            case NOT_LEAF: {
                isValid = !(this.anyTypeCond == null && this.anyCond == null && this.attributeCond == null && this.dynRealmCond == null && this.relationshipCond == null && this.relationshipTypeCond == null && this.membershipCond == null && this.roleCond == null && this.privilegeCond == null && this.resourceCond == null && this.assignableCond == null && this.memberCond == null || this.anyTypeCond != null && !this.anyTypeCond.isValid() || this.anyCond != null && !this.anyCond.isValid() || this.attributeCond != null && !this.attributeCond.isValid() || this.membershipCond != null && !this.membershipCond.isValid() || this.roleCond != null && !this.roleCond.isValid() || this.privilegeCond != null && !this.privilegeCond.isValid() || this.resourceCond != null && !this.resourceCond.isValid() || this.memberCond != null && !this.memberCond.isValid());
                break;
            }
            case AND: 
            case OR: {
                isValid = this.leftSearchCond == null || this.rightSearchCond == null ? false : this.leftSearchCond.isValid() && this.rightSearchCond.isValid();
                break;
            }
        }
        return isValid;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.type).append((Object)this.anyTypeCond).append((Object)this.anyCond).append((Object)this.attributeCond).append((Object)this.relationshipCond).append((Object)this.relationshipTypeCond).append((Object)this.membershipCond).append((Object)this.roleCond).append((Object)this.privilegeCond).append((Object)this.dynRealmCond).append((Object)this.resourceCond).append((Object)this.assignableCond).append((Object)this.memberCond).append((Object)this.leftSearchCond).append((Object)this.rightSearchCond).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SearchCond other = (SearchCond)obj;
        return new EqualsBuilder().append((Object)this.type, (Object)other.type).append((Object)this.anyTypeCond, (Object)other.anyTypeCond).append((Object)this.anyCond, (Object)other.anyCond).append((Object)this.attributeCond, (Object)other.attributeCond).append((Object)this.relationshipCond, (Object)other.relationshipCond).append((Object)this.relationshipTypeCond, (Object)other.relationshipTypeCond).append((Object)this.membershipCond, (Object)other.membershipCond).append((Object)this.roleCond, (Object)other.roleCond).append((Object)this.privilegeCond, (Object)other.privilegeCond).append((Object)this.dynRealmCond, (Object)other.dynRealmCond).append((Object)this.resourceCond, (Object)other.resourceCond).append((Object)this.assignableCond, (Object)other.assignableCond).append((Object)this.memberCond, (Object)other.memberCond).append((Object)this.leftSearchCond, (Object)other.leftSearchCond).append((Object)this.rightSearchCond, (Object)other.rightSearchCond).build();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.type).append((Object)this.anyTypeCond).append((Object)this.anyCond).append((Object)this.attributeCond).append((Object)this.relationshipCond).append((Object)this.relationshipTypeCond).append((Object)this.membershipCond).append((Object)this.roleCond).append((Object)this.privilegeCond).append((Object)this.dynRealmCond).append((Object)this.resourceCond).append((Object)this.assignableCond).append((Object)this.memberCond).append((Object)this.leftSearchCond).append((Object)this.rightSearchCond).build();
    }

    public static enum Type {
        LEAF,
        NOT_LEAF,
        AND,
        OR;

    }
}

