/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.utils;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.AttrTO;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.GroupableRelatableTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.AnyTemplate;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.java.jexl.JexlUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class TemplateUtils {
    @Autowired
    private UserDAO userDAO;
    @Autowired
    private GroupDAO groupDAO;

    private AttrTO evaluateAttr(AttrTO template, MapContext jexlContext) {
        AttrTO result = new AttrTO();
        result.setSchema(template.getSchema());
        if (template.getValues() != null && !template.getValues().isEmpty()) {
            template.getValues().forEach(value -> {
                String evaluated = JexlUtils.evaluate(value, (JexlContext)jexlContext);
                if (StringUtils.isNotBlank((CharSequence)evaluated)) {
                    result.getValues().add(evaluated);
                }
            });
        }
        return result;
    }

    private void fill(AnyTO anyTO, AnyTO template) {
        AttrTO evaluated;
        String evaluated2;
        MapContext jexlContext = new MapContext();
        JexlUtils.addFieldsToContext(anyTO, (JexlContext)jexlContext);
        JexlUtils.addAttrTOsToContext(anyTO.getPlainAttrs(), (JexlContext)jexlContext);
        JexlUtils.addAttrTOsToContext(anyTO.getDerAttrs(), (JexlContext)jexlContext);
        JexlUtils.addAttrTOsToContext(anyTO.getVirAttrs(), (JexlContext)jexlContext);
        if (template.getRealm() != null && StringUtils.isNotBlank((CharSequence)(evaluated2 = JexlUtils.evaluate(template.getRealm(), (JexlContext)jexlContext)))) {
            anyTO.setRealm(evaluated2);
        }
        Map currentAttrMap = EntityTOUtils.buildAttrMap((Collection)anyTO.getPlainAttrs());
        for (AttrTO templatePlainAttr : template.getPlainAttrs()) {
            if (templatePlainAttr.getValues().isEmpty() || currentAttrMap.containsKey(templatePlainAttr.getSchema()) && !((AttrTO)currentAttrMap.get(templatePlainAttr.getSchema())).getValues().isEmpty() || (evaluated = this.evaluateAttr(templatePlainAttr, jexlContext)).getValues().isEmpty()) continue;
            anyTO.getPlainAttrs().add(evaluated);
            jexlContext.set(evaluated.getSchema(), evaluated.getValues().get(0));
        }
        currentAttrMap = EntityTOUtils.buildAttrMap((Collection)anyTO.getDerAttrs());
        for (AttrTO templateDerAttr : template.getDerAttrs()) {
            if (currentAttrMap.containsKey(templateDerAttr.getSchema())) continue;
            anyTO.getDerAttrs().add(templateDerAttr);
        }
        currentAttrMap = EntityTOUtils.buildAttrMap((Collection)anyTO.getVirAttrs());
        for (AttrTO templateVirAttr : template.getVirAttrs()) {
            if (templateVirAttr.getValues().isEmpty() || currentAttrMap.containsKey(templateVirAttr.getSchema()) && !((AttrTO)currentAttrMap.get(templateVirAttr.getSchema())).getValues().isEmpty() || (evaluated = this.evaluateAttr(templateVirAttr, jexlContext)).getValues().isEmpty()) continue;
            anyTO.getVirAttrs().add(evaluated);
            jexlContext.set(evaluated.getSchema(), evaluated.getValues().get(0));
        }
        anyTO.getResources().addAll(template.getResources());
        anyTO.getAuxClasses().addAll(template.getAuxClasses());
    }

    private void fillRelationships(GroupableRelatableTO any, GroupableRelatableTO template) {
        template.getRelationships().stream().filter(relationship -> !any.getRelationship(relationship.getOtherEndKey(), relationship.getOtherEndKey()).isPresent()).forEachOrdered(relationship -> any.getRelationships().add(relationship));
    }

    private void fillMemberships(GroupableRelatableTO any, GroupableRelatableTO template) {
        template.getMemberships().stream().filter(membership -> !any.getMembership(membership.getGroupKey()).isPresent()).forEachOrdered(membership -> any.getMemberships().add(membership));
    }

    @Transactional(readOnly=true)
    public <T extends AnyTO> void apply(T anyTO, Optional<? extends AnyTemplate> anyTemplate) {
        if (anyTemplate.isPresent()) {
            this.apply(anyTO, anyTemplate.get().get());
        }
    }

    @Transactional(readOnly=true)
    public <T extends AnyTO> void apply(T anyTO, AnyTO template) {
        this.fill(anyTO, template);
        MapContext jexlContext = new MapContext();
        JexlUtils.addFieldsToContext(anyTO, (JexlContext)jexlContext);
        JexlUtils.addAttrTOsToContext(anyTO.getPlainAttrs(), (JexlContext)jexlContext);
        JexlUtils.addAttrTOsToContext(anyTO.getDerAttrs(), (JexlContext)jexlContext);
        JexlUtils.addAttrTOsToContext(anyTO.getVirAttrs(), (JexlContext)jexlContext);
        if (template instanceof AnyObjectTO) {
            this.fillRelationships((GroupableRelatableTO)anyTO, (GroupableRelatableTO)template);
            this.fillMemberships((GroupableRelatableTO)anyTO, (GroupableRelatableTO)template);
        } else if (template instanceof UserTO) {
            String evaluated;
            if (StringUtils.isNotBlank((CharSequence)((UserTO)template).getUsername()) && StringUtils.isNotBlank((CharSequence)(evaluated = JexlUtils.evaluate(((UserTO)template).getUsername(), (JexlContext)jexlContext)))) {
                ((UserTO)anyTO).setUsername(evaluated);
            }
            if (StringUtils.isNotBlank((CharSequence)((UserTO)template).getPassword()) && StringUtils.isNotBlank((CharSequence)(evaluated = JexlUtils.evaluate(((UserTO)template).getPassword(), (JexlContext)jexlContext)))) {
                ((UserTO)anyTO).setPassword(evaluated);
            }
            this.fillRelationships((GroupableRelatableTO)anyTO, (GroupableRelatableTO)template);
            this.fillMemberships((GroupableRelatableTO)anyTO, (GroupableRelatableTO)template);
            ((UserTO)anyTO).getRoles().addAll(((UserTO)template).getRoles());
        } else if (template instanceof GroupTO) {
            Group groupOwner;
            User userOwner;
            String evaluated;
            if (StringUtils.isNotBlank((CharSequence)((GroupTO)template).getName()) && StringUtils.isNotBlank((CharSequence)(evaluated = JexlUtils.evaluate(((GroupTO)template).getName(), (JexlContext)jexlContext)))) {
                ((GroupTO)anyTO).setName(evaluated);
            }
            if (((GroupTO)template).getUserOwner() != null && (userOwner = (User)this.userDAO.find(((GroupTO)template).getUserOwner())) != null) {
                ((GroupTO)anyTO).setUserOwner(userOwner.getKey());
            }
            if (((GroupTO)template).getGroupOwner() != null && (groupOwner = (Group)this.groupDAO.find(((GroupTO)template).getGroupOwner())) != null) {
                ((GroupTO)anyTO).setGroupOwner(groupOwner.getKey());
            }
        }
    }

    public void check(Map<String, AnyTO> templates, ClientExceptionType clientExceptionType) {
        SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)clientExceptionType);
        templates.values().forEach(value -> {
            GroupTO template;
            value.getPlainAttrs().stream().filter(attrTO -> !attrTO.getValues().isEmpty() && !JexlUtils.isExpressionValid((String)attrTO.getValues().get(0))).forEachOrdered(attrTO -> sce.getElements().add("Invalid JEXL: " + (String)attrTO.getValues().get(0)));
            value.getVirAttrs().stream().filter(attrTO -> !attrTO.getValues().isEmpty() && !JexlUtils.isExpressionValid((String)attrTO.getValues().get(0))).forEachOrdered(attrTO -> sce.getElements().add("Invalid JEXL: " + (String)attrTO.getValues().get(0)));
            if (value instanceof UserTO) {
                UserTO template2 = (UserTO)value;
                if (StringUtils.isNotBlank((CharSequence)template2.getUsername()) && !JexlUtils.isExpressionValid(template2.getUsername())) {
                    sce.getElements().add("Invalid JEXL: " + template2.getUsername());
                }
                if (StringUtils.isNotBlank((CharSequence)template2.getPassword()) && !JexlUtils.isExpressionValid(template2.getPassword())) {
                    sce.getElements().add("Invalid JEXL: " + template2.getPassword());
                }
            } else if (value instanceof GroupTO && StringUtils.isNotBlank((CharSequence)(template = (GroupTO)value).getName()) && !JexlUtils.isExpressionValid(template.getName())) {
                sce.getElements().add("Invalid JEXL: " + template.getName());
            }
        });
        if (!sce.isEmpty()) {
            throw sce;
        }
    }
}

