/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.pushpull;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.syncope.common.lib.to.PushTaskTO;
import org.apache.syncope.common.lib.types.ConflictResolutionAction;
import org.apache.syncope.common.lib.types.ImplementationType;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.resource.Provision;
import org.apache.syncope.core.persistence.api.entity.task.ProvisioningTask;
import org.apache.syncope.core.persistence.api.entity.task.PushTask;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningProfile;
import org.apache.syncope.core.provisioning.api.pushpull.ProvisioningReport;
import org.apache.syncope.core.provisioning.api.pushpull.PushActions;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopePushResultHandler;
import org.apache.syncope.core.provisioning.api.pushpull.SyncopeSinglePushExecutor;
import org.apache.syncope.core.provisioning.api.pushpull.UserPushResultHandler;
import org.apache.syncope.core.provisioning.java.pushpull.PushJobDelegate;
import org.apache.syncope.core.spring.ImplementationManager;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SinglePushJobDelegate
extends PushJobDelegate
implements SyncopeSinglePushExecutor {
    @Autowired
    private ImplementationDAO implementationDAO;

    public List<ProvisioningReport> push(Provision provision, Connector connector, Any<?> any, PushTaskTO pushTaskTO) throws JobExecutionException {
        LOG.debug("Executing push on {}", (Object)provision.getResource());
        ArrayList actions = new ArrayList();
        pushTaskTO.getActions().forEach(key -> {
            Implementation impl = this.implementationDAO.find(key);
            if (impl == null || impl.getType() != ImplementationType.PUSH_ACTIONS) {
                LOG.debug("Invalid " + Implementation.class.getSimpleName() + " {}, ignoring...", key);
            } else {
                try {
                    actions.add(ImplementationManager.build((Implementation)impl));
                }
                catch (Exception e) {
                    LOG.warn("While building {}", (Object)impl, (Object)e);
                }
            }
        });
        try {
            UserPushResultHandler handler;
            PushTask pushTask = (PushTask)this.entityFactory.newEntity(PushTask.class);
            pushTask.setResource(provision.getResource());
            pushTask.setMatchingRule(pushTaskTO.getMatchingRule() == null ? MatchingRule.LINK : pushTaskTO.getMatchingRule());
            pushTask.setUnmatchingRule(pushTaskTO.getUnmatchingRule() == null ? UnmatchingRule.ASSIGN : pushTaskTO.getUnmatchingRule());
            pushTask.setPerformCreate(pushTaskTO.isPerformCreate());
            pushTask.setPerformUpdate(pushTaskTO.isPerformUpdate());
            pushTask.setPerformDelete(pushTaskTO.isPerformDelete());
            pushTask.setSyncStatus(pushTaskTO.isSyncStatus());
            this.profile = new ProvisioningProfile(connector, (ProvisioningTask)pushTask);
            this.profile.getActions().addAll(actions);
            this.profile.setConflictResolutionAction(ConflictResolutionAction.FIRSTMATCH);
            for (PushActions action : actions) {
                action.beforeAll(this.profile);
            }
            switch (provision.getAnyType().getKind()) {
                case USER: {
                    handler = this.buildUserHandler();
                    break;
                }
                case GROUP: {
                    handler = this.buildGroupHandler();
                    break;
                }
                default: {
                    handler = this.buildAnyObjectHandler();
                }
            }
            handler.setProfile(this.profile);
            this.doHandle(Arrays.asList(any), (SyncopePushResultHandler)handler, pushTask.getResource());
            for (PushActions action : actions) {
                action.afterAll(this.profile);
            }
            return this.profile.getResults();
        }
        catch (Exception e) {
            throw e instanceof JobExecutionException ? (JobExecutionException)((Object)e) : new JobExecutionException("While pushing to connector", (Throwable)e);
        }
    }
}

